/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.netdevice;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Collector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.snmp.SNMPClient;
import org.hyperic.snmp.SNMPException;
import org.hyperic.snmp.SNMPSession;
import org.hyperic.snmp.SNMPValue;

public class SNMPCollector
extends Collector {
    protected static final String AVAILABLE_VALUES = "AvailableValues";
    protected static final Double DEFAULT_AVAILABLE_VALUE = 1.0;
    protected static final String PROP_COLUMN = "snmpColumn";
    protected Properties _props;
    protected SNMPClient _client;
    protected Set<Double> availableValues = new HashSet<Double>();
    private static final String[][] DEFAULT_PROPS = new String[][]{{"snmpIp", "127.0.0.1"}, {"snmpPort", SNMPClient.DEFAULT_PORT_STRING}, {"snmpVersion", SNMPClient.VALID_VERSIONS[1]}, {"snmpCommunity", SNMPClient.DEFAULT_COMMUNITY}};

    protected Log getLog() {
        return LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    }

    protected String getInfo() {
        String info = this._props.getProperty("snmpIp") + ":" + this._props.getProperty("snmpPort") + " " + this._props.getProperty("snmpVersion") + "," + this._props.getProperty("snmpCommunity");
        return info;
    }

    protected boolean isEmpty(List list, String name) {
        boolean isEmpty = list == null ? true : list.isEmpty();
        if (isEmpty) {
            this.setErrorMessage("No data returned for: " + name);
        }
        return isEmpty;
    }

    protected boolean isEmpty(Map map, String name) {
        boolean isEmpty = map == null ? true : map.isEmpty();
        if (isEmpty) {
            this.setErrorMessage("No data returned for: " + name);
        }
        return isEmpty;
    }

    protected void initAvailableValues() {
        String delimitedValueString = this.getPlugin().getTypeProperty(AVAILABLE_VALUES);
        if (delimitedValueString == null) {
            this.availableValues.add(DEFAULT_AVAILABLE_VALUE);
        } else {
            String[] values;
            for (String value : values = delimitedValueString.split(",")) {
                try {
                    this.availableValues.add(Double.parseDouble(value.trim()));
                }
                catch (Exception e) {
                    this.getLog().error((Object)("Invalid value set for AvailableValues: " + value));
                }
            }
        }
    }

    protected boolean isAvailability() {
        String availName = this.getPlugin().getTypeProperty("Availability");
        if (availName == null) {
            return false;
        }
        return this.getCounterName().equals(availName);
    }

    protected String getColumnName() {
        return this._props.getProperty(PROP_COLUMN);
    }

    protected String getCounterName() {
        return this._props.getProperty(PROP_COLUMN);
    }

    protected String getIndexName() {
        return this._props.getProperty("snmpIndexName");
    }

    protected String getColumnIndex(SNMPValue val) {
        String oid = val.getOID();
        int last = oid.lastIndexOf(46);
        return oid.substring(last + 1);
    }

    protected Map getIndexedColumn(SNMPSession session, String name) throws SNMPException {
        return this.getIndexedColumn(session, name, true);
    }

    protected Map getIndexedColumn(SNMPSession session, String name, boolean asString) throws SNMPException {
        HashMap<String, SNMPValue> values = new HashMap<String, SNMPValue>();
        try {
            List column = session.getBulk(name);
            if (this.isEmpty(column, name)) {
                return values;
            }
            for (int i = 0; i < column.size(); ++i) {
                SNMPValue val = (SNMPValue)column.get(i);
                String ix = this.getColumnIndex(val);
                Object obj = asString ? val.toString().trim() : val;
                values.put(ix, (SNMPValue)obj);
            }
        }
        catch (Exception e) {
            this.getLog().error((Object)("getBulk ( " + name + " ): " + e));
            return null;
        }
        return values;
    }

    protected SNMPSession getSession() throws Exception {
        try {
            return this._client.getSession(this._props);
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            throw e;
        }
    }

    protected boolean isTotalCounter(String name) {
        return false;
    }

    protected void collectIndexedColumn() {
        this.collectIndexedColumn(new GenericColumnValueConverter());
    }

    protected void collectIndexedColumn(ColumnValueConverter converter) {
        List column;
        Map indexNames;
        String indexName = this.getIndexName();
        String columnName = this.getColumnName();
        String counterName = this.getCounterName();
        boolean isAvail = this.isAvailability();
        boolean doTotal = this.isTotalCounter(counterName);
        double total = 0.0;
        try {
            SNMPSession session = this.getSession();
            indexNames = this.getIndexedColumn(session, indexName);
            column = session.getBulk(columnName);
        }
        catch (Exception e) {
            return;
        }
        if (this.isEmpty(column, columnName) || this.isEmpty(indexNames, indexName)) {
            return;
        }
        for (int i = 0; i < column.size(); ++i) {
            SNMPValue val = (SNMPValue)column.get(i);
            String ix = this.getColumnIndex(val);
            String name = (String)indexNames.get(ix);
            try {
                double value = converter.convert(ix, val);
                if (doTotal && value > 0.0 && value != Double.NaN) {
                    total += value;
                }
                this.setValue(name + "." + counterName, value);
                if (!isAvail) continue;
                if (this.availableValues.contains(value)) {
                    this.setValue(name + "." + "Availability", 1.0);
                    continue;
                }
                this.setValue(name + "." + "Availability", 0.0);
                continue;
            }
            catch (Exception e) {
                this.getLog().warn((Object)(columnName + ".convert failed for " + name + "@" + this.getInfo()));
            }
        }
        if (doTotal) {
            this.setValue("_TOTAL_." + counterName, total);
        }
    }

    public void init() throws PluginException {
        this._client = new SNMPClient();
        this._props = this.getProperties();
        this.initAvailableValues();
        for (int i = 0; i < DEFAULT_PROPS.length; ++i) {
            String key = DEFAULT_PROPS[i][0];
            String val = DEFAULT_PROPS[i][1];
            if (this._props.getProperty(key) != null) continue;
            this._props.setProperty(key, val);
        }
        this.setSource(this.getInfo());
        try {
            this.init(this._client.getSession(this._props));
        }
        catch (SNMPException e) {
            throw new PluginException(this.getInfo() + ": " + e.getMessage());
        }
    }

    protected void init(SNMPSession session) throws PluginException {
    }

    public void collect() {
    }

    public static class GenericColumnValueConverter
    implements ColumnValueConverter {
        public double convert(String index, SNMPValue value) throws Exception {
            return value.toLong();
        }
    }

    public static interface ColumnValueConverter {
        public double convert(String var1, SNMPValue var2) throws Exception;
    }
}

