/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeblogicLogParser {
    private Pattern pattern = null;
    private static final Log LOG = LogFactory.getLog((String)WeblogicLogParser.class.getName());
    public static final String DATE_TIME_FORMAT_PROPERTY = "weblogic.parser.datetime.format";
    private static final String DEFAULT_DATE_TIME_FORMAT = "MMMM d, yyyy h:mm:ss a z";
    private DateFormat dateTimeFormat = new SimpleDateFormat("MMMM d, yyyy h:mm:ss a z", Locale.getDefault());

    public DateFormat getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(DateFormat dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    private Pattern getPattern() {
        if (this.pattern == null) {
            String linePattern = "<[^>]*(<[^>]*>)*[^<]*> ";
            this.pattern = Pattern.compile(linePattern);
        }
        return this.pattern;
    }

    private String nextField(Iterator it) {
        String field = (String)it.next();
        int ix = field.lastIndexOf("> ");
        if (ix == -1) {
            return field.substring(1);
        }
        return field.substring(1, ix);
    }

    Entry parse(String line) {
        if (!line.startsWith("####")) {
            return null;
        }
        line = line.substring(4) + " ";
        ArrayList<String> list = new ArrayList<String>();
        Matcher matcher = this.getPattern().matcher(line);
        int i = 0;
        while (matcher.find()) {
            list.add(matcher.group());
            if (++i < 9) continue;
            String field = line.substring(matcher.end(), line.length());
            list.add(field);
            break;
        }
        Entry entry = new Entry();
        Iterator it = list.iterator();
        String timestamp = this.nextField(it);
        try {
            entry.time = this.dateTimeFormat.parse(timestamp).getTime();
        }
        catch (ParseException e) {
            LOG.warn((Object)("Unable to match log timestamp (" + timestamp + ") with the current date format. Adjust the formatter property (" + DATE_TIME_FORMAT_PROPERTY + ") to get accurate timestamp results. Using current time for event until format is fixed."));
            entry.time = System.currentTimeMillis();
        }
        entry.level = this.nextField(it);
        entry.subsystem = this.nextField(it);
        entry.machine = this.nextField(it);
        entry.server = this.nextField(it);
        entry.thread = this.nextField(it);
        entry.user = this.nextField(it);
        entry.transaction = this.nextField(it);
        entry.id = this.nextField(it);
        entry.message = this.nextField(it);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        WeblogicLogParser parser = new WeblogicLogParser();
        block5: for (int i = 0; i < args.length; ++i) {
            File file = new File(args[i]);
            System.out.println(file);
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    try {
                        Entry entry = parser.parse(line);
                        if (entry == null) continue;
                        System.out.println(entry);
                    }
                    catch (Exception e) {
                        System.out.println("ERROR-->" + e.getMessage());
                        e.printStackTrace();
                        continue block5;
                    }
                }
                continue;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    class Entry {
        long time;
        String level;
        String subsystem;
        String machine;
        String server;
        String thread;
        String user;
        String transaction;
        String id;
        String message;

        Entry() {
        }

        public String toString() {
            return "[" + this.level + "] " + "[" + new Date(this.time) + "] " + this.message;
        }
    }
}

