/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import java.text.SimpleDateFormat;
import java.util.Locale;
import org.hyperic.hq.plugin.weblogic.WeblogicLogParser;
import org.hyperic.hq.product.LogFileTailPlugin;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.sigar.FileInfo;

public class WeblogicLogFileTrackPlugin
extends LogFileTailPlugin {
    private static final String[] LOG_LEVELS = new String[]{"Error,Critical,Alert,Emergency", "Warning", "Info,Notice", "Debug,Trace"};
    private WeblogicLogParser parser = null;

    private WeblogicLogParser getParser() {
        if (this.parser == null) {
            this.parser = new WeblogicLogParser();
            String dateTimeFormatString = this.getManager().getProperty("weblogic.parser.datetime.format");
            if (dateTimeFormatString != null) {
                try {
                    this.parser.setDateTimeFormat(new SimpleDateFormat(dateTimeFormatString, Locale.getDefault()));
                }
                catch (IllegalArgumentException e) {
                    this.getLog().error((Object)("Unable to create date format from: " + dateTimeFormatString + ". Using default."));
                }
            }
        }
        return this.parser;
    }

    public String[] getLogLevelAliases() {
        return LOG_LEVELS;
    }

    public TrackEvent processLine(FileInfo info, String line) {
        WeblogicLogParser.Entry entry;
        try {
            entry = this.getParser().parse(line);
            if (entry == null) {
                return null;
            }
        }
        catch (Exception e) {
            this.getLog().error((Object)("Error parsing line: '" + line + "'"), (Throwable)e);
            return null;
        }
        return this.newTrackEvent(entry.time, entry.level, entry.subsystem, entry.message);
    }
}

