/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.weblogic;

import org.hyperic.hq.plugin.weblogic.WeblogicAction;
import org.hyperic.hq.plugin.weblogic.WeblogicAuthControl;
import org.hyperic.hq.plugin.weblogic.WeblogicMetric;
import org.hyperic.hq.plugin.weblogic.WeblogicUtil;
import org.hyperic.hq.product.ControlPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.config.ConfigResponse;

public abstract class WeblogicJMXControl
extends ControlPlugin
implements WeblogicAction {
    protected static final String STRING_CLASS = String.class.getName();
    private Metric componentMetric = null;
    private WeblogicAuthControl authControl;

    public WeblogicJMXControl() {
        this.setName("weblogic");
    }

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this.authControl = new WeblogicAuthControl(this, this.getConfiguredComponentMetric());
    }

    protected String getAdminURL() {
        return this.getConfig().getValue("admin.url");
    }

    protected String getAdminUsername() {
        return this.getConfig().getValue("admin.username");
    }

    protected String getAdminPassword() {
        return this.getConfig().getValue("admin.password");
    }

    protected Metric configureMetric(String template) {
        template = WeblogicMetric.translateNode(template, this.getConfig());
        String metric = Metric.translate((String)template, (ConfigResponse)this.getConfig());
        this.getLog().debug((Object)("configureMetric=" + metric));
        try {
            return Metric.parse((String)metric);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected abstract String getComponentMetric();

    protected Metric getConfiguredComponentMetric() {
        if (this.componentMetric == null) {
            this.componentMetric = this.configureMetric(this.getComponentMetric());
        }
        return this.componentMetric;
    }

    protected boolean convertIsRunning(Object value) {
        return (Boolean)value;
    }

    protected boolean isRunning() {
        return this.authControl.isRunning();
    }

    public boolean isWeblogicRunning() {
        Object value;
        Metric metric = this.getConfiguredComponentMetric();
        try {
            value = WeblogicUtil.getRemoteMBeanValue(metric);
            this.getLog().debug((Object)("isRunning: " + metric + "=" + value));
        }
        catch (Exception e) {
            this.getLog().trace((Object)("isRunning: " + metric), (Throwable)e);
            return false;
        }
        return this.convertIsRunning(value);
    }

    protected String getInvokeMethod(String action) {
        return action;
    }

    public void doAction(String action) throws PluginException {
        this.authControl.doAction(action);
    }

    public void doWeblogicAction(String action) {
        Metric mbean = this.getConfiguredComponentMetric();
        String method = this.getInvokeMethod(action);
        Object[] args = new Object[]{};
        String[] sig = new String[]{};
        try {
            Object obj = WeblogicUtil.invoke(mbean, method, args, sig);
            this.setResult(0);
            if (obj != null) {
                this.setMessage(obj.toString());
            }
        }
        catch (Exception e) {
            this.setResult(-1);
            this.setMessage(e.getMessage());
            this.getLog().debug((Object)"doAction: invoke failed", (Throwable)e);
        }
        this.getLog().debug((Object)("doAction: result=" + this.getResult()));
    }
}

