//////////////////////////////////////////////////
// diskpart.js

/** utility **************************************/

function include(filename) {
    var fso = new ActiveXObject("Scripting.FileSystemObject");
    var f = fso.OpenTextFile(filename);
    var s = f.ReadAll();
    f.Close();
    return s;
};

/** include **************************************/

eval(include("drive_letters.js"));
eval(include("workitem.js"));

/** class ****************************************/

function NetworkDrive(bag) {
    this.map = function(letter, path) {
        // false == do NOT add to profile
        this.net.MapNetworkDrive(letter, path, false, this.username, this.password);
    };

    this.unmap = function(letter) {
        this.net.RemoveNetworkDrive(letter);
    };

    // c-tor
    this.bag = bag;
    this.net = new ActiveXObject("WScript.Network");

    this.username = undefined;
    this.password = undefined;

    if (this.bag.exists("Image.Network.User")) {
        this.username = bag.get("Image.Network.User");
    }

    if (this.bag.exists("Image.Network.Password")) {
        this.password = bag.get("Image.Network.Password");
    }
}

function Deploy() {
    this.shell = new ActiveXObject("WScript.Shell");

    this.apply = function(imageFile, imageNumber, imagePath) {
        var cmd = "%comspec% /c imagex.exe /SCROLL /APPLY";
        cmd += " " + imageFile;
        cmd += " " + imageNumber;
        cmd += " " + imagePath;
        cmd += " 2>&1";

        //WScript.Echo(cmd);
        // var p = this.shell.Exec("net use");
        var p = this.shell.Exec(cmd);
	var pStr = p.StdOut.ReadAll();
    	if (pStr.indexOf("Error") !=-1) {
		    throw Error(9001, "Error applying the WIM");
    	}
        WScript.Echo(p.StdOut.ReadAll());
    };
}


/** main *****************************************/

try {
    this.dl = new DriveLetters();
    var letter = dl.getNextNetwork() + ":";

    if (!dl.isAllocated("C")) {
        throw Error(9001, "Expected to use the C: for WIM deployment, but it does not exist!");
    }

    var bag = new WorkItem("properties.xml");

    if (!bag.exists("Image.WIM.Path")) {
        throw Error(9001, "The WIM share (Image.WIM.Path) was not specified!!");
    }

    if (!bag.exists("Image.WIM.Index")) {
        throw Error(9001, "The WIM index (Image.WIM.Index) was not specified!!");
    }

    if (!bag.exists("Image.WIM.Name")) {
        throw Error(9001, "The WIM file name (Image.WIM.Name) was not specified!!");
    }

    var path = bag.get("Image.WIM.Path");
    var winIndex = bag.get("Image.WIM.Index");
    var wimName = letter + "\\" + bag.get("Image.WIM.Name");
    
    var networkDrive = new NetworkDrive(bag);
    networkDrive.map(letter, path);

    var deploy = new Deploy(bag);
    deploy.apply( wimName,winIndex, "C:");
    networkDrive.unmap(letter);

} catch (e) {
	var fso = new ActiveXObject("Scripting.FileSystemObject");
	var objFile = fso.OpenTextFile("gugenterror.txt", 2, true, 0);
	objFile.WriteLine(e.message);
	objFile.Close();
    throw e;
}
