//////////////////////////////////////////////////
// diskpart_clean.js
//
// @author: Christopher Boumenot

/** utility **************************************/

function include(filename) {
    var fso = new ActiveXObject("Scripting.FileSystemObject");
    var f = fso.OpenTextFile(filename);
    var s = f.ReadAll();
    f.Close();
    return s;
};

/** include **************************************/

eval(include("script_writer.js"));
eval(include("workitem.js"));

/** class ****************************************/

function DiskClean(offset) {
    this.offset = offset;

    this.toString = function() {
        var lines = new Array();
        lines.push("select disk " + this.offset);
        lines.push("online disk NOERR");
        lines.push("clean");

        return lines.join("\r\n");
    };
}

//////////////////////////////////////////////////
// main

try {
    sw = new ScriptWriter("diskpart", ".scr");
    var wmi = GetObject("winmgmts://./root/cimv2");
    bag = new WorkItem("properties.xml");

    // Iterate over the machine's disks and
    //  - wipe existing partitions
    // CMB: diskpart supports a primitive form of looping ...
    var physicalDisks = new Enumerator(wmi.ExecQuery("SELECT * FROM Win32_DiskDrive"));
    for (var count = 0; !physicalDisks.atEnd(); physicalDisks.moveNext(), count++) {

        if (!bag.exists("VirtualMachine.disk" + count + ".size")) {
            break;
        }

        var disk = new DiskClean(count);
        sw.write(disk);
    }
} catch (e) {
    throw e;
}
