#!/usr/bin/python
import sys
from xml.dom.minidom import parse

hostname_file = '/etc/HOSTNAME'
if len(sys.argv) > 1:
    hostname_file = sys.argv[1]

dict = {}

for node in parse("properties.xml").getElementsByTagName("property"):
    name = node.attributes['name'].nodeValue
    data = node.attributes['value'].nodeValue

    dict[name.lower()] = data

hostname = dict['virtualmachine.admin.name']
dns_suffix = ''

if dict.has_key('virtualmachine.network.default'):
    default_network_offset = dict['virtualmachine.network.default']
    default_network = 'virtualmachine.network%s.dnssuffix' % default_network_offset
    
    if dict.has_key(default_network):
        dns_suffix = dict[default_network]

hostname = "%s.%s" % (hostname, dns_suffix)
hostname = hostname.rstrip('.')

open(hostname_file, 'w').write(hostname)

# vim: ts=4 sw=4 et
