#!/usr/bin/python
import glob, os, sys
from bag import Bag
from interface import SuseInterface
from version import Version


def get_ifcfg_eth(offset):
    suse_version_major = Version().get_version()[1]

    if suse_version_major == 10:
        sysfs_eth = '/sys/class/net/eth%d/address' % offset
        mac_addr = open(sysfs_eth).read().strip()

        return '/etc/sysconfig/network/ifcfg-eth-id-%s' % mac_addr
    else:
        return '/etc/sysconfig/network/ifcfg-eth%d' % offset

def main():
    if len(sys.argv) > 1:
        ifcfg_eth_template = sys.argv[1]

    bag = Bag('properties.xml')

    for i in range(32):
        sysfs_eth = '/sys/class/net/eth%s' % i

        if not os.path.exists(sysfs_eth):
            break

        if bag.has_key('VirtualMachine.Network%s.Address' % i):
            ifcfg_eth = get_ifcfg_eth(i)
            if len(sys.argv) > 1:
                ifcfg_eth = sys.argv[i + 1]

            ifcfg_eth_lines = []
            if os.path.exists(ifcfg_eth):
                ifcfg_eth_lines = open(ifcfg_eth).readlines()

            intf = SuseInterface(bag, i)

            s = "\n".join(intf.lines(ifcfg_eth_lines)) + "\n"
            open(ifcfg_eth, 'w').write(s)


if __name__ == '__main__':
    main()

# vim: sw=4 ts=4 et
