#!/bin/bash

#####################################################
# Script for the task "CustomizeGuestOS"            #
# Will partition, format and mount additional disks #
# Date: 06/17/2010                                  #
# Author: Anton S 					                #
#####################################################

#source ../scripts/default/Common_Functions.sh || exit 3

FILE_HDR="[VRMAgent:$0]"

#set -x

fnSetupDisk()
{
	#WRK_DISK=/dev/sdb
	WRK_DISK=$1 
	#MNT_POINT=/mnt/disk1
	MNT_POINT=$2
	#FS_TYPE=ext3
	FS_TYPE=$3
	
	WRK_PART=${WRK_DISK}1

	fdisk -l | grep $WRK_PART
	if [ $? -eq 0 ]; then
		logger "$FILE_HDR Requested partition $WRK_PART already exist. Skip ..."
		echo "$FILE_HDR Requested partition $WRK_PART already exist. Skip ..." >> /usr/share/gugent/echo.out
		return 1
	fi

	mount | grep $MNT_POINT
	if [ $? -eq 0 ]; then
		logger "$FILE_HDR $MNT_POINT is already mounted. Skip ..."
		echo "$FILE_HDR $MNT_POINT is already mounted. Skip ..." >> /usr/share/gugent/echo.out
		return 2
	fi

	grep $MNT_POINT /etc/fstab
	if [ $? -eq 0 ]; then
		logger "$FILE_HDR $MNT_POINT exxist in /etc/fstab. Skip ..."
		echo "$FILE_HDR $MNT_POINT exxist in /etc/fstab. Skip ..." >> /usr/share/gugent/echo.out
		return 3
	fi

	which mkfs.$FS_TYPE
	if [ $? -ne 0 ]; then
		logger "$FILE_HDR Unknown FS type: $FS_TYPE. Skip ..."
		echo "$FILE_HDR Unknown FS type: $FS_TYPE. Skip ..." >> /usr/share/gugent/echo.out
		return 4
	fi


#	echo "Creating $WRK_PART as $MNT_POINT with $FS_TYPE FS ..."

fdisk $WRK_DISK << EOF
n
p
1


t
83
w
EOF

	its_there=0
	for i in 1 2 3 4 5 6 7 8 9 10
	do
		ls /dev/sd* | grep $WRK_PART
		if [ $? -ne 0 ]; then
			sleep 1
		else
			its_there=1
			break
		fi
	done

	if [ $its_there -eq 0 ]; then
		logger "$FILE_HDR fdisk add partition failed. Stop ..."
		echo "$FILE_HDR fdisk add partition failed. Stop ..." >> /usr/share/gugent/echo.out
		return 5
	fi

	mkfs.$FS_TYPE -v $WRK_PART >> /usr/share/gugent/echo.out

	if [ $? -ne 0 ]; then
		logger "$FILE_HDR mkfs.$FS_TYPE command failed. Stop ..."
		echo "$FILE_HDR mkfs.$FS_TYPE command failed. Stop ..." >> /usr/share/gugent/echo.out
		return 6
	fi

	mkdir -p $MNT_POINT

	mount $WRK_PART $MNT_POINT

	if [ $? -ne 0 ]; then
		logger "$FILE_HDR Warning: cannot mount $WRK_PART as $MNT_POINT ..."
		echo "$FILE_HDR Warning: cannot mount $WRK_PART as $MNT_POINT ..." >> /usr/share/gugent/echo.out
	fi

	echo "$WRK_PART         $MNT_POINT              $FS_TYPE        defaults        1 2" >> /etc/fstab
	
	logger "$FILE_HDR Done creating $WRK_PART as $MNT_POINT with $FS_TYPE FS ..."
	echo "$FILE_HDR Done creating $WRK_PART as $MNT_POINT with $FS_TYPE FS ..." >> /usr/share/gugent/echo.out
}


i=1
for disk in `ls -1 /dev/sd[b-z]`
do
	PropertyName=VirtualMachine.Disk$i.Letter
	echo $PropertyName
	PropertyValue=$(python getprop.py $PropertyName)
	mpt=$PropertyValue
	echo $PropertyValue
	
	if [ "$mpt" != "False" ]; then
		PropertyValue=$(python getprop.py VirtualMachine.Disk$i.Filesystem)
		echo $PropertyValue
		fs=$PropertyValue
		echo $fs	
		if [ "$fs" = "False" ]; then
			fs="ext3"
			echo "set fs"
		fi
		
		logger "$FILE_HDR Trying to create $disk as $mpt with $fs FS ..."
		echo "$FILE_HDR Trying to create $disk as $mpt with $fs FS ..." >> /usr/share/gugent/echo.out
		
		fnSetupDisk $disk $mpt $fs
	fi
	
	(( i += 1 ))	
done

exit 0
