#!/bin/bash

############################################
# Script for the task "InstallSoftware"    #
# Date: 28/04/2009                         #
# Author: Arnaud Bonnet & Anton S          #
############################################

# Load script with common functions
# if it occurs an error, exit with code 3
#source ../scripts/default/Common_Functions.sh || exit 3

# Check if needs to run external script
PropertyValue=$(python getprop.py Vrm.Software.Command)

FILE_HDR="[VRMAgent::$0]"

myrv=0

if [ "$PropertyValue" != "False" ];then
    sleep 10

    if [ -f "$PropertyValue" ]; then
        FILE_NAME="$PropertyValue"
    else
        FILE_NAME=`echo "$PropertyValue" | cut -f1 -d' '`
        if [ ! -f $FILE_NAME ]; then
            logger "$FILE_HDR (ERROR): Cannot find script $PropertyValue"
            logger "$FILE_HDR (INFO - Mount): `mount`"
            logger "$FILE_HDR (INFO - Ls): `ls -la $PropertyValue`"
            exit 2
        fi
    fi

    if [ -x $FILE_NAME ]; then
        $PropertyValue
    else
        if [ -z $SHELL ]; then
            /bin/bash $PropertyValue
        else
            $SHELL $PropertyValue
        fi
        rv=$?
        if [ $rv -eq 0 ]; then
            logger "$FILE_HDR (INFO): $SHELL $PropertyValue executed successfully"
        else
            logger "$FILE_HDR (ERROR): $SHELL $PropertyValue failed, error code: $rv"
            myrv=8
        fi
    fi
    sleep 5
    logger "$FILE_HDR (INFO): Unmounting all CD and DVD drives"
    umount -af -t iso9660
    sleep 5
fi

exit $myrv
