﻿SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Add the Vrm_Manager role that has access to all stored procedures.
IF NOT EXISTS( SELECT 1 FROM [dbo].[sysusers] WHERE name=N'Vrm_Manager' and issqlrole=1 )
 BEGIN

	EXEC sp_addrole N'Vrm_Manager'

END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_UpdateAnnouncement]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_UpdateAnnouncement]
GO
CREATE PROCEDURE [dbo].[usp_UpdateAnnouncement]
	@Name NVARCHAR(50),
	@Culture NVARCHAR(50),
	@Message NTEXT,
	@LastUpdate DATETIME = NULL OUT
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	
	SET @Culture = COALESCE(@Culture, '');
	SET @Message = COALESCE(@Message, '');
	SET @LastUpdate = GETDATE();
	
	UPDATE [Announcements]
		SET [Message] = @Message, [LastUpdate] = @LastUpdate
		WHERE [Name] = @Name AND [Culture] = @Culture;
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [Announcements] ([Name], [Culture], [Message], [LastUpdate])
			VALUES (@Name, @Culture, @Message, @LastUpdate);
		
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_UpdateAnnouncement] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectManagementEndpoint]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectManagementEndpoint]
GO
CREATE PROCEDURE [dbo].[usp_SelectManagementEndpoint]
	@ManagementEndpointID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@ManagementEndpointName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		ManagementEndpointID
		,ManagementUri
		,ManagementEndpointName
		,ManagementEndpointDescription
		,it.EndpointType
		,InterfaceType
	FROM [ManagementEndpoints] ep JOIN [InterfaceTypes] it
	ON ep.InterfaceType = it.InterfaceTypeId
	WHERE (ManagementEndpointID = @ManagementEndpointID OR @ManagementEndpointID IS NULL) AND
		(ManagementEndpointName LIKE @SearchString OR @SearchString IS NULL) AND
		(ManagementEndpointName = @ManagementEndpointName OR @ManagementEndpointName IS NULL)
	ORDER BY ManagementEndpointName
END
GO
GRANT EXEC ON [dbo].[usp_SelectManagementEndpoint] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectCostProfile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectCostProfile]
GO
CREATE PROCEDURE [dbo].[usp_SelectCostProfile]
	@CostProfileID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@CostProfileName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		CostProfileID
		,CostProfileName
		,CostProfileDescription
		,MemoryCost
		,DiskCost
		,CpuCost
	FROM [CostProfile]
	WHERE (CostProfileID = @CostProfileID OR @CostProfileID IS NULL) AND
		(CostProfileName LIKE @SearchString OR @SearchString IS NULL) AND
		(CostProfileName = @CostProfileName OR @CostProfileName IS NULL)
	ORDER BY CostProfileName
END
GO
GRANT EXEC ON [dbo].[usp_SelectCostProfile] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteCostProfile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteCostProfile]
GO
CREATE PROCEDURE [dbo].[usp_DeleteCostProfile]
	@CostProfileID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [CostProfile] WHERE CostProfileID = @CostProfileID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteCostProfile] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateCostProfile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateCostProfile]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateCostProfile] 
	@CostProfileID uniqueidentifier,
	@CostProfileName nvarchar(50),
	@CostProfileDescription nvarchar(1024),
	@MemoryCost Decimal(10, 4),
	@DiskCost Decimal(10, 4),
	@CpuCost Decimal(10, 4)
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [CostProfile]
	SET 
		CostProfileName = @CostProfileName
		,CostProfileDescription = @CostProfileDescription
		,MemoryCost = @MemoryCost
		,DiskCost = @DiskCost
		,CpuCost = @CpuCost
	WHERE 
		CostProfileID = @CostProfileID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [CostProfile]
		(CostProfileID
		,CostProfileName
		,CostProfileDescription
		,MemoryCost
		,DiskCost
		,CpuCost)
	 VALUES
		(@CostProfileID
		,@CostProfileName
		,@CostProfileDescription
		,@MemoryCost
		,@DiskCost
		,@CpuCost)	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateCostProfile] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectPhysicalLocation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectPhysicalLocation]
GO
CREATE PROCEDURE [dbo].[usp_SelectPhysicalLocation]
	@PhysicalLocationID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@PhysicalLocationName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		PhysicalLocationID
		,PhysicalLocationName
		,PhysicalLocationDescription
	FROM [PhysicalLocation]
	WHERE (PhysicalLocationID = @PhysicalLocationID OR @PhysicalLocationID IS NULL) AND
		(PhysicalLocationName LIKE @SearchString OR @SearchString IS NULL) AND
		(PhysicalLocationName = @PhysicalLocationName OR @PhysicalLocationName IS NULL)
	ORDER BY PhysicalLocationName
END
GO
GRANT EXEC ON [dbo].[usp_SelectPhysicalLocation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeletePhysicalLocation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeletePhysicalLocation]
GO
CREATE PROCEDURE [dbo].[usp_DeletePhysicalLocation]
	@PhysicalLocationID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [PhysicalLocation] WHERE PhysicalLocationID = @PhysicalLocationID
END
GO
GRANT EXEC ON [dbo].[usp_DeletePhysicalLocation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdatePhysicalLocation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdatePhysicalLocation]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdatePhysicalLocation] 
	@PhysicalLocationID uniqueidentifier,
	@PhysicalLocationName nvarchar(50),
	@PhysicalLocationDescription nvarchar(1024)
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	UPDATE [PhysicalLocation]
	SET 
		PhysicalLocationName = @PhysicalLocationName
		,PhysicalLocationDescription = @PhysicalLocationDescription
	WHERE 
		PhysicalLocationID = @PhysicalLocationID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [PhysicalLocation]
		(PhysicalLocationID
		,PhysicalLocationName
		,PhysicalLocationDescription)
	 VALUES
		(@PhysicalLocationID
		,@PhysicalLocationName
		,@PhysicalLocationDescription)	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdatePhysicalLocation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectHostNamePrefix]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectHostNamePrefix]
GO
CREATE PROCEDURE [dbo].[usp_SelectHostNamePrefix]
	@HostNamePrefixID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@MachinePrefix nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		HostnamePrefixID
		,MachinePrefix
		,NextMachineNo
		,MachineNumberLength
	FROM [HostNamePrefix]
	WHERE (HostnamePrefixID = @HostNamePrefixID OR @HostNamePrefixID IS NULL) AND
		(MachinePrefix LIKE @SearchString OR @SearchString IS NULL) AND
		(MachinePrefix = @MachinePrefix OR @MachinePrefix IS NULL)
	ORDER BY MachinePrefix
END
GO
GRANT EXEC ON [dbo].[usp_SelectHostNamePrefix] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteHostNamePrefix]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteHostNamePrefix]
GO
CREATE PROCEDURE [dbo].[usp_DeleteHostNamePrefix]
	@HostNamePrefixID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [HostNamePrefix] WHERE HostnamePrefixID = @HostNamePrefixID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteHostNamePrefix] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateHostNamePrefix]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateHostNamePrefix]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateHostNamePrefix] 
	@HostNamePrefixID uniqueidentifier,
	@MachinePrefix nvarchar(50),
	@NextMachineNo Decimal(8, 2),
	@MachineNumberLength Decimal(8, 2)
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [HostNamePrefix]
	SET 
		MachinePrefix = @MachinePrefix
		,NextMachineNo = @NextMachineNo
		,MachineNumberLength = @MachineNumberLength
	WHERE 
		HostnamePrefixID = @HostNamePrefixID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [HostNamePrefix]
		(HostnamePrefixID
		,MachinePrefix
		,NextMachineNo
		,MachineNumberLength)
	 VALUES
		(@HostNamePrefixID
		,@MachinePrefix
		,@NextMachineNo
		,@MachineNumberLength)	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateHostNamePrefix] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectVrmId]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectVrmId]
GO
CREATE PROCEDURE [dbo].[usp_SelectVrmId]
AS
BEGIN
	SET NOCOUNT ON;
	SELECT 
		VRMID
		,VRMName
		,VRMDescription
		,VRMVersion
		,VRMDBVersion
		,LicensedSockets
		,LicenseKey
	FROM [VRM_ID]
END
GO
GRANT EXEC ON [dbo].[usp_SelectVrmId] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateVrmId]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateVrmId]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateVrmId] 
	@VrmID uniqueidentifier,
	@VrmName nvarchar(128),
	@VrmDescription nvarchar(1024),
	@VrmVersion nvarchar(128),
	@VrmDBVersion nvarchar(128),
	@LicensedSockets int,
	@LicenseKey nvarchar(128)
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	UPDATE [VRM_ID]
	SET 
		VRMName = @VrmName
		,VRMDescription = @VrmDescription
		,VRMVersion = @VrmVersion
		,VRMDBVersion = @VrmDBVersion
		,LicensedSockets = @LicensedSockets
		,LicenseKey = @LicenseKey
	WHERE 
		VRMID = @VrmID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [VRM_ID]
		(VRMID
		,VRMName
		,VRMDescription
		,VRMVersion
		,VRMDBVersion
		,LicensedSockets
		,LicenseKey)
	 VALUES
		(@VrmID
		,@VrmName
		,@VrmDescription
		,@VrmVersion
		,@VrmDBVersion
		,@LicensedSockets
		,@LicenseKey)	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateVrmId] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectCredential]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectCredential]
GO
CREATE PROCEDURE [dbo].[usp_SelectCredential]
	@CredentialID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@CredentialName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		CredentialID
		,CredentialName
		,CredentialDescription
		,UserName
		,Domain
		,Password
		,Certificate
	FROM [Credential]
	WHERE (CredentialID = @CredentialID OR @CredentialID IS NULL) AND
		(CredentialName LIKE @SearchString OR @SearchString IS NULL) AND
		(CredentialName = @CredentialName OR @CredentialName IS NULL)
	ORDER BY CredentialName
END
GO
GRANT EXEC ON [dbo].[usp_SelectCredential] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteCredential]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteCredential]
GO
CREATE PROCEDURE [dbo].[usp_DeleteCredential]
	@CredentialID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [Credential] WHERE CredentialID = @CredentialID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteCredential] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateCredential]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateCredential]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateCredential] 
	@CredentialID uniqueidentifier,
	@CredentialName nvarchar(128),
	@CredentialDescription nvarchar(1024)=null,
	@UserName nvarchar(128),
	@Domain nvarchar(128)=null,
	@Password nvarchar(128)=null,
	@Certificate nvarchar(max)=null
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [Credential]
	SET 
		CredentialName = @CredentialName
		,CredentialDescription = @CredentialDescription
		,UserName = @UserName
		,Domain = @Domain
		,Password = @Password
		,Certificate = @Certificate
	WHERE 
		CredentialID = @CredentialID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [Credential]
		(CredentialID
		,CredentialName
		,CredentialDescription
		,UserName
		,Domain
		,Password
		,Certificate)
	 VALUES
		(@CredentialID
		,@CredentialName
		,@CredentialDescription
		,@UserName
		,@Domain
		,@Password
		,@Certificate)	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateCredential] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectFilterSpecGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectFilterSpecGroup]
GO
CREATE PROCEDURE [dbo].[usp_SelectFilterSpecGroup]
	@FilterSpecGroupID uniqueidentifier = NULL,
	@FilterSpecGroupName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		FilterSpecGroupID
		,FilterSpecGroupName
		,FilterSpecGroupDesc
		,ScheduleID
		,DependsOnFilterSpecGroupID
	FROM [FilterSpecGroup]
	WHERE (FilterSpecGroupID = @FilterSpecGroupID OR @FilterSpecGroupID IS NULL) AND
		(FilterSpecGroupName = @FilterSpecGroupName OR @FilterSpecGroupName IS NULL)
	ORDER BY FilterSpecGroupName
END
GO
GRANT EXEC ON [dbo].[usp_SelectFilterSpecGroup] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteFilterSpecGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteFilterSpecGroup]
GO
CREATE PROCEDURE [dbo].[usp_DeleteFilterSpecGroup]
	@FilterSpecGroupID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [FilterSpecGroup] WHERE FilterSpecGroupID = @FilterSpecGroupID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteFilterSpecGroup] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateFilterSpecGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateFilterSpecGroup]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateFilterSpecGroup] 
	@FilterSpecGroupID uniqueidentifier,
	@FilterSpecGroupName nvarchar(128),
	@FilterSpecGroupDesc nvarchar(1024) = NULL,
	@ScheduleID uniqueidentifier = NULL,
	@DependsOnFilterSpecGroupID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	UPDATE [FilterSpecGroup]
	SET 
		FilterSpecGroupName = @FilterSpecGroupName
		,FilterSpecGroupDesc = @FilterSpecGroupDesc
		,ScheduleID = @ScheduleID
		,DependsOnFilterSpecGroupID = @DependsOnFilterSpecGroupID
	WHERE 
		FilterSpecGroupID = @FilterSpecGroupID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [FilterSpecGroup]
		(FilterSpecGroupID
		,FilterSpecGroupName
		,FilterSpecGroupDesc
		,ScheduleID
		,DependsOnFilterSpecGroupID)
	 VALUES
		(@FilterSpecGroupID
		,@FilterSpecGroupName
		,@FilterSpecGroupDesc
		,@ScheduleID
		,@DependsOnFilterSpecGroupID)	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateFilterSpecGroup] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectSchedule]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectSchedule]
GO
CREATE PROCEDURE [dbo].[usp_SelectSchedule]
	@ScheduleID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@ScheduleName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		ScheduleID
		,ScheduleName
		,ScheduleDesc
		,ScheduleExpression
	FROM [CollectionSchedule]
	WHERE (ScheduleID = @ScheduleID OR @ScheduleID IS NULL) AND
		(ScheduleName LIKE @SearchString OR @SearchString IS NULL) AND
		(ScheduleName = @ScheduleName OR @ScheduleName IS NULL)
	ORDER BY ScheduleName
END
GO
GRANT EXEC ON [dbo].[usp_SelectSchedule] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteSchedule]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteSchedule]
GO
CREATE PROCEDURE [dbo].[usp_DeleteSchedule]
	@ScheduleID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [CollectionSchedule] WHERE ScheduleID = @ScheduleID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteSchedule] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateSchedule]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateSchedule]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateSchedule] 
	@ScheduleID uniqueidentifier,
	@ScheduleName nvarchar(128),
	@ScheduleDesc nvarchar(1024),
	@ScheduleExpression nvarchar(128)
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	UPDATE [CollectionSchedule]
	SET 
		ScheduleName = @ScheduleName
		,ScheduleDesc = @ScheduleDesc
		,ScheduleExpression = @ScheduleExpression
	WHERE 
		ScheduleID = @ScheduleID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [CollectionSchedule]
		(ScheduleID
		,ScheduleName
		,ScheduleDesc
		,ScheduleExpression)
	 VALUES
		(@ScheduleID
		,@ScheduleName
		,@ScheduleDesc
		,@ScheduleExpression)	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateSchedule] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectAgent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectAgent]
GO
CREATE PROCEDURE [dbo].[usp_SelectAgent]
	@AgentID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@AgentName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		AgentID
		,AgentName
		,AgentDescription
		,AgentAlive
		,AgentHostName
		,AgentVersion
		,AgentGeneratedID
		,ManagesAll
		,WorkItemsProcessed
		,LastAccessed
	FROM [Agent]
	WHERE (AgentID = @AgentID OR @AgentID IS NULL) AND
		(AgentName LIKE @SearchString OR @SearchString IS NULL) AND
		(AgentName = @AgentName OR @AgentName IS NULL)
	ORDER BY AgentName
END
GO
GRANT EXEC ON [dbo].[usp_SelectAgent] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectHostAgents]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectHostAgents]
GO
CREATE PROCEDURE [dbo].[usp_SelectHostAgents]
	@HostID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	SELECT 
		Agent.AgentID
		,AgentName
		,AgentDescription
		,AgentAlive
		,AgentHostName
		,AgentVersion
		,AgentGeneratedID
		,ManagesAll
		,WorkItemsProcessed
		,LastAccessed
		,HostID
	FROM [Agent], [HostToAgent]
	WHERE Agent.AgentID = HostToAgent.AgentID AND
		HostID = @HostID
	ORDER BY AgentName
END
GO
GRANT EXEC ON [dbo].[usp_SelectHostAgents] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteAgent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteAgent]
GO
CREATE PROCEDURE [dbo].[usp_DeleteAgent]
	@AgentID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [Agent] WHERE AgentID = @AgentID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteAgent] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateAgent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateAgent]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateAgent] 
	@AgentID uniqueidentifier,
	@AgentName nvarchar(128),
	@AgentDescription nvarchar(1024)=NULL,
	@AgentAlive bit,
	@AgentHostName nvarchar(128),
	@AgentVersion nvarchar(128)=NULL,
	@AgentGeneratedID nvarchar(128)=NULL,
	@ManagesAll bit=NULL,
	@WorkItemsProcessed int=NULL,
	@LastAccessed datetime=NULL
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [Agent]
	SET 
		AgentName = @AgentName
		,AgentDescription = @AgentDescription
		,AgentAlive = @AgentAlive
		,AgentHostName = @AgentHostName
		,AgentVersion = @AgentVersion
		,AgentGeneratedID = @AgentGeneratedID
		,ManagesAll = @ManagesAll
		,WorkItemsProcessed = @WorkItemsProcessed
		,LastAccessed = @LastAccessed
	WHERE 
		AgentID = @AgentID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [Agent]
		(AgentID
		,AgentName
		,AgentDescription
		,AgentAlive
		,AgentHostName
		,AgentVersion
		,AgentGeneratedID
		,ManagesAll
		,WorkItemsProcessed
		,LastAccessed)
	 VALUES
		(@AgentID
		,@AgentName
		,@AgentDescription
		,@AgentAlive
		,@AgentHostName
		,@AgentVersion
		,@AgentGeneratedID
		,@ManagesAll
		,@WorkItemsProcessed
		,@LastAccessed)	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateAgent] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteHostAgentAssociation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteHostAgentAssociation]
GO
CREATE PROCEDURE [dbo].[usp_DeleteHostAgentAssociation]
	@AgentID uniqueidentifier,
	@HostID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [HostToAgent] WHERE AgentID = @AgentID AND HostID = @HostID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteHostAgentAssociation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertHostAgentAssociation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertHostAgentAssociation]
GO
CREATE PROCEDURE [dbo].[usp_InsertHostAgentAssociation] 
	@AgentID uniqueidentifier,
	@HostID uniqueidentifier
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	INSERT INTO [HostToAgent] (AgentID, HostID) VALUES (@AgentID, @HostID)	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertHostAgentAssociation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteEnterpriseAdminHostAssociation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteEnterpriseAdminHostAssociation]
GO
CREATE PROCEDURE [dbo].[usp_DeleteEnterpriseAdminHostAssociation]
	@EnterpriseAdminGroupID uniqueidentifier,
	@HostID uniqueidentifier=NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [AdminGroupToHost] WHERE EnterpriseAdminID = @EnterpriseAdminGroupID AND ( HostID = @HostID OR @HostID IS NULL)
END
GO
GRANT EXEC ON [dbo].[usp_DeleteEnterpriseAdminHostAssociation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertEnterpriseAdminHostAssociation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertEnterpriseAdminHostAssociation]
GO
CREATE PROCEDURE [dbo].[usp_InsertEnterpriseAdminHostAssociation] 
	@EnterpriseAdminGroupID uniqueidentifier,
	@HostName nvarchar(256)
AS
BEGIN
	DECLARE @HostID uniqueidentifier;
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	SELECT @HostID = HostID From Host WHERE HostName=@HostName
	IF @@ROWCOUNT = 1
		INSERT INTO [AdminGroupToHost] (EnterpriseAdminID, HostID) VALUES (@EnterpriseAdminGroupID, @HostID)	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertEnterpriseAdminHostAssociation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectHyperVisor]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectHyperVisor]
GO
CREATE PROCEDURE [dbo].[usp_SelectHyperVisor]
	@HyperVisorManagementID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@HyperVisorName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		HypervisorManagementID
		,HypervisorName
		,HypervisorManagementDescription
		,HypervisorManagementURL
		,ProvisioningEnabled
		,DataCenterName
		,HypervisorTypeID
		,CredentialID
		,HypervisorAgentID
		,MonitoringAgentID
	FROM [HypervisorManagementEndpoint]
	WHERE (HypervisorManagementID = @HyperVisorManagementID OR @HyperVisorManagementID IS NULL) AND
		(HypervisorName LIKE @SearchString OR @SearchString IS NULL) AND
		(HypervisorName = @HyperVisorName OR @HyperVisorName IS NULL)
	ORDER BY HypervisorName
END
GO
GRANT EXEC ON [dbo].[usp_SelectHyperVisor] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteHyperVisor]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteHyperVisor]
GO
CREATE PROCEDURE [dbo].[usp_DeleteHyperVisor]
	@HyperVisorManagementID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [HypervisorManagementEndpoint] WHERE HypervisorManagementID = @HyperVisorManagementID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteHyperVisor] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateHyperVisor]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateHyperVisor]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateHyperVisor] 
	@HyperVisorManagementID uniqueidentifier,
	@HyperVisorName nvarchar(128),
	@HyperVisorManagementDescription nvarchar(1024),
	@HypervisorManagementURL nvarchar(128),
	@ProvisioningEnabled bit,
	@DataCenterName nvarchar(128),
	@HypervisorTypeID tinyint,
	@CredentialID uniqueidentifier,
	@HyperVisorAgentID uniqueidentifier,
	@MonitoringAgentID uniqueidentifier
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [HypervisorManagementEndpoint]
	SET 
		HypervisorName = @HyperVisorName
		,HypervisorManagementDescription = @HyperVisorManagementDescription
		,HypervisorManagementURL = @HypervisorManagementURL
		,ProvisioningEnabled = @ProvisioningEnabled
		,DataCenterName = @DataCenterName
		,HypervisorTypeID = @HypervisorTypeID
		,CredentialID = @CredentialID
		,HypervisorAgentID = @HyperVisorAgentID
		,MonitoringAgentID = @MonitoringAgentID
	WHERE 
		HypervisorManagementID = @HyperVisorManagementID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [HypervisorManagementEndpoint]
		(HypervisorManagementID
		,HypervisorName
		,HypervisorManagementDescription
		,HypervisorManagementURL
		,ProvisioningEnabled
		,DataCenterName
		,HypervisorTypeID
		,CredentialID
		,HypervisorAgentID
		,MonitoringAgentID)
	 VALUES
		(@HyperVisorManagementID
		,@HyperVisorName
		,@HyperVisorManagementDescription
		,@HypervisorManagementURL
		,@ProvisioningEnabled
		,@DataCenterName
		,@HypervisorTypeID
		,@CredentialID
		,@HyperVisorAgentID
		,@MonitoringAgentID)	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateHyperVisor] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectFilterSpec]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectFilterSpec]
GO
CREATE PROCEDURE [dbo].[usp_SelectFilterSpec]
	@FilterSpecID uniqueidentifier = NULL,
	@FilterSpecGroupID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@FilterSpecName nvarchar(256) = NULL,
	@AgentCapabilityName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		FilterSpecID
		,FilterSpecName
		,FilterSpecDesc
		,FilterSpecNamespace
		,FilterSpecPath
		,FilterSpecQuery
		,FilterSpecScript
		,FilterSpecGroupID
		,AgentCapabilityName
	FROM [FilterSpec]
	WHERE (FilterSpecID = @FilterSpecID OR @FilterSpecID IS NULL) AND
		(FilterSpecName LIKE @SearchString OR @SearchString IS NULL) AND
		(FilterSpecName = @FilterSpecName OR @FilterSpecName IS NULL) AND
		(FilterSpecGroupID = @FilterSpecGroupID OR @FilterSpecGroupID IS NULL) AND
		(AgentCapabilityName = @AgentCapabilityName OR @AgentCapabilityName IS NULL)
	ORDER BY FilterSpecName
END
GO
GRANT EXEC ON [dbo].[usp_SelectFilterSpec] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteFilterSpec]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteFilterSpec]
GO
CREATE PROCEDURE [dbo].[usp_DeleteFilterSpec]
	@FilterSpecID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [FilterSpec] WHERE FilterSpecID = @FilterSpecID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteFilterSpec] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateFilterSpec]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateFilterSpec]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateFilterSpec] 
	@FilterSpecID uniqueidentifier
	,@FilterSpecGroupID uniqueidentifier 
	,@FilterSpecName nvarchar(255)
	,@AgentCapabilityName nvarchar(255)
	,@FilterSpecDesc nvarchar(max) = NULL
	,@FilterSpecNamespace nvarchar(255) = NULL
	,@FilterSpecPath nvarchar(255) = NULL
	,@FilterSpecQuery nvarchar(max) = NULL
	,@FilterSpecScript nvarchar(max) = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	SELECT AgentCapabilityName FROM AgentCapabilityType WHERE AgentCapabilityName = @AgentCapabilityName
	IF @@ROWCOUNT = 0 
		INSERT INTO AgentCapabilityType(AgentCapabilityName) VALUES(@AgentCapabilityName)
		
	UPDATE [FilterSpec]
	SET 
		FilterSpecName = @FilterSpecName
		,FilterSpecDesc = @FilterSpecDesc
		,FilterSpecNamespace = @FilterSpecNamespace
		,FilterSpecPath = @FilterSpecPath
		,FilterSpecQuery = @FilterSpecQuery
		,FilterSpecScript = @FilterSpecScript
		,FilterSpecGroupID = @FilterSpecGroupID
		,AgentCapabilityName = @AgentCapabilityName
	WHERE 
		FilterSpecID = @FilterSpecID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [FilterSpec]
		(FilterSpecID
		,FilterSpecName
		,AgentCapabilityName
		,FilterSpecDesc
		,FilterSpecNamespace
		,FilterSpecPath
		,FilterSpecQuery
		,FilterSpecScript
		,FilterSpecGroupID)
	 VALUES
		(@FilterSpecID
		,@FilterSpecName
		,@AgentCapabilityName
		,@FilterSpecDesc
		,@FilterSpecNamespace
		,@FilterSpecPath
		,@FilterSpecQuery
		,@FilterSpecScript
		,@FilterSpecGroupID)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateFilterSpec] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteAgentCapabilityType]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteAgentCapabilityType]
GO
CREATE PROCEDURE [dbo].[usp_DeleteAgentCapabilityType]
	@AgentCapabilityName nvarchar(128) = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [AgentCapabilityType] WHERE AgentCapabilityName = @AgentCapabilityName
END
GO
GRANT EXEC ON [dbo].[usp_DeleteAgentCapabilityType] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateAgentCapabilityType]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateAgentCapabilityType]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateAgentCapabilityType] 
	@AgentCapabilityName nvarchar(128)
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	SELECT * FROM [AgentCapabilityType]
	WHERE AgentCapabilityName = @AgentCapabilityName
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [AgentCapabilityType]
		(AgentCapabilityName)
	 VALUES
		(@AgentCapabilityName)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateAgentCapabilityType] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateAgentCapability]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateAgentCapability]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateAgentCapability] 
	@AgentID uniqueidentifier
	,@AgentCapabilityName nvarchar(128)
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	SELECT * FROM [AgentCapabilityType]	WHERE AgentCapabilityName = @AgentCapabilityName
	IF @@ROWCOUNT = 0 
		INSERT INTO [AgentCapabilityType] (AgentCapabilityName) VALUES (@AgentCapabilityName)
		
	SELECT * FROM [AgentCapabilities]	WHERE AgentID = @AgentID AND AgentCapabilityName = @AgentCapabilityName
	IF @@ROWCOUNT = 0 
		INSERT INTO [AgentCapabilities] (AgentID, AgentCapabilityName) VALUES (@AgentID, @AgentCapabilityName)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateAgentCapability] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectAgentCapabilities]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectAgentCapabilities]
GO
CREATE PROCEDURE [dbo].[usp_SelectAgentCapabilities] 
	@AgentID uniqueidentifier
AS
BEGIN
	SET NOCOUNT OFF;
	SELECT * FROM [AgentCapabilities]	WHERE AgentID = @AgentID
END
GO
GRANT EXEC ON [dbo].[usp_SelectAgentCapabilities] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectStorage]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectStorage]
GO
CREATE PROCEDURE [dbo].[usp_SelectStorage]
	@StorageID uniqueidentifier = NULL,
	@StorageArrayID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@StorageName nvarchar(256) = NULL,
	@UniqueID nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		StorageID
		,StorageUniqueID
		,StorageDevice
		,StorageTotalCapacityGB
		,StorageFreeCapacityGB
		,StorageTypeID
		,StorageName
		,ManagementEndpointID
		,IsFileLevelCloneInstalled
		,VolumeSaving
	FROM [Storage]
	WHERE (StorageID = @StorageID OR @StorageID IS NULL) AND
		(StorageName LIKE @SearchString OR @SearchString IS NULL) AND
		(StorageName = @StorageName OR @StorageName IS NULL) AND
		(ManagementEndpointID = @StorageArrayID OR @StorageArrayID IS NULL) AND
		(StorageUniqueID = @UniqueID OR @UniqueID IS NULL)
	ORDER BY StorageName
END
GO
GRANT EXEC ON [dbo].[usp_SelectStorage] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteStorage]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteStorage]
GO
CREATE PROCEDURE [dbo].[usp_DeleteStorage]
	@StorageID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [Storage] WHERE StorageID = @StorageID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteStorage] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateStorage]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateStorage]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateStorage] 
	@StorageID uniqueidentifier
	,@StorageUniqueID nvarchar(256)
	,@StorageDevice nvarchar(256) = null
	,@StorageTotalCapacityGB bigint
	,@StorageFreeCapacityGB bigint
	,@StorageTypeID tinyint
	,@StorageName nvarchar(256)
	,@StorageArrayID uniqueidentifier
	,@IsFileLevelCloneInstalled bit
	,@VolumeSaving decimal(5,2)
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [Storage]
	SET 
		StorageUniqueID = @StorageUniqueID
		,StorageDevice = @StorageDevice
		,StorageTotalCapacityGB = @StorageTotalCapacityGB
		,StorageFreeCapacityGB = @StorageFreeCapacityGB
		,StorageTypeID = @StorageTypeID
		,StorageName = @StorageName
		,ManagementEndpointID = @StorageArrayID
		,IsFileLevelCloneInstalled = @IsFileLevelCloneInstalled
		,VolumeSaving = @VolumeSaving
	WHERE 
		StorageID = @StorageID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [Storage]
		(StorageID
		,StorageUniqueID
		,StorageDevice
		,StorageTotalCapacityGB
		,StorageFreeCapacityGB
		,StorageTypeID
		,StorageName
		,ManagementEndpointID
		,IsFileLevelCloneInstalled
		,VolumeSaving)
	 VALUES
		(@StorageID
		,@StorageUniqueID
		,@StorageDevice
		,@StorageTotalCapacityGB
		,@StorageFreeCapacityGB
		,@StorageTypeID
		,@StorageName
		,@StorageArrayID
		,@IsFileLevelCloneInstalled
		,@VolumeSaving)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateStorage] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectRequest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectRequest]
GO
CREATE PROCEDURE [dbo].[usp_SelectRequest]
	@RequestID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@RequestUser nvarchar(256) = NULL,
	@RequestTypeID tinyint = NULL,
	@VirtualMachineID uniqueidentifier = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT * 
	FROM [RequestView] 
	WHERE (RequestID = @RequestID OR @RequestID IS NULL) AND
		(RequestUser LIKE @SearchString OR @SearchString IS NULL) AND
		(RequestUser = @RequestUser OR @RequestUser IS NULL) AND
		(RequestTypeID = @RequestTypeID OR @RequestTypeID IS NULL) AND
		(VirtualMachineID = @VirtualMachineID OR @VirtualMachineID IS NULL)
	ORDER BY RequestDate
END
GO
GRANT EXEC ON [dbo].[usp_SelectRequest] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectRequestByApprover]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectRequestByApprover]
GO
CREATE PROCEDURE [dbo].[usp_SelectRequestByApprover]
	@RequestID uniqueidentifier = NULL,
	@RequestApprover nvarchar(256) = NULL,
	@RequestTypeID tinyint = NULL,
	@VirtualMachineID uniqueidentifier = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT R.* 
	FROM [RequestView] R 
	INNER JOIN 
		[RequestApprover] RA ON R.RequestID = RA.RequestID
	WHERE 
		(R.RequestID = @RequestID OR @RequestID IS NULL) 
	AND (RA.UserName = (SELECT U.UserID FROM Users U WHERE U.UserName = @RequestApprover) OR @RequestApprover IS NULL) 
	AND (R.RequestTypeID = @RequestTypeID OR @RequestTypeID IS NULL) 
	AND (R.VirtualMachineID = @VirtualMachineID OR @VirtualMachineID IS NULL)
	ORDER BY RequestDate
END
GO
GRANT EXEC ON [dbo].[usp_SelectRequestByApprover] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectApprovarsForRequest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectApprovarsForRequest]
GO
CREATE PROCEDURE [dbo].[usp_SelectApprovarsForRequest]
	@RequestID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	SELECT 
		RA.RequestID
		,U.UserName AS UserName
		,RA.RequestApproverPriority
		,RA.RequestApproverFlags
		,RA.RequestApproverStateID
	FROM RequestApprover RA
	LEFT OUTER JOIN
		Users U ON U.UserID = RA.UserName
	WHERE RequestID = @RequestID
	ORDER BY RequestApproverPriority
END
GO
GRANT EXEC ON [dbo].[usp_SelectApprovarsForRequest] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteRequest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteRequest]
GO
CREATE PROCEDURE [dbo].[usp_DeleteRequest]
	@RequestID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM RequestApprover WHERE RequestID = @RequestID;
	DELETE FROM RequestAudit WHERE RequestID = @RequestID;
	DELETE FROM [Request] WHERE RequestID = @RequestID;
END
GO
GRANT EXEC ON [dbo].[usp_DeleteRequest] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateRequest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateRequest]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateRequest] 
	@RequestID uniqueidentifier
	,@RequestUser nvarchar(128)
	,@RequestComments nvarchar(max)=NULL
	,@RequestFilter nvarchar(max)=NULL
	,@RequestDescription nvarchar(max)=NULL
	,@VirtualMachineID uniqueidentifier=NULL
	,@HostID uniqueidentifier=NULL
	,@VirtualMachineTemplateID uniqueidentifier=NULL
	,@GroupID uniqueidentifier=NULL
	,@RequestState nvarchar(128)=NULL
	,@CompleteDate datetime=NULL
	,@RequestTypeID tinyint=NULL
	,@WorkflowID uniqueidentifier=NULL
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

		UPDATE [Request]
	SET 
		RequestUser = (SELECT U.UserID FROM Users U WHERE U.UserName = @RequestUser)
		,RequestComments = @RequestComments
		,RequestFilter = @RequestFilter
		,RequestDescription = @RequestDescription
		,VirtualMachineID = @VirtualMachineID
		,HostID = @HostID
		,VirtualMachineTemplateID = @VirtualMachineTemplateID
		,GroupID = @GroupID
		,RequestState = @RequestState
		,CompleteDate = @CompleteDate
		,RequestTypeID = @RequestTypeID
		,WorkflowID = @WorkflowID
	WHERE 
		RequestID = @RequestID;

	IF @@ROWCOUNT = 0 
		INSERT INTO [Request]
		(RequestID
		,RequestUser
		,RequestDate
		,RequestComments
		,RequestFilter
		,RequestDescription
		,VirtualMachineID
		,HostID
		,VirtualMachineTemplateID
		,GroupID
		,RequestState
		,CompleteDate
		,RequestTypeID
		,WorkflowID)
	 SELECT
		@RequestID
		,(SELECT U.UserID FROM Users U WHERE U.UserName = @RequestUser)
		,GETDATE()
		,@RequestComments
		,@RequestFilter
		,@RequestDescription
		,@VirtualMachineID
		,@HostID
		,@VirtualMachineTemplateID
		,@GroupID
		,@RequestState
		,@CompleteDate
		,@RequestTypeID
		,@WorkflowID;
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateRequest] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateUsers]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateUsers]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateUsers] 
	@UserName nvarchar(256)
	,@UserNameDescription nvarchar(max) = NULL
	,@GroupID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	IF @UserName is not null 
	BEGIN
		IF @GroupID is not null 
			UPDATE [Users] SET GroupID = @GroupID WHERE UserName = @UserName;
		IF @UserNameDescription is not null 
			UPDATE [Users] SET UserNameDescription = @UserNameDescription WHERE UserName = @UserName;
		SELECT UserName FROM [Users] WHERE UserName = @UserName;
		IF @@ROWCOUNT = 0 
			INSERT INTO [Users]
			(UserName
			,UserNameDescription
			,GroupID)
		 VALUES
			(@UserName
			,@UserNameDescription
			,@GroupID);
	END
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateUsers] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateRequestApprover]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateRequestApprover]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateRequestApprover] 
	@RequestID uniqueidentifier
	,@UserName nvarchar(256)
	,@RequestApproverPriority int = NULL
	,@RequestApproverFlags bigint = NULL
	,@RequestApproverStateID tinyint = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	IF @UserName is not null 
	BEGIN
		UPDATE [RequestApprover]
		SET 
			RequestApproverPriority = @RequestApproverPriority,
			RequestApproverStateID = @RequestApproverStateID
		WHERE 
			RequestID = @RequestID 
		AND UserName = (SELECT U.UserID FROM Users U WHERE U.UserName = @UserName)

		IF @@ROWCOUNT = 0 
			INSERT INTO [RequestApprover]
			(RequestID
			,UserName
			,RequestApproverStateID
			,RequestApproverPriority)
		 SELECT
			@RequestID
			,(SELECT U.UserID FROM Users U WHERE U.UserName = @UserName)
			,@RequestApproverStateID
			,@RequestApproverPriority
	END
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateRequestApprover] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteRequestApprovers]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteRequestApprovers]
GO
CREATE PROCEDURE [dbo].[usp_DeleteRequestApprovers]
	@RequestID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM RequestApprover WHERE RequestID = @RequestID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteRequestApprovers] TO Vrm_Manager
GO----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectGlobalProfile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectGlobalProfile]
GO
CREATE PROCEDURE [dbo].[usp_SelectGlobalProfile]
	@GlobalProfileID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@GlobalProfileName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		GlobalProfileID
		,ProfileName
		,Description
	FROM [GlobalProfiles]
	WHERE (GlobalProfileID = @GlobalProfileID OR @GlobalProfileID IS NULL) AND
		(ProfileName LIKE @SearchString OR @SearchString IS NULL) AND
		(ProfileName = @GlobalProfileName OR @GlobalProfileName IS NULL)
	ORDER BY ProfileName
END
GO
GRANT EXEC ON [dbo].[usp_SelectGlobalProfile] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteGlobalProfile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteGlobalProfile]
GO
CREATE PROCEDURE [dbo].[usp_DeleteGlobalProfile]
	@GlobalProfileID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [GlobalProfiles] WHERE GlobalProfileID = @GlobalProfileID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteGlobalProfile] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateGlobalProfile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateGlobalProfile]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateGlobalProfile] 
	@GlobalProfileID uniqueidentifier
	,@ProfileName nvarchar(256)
	,@Description nvarchar(max)=null
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [GlobalProfiles]
	SET 
		ProfileName = @ProfileName
		,Description = @Description
	WHERE 
		GlobalProfileID = @GlobalProfileID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [GlobalProfiles]
		(GlobalProfileID
		,ProfileName
		,Description)
	 VALUES
		(@GlobalProfileID
		,@ProfileName
		,@Description)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateGlobalProfile] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectGroup]
GO
CREATE PROCEDURE [dbo].[usp_SelectGroup]
	@GroupID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@GroupName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	/*SET ROWCOUNT @ResultCount;*/
	SELECT 
		GroupID
		,GroupName
		,GroupDescription
		,h.HostnamePrefixID
		,AdContainer
		,AdministratorEmail
		,IsTestGroup
		,h.MachinePrefix
	FROM [ProvisioningGroup] g INNER JOIN  
		HostNamePrefix h ON h.HostnamePrefixID = g.HostnamePrefixID
	WHERE (GroupID = @GroupID OR @GroupID IS NULL) AND
		(GroupName LIKE @SearchString OR @SearchString IS NULL) AND
		(GroupName = @GroupName OR @GroupName IS NULL) AND 
		GroupType = 0
	ORDER BY GroupName
END
GO
GRANT EXEC ON [dbo].[usp_SelectGroup] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteGroup]
GO
CREATE PROCEDURE [dbo].[usp_DeleteGroup]
	@GroupID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [ProvisioningGroup] WHERE GroupID = @GroupID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteGroup] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateGroup]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateGroup] 
	@GroupID uniqueidentifier
	,@GroupName nvarchar(50)
	,@GroupDescription nvarchar(2000) = NULL
	,@HostnamePrefixID uniqueidentifier = NULL
	,@AdContainer nvarchar(2000) = NULL
	,@AdministratorEmail nvarchar(256) = NULL
	,@IsTestGroup bit = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [ProvisioningGroup]
	SET 
		GroupName = @GroupName
		,GroupDescription = @GroupDescription
		,HostnamePrefixID = @HostnamePrefixID
		,AdContainer = @AdContainer
		,AdministratorEmail = @AdministratorEmail
		,IsTestGroup = @IsTestGroup
	WHERE 
		GroupID = @GroupID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [ProvisioningGroup]
		(GroupID
		,GroupName
		,GroupDescription
		,HostnamePrefixID
		,AdContainer
		,AdministratorEmail
		,IsTestGroup
		,GroupType)
	 VALUES
		(@GroupID
		,@GroupName
		,@GroupDescription
		,@HostnamePrefixID
		,@AdContainer
		,@AdministratorEmail
		,@IsTestGroup
		,0)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateGroup] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectUsersForGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectUsersForGroup]
GO
CREATE PROCEDURE [dbo].[usp_SelectUsersForGroup]
	@GroupID uniqueidentifier
AS
BEGIN
	SELECT 
		GroupID
		,UserName
	FROM [Users]
	WHERE GroupID = @GroupID
	ORDER BY UserName
END
GO
GRANT EXEC ON [dbo].[usp_SelectUsersForGroup] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectHost]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectHost]
GO
CREATE PROCEDURE [dbo].[usp_SelectHost]
	@HostID uniqueidentifier = NULL,
	@HostUniqueID nvarchar(256) = NULL,
	@EnterpriseAdminGroupID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@AgentName nvarchar(256) = NULL,
	@HostName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT * FROM HostBasicView
	WHERE (HostBasicView.HostID = @HostID OR @HostID IS NULL) AND
		(HostBasicView.HostUniqueID = @HostUniqueID OR @HostUniqueID IS NULL) AND
		(HostName LIKE @SearchString OR @SearchString IS NULL OR LEN(@SearchString) = 0) AND
		(HostName = @HostName OR @HostName IS NULL) AND
		(AgentName = @AgentName OR @AgentName IS NULL) AND
		(EnterpriseAdminGroupID = @EnterpriseAdminGroupID OR @EnterpriseAdminGroupID IS NULL)
	ORDER BY HostName
END
GO
GRANT EXEC ON [dbo].[usp_SelectHost] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectHostByEnterpriseAdmin]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectHostByEnterpriseAdmin]
GO
CREATE PROCEDURE [dbo].[usp_SelectHostByEnterpriseAdmin]
	@EnterpriseAdminGroupID uniqueidentifier
AS
BEGIN
	SELECT
		*
	FROM
		HostBasicView HV
	WHERE
		HV.HostID IN
		(
			SELECT 
				HostID
			FROM
				AdminGroupToHost
			WHERE
				EnterpriseAdminID = @EnterpriseAdminGroupID
		)
	ORDER BY HostName
END
GO
GRANT EXEC ON [dbo].[usp_SelectHostByEnterpriseAdmin] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectHostNoClusterMember]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectHostNoClusterMember]
GO
CREATE PROCEDURE [dbo].[usp_SelectHostNoClusterMember]
	@HostID uniqueidentifier = NULL,
	@EnterpriseAdminGroupID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@AgentName nvarchar(256) = NULL,
	@HostName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT * FROM HostBasicView
	WHERE (HostBasicView.HostID = @HostID OR @HostID IS NULL) AND
		(HostName LIKE @SearchString OR @SearchString IS NULL OR LEN(@SearchString) = 0) AND
		(HostName = @HostName OR @HostName IS NULL) AND
		(AgentName = @AgentName OR @AgentName IS NULL) AND
		(EnterpriseAdminGroupID = @EnterpriseAdminGroupID OR @EnterpriseAdminGroupID IS NULL) AND 
		ClusterHostID IS NULL
	ORDER BY HostName
END
GO
GRANT EXEC ON [dbo].[usp_SelectHostNoClusterMember] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectClusterMembers]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectClusterMembers]
GO
CREATE PROCEDURE [dbo].[usp_SelectClusterMembers]
	@ClusterHostID uniqueidentifier = NULL,
	@AgentName nvarchar(256) = NULL,
	@HostName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT * FROM HostBasicView
	WHERE (HostBasicView.ClusterHostID = @ClusterHostID OR @ClusterHostID IS NULL) AND
		(HostName = @HostName OR @HostName IS NULL) AND
		(AgentName = @AgentName OR @AgentName IS NULL) 
	ORDER BY HostName
END
GO
GRANT EXEC ON [dbo].[usp_SelectClusterMembers] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectHostReservationScreenInfo]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectHostReservationScreenInfo]
GO
CREATE PROCEDURE [dbo].[usp_SelectHostReservationScreenInfo]
	@HostID uniqueidentifier = NULL,
	@EnterpriseAdminGroupID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@AgentName nvarchar(256) = NULL,
	@HostName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT * FROM HostCapacityView h
	WHERE (h.HostID = @HostID OR @HostID IS NULL) AND
		(HostName LIKE @SearchString OR @SearchString IS NULL OR LEN(@SearchString) = 0) AND
		(HostName = @HostName OR @HostName IS NULL) AND
		(AgentName = @AgentName OR @AgentName IS NULL) AND
		(EnterpriseAdminGroupID = @EnterpriseAdminGroupID OR @EnterpriseAdminGroupID IS NULL)
	ORDER BY HostName
END
GO
GRANT EXEC ON [dbo].[usp_SelectHostReservationScreenInfo] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectHostByHostReservationID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectHostByHostReservationID]
GO
CREATE PROCEDURE [dbo].[usp_SelectHostByHostReservationID]
	@HostReservationID uniqueidentifier,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		h.*
		,a.AgentName
		,r.HostReservationID
	FROM Host h INNER JOIN
		 HostReservation r ON h.HostID = r.HostID LEFT JOIN
		 Agent a ON h.ProvisioningAgentID = a.AgentID
	WHERE (HostReservationID = @HostReservationID) 
	ORDER BY HostName
END
GO
GRANT EXEC ON [dbo].[usp_SelectHostByHostReservationID] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectBasicHost]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectBasicHost]
GO
CREATE PROCEDURE [dbo].[usp_SelectBasicHost]
	@HostID uniqueidentifier = NULL,
	@AgentName nvarchar(256) = NULL,
	@HostName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		h.*
		,a.AgentName
	FROM Host h INNER JOIN
		 Agent a ON h.ProvisioningAgentID = a.AgentID
	WHERE (h.HostID = @HostID OR @HostID IS NULL) AND
		(HostName = @HostName OR @HostName IS NULL) AND
		(AgentName = @AgentName OR @AgentName IS NULL) 
	ORDER BY HostName
END
GO
GRANT EXEC ON [dbo].[usp_SelectBasicHost] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteHost]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteHost]
GO
CREATE PROCEDURE [dbo].[usp_DeleteHost]
	@HostID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [AdminGroupToHost] WHERE HostID = @HostID;
	DELETE FROM [HostToAgent] WHERE HostID = @HostID;
	DELETE FROM [HostToStorage] WHERE HostID = @HostID;
	DELETE FROM [HostNic] WHERE HostID = @HostID;
	DELETE FROM [ResourcePool] WHERE HostID = @HostID;
	DELETE FROM [Host] WHERE HostID = @HostID;
END
GO
GRANT EXEC ON [dbo].[usp_DeleteHost] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateHost]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateHost]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateHost] 
	@HostID uniqueidentifier
	,@ClusterHostID uniqueidentifier
	,@PhysicalLocationID uniqueidentifier
	,@CostProfileID uniqueidentifier
	,@ManagementEndpointID uniqueidentifier
	,@HostName nvarchar(256)
	,@HostStateID tinyint
	,@HostComments nvarchar(2048) = NULL 
	,@HostOSType NVARCHAR(256) = NULL
	,@HostManufacturer NVARCHAR(256) = NULL
	,@HostModel NVARCHAR(256) = NULL
	,@HostUniqueID nvarchar(256) = NULL
	,@IsCluster bit = NULL
	,@HostProcessors integer = NULL
	,@HostProcessorSpeed integer = NULL
	,@HostProcessorType nvarchar(256) = NULL
	,@RecCreationTime datetime = NULL
	,@RecDeleteTime datetime = NULL
	,@RecUpdateTime datetime = NULL
	,@HostTotalMemoryMB bigint = NULL
	,@HostTotalStorageGB bigint = NULL
	,@HostUsedMemoryMB bigint = NULL
	,@HostUsedStorageGB bigint = NULL
	,@ProvisioningAgentID uniqueidentifier = NULL
	,@EnterpriseAdminGroupID uniqueidentifier = NULL
	,@HostDNSName nvarchar(256) = NULL
	,@IsVRMManaged bit = NULL
	,@MachineType tinyint = 0
	,@HostUuid nvarchar(256) = NULL
	,@AllocationType tinyint = NULL
	,@IsTpmEnabled bit = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [Host]
	SET 
		ClusterHostID = @ClusterHostID
		,PhysicalLocationID = @PhysicalLocationID
		,CostProfileID = @CostProfileID
		,ManagementEndpointID = @ManagementEndpointID
		,HostName = @HostName
		,HostComments = @HostComments
		,HostOSType = @HostOSType
		,HostManufacturer = @HostManufacturer
		,HostModel = @HostModel
		,HostUniqueID = @HostUniqueID
		,IsCluster = @IsCluster
		,HostProcessors = @HostProcessors
		,HostProcessorSpeed = @HostProcessorSpeed
		,HostProcessorType = @HostProcessorType
--		,RecCreationTime = @RecCreationTime
--		,RecDeleteTime = @RecDeleteTime
		,RecUpdateTime = GETDATE()
		,HostStateID = @HostStateID
		,HostTotalMemoryMB = @HostTotalMemoryMB
		,HostTotalStorageGB = @HostTotalStorageGB
		,HostUsedMemoryMB = @HostUsedMemoryMB
		,HostUsedStorageGB = @HostUsedStorageGB
		,ProvisioningAgentID = @ProvisioningAgentID
		,HostDNSName = @HostDNSName
		,IsVRMManaged = @IsVRMManaged
		,MachineType = @MachineType
		,HostUuid = @HostUuid
		,AllocationType = @AllocationType
		,IsTpmEnabled = @IsTpmEnabled
	WHERE 
		HostID = @HostID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [Host]
		(HostID
		,ClusterHostID
		,PhysicalLocationID
		,CostProfileID
		,ManagementEndpointID
		,HostName
		,HostComments
		,HostOSType
		,HostManufacturer
		,HostModel
		,HostUniqueID
		,IsCluster
		,HostProcessors
		,HostProcessorSpeed
		,HostProcessorType
		,RecCreationTime
--		,RecDeleteTime
--		,RecUpdateTime
		,HostStateID
		,HostTotalMemoryMB
		,HostTotalStorageGB
		,HostUsedMemoryMB
		,HostUsedStorageGB
		,ProvisioningAgentID
		,HostDNSName
		,IsVRMManaged
		,MachineType
		,HostUuid
		,AllocationType
		,IsTpmEnabled)
	 VALUES
		(@HostID
		,@ClusterHostID
		,@PhysicalLocationID
		,@CostProfileID
		,@ManagementEndpointID
		,@HostName
		,@HostComments
		,@HostOSType
		,@HostManufacturer
		,@HostModel
		,@HostUniqueID
		,@IsCluster
		,@HostProcessors
		,@HostProcessorSpeed
		,@HostProcessorType
		,GETDATE()
--		,@RecDeleteTime
--		,@RecUpdateTime
		,@HostStateID
		,@HostTotalMemoryMB
		,@HostTotalStorageGB
		,@HostUsedMemoryMB
		,@HostUsedStorageGB
		,@ProvisioningAgentID
		,@HostDNSName
		,@IsVRMManaged
		,@MachineType
		,@HostUuid
		,@AllocationType
		,@IsTpmEnabled)
	
	SELECT EnterpriseAdminID From EnterpriseAdminGroups WHERE EnterpriseAdminID = @EnterpriseAdminGroupID
	if @@ROWCOUNT = 1  
	BEGIN
		SELECT HostID From AdminGroupToHost WHERE EnterpriseAdminID = @EnterpriseAdminGroupID AND HostID = @HostID
		if @@ROWCOUNT = 0  
			INSERT INTO AdminGroupToHost(HostID, EnterpriseAdminID) VALUES(@HostID, @EnterpriseAdminGroupID)
	END
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateHost] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectEnterpriseAdminGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectEnterpriseAdminGroup]
GO
CREATE PROCEDURE [dbo].[usp_SelectEnterpriseAdminGroup]
	@EnterpriseAdminID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@AdminName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		EnterpriseAdminID
		,AdminName
		,AdminDescription
		,dbo.GetHostNamesForEnterpriseAdmin(EnterpriseAdminID) AS Hosts
	FROM [EnterpriseAdminGroups]
	WHERE (EnterpriseAdminID = @EnterpriseAdminID OR @EnterpriseAdminID IS NULL) AND
		(AdminName LIKE @SearchString OR @SearchString IS NULL) AND
		(AdminName = @AdminName OR @AdminName IS NULL)
	ORDER BY AdminName
END
GO
GRANT EXEC ON [dbo].[usp_SelectEnterpriseAdminGroup] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectUsersForEnterpriseAdminGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectUsersForEnterpriseAdminGroup]
GO
CREATE PROCEDURE [dbo].[usp_SelectUsersForEnterpriseAdminGroup]
	@EnterpriseAdminID uniqueidentifier
AS
BEGIN
	SELECT 
		 AGM.EnterpriseAdminID
		 ,U.UserName AS UserName
	FROM AdminGroupMembers AGM
	LEFT OUTER JOIN
		Users U ON U.UserID = AGM.UserName
	WHERE EnterpriseAdminID = @EnterpriseAdminID
	ORDER BY UserName
END
GO
GRANT EXEC ON [dbo].[usp_SelectUsersForEnterpriseAdminGroup] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteEnterpriseAdminGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteEnterpriseAdminGroup]
GO
CREATE PROCEDURE [dbo].[usp_DeleteEnterpriseAdminGroup]
	@EnterpriseAdminID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [EnterpriseAdminGroups] WHERE EnterpriseAdminID = @EnterpriseAdminID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteEnterpriseAdminGroup] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateEnterpriseAdminGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateEnterpriseAdminGroup]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateEnterpriseAdminGroup] 
	@EnterpriseAdminID uniqueidentifier
	,@AdminName nvarchar(50)
	,@AdminDescription nvarchar(256) = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [EnterpriseAdminGroups]
	SET 
		AdminName = @AdminName
		,AdminDescription = @AdminDescription
	WHERE 
		EnterpriseAdminID = @EnterpriseAdminID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [EnterpriseAdminGroups]
		(EnterpriseAdminID
		,AdminName
		,AdminDescription)
	 VALUES
		(@EnterpriseAdminID
		,@AdminName
		,@AdminDescription)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateEnterpriseAdminGroup] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectHostNic]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectHostNic]
GO
CREATE PROCEDURE [dbo].[usp_SelectHostNic]
	@HostNicID uniqueidentifier = NULL,
	@HostID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@HostNicName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		HostNicID
		,HostNicUniqueID
		,HostNicName
		,HostID
		,NetworkName
		,MacID
	FROM [HostNic]
	WHERE (HostNicID = @HostNicID OR @HostNicID IS NULL) AND
		(HostID = @HostID OR @HostID IS NULL) AND
		(HostNicName LIKE @SearchString OR @SearchString IS NULL) AND
		(HostNicName = @HostNicName OR @HostNicName IS NULL)
	ORDER BY HostNicName
END
GO
GRANT EXEC ON [dbo].[usp_SelectHostNic] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteHostNic]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteHostNic]
GO
CREATE PROCEDURE [dbo].[usp_DeleteHostNic]
	@HostNicID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [VMToNetwork] WHERE [HostNicID] = @HostNicID;
	DELETE FROM [HostNic] WHERE HostNicID = @HostNicID;
END
GO
GRANT EXEC ON [dbo].[usp_DeleteHostNic] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateHostNic]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateHostNic]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateHostNic] 
	@HostNicID uniqueidentifier
	,@HostNicUniqueID NVARCHAR(40)
	,@HostNicName nvarchar(256)
	,@HostID uniqueidentifier
	,@NetworkName nvarchar(128)
	,@MacID nvarchar(64) = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [HostNic]
	SET 
		HostNicUniqueID = @HostNicUniqueID
		,HostNicName = @HostNicName
		,HostID = @HostID
		,NetworkName = @NetworkName
		,MacID = @MacID
	WHERE 
		HostNicID = @HostNicID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [HostNic]
		(HostNicID
		,HostNicUniqueID
		,HostNicName
		,HostID
		,NetworkName
		,MacID)
	 VALUES
		(@HostNicID
		,@HostNicUniqueID
		,@HostNicName
		,@HostID
		,@NetworkName
		,@MacID)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateHostNic] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectResourcePool]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectResourcePool]
GO
CREATE PROCEDURE [dbo].[usp_SelectResourcePool]
	@ResourcePoolID uniqueidentifier = NULL,
	@HostID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@ResourcePoolName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		ResourcePoolID
		,ResourcePoolUniqueID
		,HostID
		,ResourcePoolName
		,ResourcePoolDesc
		,ResourcePoolMemoryMB
		,ResourcePoolCPU
	FROM [ResourcePool]
	WHERE (ResourcePoolID = @ResourcePoolID OR @ResourcePoolID IS NULL) AND
		(HostID = @HostID OR @HostID IS NULL) AND
		(ResourcePoolName LIKE @SearchString OR @SearchString IS NULL) AND
		(ResourcePoolName = @ResourcePoolName OR @ResourcePoolName IS NULL)
	ORDER BY ResourcePoolName
END
GO
GRANT EXEC ON [dbo].[usp_SelectResourcePool] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteResourcePool]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteResourcePool]
GO
CREATE PROCEDURE [dbo].[usp_DeleteResourcePool]
	@ResourcePoolID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [ResourcePool] WHERE ResourcePoolID = @ResourcePoolID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteResourcePool] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateResourcePool]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateResourcePool]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateResourcePool] 
	@ResourcePoolID uniqueidentifier
	,@ResourcePoolUniqueID nvarchar(256) = NULL
	,@HostID uniqueidentifier
	,@ResourcePoolName nvarchar(256)
	,@ResourcePoolDesc nvarchar(max) = NULL
	,@ResourcePoolMemoryMB integer = NULL
	,@ResourcePoolCPU integer = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [ResourcePool]
	SET 
		ResourcePoolUniqueID = @ResourcePoolUniqueID
		,HostID = @HostID
		,ResourcePoolName = @ResourcePoolName
		,ResourcePoolDesc = @ResourcePoolDesc
		,ResourcePoolMemoryMB = @ResourcePoolMemoryMB
		,ResourcePoolCPU = @ResourcePoolCPU
	WHERE 
		ResourcePoolID = @ResourcePoolID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [ResourcePool]
		(ResourcePoolID
		,ResourcePoolUniqueID
		,HostID
		,ResourcePoolName
		,ResourcePoolDesc
		,ResourcePoolMemoryMB
		,ResourcePoolCPU)
	 VALUES
		(@ResourcePoolID
		,@ResourcePoolUniqueID
		,@HostID
		,@ResourcePoolName
		,@ResourcePoolDesc
		,@ResourcePoolMemoryMB
		,@ResourcePoolCPU)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateResourcePool] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectHostToStorage]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectHostToStorage]
GO
CREATE PROCEDURE [dbo].[usp_SelectHostToStorage]
	@HostToStorageID uniqueidentifier = NULL,
	@HostID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@StoragePath nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		HostToStorageID
		,HostID
		,HS.StorageID
		,HS.StoragePath
		,S.StorageUniqueID
		,S.StorageDevice
		,S.StorageTotalCapacityGB
		,S.StorageFreeCapacityGB
		,S.StorageTypeID
		,S.StorageName
		,S.ManagementEndpointID
		,S.IsFileLevelCloneInstalled
		,S.VolumeSaving
		,COALESCE((SELECT ReservedCapacityInGB FROM [HostStorageReservationView] srv WHERE srv.StorageID = HS.StorageID), 0) ReservedCapacityInGB
		,COALESCE((SELECT ReservedUsedCapacityInGB FROM [HostStorageReservationUsedView] sruv WHERE sruv.StorageID = HS.StorageID), 0) ReservedUsedCapacityInGB
		,COALESCE(HS.Flags, 0) IsDeleted
		,HS.HostStorageReservationPolicyID
	FROM [HostToStorage] HS, [Storage] S
	WHERE HS.StorageID = S.StorageID AND
		(HostToStorageID = @HostToStorageID OR @HostToStorageID IS NULL) AND
		(HostID = @HostID OR @HostID IS NULL) AND
		(StoragePath LIKE @SearchString OR @SearchString IS NULL) AND
		(StoragePath = @StoragePath OR @StoragePath IS NULL)
	ORDER BY StoragePath
END
GO
GRANT EXEC ON [dbo].[usp_SelectHostToStorage] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteHostToStorage]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteHostToStorage]
GO
CREATE PROCEDURE [dbo].[usp_DeleteHostToStorage]
	@HostToStorageID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	SELECT Flags FROM HostReservationToStorage WHERE HostToStorageID = @HostToStorageID
	IF @@ROWCOUNT = 0 
		DELETE FROM [HostToStorage] WHERE HostToStorageID = @HostToStorageID
	ELSE
		UPDATE [HostToStorage] SET Flags = 1 WHERE HostToStorageID = @HostToStorageID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteHostToStorage] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateHostToStorage]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateHostToStorage]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateHostToStorage] 
	 @HostToStorageID uniqueidentifier
	,@HostID uniqueidentifier
	,@StorageID uniqueidentifier
	,@StoragePath nvarchar(256)
	,@StorageUniqueID nvarchar(256)
	,@StorageDevice nvarchar(256) = null
	,@StorageTotalCapacityGB bigint
	,@StorageFreeCapacityGB bigint
	,@StorageTypeID tinyint
	,@StorageName nvarchar(256)
	,@StorageArrayID uniqueidentifier
	,@IsFileLevelCloneInstalled bit
	,@VolumeSaving decimal(5,2)
	,@Flags bigint,
	 @HostStorageReservationPolicyID uniqueidentifier
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	UPDATE [Storage]
	SET 
		StorageUniqueID = @StorageUniqueID
		,StorageDevice = @StorageDevice
		,StorageTotalCapacityGB = @StorageTotalCapacityGB
		,StorageFreeCapacityGB = @StorageFreeCapacityGB
		,StorageTypeID = @StorageTypeID
		,StorageName = @StorageName
		,ManagementEndpointID = @StorageArrayID
		,IsFileLevelCloneInstalled = @IsFileLevelCloneInstalled
	WHERE 
		StorageID = @StorageID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [Storage]
		(StorageID
		,StorageUniqueID
		,StorageDevice
		,StorageTotalCapacityGB
		,StorageFreeCapacityGB
		,StorageTypeID
		,StorageName
		,ManagementEndpointID
		,IsFileLevelCloneInstalled)
	 VALUES
		(@StorageID
		,@StorageUniqueID
		,@StorageDevice
		,@StorageTotalCapacityGB
		,@StorageFreeCapacityGB
		,@StorageTypeID
		,@StorageName
		,@StorageArrayID
		,@IsFileLevelCloneInstalled)

	UPDATE [HostToStorage]
	SET 
		HostID = @HostID
		,StorageID = @StorageID
		,StoragePath = @StorageName
		,HostStorageReservationPolicyID=@HostStorageReservationPolicyID
		,Flags = @Flags
	WHERE 
		HostToStorageID = @HostToStorageID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [HostToStorage]
		(HostToStorageID
		,HostID
		,StorageID
		,StoragePath
		,Flags,HostStorageReservationPolicyID)
	 VALUES
		(@HostToStorageID
		,@HostID
		,@StorageID
		,@StorageName
		,@Flags
		,@HostStorageReservationPolicyID
		)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateHostToStorage] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectHostReservationToStorage]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectHostReservationToStorage]
GO
CREATE PROCEDURE [dbo].[usp_SelectHostReservationToStorage]
	@HostReservationToStorageID uniqueidentifier = NULL,
	@HostReservationID uniqueidentifier = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		HostReservationToStorageID
		,HostReservationID
		,MaxVMsAttachedStorage
		,ReservationPriority
		,Enabled
		,MaxCapacity
		,HostToStorageID
		,IsFileLevelCloneEnabled
		,HostStorageReservationPolicyID
	FROM [HostReservationToStorage] hs
	WHERE (hs.HostReservationToStorageID = @HostReservationToStorageID OR @HostReservationToStorageID IS NULL) AND
		(hs.HostReservationID = @HostReservationID OR @HostReservationID IS NULL)
	ORDER BY ReservationPriority
END
GO
GRANT EXEC ON [dbo].[usp_SelectHostReservationToStorage] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectHostReservationToStorageWithUsage]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectHostReservationToStorageWithUsage]
GO
CREATE PROCEDURE [dbo].[usp_SelectHostReservationToStorageWithUsage]
	@HostReservationToStorageID uniqueidentifier = NULL,
	@HostReservationID uniqueidentifier = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		HostReservationToStorageID
		,HostReservationID
		,MaxVMsAttachedStorage
		,ReservationPriority
		,Enabled
		,(	SELECT	SUM(vmd.Capacity) 
			FROM	VMDiskHardware		vmd
			JOIN	VirtualMachine		vm	ON vmd.VirtualMachineID = vm.VirtualMachineID
			WHERE	vmd.HostToStorageID = hs.HostToStorageID 
			AND		vm.HostReservationID = hs.HostReservationID) UsedCapacityInGB
		,MaxCapacity
		,HostToStorageID
		,IsFileLevelCloneEnabled
		,HostStorageReservationPolicyID
	FROM [HostReservationToStorage] hs
	WHERE (hs.HostReservationToStorageID = @HostReservationToStorageID OR @HostReservationToStorageID IS NULL) AND
		(hs.HostReservationID = @HostReservationID OR @HostReservationID IS NULL)
	ORDER BY ReservationPriority
END
GO
GRANT EXEC ON [dbo].[usp_SelectHostReservationToStorageWithUsage] TO Vrm_Manager
GO----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteHostReservationToStorage]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteHostReservationToStorage]
GO
CREATE PROCEDURE [dbo].[usp_DeleteHostReservationToStorage]
	@HostReservationToStorageID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [HostReservationToStorage] WHERE HostReservationToStorageID = @HostReservationToStorageID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteHostReservationToStorage] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateHostReservationToStorage]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateHostReservationToStorage]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateHostReservationToStorage] 
	@HostReservationToStorageID uniqueidentifier
	,@HostReservationID uniqueidentifier
	,@MaxVMsAttachedStorage integer
	,@ReservationPriority integer
	,@Enabled bit
	,@MaxCapacity bigint 
	,@HostToStorageID uniqueidentifier
	,@IsFileLevelCloneEnabled bit
	,@HostStorageReservationPolicyID uniqueidentifier
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [HostReservationToStorage]
	SET 
		HostReservationID = @HostReservationID
		,MaxVMsAttachedStorage = @MaxVMsAttachedStorage
		,ReservationPriority = @ReservationPriority
		,Enabled = @Enabled
		,MaxCapacity = @MaxCapacity
		,HostToStorageID = @HostToStorageID
		,IsFileLevelCloneEnabled = @IsFileLevelCloneEnabled
		,HostStorageReservationPolicyID = @HostStorageReservationPolicyID 
	WHERE 
		HostReservationToStorageID = @HostReservationToStorageID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [HostReservationToStorage]
		(HostReservationToStorageID
		,HostReservationID
		,MaxVMsAttachedStorage
		,ReservationPriority
		,Enabled
		,MaxCapacity
		,HostToStorageID
		,IsFileLevelCloneEnabled,
		HostStorageReservationPolicyID)
	 VALUES
		(@HostReservationToStorageID
		,@HostReservationID
		,@MaxVMsAttachedStorage
		,@ReservationPriority
		,@Enabled
		,@MaxCapacity
		,@HostToStorageID
		,@IsFileLevelCloneEnabled
		,@HostStorageReservationPolicyID 
		)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateHostReservationToStorage] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectReservationHostNics]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectReservationHostNics]
GO
CREATE PROCEDURE [dbo].[usp_SelectReservationHostNics]
	@HostReservationID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	SELECT 
		HostNic.HostNicID
		,HostNicUniqueID
		,HostNicName
		,HostID
		,NetworkName
		,MacID
	FROM [HostNic], [HostNicToReservation]
	WHERE HostNic.HostNicID = HostNicToReservation.HostNicID AND
		(HostNicToReservation.HostReservationID = @HostReservationID)
	ORDER BY HostNicName
END
GO
GRANT EXEC ON [dbo].[usp_SelectReservationHostNics] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteReservationHostNicAssociation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteReservationHostNicAssociation]
GO
CREATE PROCEDURE [dbo].[usp_DeleteReservationHostNicAssociation]
	@HostReservationID uniqueidentifier,
	@HostNicID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [HostNicToReservation] WHERE HostReservationID = @HostReservationID AND HostNicID = @HostNicID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteHostAgentAssociation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertReservationHostNicAssociation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertReservationHostNicAssociation]
GO
CREATE PROCEDURE [dbo].[usp_InsertReservationHostNicAssociation] 
	@HostReservationID uniqueidentifier,
	@HostNicID uniqueidentifier
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	INSERT INTO [HostNicToReservation] (HostReservationID, HostNicID) VALUES (@HostReservationID, @HostNicID)	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertHostAgentAssociation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectHostReservation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectHostReservation]
GO
CREATE PROCEDURE [dbo].[usp_SelectHostReservation]
	@HostReservationID uniqueidentifier = NULL,
	@HostID uniqueidentifier = NULL,
	@GroupID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@HostReservationName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT * FROM ReservationView
	WHERE (HostReservationID = @HostReservationID OR @HostReservationID IS NULL) AND
		(HostID = @HostID OR @HostID IS NULL) AND
		(GroupID = @GroupID OR @GroupID IS NULL) AND
		(HostReservationName LIKE @SearchString OR @SearchString IS NULL) AND
		(HostReservationName = @HostReservationName OR @HostReservationName IS NULL)
	ORDER BY HostReservationName
END
GO
GRANT EXEC ON [dbo].[usp_SelectHostReservation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteHostReservation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteHostReservation]
GO
CREATE PROCEDURE [dbo].[usp_DeleteHostReservation]
	@HostReservationID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM HostNicToReservation WHERE HostReservationID = @HostReservationID;
	DELETE FROM HostReservationToStorage WHERE HostReservationID = @HostReservationID;
	DELETE FROM [HostReservation] WHERE HostReservationID = @HostReservationID;
END
GO
GRANT EXEC ON [dbo].[usp_DeleteHostReservation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateHostReservation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateHostReservation]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateHostReservation] 
	@HostReservationID uniqueidentifier
	,@HostReservationName nvarchar(256)
	,@Enabled bit
	,@GroupID uniqueidentifier
	,@ReservationMemorySizeMB integer
	,@MaxVMsPowerOn integer
	,@MaxVMsCreate integer=NULL
	,@ReservationPriority integer
	,@ResourcePoolID uniqueidentifier=NULL
	,@HostID uniqueidentifier
	,@StorageAllocationPolicyID tinyint=NULL
	,@ReservationPolicyID uniqueidentifier=NULL
	,@IsFileLevelCloningEnabled bit=null
	,@MachineType TINYINT = 0
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [HostReservation]
	SET 
		HostReservationName = @HostReservationName
		,Enabled = @Enabled
		,GroupID = @GroupID
		,ReservationMemorySizeMB = @ReservationMemorySizeMB
		,MaxVMsPowerOn = @MaxVMsPowerOn
		,MaxVMsCreate = @MaxVMsCreate
		,ResourcePoolID = @ResourcePoolID
		,HostID = @HostID
		,ReservationPriority = @ReservationPriority
		,StorageAllocationPolicyID = @StorageAllocationPolicyID
		,ReservationPolicyID = @ReservationPolicyID
		,IsFileLevelCloningEnabled = @IsFileLevelCloningEnabled
		,MachineType = @MachineType
	WHERE 
		HostReservationID = @HostReservationID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [HostReservation]
		(HostReservationID
		,HostReservationName
		,Enabled
		,GroupID
		,ReservationMemorySizeMB
		,MaxVMsPowerOn
		,MaxVMsCreate
		,ResourcePoolID
		,ReservationPriority
		,StorageAllocationPolicyID
		,HostID
		,ReservationPolicyID
		,IsFileLevelCloningEnabled
		,MachineType)
	 VALUES
		(@HostReservationID
		,@HostReservationName
		,@Enabled
		,@GroupID
		,@ReservationMemorySizeMB
		,@MaxVMsPowerOn
		,@MaxVMsCreate
		,@ResourcePoolID
		,@ReservationPriority
		,@StorageAllocationPolicyID
		,@HostID
		,@ReservationPolicyID
		,@IsFileLevelCloningEnabled
		,@MachineType)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateHostReservation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectWorkflowInfo]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectWorkflowInfo]
GO
CREATE PROCEDURE [dbo].[usp_SelectWorkflowInfo]
	@WorkflowID uniqueidentifier = NULL,
	@AssemblyFQN nvarchar(256) = NULL,
	@WorkflowName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		WorkflowID
		,WorkflowName
		,AssemblyFQN
		,WorkflowDescription
	FROM [WorkflowInfo]
	WHERE (WorkflowID = @WorkflowID OR @WorkflowID IS NULL) AND
		(AssemblyFQN = @AssemblyFQN OR @AssemblyFQN IS NULL) AND
		(WorkflowName = @WorkflowName OR @WorkflowName IS NULL)
	ORDER BY WorkflowName
END
GO
GRANT EXEC ON [dbo].[usp_SelectWorkflowInfo] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteWorkflowInfo]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteWorkflowInfo]
GO
CREATE PROCEDURE [dbo].[usp_DeleteWorkflowInfo]
	@WorkflowID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [WorkflowInfo] WHERE WorkflowID = @WorkflowID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteWorkflowInfo] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateWorkflowInfo]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateWorkflowInfo]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateWorkflowInfo] 
	@WorkflowID uniqueidentifier
	,@WorkflowName nvarchar(50)
	,@AssemblyFQN nvarchar(1024)
	,@WorkflowDescription nvarchar(max)
	,@WorkflowBuildTagType nvarchar(128)
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [WorkflowInfo]
	SET 
		WorkflowName = @WorkflowName
		,AssemblyFQN = @AssemblyFQN
		,WorkflowDescription = @WorkflowDescription
		,WorkflowBuildTagType = @WorkflowBuildTagType
	WHERE 
		WorkflowID = @WorkflowID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [WorkflowInfo]
		(WorkflowID
		,WorkflowName
		,AssemblyFQN
		,WorkflowDescription
		,WorkflowBuildTagType)
	 VALUES
		(@WorkflowID
		,@WorkflowName
		,@AssemblyFQN
		,@WorkflowDescription
		,@WorkflowBuildTagType)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateWorkflowInfo] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectGroupsByTemplate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectGroupsByTemplate]
GO
CREATE PROCEDURE [dbo].[usp_SelectGroupsByTemplate]
	@VirtualMachineTemplateID uniqueidentifier,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		ProvisioningGroup.GroupID
		,GroupName
		,GroupDescription
		,HostnamePrefixID
		,AdContainer
		,AdministratorEmail
		,IsTestGroup
		,VirtualMachineTemplateID
	FROM [ProvisioningGroup], GroupToTemplate
	WHERE (VirtualMachineTemplateID = @VirtualMachineTemplateID) AND
		ProvisioningGroup.GroupID = GroupToTemplate.GroupID
	ORDER BY GroupName
END
GO
GRANT EXEC ON [dbo].[usp_SelectGroupsByTemplate] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteGroupTemplateAssociation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteGroupTemplateAssociation]
GO
CREATE PROCEDURE [dbo].[usp_DeleteGroupTemplateAssociation]
	@VirtualMachineTemplateID uniqueidentifier,
	@GroupID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [GroupToTemplate] WHERE VirtualMachineTemplateID = @VirtualMachineTemplateID AND GroupID = @GroupID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteGroupTemplateAssociation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertGroupTemplateAssociation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertGroupTemplateAssociation]
GO
CREATE PROCEDURE [dbo].[usp_InsertGroupTemplateAssociation] 
	@VirtualMachineTemplateID uniqueidentifier,
	@GroupID uniqueidentifier
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	SELECT * FROM [GroupToTemplate] WHERE VirtualMachineTemplateID = @VirtualMachineTemplateID AND GroupID = @GroupID
	IF @@ROWCOUNT = 0 
		INSERT INTO [GroupToTemplate] (VirtualMachineTemplateID, GroupID) VALUES (@VirtualMachineTemplateID, @GroupID)	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertGroupTemplateAssociation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectVirtualMachineTemplate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectVirtualMachineTemplate]
GO
CREATE PROCEDURE [dbo].[usp_SelectVirtualMachineTemplate]
	@VirtualMachineTemplateID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@VirtualMachineTemplateName nvarchar(256) = NULL,
	@Group nvarchar(256) = NULL,
	@EnabledOnly bit = NULL,
	@MasterOnly bit = NULL
	
AS
BEGIN
	SELECT * FROM VMTemplateView
	WHERE  (Enabled = 1 OR @EnabledOnly IS NULL OR @EnabledOnly = 0) AND
		   (Master = 1 OR @MasterOnly IS NULL OR @MasterOnly = 0) AND
		   ((GroupName = @Group OR @Group IS NULL OR @Group LIKE N'') AND 
			(VirtualMachineTemplateID = @VirtualMachineTemplateID OR @VirtualMachineTemplateID IS NULL) AND
		   (VirtualMachineTemplateName LIKE @SearchString OR @SearchString IS NULL) AND
		   (VirtualMachineTemplateName LIKE @VirtualMachineTemplateName OR @VirtualMachineTemplateName IS NULL OR @VirtualMachineTemplateName LIKE N'') )
	ORDER BY VirtualMachineTemplateName
END
GO
GRANT EXEC ON [dbo].[usp_SelectVirtualMachineTemplate] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectVirtualMachineTemplateByID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectVirtualMachineTemplateByID]
GO
CREATE PROCEDURE [dbo].[usp_SelectVirtualMachineTemplateByID]
	@VirtualMachineTemplateID uniqueidentifier,
	@EnabledOnly bit = NULL
AS
BEGIN
	SELECT * FROM VMTemplateView
	WHERE  (VirtualMachineTemplateID = @VirtualMachineTemplateID) AND
		   (Enabled = 1 OR @EnabledOnly IS NULL OR @EnabledOnly = 0)
	ORDER BY VirtualMachineTemplateName
END
GO
GRANT EXEC ON [dbo].[usp_SelectVirtualMachineTemplateByID] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteVirtualMachineTemplate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteVirtualMachineTemplate]
GO
CREATE PROCEDURE [dbo].[usp_DeleteVirtualMachineTemplate]
	@VirtualMachineTemplateID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM TemplateToGlobalProfiles WHERE VirtualMachineTemplateID = @VirtualMachineTemplateID;
	DELETE FROM GroupToTemplate WHERE VirtualMachineTemplateID = @VirtualMachineTemplateID;
	DELETE FROM [VirtualMachineTemplate] WHERE VirtualMachineTemplateID = @VirtualMachineTemplateID;
END
GO
GRANT EXEC ON [dbo].[usp_DeleteVirtualMachineTemplate] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateVirtualMachineTemplate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateVirtualMachineTemplate]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateVirtualMachineTemplate] 
	 @VirtualMachineTemplateID uniqueidentifier
	,@VirtualMachineTemplateName nvarchar(256)
	,@VirtualMachineTemplateDescription nvarchar(1024)=NULL
	,@ExpireDays integer
	,@LeaseDays integer
	,@Enabled bit
	,@IsGlobal bit
	,@BlueprintType TINYINT
	,@RequiresApproval bit
	,@Master bit
	,@MemoryMB bigint
	,@MemoryMaxMB bigint = NULL
	,@DiskSize0GB bigint
	,@DiskSizeMaxGB bigint = NULL
	,@CPUCount integer
	,@CpuCountMax integer = NULL
	,@MachinePrefix NVARCHAR(50)=NULL
	,@Cost decimal(28,3)=NULL
	,@InheritsFromVMTemplateID uniqueidentifier=NULL
	,@WorkflowID uniqueidentifier
	,@MaxVMsPerUser integer = NULL
	,@ApprovalPolicyId uniqueidentifier=NULL
	,@LeaseDaysMax integer = NULL    
	,@ReservationPolicyID uniqueidentifier=NULL
	,@MachineType TINYINT = 0
	,@InterfaceTypeId nvarchar(128)
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [VirtualMachineTemplate]
	SET 
		VirtualMachineTemplateName = @VirtualMachineTemplateName
		,VirtualMachineTemplateDescription = @VirtualMachineTemplateDescription
		,ExpireDays = @ExpireDays
		,LeaseDays = @LeaseDays
		,Enabled = @Enabled
		,IsGlobal = @IsGlobal
		,BlueprintType = @BlueprintType
		,RequiresApproval = @RequiresApproval
		,Master = @Master
		,MemoryMB = @MemoryMB
		,MemoryMaxMB = @MemoryMaxMB
		,DiskSize0GB = @DiskSize0GB
		,DiskSizeMaxGB = @DiskSizeMaxGB
		,CPUCount = @CPUCount
		,CPUCountMax = @CpuCountMax
		,MachinePrefix = @MachinePrefix
		,Cost = @Cost
		,InheritsFromVMTemplateID = @InheritsFromVMTemplateID
		,ApprovalPolicyId = @ApprovalPolicyId
		,WorkflowID = @WorkflowID
		,MaxVMsPerUser = @MaxVMsPerUser
		,RecUpdateTime = GETDATE()
		,LeaseDaysMax = @LeaseDaysMax		
		,ReservationPolicyID = @ReservationPolicyID
		,MachineType = @MachineType
		,InterfaceTypeId = @InterfaceTypeId
	WHERE 
		VirtualMachineTemplateID = @VirtualMachineTemplateID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [VirtualMachineTemplate]
		(VirtualMachineTemplateID
		,VirtualMachineTemplateName
		,VirtualMachineTemplateDescription
		,ExpireDays
		,LeaseDays
		,Enabled
		,IsGlobal
		,BlueprintType
		,RequiresApproval
		,Master
		,MemoryMB
		,MemoryMaxMB
		,DiskSize0GB
		,DiskSizeMaxGB
		,CPUCount
		,CPUCountMax
		,MachinePrefix
		,Cost
		,InheritsFromVMTemplateID
		,WorkflowID
		,RecCreationTime
		,ApprovalPolicyId
		,MaxVMsPerUser		
		,LeaseDaysMax		
		,ReservationPolicyID
		,MachineType
		,InterfaceTypeId)
	 VALUES
		(@VirtualMachineTemplateID
		,@VirtualMachineTemplateName
		,@VirtualMachineTemplateDescription
		,@ExpireDays
		,@LeaseDays
		,@Enabled
		,@IsGlobal
		,@BlueprintType
		,@RequiresApproval
		,@Master
		,@MemoryMB
		,@MemoryMaxMB
		,@DiskSize0GB
		,@DiskSizeMaxGB
		,@CPUCount
		,@CpuCountMax
		,@MachinePrefix
		,@Cost
		,@InheritsFromVMTemplateID
		,@WorkflowID
		,GETDATE()
		,@ApprovalPolicyId
		,@MaxVMsPerUser		
		,@LeaseDaysMax		
		,@ReservationPolicyID
		,@MachineType
		,@InterfaceTypeId)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateVirtualMachineTemplate] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectGlobalProfilesByTemplate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectGlobalProfilesByTemplate]
GO
CREATE PROCEDURE [dbo].[usp_SelectGlobalProfilesByTemplate]
	@VirtualMachineTemplateID uniqueidentifier,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		GlobalProfiles.GlobalProfileID
		,ProfileName
		,Description
		,VirtualMachineTemplateID
	FROM [GlobalProfiles], TemplateToGlobalProfiles
	WHERE VirtualMachineTemplateID = @VirtualMachineTemplateID AND
		GlobalProfiles.GlobalProfileID = TemplateToGlobalProfiles.GlobalProfileID
	ORDER BY ProfileName
END
GO
GRANT EXEC ON [dbo].[usp_SelectGlobalProfilesByTemplate] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteGlobalProfileTemplateAssociation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteGlobalProfileTemplateAssociation]
GO
CREATE PROCEDURE [dbo].[usp_DeleteGlobalProfileTemplateAssociation]
	@VirtualMachineTemplateID uniqueidentifier,
	@GlobalProfileID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [TemplateToGlobalProfiles] WHERE VirtualMachineTemplateID = @VirtualMachineTemplateID AND GlobalProfileID = @GlobalProfileID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteGlobalProfileTemplateAssociation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertGlobalProfileTemplateAssociation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertGlobalProfileTemplateAssociation]
GO
CREATE PROCEDURE [dbo].[usp_InsertGlobalProfileTemplateAssociation] 
	@VirtualMachineTemplateID uniqueidentifier,
	@GlobalProfileID uniqueidentifier
AS
BEGIN
	SET NOCOUNT OFF;
	SELECT * FROM [TemplateToGlobalProfiles] WHERE VirtualMachineTemplateID = @VirtualMachineTemplateID AND GlobalProfileID = @GlobalProfileID
	IF @@ROWCOUNT = 0 
		INSERT INTO [TemplateToGlobalProfiles] (VirtualMachineTemplateID, GlobalProfileID) VALUES (@VirtualMachineTemplateID, @GlobalProfileID)	
END
GO
GRANT EXEC ON [dbo].[usp_InsertGlobalProfileTemplateAssociation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteEntityProperties]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteEntityProperties]
GO
CREATE PROCEDURE [dbo].[usp_DeleteEntityProperties]
	@EntityType integer,
	@EntityID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	
	IF @EntityType = 1
		BEGIN DELETE VirtualMachineProperties WHERE EntityID = @EntityID END
	ELSE IF @EntityType = 2 
		BEGIN DELETE VirtualMachineTemplateProperties WHERE EntityID = @EntityID END
	ELSE IF @EntityType = 3 
		BEGIN DELETE HostProperties WHERE EntityID = @EntityID END
	ELSE IF @EntityType = 4 
		BEGIN DELETE HostReservationProperties WHERE EntityID = @EntityID END
	ELSE IF @EntityType = 5 
		BEGIN DELETE GlobalProfileProperties WHERE EntityID = @EntityID END
	ELSE IF @EntityType = 6 
		BEGIN DELETE ProvisioningGroupProperties WHERE EntityID = @EntityID END
	ELSE IF @EntityType = 7 
		BEGIN DELETE RequestProperties WHERE EntityID = @EntityID END
END
GO
GRANT EXEC ON [dbo].[usp_DeleteEntityProperties] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertEntityProperty]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertEntityProperty]
GO
CREATE PROCEDURE [dbo].[usp_InsertEntityProperty]
	@EntityType integer,
	@EntityID uniqueidentifier,
	@PropertyName nvarchar(256),
	@PropertyValue nvarchar(4000)=null,
	@IsEncrypted bit,
	@IsRuntime bit,
	@IsHidden bit
AS
BEGIN
	SET NOCOUNT ON;
	--BEGIN TRAN
	IF @EntityType = 1
		BEGIN 
			IF EXISTS(SELECT * FROM VirtualMachineProperties WHERE EntityID = @EntityID AND PropertyName = @PropertyName)
				UPDATE VirtualMachineProperties SET EntityID = @EntityID, PropertyName = @PropertyName, PropertyValue = @PropertyValue, IsEncrypted = @IsEncrypted, IsHidden = @IsHidden, IsRuntime = @IsRuntime
				WHERE EntityID = @EntityID AND PropertyName = @PropertyName
			ELSE
			INSERT INTO VirtualMachineProperties (EntityID, PropertyName,PropertyValue,IsEncrypted, IsRuntime, IsHidden)
			VALUES (@EntityID ,@PropertyName ,@PropertyValue ,@IsEncrypted ,@IsRuntime ,@IsHidden) 
		END
	ELSE IF @EntityType = 2
		BEGIN 
			IF EXISTS(SELECT * FROM VirtualMachineTemplateProperties WHERE EntityID = @EntityID AND PropertyName = @PropertyName)
				UPDATE VirtualMachineTemplateProperties SET EntityID = @EntityID, PropertyName = @PropertyName, PropertyValue = @PropertyValue, IsEncrypted = @IsEncrypted, IsHidden = @IsHidden, IsRuntime = @IsRuntime
				WHERE EntityID = @EntityID AND PropertyName = @PropertyName
			ELSE
			INSERT INTO VirtualMachineTemplateProperties (EntityID, PropertyName,PropertyValue,IsEncrypted, IsRuntime, IsHidden)
			VALUES (@EntityID ,@PropertyName ,@PropertyValue ,@IsEncrypted ,@IsRuntime ,@IsHidden) 
		END
	ELSE IF @EntityType = 3
		BEGIN 
			IF EXISTS(SELECT * FROM HostProperties WHERE EntityID = @EntityID AND PropertyName = @PropertyName)
				UPDATE HostProperties SET EntityID = @EntityID, PropertyName = @PropertyName, PropertyValue = @PropertyValue, IsEncrypted = @IsEncrypted, IsHidden = @IsHidden, IsRuntime = @IsRuntime
				WHERE EntityID = @EntityID AND PropertyName = @PropertyName
			ELSE
			INSERT INTO HostProperties (EntityID, PropertyName,PropertyValue,IsEncrypted, IsRuntime, IsHidden)
			VALUES (@EntityID ,@PropertyName ,@PropertyValue ,@IsEncrypted ,@IsRuntime ,@IsHidden) 
		END
	ELSE IF @EntityType = 4
		BEGIN 
			IF EXISTS(SELECT * FROM HostReservationProperties WHERE EntityID = @EntityID AND PropertyName = @PropertyName)
				UPDATE HostReservationProperties SET EntityID = @EntityID, PropertyName = @PropertyName, PropertyValue = @PropertyValue, IsEncrypted = @IsEncrypted, IsHidden = @IsHidden, IsRuntime = @IsRuntime
				WHERE EntityID = @EntityID AND PropertyName = @PropertyName
			ELSE
			INSERT INTO HostReservationProperties (EntityID, PropertyName,PropertyValue,IsEncrypted, IsRuntime, IsHidden)
			VALUES (@EntityID ,@PropertyName ,@PropertyValue ,@IsEncrypted ,@IsRuntime ,@IsHidden) END
	ELSE IF @EntityType = 5
		BEGIN 
			IF EXISTS(SELECT * FROM GlobalProfileProperties WHERE EntityID = @EntityID AND PropertyName = @PropertyName)
				UPDATE GlobalProfileProperties SET EntityID = @EntityID, PropertyName = @PropertyName, PropertyValue = @PropertyValue, IsEncrypted = @IsEncrypted, IsHidden = @IsHidden, IsRuntime = @IsRuntime
				WHERE EntityID = @EntityID AND PropertyName = @PropertyName
			ELSE
			INSERT INTO GlobalProfileProperties (EntityID, PropertyName,PropertyValue,IsEncrypted, IsRuntime, IsHidden)
			VALUES (@EntityID ,@PropertyName ,@PropertyValue ,@IsEncrypted ,@IsRuntime ,@IsHidden) END
	ELSE IF @EntityType = 6
		BEGIN 
			IF EXISTS(SELECT * FROM ProvisioningGroupProperties WHERE EntityID = @EntityID AND PropertyName = @PropertyName)
				UPDATE ProvisioningGroupProperties SET EntityID = @EntityID, PropertyName = @PropertyName, PropertyValue = @PropertyValue, IsEncrypted = @IsEncrypted, IsHidden = @IsHidden, IsRuntime = @IsRuntime
				WHERE EntityID = @EntityID AND PropertyName = @PropertyName
			ELSE
			INSERT INTO ProvisioningGroupProperties (EntityID, PropertyName,PropertyValue,IsEncrypted, IsRuntime, IsHidden)
			VALUES (@EntityID ,@PropertyName ,@PropertyValue ,@IsEncrypted ,@IsRuntime ,@IsHidden) END
	ELSE IF @EntityType = 7
		BEGIN 
			IF EXISTS(SELECT * FROM RequestProperties WHERE EntityID = @EntityID AND PropertyName = @PropertyName)
				UPDATE RequestProperties SET EntityID = @EntityID, PropertyName = @PropertyName, PropertyValue = @PropertyValue, IsEncrypted = @IsEncrypted, IsHidden = @IsHidden, IsRuntime = @IsRuntime
				WHERE EntityID = @EntityID AND PropertyName = @PropertyName
			ELSE
			INSERT INTO RequestProperties (EntityID, PropertyName,PropertyValue,IsEncrypted, IsRuntime, IsHidden)
			VALUES (@EntityID ,@PropertyName ,@PropertyValue ,@IsEncrypted ,@IsRuntime ,@IsHidden) END
	--COMMIT TRAN
END
GO
GRANT EXEC ON [dbo].[usp_InsertEntityProperty] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectEntityProperties]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectEntityProperties]
GO
CREATE PROCEDURE [dbo].[usp_SelectEntityProperties]
	@EntityID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;

	SELECT
		EntityID
		,PropertyName
		,PropertyValue
		,IsEncrypted
		,IsRuntime
		,IsHidden
	FROM
		EntityProperties
	WHERE
		EntityID = @EntityID
END
GO
GRANT EXEC ON [dbo].[usp_SelectEntityProperties] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectVMDiskHardware]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectVMDiskHardware]
GO
CREATE PROCEDURE [dbo].[usp_SelectVMDiskHardware]
	@VMDiskHardwareID uniqueidentifier = NULL,
	@VirtualMachineID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@VMDiskHardwareName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT
		VMToStorageID
		,VirtualMachineID
		,HostToStorageID
		,Capacity
		,DiskName
        ,UsedCapacity
        ,ExternalDiskID
		,DeviceID
		,IsFixed
	FROM [VMDiskHardware]
	WHERE (VMToStorageID = @VMDiskHardwareID OR @VMDiskHardwareID IS NULL) AND
		(VirtualMachineID = @VirtualMachineID OR @VirtualMachineID IS NULL) AND
		(DiskName LIKE @SearchString OR @SearchString IS NULL) AND
		(DiskName = @VMDiskHardwareName OR @VMDiskHardwareName IS NULL)
	ORDER BY DiskName
END
GO
GRANT EXEC ON [dbo].[usp_SelectVMDiskHardware] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteVMDiskHardware]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteVMDiskHardware]
GO
CREATE PROCEDURE [dbo].[usp_DeleteVMDiskHardware]
	@VMToStorageID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [VMDiskHardware] WHERE VMToStorageID = @VMToStorageID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteVMDiskHardware] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateVMDiskHardware]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateVMDiskHardware]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateVMDiskHardware] 
	@VMToStorageID uniqueidentifier
	,@VirtualMachineID uniqueidentifier
	,@HostToStorageID uniqueidentifier = NULL
	,@Capacity bigint = NULL
	,@DiskName nvarchar(128)
    ,@UsedCapacity bigint = NULL
    ,@ExternalDiskID nvarchar(256)
	,@DeviceID nvarchar(256)
	,@IsFixed bit    
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [VMDiskHardware]
	SET 
		VirtualMachineID = @VirtualMachineID
		,HostToStorageID = @HostToStorageID
		,Capacity = @Capacity
		,DiskName = @DiskName
        ,UsedCapacity = @UsedCapacity
        ,ExternalDiskID = @ExternalDiskID
		,DeviceID = @DeviceID
		,IsFixed = @IsFixed
	WHERE 
		VMToStorageID = @VMToStorageID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [VMDiskHardware]
		(VMToStorageID
		,VirtualMachineID
		,HostToStorageID
		,Capacity
		,DiskName
        ,UsedCapacity
        ,ExternalDiskID
		,DeviceID
		,IsFixed
        )
	 VALUES
		(@VMToStorageID
		,@VirtualMachineID
		,@HostToStorageID
		,@Capacity
		,@DiskName
        ,@UsedCapacity
        ,@ExternalDiskID
		,@DeviceID
		,@IsFixed
        )
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateVMDiskHardware] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectVMLogicalDisk]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectVMLogicalDisk]
GO
CREATE PROCEDURE [dbo].[usp_SelectVMLogicalDisk]
	@VMLogicalDiskID uniqueidentifier = NULL,
	@VirtualMachineID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@VMLogicalDiskName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		VMLogicalDiskID
		,VMLogicalDiskName
		,VMLogicalTotalCapacityGB
		,VMLogicalUsedCapacityGB
		,VirtualMachineID
		,VMLogicalDiskUniqueID
	FROM [VMLogicalDisk]
	WHERE (VMLogicalDiskID = @VMLogicalDiskID OR @VMLogicalDiskID IS NULL) AND
		(VirtualMachineID = @VirtualMachineID OR @VirtualMachineID IS NULL) AND
		(VMLogicalDiskName LIKE @SearchString OR @SearchString IS NULL) AND
		(VMLogicalDiskName = @VMLogicalDiskName OR @VMLogicalDiskName IS NULL)
	ORDER BY VMLogicalDiskName
END
GO
GRANT EXEC ON [dbo].[usp_SelectVMLogicalDisk] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteVMLogicalDisk]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteVMLogicalDisk]
GO
CREATE PROCEDURE [dbo].[usp_DeleteVMLogicalDisk]
	@VMLogicalDiskID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [VMLogicalDisk] WHERE VMLogicalDiskID = @VMLogicalDiskID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteVMLogicalDisk] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateVMLogicalDisk]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateVMLogicalDisk]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateVMLogicalDisk] 
	@VMLogicalDiskID uniqueidentifier
	,@VMLogicalDiskName nvarchar(128)
	,@VMLogicalTotalCapacityGB bigint
	,@VMLogicalUsedCapacityGB bigint=NULL
	,@VirtualMachineID uniqueidentifier
	,@VMLogicalDiskUniqueID nvarchar(128)=NULL
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [VMLogicalDisk]
	SET 
		VMLogicalDiskName = @VMLogicalDiskName
		,VMLogicalTotalCapacityGB = @VMLogicalTotalCapacityGB
		,VMLogicalUsedCapacityGB = @VMLogicalUsedCapacityGB
		,VirtualMachineID = @VirtualMachineID
		,VMLogicalDiskUniqueID = @VMLogicalDiskUniqueID
	WHERE 
		VMLogicalDiskID = @VMLogicalDiskID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [VMLogicalDisk]
		(VMLogicalDiskID
		,VMLogicalDiskName
		,VMLogicalTotalCapacityGB
		,VMLogicalUsedCapacityGB
		,VirtualMachineID
		,VMLogicalDiskUniqueID)
	 VALUES
		(@VMLogicalDiskID
		,@VMLogicalDiskName
		,@VMLogicalTotalCapacityGB
		,@VMLogicalUsedCapacityGB
		,@VirtualMachineID
		,@VMLogicalDiskUniqueID)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateVMLogicalDisk] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectVirtualMachine]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectVirtualMachine]
GO
CREATE PROCEDURE [dbo].[usp_SelectVirtualMachine]
	@VirtualMachineID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@UniqueID nvarchar(256) = NULL,
	@VirtualMachineName nvarchar(256) = NULL,
	@VirtualMachineUser nvarchar(256) = NULL,
	@HostID uniqueidentifier = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT *
	FROM [uv_VirtualMachineView] v 
	WHERE (VirtualMachineID = @VirtualMachineID OR @VirtualMachineID IS NULL) AND
		(VirtualMachineName LIKE @SearchString OR @SearchString IS NULL) AND
		(VirtualMachineName = @VirtualMachineName OR @VirtualMachineName IS NULL) AND 
		(v.Owner = @VirtualMachineUser OR @VirtualMachineUser IS NULL) AND 
		(v.VMUniqueID = @UniqueID OR @UniqueID IS NULL) AND 
		(v.HostID = @HostID OR @HostID IS NULL)
	ORDER BY VirtualMachineName
END
GO
GRANT EXEC ON [dbo].[usp_SelectVirtualMachine] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectVirtualMachineByHostName]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectVirtualMachineByHostName]
GO
CREATE PROCEDURE [dbo].[usp_SelectVirtualMachineByHostName]
	@HostName nvarchar(256)
AS
BEGIN
	SELECT * FROM [uv_VirtualMachineView] v 
	WHERE HostName = @HostName
	ORDER BY VirtualMachineName
END
GO
GRANT EXEC ON [dbo].[usp_SelectVirtualMachineByHostName] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectVirtualMachineByName]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectVirtualMachineByName]
GO
CREATE PROCEDURE [dbo].[usp_SelectVirtualMachineByName]
	@VirtualMachineName nvarchar(256)
AS
BEGIN
	SET ROWCOUNT 1
	SELECT VirtualMachineID FROM [VirtualMachine] v 
	WHERE VirtualMachineName = @VirtualMachineName
END
GO
GRANT EXEC ON [dbo].[usp_SelectVirtualMachineByName] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SearchRequestedVirtualMachines]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SearchRequestedVirtualMachines]
GO
CREATE PROCEDURE [dbo].[usp_SearchRequestedVirtualMachines]
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT * 
	FROM [uv_VirtualMachineView] v
		INNER JOIN [InstanceState] INS ON INS.uidInstanceID = v.VirtualMachineID
	WHERE 
		v.VirtualMachineState = N'Requested'
	ORDER BY VirtualMachineName
END
GO
GRANT EXEC ON [dbo].[usp_SearchRequestedVirtualMachines] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SearchInitializingRequestVirtualMachines]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SearchInitializingRequestVirtualMachines]
GO
CREATE PROCEDURE [dbo].[usp_SearchInitializingRequestVirtualMachines]
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT v.*
	FROM uv_VirtualMachineView v
	LEFT JOIN InstanceState i ON v.VirtualMachineID = i.uidInstanceID
	WHERE v.VirtualMachineState = N'InitializingRequest'
	-- make sure instance doesn't exist for delay between workflow generation 
	-- and state change from InitializingRequest and Requested states
	AND i.uidInstanceID IS NULL
END
GO
GRANT EXEC ON [dbo].[usp_SearchInitializingRequestVirtualMachines] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EnumerateLeaseVirtualMachineChanges]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EnumerateLeaseVirtualMachineChanges]
GO
CREATE PROCEDURE [dbo].[usp_EnumerateLeaseVirtualMachineChanges]
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SET NOCOUNT ON;
	SELECT * 
	FROM [uv_VirtualMachineView] v 
	WHERE 
		( (VirtualMachineState = N'Active' AND GETDATE() > Expires)
		OR (VirtualMachineState = N'Expired' AND GETDATE() < Expires)
		OR (VirtualMachineState = N'Expired' AND GETDATE() > DATEADD(day, ExpireDays, Expires) )
		OR (VirtualMachineState = N'Expired' AND Expires IS NULL)
		OR (VirtualMachineState = N'On' AND GETDATE() > Expires)
		OR (VirtualMachineState = N'Off' AND GETDATE() > Expires)
		OR (VirtualMachineState = N'On' AND Expires < DATEADD(day,7,GETDATE() ))
		OR (VirtualMachineState = N'Off' AND Expires < DATEADD(day,7,GETDATE() )) )
		And IsComponent = 0

END
GO
GRANT EXEC ON [dbo].[usp_EnumerateLeaseVirtualMachineChanges] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteVirtualMachine]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteVirtualMachine]
GO
CREATE PROCEDURE [dbo].[usp_DeleteVirtualMachine]
	@VirtualMachineID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [StateOperations] WHERE Id in (
			SELECT StateOperationId FROM [StateOperationVirtualMachines] WHERE VirtualMachineId = @VirtualMachineId)

	DELETE FROM [VirtualMachine] WHERE VirtualMachineID IN (
			SELECT VirtualMachineID FROM [VirtualMachine] WHERE ParentMachineID = @VirtualMachineID)

	DELETE FROM [VirtualMachine] WHERE VirtualMachineID = @VirtualMachineID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteVirtualMachine] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteUnmanagedVirtualMachines]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteUnmanagedVirtualMachines]
GO
CREATE PROCEDURE [dbo].[usp_DeleteUnmanagedVirtualMachines]
	@HostID uniqueidentifier = NULL,
	@IsMissing bit = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [VirtualMachine] 
	WHERE VirtualMachineTemplateID IS NULL
		AND (HostID = @HostID OR @HostID IS NULL)
		AND (IsMissing = @IsMissing OR @IsMissing IS NULL)
END
GO
GRANT EXEC ON [dbo].[usp_DeleteUnmanagedVirtualMachines] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SearchVirtualMachines]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SearchVirtualMachines]
GO
CREATE PROCEDURE [dbo].[usp_SearchVirtualMachines]
	@VirtualMachineName nvarchar(256) = NULL,
		@VirtualMachineUser nvarchar(256) = NULL,
		@Host nvarchar(256) = NULL,
		@VirtualMachineState nvarchar(50) = NULL,
		@HostReservationID uniqueidentifier = NULL,
		@VirtualMachineTemplateID uniqueidentifier = NULL,
		@ResultCount int = 0
	AS
	BEGIN
	
		IF (@ResultCount > 0)
		BEGIN
			SET ROWCOUNT @ResultCount
		END
		
	SELECT * 
	FROM [uv_VirtualMachineView] v
	WHERE 
		(VirtualMachineName LIKE @VirtualMachineName OR Owner LIKE @VirtualMachineName OR @VirtualMachineName IS NULL)
		--AND v.HostReservationID IS NOT NULL /* registered VMs only */
		AND IsTemplate = 0
		AND (Owner LIKE @VirtualMachineUser OR @VirtualMachineUser IS NULL)
		AND (HostName LIKE @Host OR @Host IS NULL)
		AND (HostReservationID LIKE @HostReservationID OR @HostReservationID IS NULL)
		AND (VirtualMachineTemplateID LIKE @VirtualMachineTemplateID OR @VirtualMachineTemplateID IS NULL)
		AND (@VirtualMachineState IS NULL OR VirtualMachineState = @VirtualMachineState)
END
GO
GRANT EXEC ON [dbo].[usp_SearchVirtualMachines] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateVirtualMachine]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateVirtualMachine]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateVirtualMachine] 
	@VirtualMachineID uniqueidentifier
	,@VirtualMachineTemplateID uniqueidentifier
	,@IsManaged bit = 0
	,@HostReservationID uniqueidentifier
	,@VirtualMachineName nvarchar(256)
	,@ResourcePoolID uniqueidentifier = NULL
	,@Expires datetime = NULL
	,@ExpireDays integer = NULL
	,@BlueprintType TINYINT = NULL
	,@InitiatorType nvarchar(256) = NULL
	,@Notes nvarchar(max) = NULL
	,@GuestOS NVARCHAR(256) = NULL
	,@GuestOSFamily NVARCHAR(128) = NULL
	,@VMUniqueID NVARCHAR(256) = NULL
	,@PlatformDetails nvarchar(50) = NULL
	,@VMCreationDate datetime = NULL
	,@VMDeleteDate datetime = NULL
	,@HostID uniqueidentifier
	,@LastLoggedDate datetime = NULL
	,@LastLoggedUser nvarchar(256) = NULL
	,@LastPowerOffDate datetime = NULL
	,@LastPowerOnDate datetime = NULL
	,@OwnerExists bit = NULL
	,@UsageIndex integer = NULL
	,@UsageIndexIgnoreBy nvarchar(256) = NULL
	,@IsDeleted bit = NULL
	,@IsMissing bit = NULL
	,@IsRogue bit = NULL
	,@IsRunning bit = NULL
	,@VirtualMachineState nvarchar(128) = NULL
	,@CurrentTask nvarchar(128) = NULL
	,@VMCPUs bigint = NULL
	,@VMTotalMemoryMB bigint = NULL
	,@VMTotalStorageGB bigint = NULL
	,@VMUsedStorageGB decimal(10,2) = NULL
	,@Owner nvarchar(128) = NULL
	,@HostStorageReservationID uniqueidentifier = NULL
	,@StoragePath nvarchar(256) = NULL
	,@IsTemplate bit = NULL
	,@ConnectToVdi bit = NULL
	,@VMDNSName nvarchar(256) = NULL
	,@FileLevelCloneImageName nvarchar(128) = NULL
	,@VMInitialUsedSpace decimal(10,2) = NULL
	,@VMEstimatedUsedSpace decimal(10,2) = NULL
	,@PhysicalMachineID uniqueidentifier = NULL
	,@MachineType tinyint = 0
	,@IsComponent bit = 0
	,@ParentMachineID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	EXEC usp_InsertUpdateUsers @Owner

	UPDATE [VirtualMachine]
	SET 
		VirtualMachineTemplateID = @VirtualMachineTemplateID
		,IsManaged = @IsManaged
		,HostReservationID = @HostReservationID
		,VirtualMachineName = @VirtualMachineName
		,ResourcePoolID = @ResourcePoolID
		,Expires = @Expires
		,ExpireDays = @ExpireDays
		,BlueprintType = @BlueprintType
		,InitiatorType = @InitiatorType
		,Notes = @Notes
		,GuestOS = @GuestOS
		,GuestOSFamily = @GuestOSFamily
		,VMUniqueID = @VMUniqueID
		,PlatformDetails = @PlatformDetails
		,VMCreationDate = ISNULL(VMCreationDate, @VMCreationDate)
		,VMDeleteDate = @VMDeleteDate
		,HostID = @HostID
		,LastLoggedDate = @LastLoggedDate
		,LastLoggedUser = @LastLoggedUser
		,LastPowerOffDate = @LastPowerOffDate
		,LastPowerOnDate = @LastPowerOnDate
		,OwnerExists = @OwnerExists
		,UsageIndex = @UsageIndex
		,UsageIndexIgnoreBy = @UsageIndexIgnoreBy
		,IsDeleted = @IsDeleted
		,IsMissing = @IsMissing
		,IsRogue = @IsRogue
		,IsRunning = @IsRunning
		,RecUpdateTime = GETUTCDATE()
		--,VirtualMachineState = @VirtualMachineState
		--,CurrentTask = @CurrentTask
		,VMCPUs = @VMCPUs
		,VMTotalMemoryMB = @VMTotalMemoryMB
		,VMTotalStorageGB = @VMTotalStorageGB
		,VMUsedStorageGB = @VMUsedStorageGB
		,Owner = (SELECT UserID FROM Users WHERE UserName = @Owner)
		,HostStorageReservationID = @HostStorageReservationID
		,StoragePath = @StoragePath
		,IsTemplate = @IsTemplate
		,ConnectToVdi = @ConnectToVdi
		,VMDNSName = @VMDNSName
		,FileLevelCloneImageName = @FileLevelCloneImageName
		,VMInitialUsedSpace = @VMInitialUsedSpace
		,VMEstimatedUsedSpace = @VMEstimatedUsedSpace
		,PhysicalMachineID = @PhysicalMachineID
		,MachineType = @MachineType
		,IsComponent = @IsComponent
		,ParentMachineID = @ParentMachineID
	WHERE 
		VirtualMachineID = @VirtualMachineID

	IF @@ROWCOUNT = 0 
		INSERT INTO [VirtualMachine]
		(VirtualMachineID
		,VirtualMachineTemplateID
		,IsManaged
		,HostReservationID
		,VirtualMachineName
		,ResourcePoolID
		,Expires
		,ExpireDays
		,BlueprintType
		,InitiatorType
		,Notes
		,GuestOS
		,GuestOSFamily
		,VMUniqueID
		,PlatformDetails
		,VMCreationDate
		,VMDeleteDate
		,HostID
		,LastLoggedDate
		,LastLoggedUser
		,LastPowerOffDate
		,LastPowerOnDate
		,OwnerExists
		,UsageIndex
		,UsageIndexIgnoreBy
		,IsDeleted
		,IsMissing
		,IsRogue
		,IsRunning
		,RecCreationTime
		,RecUpdateTime
		,VirtualMachineState
		,CurrentTask
		,VMCPUs
		,VMTotalMemoryMB
		,VMTotalStorageGB
		,VMUsedStorageGB
		,Owner
		,HostStorageReservationID
		,StoragePath
		,IsTemplate
		,ConnectToVdi
		,VMDNSName
		,FileLevelCloneImageName
		,VMInitialUsedSpace
		,VMEstimatedUsedSpace
		,PhysicalMachineID
		,MachineType
		,IsComponent
		,ParentMachineID)
	 SELECT
		@VirtualMachineID
		,@VirtualMachineTemplateID
		,@IsManaged
		,@HostReservationID
		,@VirtualMachineName
		,@ResourcePoolID
		,@Expires
		,@ExpireDays
		,@BlueprintType
		,@InitiatorType
		,@Notes
		,@GuestOS
		,@GuestOSFamily
		,@VMUniqueID
		,@PlatformDetails
		,@VMCreationDate
		,@VMDeleteDate
		,@HostID
		,@LastLoggedDate
		,@LastLoggedUser
		,@LastPowerOffDate
		,@LastPowerOnDate
		,@OwnerExists
		,@UsageIndex
		,@UsageIndexIgnoreBy
		,@IsDeleted
		,@IsMissing
		,@IsRogue
		,@IsRunning
		,GETDATE()
		,GETUTCDATE()
		,@VirtualMachineState
		,@CurrentTask
		,@VMCPUs
		,@VMTotalMemoryMB
		,@VMTotalStorageGB
		,@VMUsedStorageGB
		,(SELECT UserID FROM Users WHERE UserName = @Owner)
		,@HostStorageReservationID
		,@StoragePath
		,@IsTemplate
		,@ConnectToVdi
		,@VMDNSName
		,@FileLevelCloneImageName
		,@VMInitialUsedSpace
		,@VMEstimatedUsedSpace
		,@PhysicalMachineID
		,@MachineType
		,@IsComponent
		,@ParentMachineID
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateVirtualMachine] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_UpdateVirtualMachineWithState]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_UpdateVirtualMachineWithState]
GO
CREATE PROCEDURE [dbo].[usp_UpdateVirtualMachineWithState] 
	@VirtualMachineID uniqueidentifier
	,@VirtualMachineTemplateID uniqueidentifier
	,@IsManaged bit = 0
	,@HostReservationID uniqueidentifier
	,@VirtualMachineName nvarchar(256)
	,@ResourcePoolID uniqueidentifier = NULL
	,@Expires datetime = NULL
	,@ExpireDays integer = NULL
	,@BlueprintType TINYINT = NULL
	,@InitiatorType nvarchar(256) = NULL
	,@Notes nvarchar(max) = NULL
	,@GuestOS NVARCHAR(256) = NULL
	,@GuestOSFamily NVARCHAR(128) = NULL
	,@VMUniqueID NVARCHAR(256) = NULL
	,@PlatformDetails nvarchar(50) = NULL
	,@VMCreationDate datetime = NULL
	,@VMDeleteDate datetime = NULL
	,@HostID uniqueidentifier
	,@LastLoggedDate datetime = NULL
	,@LastLoggedUser nvarchar(256) = NULL
	,@LastPowerOffDate datetime = NULL
	,@LastPowerOnDate datetime = NULL
	,@OwnerExists bit = NULL
	,@UsageIndex integer = NULL
	,@UsageIndexIgnoreBy nvarchar(256) = NULL
	,@IsDeleted bit = NULL
	,@IsMissing bit = NULL
	,@IsRogue bit = NULL
	,@IsRunning bit = NULL
	,@VirtualMachineState nvarchar(128) = NULL
	,@CurrentTask nvarchar(128) = NULL
	,@VMCPUs bigint = NULL
	,@VMTotalMemoryMB bigint = NULL
	,@VMTotalStorageGB bigint = NULL
	,@VMUsedStorageGB decimal(10,2) = NULL
	,@Owner nvarchar(128) = NULL
	,@HostStorageReservationID uniqueidentifier = NULL
	,@StoragePath nvarchar(256) = NULL
	,@IsTemplate bit = NULL
	,@ConnectToVdi bit = NULL
	,@VMDNSName nvarchar(256) = NULL
	,@FileLevelCloneImageName nvarchar(128) = NULL
	,@VMInitialUsedSpace decimal(10,2) = NULL
	,@VMEstimatedUsedSpace decimal(10,2) = NULL
	,@PhysicalMachineID uniqueidentifier = NULL
	,@MachineType tinyint = 0
	,@IsComponent bit = 0
	,@ParentMachineID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	EXEC usp_InsertUpdateUsers @Owner

	UPDATE [VirtualMachine]
	SET 
		VirtualMachineTemplateID = @VirtualMachineTemplateID
		,IsManaged = @IsManaged
		,HostReservationID = @HostReservationID
		,VirtualMachineName = @VirtualMachineName
		,ResourcePoolID = @ResourcePoolID
		,Expires = @Expires
		,ExpireDays = @ExpireDays
		,BlueprintType = @BlueprintType
		,InitiatorType = @InitiatorType
		,Notes = @Notes
		,GuestOS = @GuestOS
		,GuestOSFamily = @GuestOSFamily
		,VMUniqueID = @VMUniqueID
		,PlatformDetails = @PlatformDetails
		,VMCreationDate = @VMCreationDate
		,VMDeleteDate = @VMDeleteDate
		,HostID = @HostID
		,LastLoggedDate = @LastLoggedDate
		,LastLoggedUser = @LastLoggedUser
		,LastPowerOffDate = @LastPowerOffDate
		,LastPowerOnDate = @LastPowerOnDate
		,OwnerExists = @OwnerExists
		,UsageIndex = @UsageIndex
		,UsageIndexIgnoreBy = @UsageIndexIgnoreBy
		,IsDeleted = @IsDeleted
		,IsMissing = @IsMissing
		,IsRogue = @IsRogue
		,IsRunning = @IsRunning
		,RecUpdateTime = GETUTCDATE()
		,VirtualMachineState = @VirtualMachineState
		,CurrentTask = @CurrentTask
		,VMCPUs = @VMCPUs
		,VMTotalMemoryMB = @VMTotalMemoryMB
		,VMTotalStorageGB = @VMTotalStorageGB
		,VMUsedStorageGB = @VMUsedStorageGB
		,Owner = (SELECT U.UserID FROM Users U WHERE U.UserName = @Owner)
		,HostStorageReservationID = @HostStorageReservationID
		,StoragePath = @StoragePath
		,IsTemplate = @IsTemplate
		,ConnectToVdi = @ConnectToVdi
		,VMDNSName = @VMDNSName
		,FileLevelCloneImageName = @FileLevelCloneImageName
		,VMInitialUsedSpace = @VMInitialUsedSpace
		,VMEstimatedUsedSpace = @VMEstimatedUsedSpace
		,PhysicalMachineID = @PhysicalMachineID
		,MachineType = @MachineType
		,IsComponent = @IsComponent
		,ParentMachineID = @ParentMachineID
	WHERE 
		VirtualMachineID = @VirtualMachineID
		
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_UpdateVirtualMachineWithState] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectAnnouncements]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectAnnouncements]
GO
CREATE PROCEDURE [dbo].[usp_SelectAnnouncements]
AS
BEGIN
	SET NOCOUNT ON;
	SELECT [Name],[Culture],[Message],[LastUpdate] FROM [Announcements];
END
GO
GRANT EXEC ON [dbo].[usp_SelectAnnouncements] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_UpdateAnnouncement]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_UpdateAnnouncement]
GO
CREATE PROCEDURE [dbo].[usp_UpdateAnnouncement]
	@Name NVARCHAR(50),
	@Culture NVARCHAR(50),
	@Message NTEXT,
	@LastUpdate DATETIME = NULL OUT
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	
	SET @Culture = COALESCE(@Culture, N'');
	SET @Message = COALESCE(@Message, N'');
	SET @LastUpdate = GETDATE();
	
	UPDATE [Announcements]
		SET [Message] = @Message, [LastUpdate] = @LastUpdate
		WHERE [Name] = @Name AND [Culture] = @Culture;
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [Announcements] ([Name], [Culture], [Message], [LastUpdate])
			VALUES (@Name, @Culture, @Message, @LastUpdate);
		
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_UpdateAnnouncement] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectAppAppearance]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectAppAppearance]
GO
CREATE PROCEDURE [dbo].[usp_SelectAppAppearance]
AS
BEGIN
	SET NOCOUNT ON;
	SELECT TOP 1 [AppName],[Logo],[LastUpdate], [EnableStaticIPv4Service], [DefaultGridPageSize], [EnableFlexCloneProvisioning], [EnableComplexApprovals], [EnableVirtualDataCenterSkill] FROM [AppAppearance];
END
GO
GRANT EXEC ON [dbo].[usp_SelectAppAppearance] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_UpdateAppAppearance]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_UpdateAppAppearance]
GO
CREATE PROCEDURE [dbo].[usp_UpdateAppAppearance]
	@AppName NVARCHAR(50),
	@Logo VARBINARY(MAX),
	@LastUpdate DATETIME = NULL OUT,
	@EnableStaticIPv4Service BIT,
	@DefaultGridPageSize INTEGER,
	@EnableFlexClone BIT,
	@EnableComplexApprovals BIT,
	@EnableVirtualDataCenterSkill BIT
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	
	SET @LastUpdate = GETDATE();
	
	UPDATE [AppAppearance]
		SET [AppName] = @AppName, [Logo] = @Logo, [LastUpdate] = @LastUpdate, [EnableStaticIPv4Service] = @EnableStaticIPv4Service, [DefaultGridPageSize]=@DefaultGridPageSize,
		[EnableFlexCloneProvisioning] = @EnableFlexClone, [EnableComplexApprovals] = @EnableComplexApprovals, [EnableVirtualDataCenterSkill] = @EnableVirtualDataCenterSkill;
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [AppAppearance] ([AppName], [Logo], [LastUpdate], [EnableStaticIPv4Service], [DefaultGridPageSize], [EnableFlexCloneProvisioning], [EnableComplexApprovals], [EnableVirtualDataCenterSkill])
			VALUES (@AppName, @Logo, @LastUpdate,@EnableStaticIPv4Service, @DefaultGridPageSize, @EnableFlexClone, @EnableComplexApprovals, @EnableVirtualDataCenterSkill );
		
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_UpdateAppAppearance] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectUserLog]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectUserLog]
GO
CREATE PROCEDURE [dbo].[usp_SelectUserLog]
	@User nvarchar(256),
	@EventType int = NULL
AS
BEGIN
	SET ROWCOUNT 100  
	SELECT 
		[Timestamp]
		,[Type]
		,[Message]
		,G.GroupID
		,G.GroupName
		,G.AdministratorEmail
		,G.IsTestGroup
	FROM UserLog AS UL
	LEFT JOIN [ProvisioningGroup] AS G ON UL.GroupID = G.GroupID	
	WHERE [UserName] = @User
		AND ([Type] = @EventType OR @EventType IS NULL OR (@EventType = 4 AND [Type] IN (1, 2))) 
	ORDER BY UL.UserLogId DESC
END
GO
GRANT EXEC ON [dbo].[usp_SelectUserLog] TO Vrm_Manager
GO
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUserLog]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUserLog]
GO
CREATE PROCEDURE [dbo].[usp_InsertUserLog]
	@User nvarchar(256),
	@Type tinyint,
	@Message nvarchar(2000),
	@GroupID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	
	INSERT INTO [UserLog]
			([UserName]
			,[Timestamp]
			,[Type]
			,[Message]
			,[GroupID])
	 VALUES
			(@User
			,GETUTCDATE()
			,@Type
			,@Message
			,@GroupID)
END
GO
GRANT EXEC ON [dbo].[usp_InsertUserLog] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteEntityProperty]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteEntityProperty]
GO

CREATE PROCEDURE [dbo].[usp_DeleteEntityProperty]
	@EntityID uniqueidentifier,
	@PropertyName nvarchar(50)
AS
BEGIN
	SET NOCOUNT ON;
	--Do not use the view EntityProperties, because it is not update-able
	IF EXISTS(select id from VirtualMachineProperties where EntityID = @EntityID)
	BEGIN
		DELETE FROM VirtualMachineProperties WHERE EntityID = @EntityID AND PropertyName = @PropertyName
	END	
	
	ELSE IF EXISTS(select id from RequestProperties where EntityID = @EntityID)
	BEGIN
		DELETE FROM RequestProperties WHERE EntityID = @EntityID AND PropertyName = @PropertyName
	END
	
	ELSE IF EXISTS(select id from HostProperties where EntityID = @EntityID)
	BEGIN
		DELETE FROM HostProperties WHERE EntityID = @EntityID AND PropertyName = @PropertyName
	END

	ELSE IF EXISTS(select id from GlobalProfileProperties  where EntityID = @EntityID)
	BEGIN
		DELETE FROM GlobalProfileProperties WHERE EntityID = @EntityID AND PropertyName = @PropertyName
	END

	IF EXISTS(select id from HostReservationProperties where EntityID = @EntityID)
	BEGIN
		DELETE FROM HostReservationProperties WHERE EntityID = @EntityID AND PropertyName = @PropertyName
	END

	ELSE IF EXISTS(select id from ProvisioningGroupProperties where EntityID = @EntityID)
	BEGIN
		DELETE FROM ProvisioningGroupProperties WHERE EntityID = @EntityID AND PropertyName = @PropertyName
	END

	ELSE IF EXISTS(select id from VirtualMachineTemplateProperties where EntityID = @EntityID)
	BEGIN
		DELETE FROM VirtualMachineTemplateProperties WHERE EntityID = @EntityID AND PropertyName = @PropertyName
	END

	ELSE IF EXISTS(select id from VirtualMachineHistoryProperties where EntityID = @EntityID)
	BEGIN
		DELETE FROM VirtualMachineHistoryProperties WHERE EntityID = @EntityID AND PropertyName = @PropertyName
	END

	ELSE IF EXISTS(select id from ManagementEndpointProperties where ManagementEndpointID = @EntityID)
	BEGIN
		DELETE FROM ManagementEndpointProperties WHERE ManagementEndpointID = @EntityID AND Name = @PropertyName
	END
END
GO
GRANT EXEC ON [dbo].[usp_DeleteEntityProperty] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CreateWorkItem]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[CreateWorkItem]
GO
/* Work Item Logic */
/* Enqueue a new workitem */
CREATE PROCEDURE [dbo].[CreateWorkItem]
	@WorkItemID uniqueidentifier,
	@WorkflowID uniqueidentifier,
	@AgentID nvarchar(256),
	@WorkItemContent nvarchar(max),
	@DataCollectionStatusID uniqueidentifier = NULL
AS
BEGIN
INSERT WorkItem(
	WorkItemID,
	WorkflowID,
	DataCollectionStatusID,
	AgentName,
	Dispatched,
	WorkItemContent)
VALUES(
	@WorkItemID,
	@WorkflowID,
	@DataCollectionStatusID,
	@AgentID,
	0,
	@WorkItemContent);
END
GO
GRANT EXEC ON [dbo].[CreateWorkItem] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeleteWorkItem]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeleteWorkItem]
GO
/* Delete a workitem */
CREATE PROCEDURE [dbo].[DeleteWorkItem]
	@WorkItemID uniqueidentifier
AS
BEGIN
	DELETE WorkItem
	WHERE WorkItemID = @WorkItemID;
END
GO
GRANT EXEC ON [dbo].[DeleteWorkItem] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeleteDataCollectionWorkItems]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeleteDataCollectionWorkItems]
GO
/* Delete a workitem */
CREATE PROCEDURE [dbo].[DeleteDataCollectionWorkItems]
	@DataCollectionStatusID uniqueidentifier
AS
BEGIN
	DELETE WorkItem
	WHERE DataCollectionStatusID = @DataCollectionStatusID
END
GO
GRANT EXEC ON [dbo].[DeleteWorkItem] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeleteWorkItemsForWorkflowID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[DeleteWorkItemsForWorkflowID]
GO
/* Deletes the work items associated with a workflow */
CREATE PROCEDURE [dbo].[DeleteWorkItemsForWorkflowID]
	@WorkflowID uniqueidentifier
AS
BEGIN
	DELETE WorkItem
	WHERE WorkflowID = @WorkflowID;
END
GO
GRANT EXEC ON [dbo].[DeleteWorkItemsForWorkflowID] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetWorkItem]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetWorkItem]
GO
/* Retrieve the next workitem for an agent */
CREATE PROCEDURE [dbo].[GetWorkItem]
	@AgentName nvarchar(256) = NULL
AS
BEGIN
DECLARE @WorkItemID uniqueidentifier

SELECT TOP 1
	@WorkItemID = WorkItemID
FROM
	WorkItem
WHERE
	AgentName = @AgentName AND
	Dispatched = 0
ORDER BY
	CreatedAt

IF(@@ROWCOUNT = 0)
BEGIN
	SELECT NULL;
	RETURN;
END;

SELECT WorkItemContent
FROM WorkItem
WHERE WorkItemID = @WorkItemID;

UPDATE WorkItem
SET Dispatched = 1 WHERE WorkItemID = @WorkItemID;
END
GO
GRANT EXEC ON [dbo].[GetWorkItem] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetWorkItemWorkflowID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetWorkItemWorkflowID]
GO
/* Get the WorkflowID for a given WorkItemID */
CREATE PROCEDURE [dbo].[GetWorkItemWorkflowID]
	@WorkItemID uniqueidentifier
AS
BEGIN
	SELECT WorkflowID FROM WorkItem WHERE WorkItemID = @WorkItemID;
END
GO
GRANT EXEC ON [dbo].[GetWorkItemWorkflowID] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[TempHostReservationInfo]'))
DROP VIEW [dbo].[TempHostReservationInfo]
GO
CREATE VIEW [dbo].[TempHostReservationInfo]
AS
SELECT	hr.HostReservationID, 
	hr.GroupID,
	hr.HostReservationName,
	hr.HostID,
	hr.ReservationMemorySizeMB,
	rv.ReservationStorageSizeGB,
	rv.ReservationStorageWithoutDisabledPathsSizeGB,
	hr.MaxVMsPowerOn,
	-- keep alias for time being until we fix other views which are using this
	hr.ReservationMemorySizeMB ReservationMemorySize, 
	rv.ReservationStorageSizeGB ReservationDiskSize, 
	hr.MaxVMsPowerOn VirtualMachineQuota, 
	hr.ReservationPriority,
	hr.ReservationPolicyID,
	hr.MachineType,
	(
		SELECT TOP 1 NetworkName 
		FROM HostNic hn 
		INNER JOIN HostNicToReservation nr ON nr.HostNicID = hn.HostNicID
		WHERE nr.HostReservationID = hr.HostReservationID
	) NetworkName, 
	hr.Enabled,
	(
		SELECT TOP 1 StoragePath 
		FROM HostToStorage hs 
		INNER JOIN HostReservationToStorage a ON hs.HostToStorageID = a.HostToStorageID 
		WHERE a.HostReservationID = hr.HostReservationID
	) ReservationPath, 
	h.HostName,
	g.GroupName,
	p.ResourcePoolName,
	h.HostStateID HostState,
	ISNULL(cap.ResTotalDiskUsage, 0) ResTotalDiskUsage,
	ISNULL(cap.ResTotalDiskUsageWithoutDisabledPaths, 0) as ResTotalDiskUsageWithoutDisabledPaths,
	(
		SELECT	COALESCE (SUM(VMTotalMemoryMB), 0) AS TotalMemory
		FROM	VirtualMachine vm
		WHERE	(vm.HostReservationID = hr.HostReservationID) AND (vm.IsRunning = 1)
	) AS ResTotalMemoryUsage,
	(
		SELECT	COALESCE (COUNT(*), 0) AS MachineCount
		FROM	VirtualMachine vm
		WHERE	(vm.HostReservationID = hr.HostReservationID) AND ((vm.IsRunning = 1 AND vm.MachineType != 1) OR (vm.MachineType = 1 AND vm.IsManaged = 1)))
    AS ResTotalVMCount,
	rv.LargestFreeCapacityGB
FROM	HostReservation hr
INNER JOIN Host H ON h.HostID = hr.HostID 
INNER JOIN ReservationStorageSizeView rv ON rv.HostReservationID = hr.HostReservationID 
INNER JOIN ProvisioningGroup g ON g.GroupID = hr.GroupID 
LEFT OUTER JOIN ResourcePool p ON p.ResourcePoolID = hr.ResourcePoolID
LEFT OUTER JOIN
(
	SELECT	hr.HostReservationID,
		ISNULL(SUM(vmdh.Capacity), 0) AS ResTotalDiskUsage,
		COALESCE(
			SUM(
			CASE 
				WHEN hrs.Enabled = 1 AND hr.HostReservationID IS NOT NULL THEN vmdh.capacity
				ELSE 0 
			END), 0) AS ResTotalDiskUsageWithoutDisabledPaths
	FROM VMDiskHardware			vmdh
	INNER JOIN VirtualMachine	vm			ON vmdh.VirtualMachineID = vm.VirtualMachineID AND vm.IsManaged = 1
	INNER JOIN HostReservation	hr			ON hr.HostReservationID  = vm.HostReservationID
	INNER JOIN HostToStorage	hs			ON hs.HostToStorageID	 = vmdh.HostToStorageID
	INNER JOIN HostReservationToStorage hrs	ON hrs.HostToStorageID	 = hs.HostToStorageID
											AND hrs.HostReservationID = hr.HostReservationID
	GROUP BY hr.HostReservationID
) AS cap ON hr.HostReservationID = cap.HostReservationID

GO

GRANT SELECT ON [dbo].[TempHostReservationInfo] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[VirtualMachineInfo]'))
DROP VIEW [dbo].[VirtualMachineInfo]
GO
CREATE VIEW [dbo].[VirtualMachineInfo]
AS
	SELECT 
		VM.VirtualMachineName, 
		VM.Owner, 
		VM.Expires, 
		H.HostName
		,EP1.PropertyValue AS PhysicalHostName
		,EP2.PropertyValue AS ResourcePool
		,EP3.PropertyValue AS ApplicationID
		,EP4.PropertyValue AS CPUCount
		,EP5.PropertyValue AS Memory
	FROM VirtualMachine VM
		LEFT JOIN EntityProperties EP1 ON EP1.EntityID = VM.VirtualMachineID AND UPPER(EP1.PropertyName)=N'VIRTUALMACHINE.ADMIN.HOSTNAME'
		LEFT JOIN EntityProperties EP2 ON EP2.EntityID = VM.VirtualMachineID AND UPPER(EP2.PropertyName)=N'INFRASTRUCTURE.RESOURCEPOOL.NAME'
		LEFT JOIN EntityProperties EP3 ON EP3.EntityID = VM.VirtualMachineID AND UPPER(EP3.PropertyName)=N'VIRTUALMACHINE.ADMIN.APPLICATIONID' 
		LEFT JOIN EntityProperties EP4 ON EP4.EntityID = VM.VirtualMachineID AND UPPER(EP4.PropertyName)=N'VIRTUALMACHINE.CPU.COUNT'
		LEFT JOIN EntityProperties EP5 ON EP5.EntityID = VM.VirtualMachineID AND UPPER(EP5.PropertyName)=N'VIRTUALMACHINE.MEMORY.SIZE'
		LEFT JOIN HostReservation HR ON HR.HostReservationID = VM.HostReservationID
		LEFT JOIN Host H ON H.HostID = HR.HostID;
GO
GRANT SELECT ON [dbo].[VirtualMachineInfo] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[HostReservationInfo]'))
DROP VIEW [dbo].[HostReservationInfo]
GO
CREATE VIEW [dbo].[HostReservationInfo]
AS
SELECT	HostReservationID, 
		GroupID, 
		GroupName,
		HostReservationName, 
		HostName, 
		HostID,
		ResourcePoolName,
		ReservationMemorySizeMB, 
		ReservationStorageSizeGB, 
		ReservationStorageWithoutDisabledPathsSizeGB,
		ResTotalDiskUsageWithoutDisabledPaths,
         MaxVMsPowerOn, 
	   -- keep alias for time being until we fix other views which are using this
		   ReservationMemorySize, 
		   ReservationDiskSize, 
                   VirtualMachineQuota, 
		ReservationPriority, 
		Enabled, 
		NetworkName, 
		ReservationPath, 
		HostState, 
		ResTotalDiskUsage, 
		ResTotalMemoryUsage, 
		ResTotalVMCount,
		ReservationPolicyID,
		MachineType,
	  (SELECT     COALESCE (SUM(CAST(ResTotalMemoryUsage AS Integer)), 0) AS Expr1
		FROM          dbo.TempHostReservationInfo AS HRI
		WHERE      (GroupID = HRI1.GroupID) AND (HostID = HRI1.HostID)) AS AbsoluteMemoryUsed,
		LargestFreeCapacityGB
FROM         dbo.TempHostReservationInfo AS HRI1;

GO
GRANT SELECT ON [dbo].[HostReservationInfo] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectVirtualMachineHostNics]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectVirtualMachineHostNics]
GO
CREATE PROCEDURE [dbo].[usp_SelectVirtualMachineHostNics]
	@VirtualMachineID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	SELECT 
		n.HostNicID
		,HostNicUniqueID
		,HostNicName
		,HostID
		,NetworkName
		,MacID
		,VirtualMachineID
	FROM [HostNic] n INNER JOIN VMToNetwork v ON n.HostNicID = v.HostNicID
	WHERE VirtualMachineID = @VirtualMachineID
	ORDER BY HostNicName;
END
GO
GRANT EXEC ON [dbo].[usp_SelectVirtualMachineHostNics] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_GetHostStatusReport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_GetHostStatusReport]
GO
/* Host Status Report for IProxyAgentService */
CREATE PROCEDURE [dbo].[usp_GetHostStatusReport]
	@HostName nvarchar(256)
AS
BEGIN
SELECT
	VirtualMachineID AS '@vmId',
	VirtualMachineName AS '@VirtualMachine.Admin.Name',
	PropertyValue AS '@VirtualMachine.Admin.Hostname',
	CASE
		WHEN
			VirtualMachineState = N'On'
		THEN
			N'poweredOn'
		WHEN
			VirtualMachineState = N'Off'
		THEN
			N'poweredOff'
		WHEN
			VirtualMachineState = N'Expired'
		THEN
			N'poweredOff'
		ELSE
			N'unknown'
		END AS '@powerState'
FROM
	VirtualMachine VM INNER JOIN HostReservation HR
		ON VM.HostReservationID = HR.HostReservationID
	INNER JOIN Host H
		ON HR.HostID = H.HostID
	LEFT JOIN EntityProperties EP
		ON EP.EntityID = VM.VirtualMachineID AND EP.PropertyName = N'VirtualMachine.Admin.Hostname'
WHERE
	H.HostName = @HostName
FOR XML PATH('virtualMachine'), ROOT('virtualMachines');
END
GO
GRANT EXEC ON [dbo].[usp_GetHostStatusReport] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SearchProxyAgentInfo]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SearchProxyAgentInfo]
GO
CREATE PROCEDURE [dbo].[usp_SearchProxyAgentInfo]
	@HostName nvarchar(256) = NULL,
	@ProxyAgentName nvarchar(256) = NULL
AS
BEGIN
	SELECT 
		AgentID
		,AgentName
		,AgentDescription
		,AgentAlive
		,AgentHostName
		,AgentVersion
		,AgentGeneratedID
		,ManagesAll
		,WorkItemsProcessed
		,LastAccessed
	FROM [Agent]
	WHERE (AgentHostName = @HostName OR @HostName IS NULL) AND
		(AgentName = @ProxyAgentName OR @ProxyAgentName IS NULL)
	ORDER BY AgentName;
END
GO
GRANT EXEC ON [dbo].[usp_SearchProxyAgentInfo] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectNextMachineNameByPrefix]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectNextMachineNameByPrefix]
GO
CREATE PROCEDURE [dbo].[usp_SelectNextMachineNameByPrefix] 
	@MachinePrefix nvarchar(50)
AS
BEGIN
	DECLARE @NextMachineNumber int
	DECLARE @MachineName nvarchar(50)
	DECLARE @PrefixID uniqueidentifier

	SELECT 
		@MachineName = RTRIM(@MachinePrefix) + RIGHT(REPLICATE('0',MachineNumberLength) + CONVERT(nvarchar,NextMachineNo),MachineNumberLength),
		@NextMachineNumber = NextMachineNo + 1
	FROM [HostNamePrefix] (UPDLOCK)
	
	WHERE MachinePrefix = @MachinePrefix;
	
	UPDATE [HostNamePrefix]
	SET NextMachineNo = @NextMachineNumber
	WHERE MachinePrefix = @MachinePrefix;

	SELECT @MachineName;
END
GO
GRANT EXEC ON [dbo].[usp_SelectNextMachineNameByPrefix] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_FindVirtualMachineGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_FindVirtualMachineGroup]
GO
CREATE PROCEDURE [dbo].[usp_FindVirtualMachineGroup] 
	@EntityID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;

		SELECT 
			G.GroupName
		FROM VirtualMachine VM
		JOIN HostReservation VMR ON VM.HostReservationID = VMR.HostReservationID
		JOIN [ProvisioningGroup] G ON G.GroupID = VMR.GroupID
		WHERE 
			VM.VirtualMachineID = @EntityID

END
GO
GRANT EXEC ON [dbo].[usp_FindVirtualMachineGroup] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectNextMachineName]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectNextMachineName]
GO
CREATE PROCEDURE [dbo].[usp_SelectNextMachineName] 
	@GroupID uniqueidentifier
AS
BEGIN
	DECLARE @NextMachineNumber int
	DECLARE @MachineName nvarchar(50)
	DECLARE @PrefixID uniqueidentifier

	SELECT 
		@MachineName = RTRIM(HP.MachinePrefix) + RIGHT(REPLICATE('0',HP.MachineNumberLength) + CONVERT(nvarchar,NextMachineNo),HP.MachineNumberLength),
		@NextMachineNumber = HP.NextMachineNo + 1,
		@PrefixID = G.HostnamePrefixID
	FROM [ProvisioningGroup] G (UPDLOCK)
	INNER JOIN HostNamePrefix HP ON HP.HostnamePrefixID = G.HostnamePrefixID
	WHERE GroupID = @GroupID
	
	UPDATE [HostNamePrefix]
	SET NextMachineNo = @NextMachineNumber
	WHERE HostnamePrefixID = @PrefixID

	SELECT @MachineName
END
GO
GRANT EXEC ON [dbo].[usp_SelectNextMachineName] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertHostCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertHostCommand]
GO
CREATE PROCEDURE [dbo].[usp_InsertHostCommand]
	@HostCommandID uniqueidentifier,
	@VirtualMachineID uniqueidentifier,
	@WorkflowType nvarchar(2048),
	@HostCommandPriority smallint
AS
BEGIN
	SET NOCOUNT ON;
	INSERT INTO HostCommand
		(HostCommandID
		,VirtualMachineID
		,WorkflowType
		,HostCommandPriority)
	 VALUES
		(@HostCommandID
		,@VirtualMachineID
		,@WorkflowType
		,@HostCommandPriority)
END
GO
GRANT EXEC ON [dbo].[usp_InsertHostCommand] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteHostCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteHostCommand]
GO
CREATE PROCEDURE [dbo].[usp_DeleteHostCommand]
	@HostCommandID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;

	DELETE FROM HostCommand
	WHERE @HostCommandID = HostCommandID;
END
GO
GRANT EXEC ON [dbo].[usp_DeleteHostCommand] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectNextHostCommand]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectNextHostCommand]
GO
CREATE PROCEDURE [dbo].[usp_SelectNextHostCommand]
	@HostID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	SELECT 
		HostCommandID
		,VM.VirtualMachineID
		,WorkflowType		
	FROM HostCommand AS HC
	JOIN VirtualMachine VM ON VM.VirtualMachineID = HC.VirtualMachineID
	JOIN HostReservation HR ON HR.HostReservationID = VM.HostReservationID
	WHERE @HostID = HR.HostID
	ORDER BY HC.HostCommandPriority;
END
GO
GRANT EXEC ON [dbo].[usp_SelectNextHostCommand] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EnableHostReservation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EnableHostReservation]
GO
CREATE PROCEDURE [dbo].[usp_EnableHostReservation] 
	@HostReservationID uniqueidentifier,
	@Enabled bit
AS
BEGIN
	SET NOCOUNT ON;
	
	UPDATE [HostReservation]
	SET 
		HostReservationID = @HostReservationID
		,Enabled = @Enabled
	WHERE 
		HostReservationID = @HostReservationID;
	
END
GO
GRANT EXEC ON [dbo].[usp_EnableHostReservation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_UpdateVirtualMachineReservation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_UpdateVirtualMachineReservation]
GO
CREATE PROCEDURE [dbo].[usp_UpdateVirtualMachineReservation] 
	@VirtualMachineID uniqueidentifier,
	@HostReservationID uniqueidentifier,
	@HostStorageReservationID uniqueidentifier,
	@VirtualMachineTemplateID uniqueidentifier,
	@Owner nvarchar(128)
	
AS
BEGIN
	SET NOCOUNT ON;
	
	DECLARE @UserCount INT;
	SELECT @UserCount = COUNT(*) FROM Users WHERE UserName = @Owner;
	
	IF (@UserCount = 0)
		INSERT INTO Users (UserName) VALUES (@Owner);
	

	UPDATE VirtualMachine
	SET 
		HostReservationID = @HostReservationID,
		HostStorageReservationID = @HostStorageReservationID,
		VirtualMachineTemplateID = @VirtualMachineTemplateID,
		Owner = @Owner
	WHERE 
		VirtualMachineID = @VirtualMachineID

END 
GO
GRANT EXEC ON [dbo].[usp_UpdateVirtualMachineReservation] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectHostReservationInfo]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectHostReservationInfo]
GO
CREATE PROCEDURE [dbo].[usp_SelectHostReservationInfo]
	@HostReservationID uniqueidentifier = NULL,
	@GroupID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;

	SELECT * 
	FROM ReservationInfoExView
	WHERE
		(HostReservationID = @HostReservationID OR @HostReservationID IS NULL) AND
		(GroupID = @GroupID OR @GroupID IS NULL)
END
GO
GRANT EXEC ON [dbo].[usp_SelectHostReservationInfo] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_GetPowerOnInfo]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_GetPowerOnInfo]
GO
/* Stored procedure to be used to test whether a virtual machine can be powered on. */
CREATE PROCEDURE [dbo].[usp_GetPowerOnInfo]
	@VirtualMachineID uniqueidentifier
AS
BEGIN
	SELECT	VM.VirtualMachineName
			,VM.VirtualMachineID
			,VM.VirtualMachineState
			,HRI.HostReservationName
			,HRI.HostReservationID
			,CAST(HRI.ResTotalDiskUsage as Integer) ResTotalDiskUsage
			,CAST(HRI.ResTotalMemoryUsage as Integer) ResTotalMemoryUsage
			,HRI.ResTotalVMCount
			,HRI.ReservationDiskSize
			,HRI.ReservationMemorySize
			,HRI.VirtualMachineQuota
			,HRI.Enabled
			,HRI.AbsoluteMemoryUsed
			,CAST(VM.VMTotalMemoryMB as Integer) AS Memory

	FROM VirtualMachine VM
	INNER JOIN HostReservationInfo HRI ON HRI.HostReservationID=VM.HostReservationID
	WHERE VM.VirtualMachineID = @VirtualMachineID
END
GO
GRANT EXEC ON [dbo].[usp_GetPowerOnInfo] TO Vrm_Manager
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectRequestNotify]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectRequestNotify]
GO
CREATE PROCEDURE [dbo].[usp_SelectRequestNotify]	
	@GroupID uniqueidentifier,
	@RequestTypeID tinyint = NULL
AS
BEGIN
	SET NOCOUNT ON;

	SELECT 
		G.GroupName
		,G.AdministratorEmail
		,R.RequestID
	FROM Request R
		INNER JOIN [ProvisioningGroup] AS G ON G.GroupID = R.GroupID
	WHERE
		G.GroupID = @GroupID AND
		(RequestTypeID = @RequestTypeID OR @RequestTypeID IS NULL)
END
GO
GRANT EXEC ON [dbo].[usp_SelectRequestNotify] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EnumerateUsers]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EnumerateUsers]
GO
/* Retrieve the distinct users who own virtualmachines */
CREATE PROCEDURE [dbo].[usp_EnumerateUsers]
AS
BEGIN
	SELECT DISTINCT U.UserName AS Owner
	FROM 
		VirtualMachine vm
	JOIN
		Users U ON U.UserID = vm.Owner
	WHERE vm.Owner IS NOT NULL;
END
GO
GRANT EXEC ON [dbo].[usp_EnumerateUsers] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertWorkflowMapping]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertWorkflowMapping]
GO
CREATE PROCEDURE [dbo].[usp_InsertWorkflowMapping]
	@VirtualMachineID uniqueidentifier,
	@ChildWorkflowID uniqueidentifier	
AS
SET NOCOUNT ON;

BEGIN
	INSERT INTO WorkflowMap
		   (VirtualMachineID
		   ,ChildWorkflowID
		   )
	 VALUES
		   (@VirtualMachineID
		   ,@ChildWorkflowID
		   )
END
GO
GRANT EXEC ON [dbo].[usp_InsertWorkflowMapping] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectWorkflowMapping]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectWorkflowMapping]
GO
CREATE PROCEDURE [dbo].[usp_SelectWorkflowMapping]
	@VirtualMachineID uniqueidentifier = NULL
AS
BEGIN
	SELECT 
		VirtualMachineID,
		ChildWorkflowID
	FROM 
		WorkflowMap
	WHERE
		VirtualMachineID = @VirtualMachineID OR ChildWorkflowID = @VirtualMachineID
END
GO
GRANT EXEC ON [dbo].[usp_SelectWorkflowMapping] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteWorkflowMapping]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteWorkflowMapping]
GO
CREATE PROCEDURE [dbo].[usp_DeleteWorkflowMapping]
	@VirtualMachineID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM WorkflowMap WHERE VirtualMachineID = @VirtualMachineID	
END
GO
GRANT EXEC ON [dbo].[usp_DeleteWorkflowMapping] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectDataCollectionStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectDataCollectionStatus]
GO
CREATE PROCEDURE [dbo].[usp_SelectDataCollectionStatus]
	@DataCollectionStatusID uniqueidentifier = NULL,
	@AgentID uniqueidentifier = NULL,
	@FilterSpecID uniqueidentifier = NULL,
--	@WorkItemID uniqueidentifier = NULL,
	@ResultCount int = 0
AS
BEGIN 
	SET NOCOUNT OFF;
	SELECT * FROM DataCollectionStatusView 
	WHERE (DataCollectionStatusID = @DataCollectionStatusID OR @DataCollectionStatusID IS NULL) AND
		  (AgentID = @AgentID OR @AgentID IS NULL) AND
		  (FilterSpecID = @FilterSpecID OR @FilterSpecID IS NULL) --AND
--		  (WorkItemID = @WorkItemID OR @WorkItemID IS NULL)
	ORDER BY LastCollectedTime
END
GO
GRANT EXEC ON [dbo].[usp_SelectDataCollectionStatus] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectDataCollectionStatusByWorkItemID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectDataCollectionStatusByWorkItemID]
GO
CREATE PROCEDURE [dbo].[usp_SelectDataCollectionStatusByWorkItemID]
	@WorkItemID uniqueidentifier,
	@ResultCount int = 0
AS
BEGIN
	SET NOCOUNT OFF;
	SELECT * FROM DataCollectionStatusView d inner join WorkItem w on d.DataCollectionStatusID = w.DataCollectionStatusID 
	WHERE (w.WorkItemID = @WorkItemID OR @WorkItemID IS NULL)
	ORDER BY LastCollectedTime
END
GO
GRANT EXEC ON [dbo].[usp_SelectDataCollectionStatusByWorkItemID] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteDataCollectionStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteDataCollectionStatus]
GO
CREATE PROCEDURE [dbo].[usp_DeleteDataCollectionStatus]
	@DataCollectionStatusID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [WorkItem] WHERE DataCollectionStatusID = @DataCollectionStatusID
	DELETE FROM [DataCollectionStatus] WHERE DataCollectionStatusID = @DataCollectionStatusID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteDataCollectionStatus] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateDataCollectionStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateDataCollectionStatus]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateDataCollectionStatus] 
	@DataCollectionStatusID uniqueidentifier,
	@AgentID uniqueidentifier,
	@FilterSpecID uniqueidentifier,
	@EntityID uniqueidentifier,
	@IsDisabled bit,
	@LastCollectedTime datetime = NULL,
	@CollectionStartTime datetime = NULL,
	@LastCollectedStatus bit = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [DataCollectionStatus]
	SET 
		LastCollectedTime = @LastCollectedTime
		,LastCollectedStatus = @LastCollectedStatus
		,AgentID = @AgentID
		,FilterSpecID = @FilterSpecID
		,EntityID = @EntityID
		,CollectionStartTime = @CollectionStartTime
		,IsDisabled = @IsDisabled
	WHERE 
		DataCollectionStatusID = @DataCollectionStatusID 
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [DataCollectionStatus]
		(DataCollectionStatusID
		,AgentID
		,EntityID
		,FilterSpecID
		,LastCollectedTime
		,LastCollectedStatus
		,CollectionStartTime
		,IsDisabled)
	 VALUES
		(@DataCollectionStatusID
		,@AgentID
		,@EntityID
		,@FilterSpecID
		,@LastCollectedTime
		,@LastCollectedStatus
		,@CollectionStartTime
		,@IsDisabled)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateDataCollectionStatus] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectOverdueDataCollectionStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectOverdueDataCollectionStatus]
GO
-- Get a list of overdue data collection tasks.  A task is overdue under the
-- following conditions:
--   1. The last time this task ran is greater than the frequency of said task.
--   2. The task has been in progress three times the frequency of said task.
--   3. There is not a work item already outstanding that has not been dispatched for said task.
CREATE PROCEDURE [dbo].[usp_SelectOverdueDataCollectionStatus]
AS
BEGIN
	SET NOCOUNT OFF;
	SELECT DISTINCT v.*
	FROM
	(
		SELECT * FROM [DataCollectionStatusView]  
		-- if we have never collected, collect
		WHERE (LastCollectedTime is null  
		-- if the last time we collected, is greater than the frequency of this collection, collect
		OR GETDATE() > DateAdd(mi, FrequencyInMinutes, LastCollectedTime))
		AND (DependsOnFilterSpecGroupID IS NULL or DependsOnLastCollectedStatus = 1)
		-- if there is an outstanding collection, but it was issued 180 minutes previous it
		-- must have been lost, so re-collect.
		AND (CollectionStartTime is null or
			GETUTCDATE() > DateAdd(mi, 180/*minutes*/, CollectionStartTime))
		AND IsVRMManaged = 1
		AND IsDisabled = 0
	) v     
	-- look at the list of queued work items to ensure we do not continually re-queue
	-- workitems, and overwhelm the agent and hypervisor
	LEFT OUTER JOIN 
		WorkItem w 
	ON v.DataCollectionStatusID = w.DataCollectionStatusID
		WHERE      
			-- there are no work items in the queue for this collection, collect
			w.WorkItemID IS NULL 
	OR
		(
			-- if there is a work item in the queue, has it already been dispatched?
			w.Dispatched = 1 
			-- and is there
			AND 
			(
				SELECT ISNULL((SELECT count(*)
				FROM WorkItem ww 
				WHERE ww.Dispatched = 0 AND ww.DataCollectionStatusID = w.DataCollectionStatusID), 0)
			) = 0
		)
	ORDER BY v.LastCollectedTime
END
GO
GRANT EXEC ON [dbo].[usp_SelectOverdueDataCollectionStatus] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectLoggedonUserCollectionStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectLoggedonUserCollectionStatus]
GO
CREATE PROCEDURE [dbo].[usp_SelectLoggedonUserCollectionStatus]
	@FrequencyInMinutes int
AS
BEGIN
	SET NOCOUNT OFF;
	SELECT top 20 * 
	FROM [LoggedOnCollectionStatusView]
	WHERE LastUpdated is null or GETDATE() > DateAdd(mi, @FrequencyInMinutes, LastUpdated)
	ORDER BY LastUpdated 
END
GO
GRANT EXEC ON [dbo].[usp_SelectLoggedonUserCollectionStatus] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectVMsForLoggedonUserCollection]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectVMsForLoggedonUserCollection]
GO
CREATE PROCEDURE [dbo].[usp_SelectVMsForLoggedonUserCollection]
	@AgentID uniqueidentifier
AS
BEGIN
	SET NOCOUNT OFF;
	SELECT DISTINCT VMDNSName, VirtualMachineID
	FROM [LoggedOnCollectionStatusView]
	WHERE
		VMDNSName IS NOT NULL AND 
		(AgentID IS NULL OR 
		(AgentID = @AgentID AND ErrorCode = 0) OR 
		(ErrorCode IS NOT NULL AND ErrorCode != 0))
	ORDER BY VMDNSName 
END
GO
GRANT EXEC ON [dbo].[usp_SelectVMsForLoggedonUserCollection] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteVirtualMachineHostNicAssociation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteVirtualMachineHostNicAssociation]
GO
CREATE PROCEDURE [dbo].[usp_DeleteVirtualMachineHostNicAssociation]
	@VirtualMachineID uniqueidentifier,
	@HostNicID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [VMToNetwork] WHERE VirtualMachineID = @VirtualMachineID AND HostNicID = @HostNicID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteHostAgentAssociation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertVirtualMachineHostNicAssociation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertVirtualMachineHostNicAssociation]
GO
CREATE PROCEDURE [dbo].[usp_InsertVirtualMachineHostNicAssociation] 
	@VirtualMachineID uniqueidentifier,
	@HostNicID uniqueidentifier
AS
BEGIN
	SET NOCOUNT OFF;
	SELECT HostNicID FROM [VMToNetwork] WHERE VirtualMachineID = @VirtualMachineID AND HostNicID = @HostNicID
	IF @@ROWCOUNT = 0 
		INSERT INTO [VMToNetwork] (VirtualMachineID, HostNicID) VALUES (@VirtualMachineID, @HostNicID)	
END
GO
GRANT EXEC ON [dbo].[usp_InsertHostAgentAssociation] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectUserFilter]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectUserFilter]
GO
CREATE PROCEDURE [dbo].[usp_SelectUserFilter] 
	@UserFilterID uniqueidentifier
AS
BEGIN
	SELECT
		*
	FROM
		UserFilter
	WHERE
		UserFilterID = @UserFilterID;
END
GO
GRANT EXEC ON [dbo].[usp_SelectUserFilter] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectUserFilterExclusionKeys]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectUserFilterExclusionKeys]
GO
CREATE PROCEDURE [dbo].[usp_SelectUserFilterExclusionKeys] 
	@UserFilterID uniqueidentifier
AS
BEGIN
	SELECT
		ExclusionKey
	FROM
		UserFilterExclusion
	WHERE
		UserFilterID = @UserFilterID;
END
GO
GRANT EXEC ON [dbo].[usp_SelectUserFilterExclusionKeys] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteUserFilter]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteUserFilter]
GO
CREATE PROCEDURE [dbo].[usp_DeleteUserFilter] 
	@UserFilterID uniqueidentifier,
	@UserName nvarchar(128) = NULL
AS
BEGIN
	DELETE FROM UserFilterExclusion WHERE UserFilterID IN (SELECT UserFilterID FROM UserFilter WHERE UserFilterID = @UserFilterID AND (@UserName IS NULL OR UserName = @UserName));
	DELETE FROM UserFilter WHERE UserFilterID = @UserFilterID AND (@UserName IS NULL OR UserName = @UserName);
END
GO
GRANT EXEC ON [dbo].[usp_DeleteUserFilter] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EnumerateUserFilters]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EnumerateUserFilters]
GO
CREATE PROCEDURE [dbo].[usp_EnumerateUserFilters] 
	@DataSourceName nvarchar(128),
	@UserName nvarchar(128)
AS
BEGIN
	SELECT
		*
	FROM
		UserFilter
	WHERE
		(@DataSourceName IS NULL OR DataSourceName = @DataSourceName)
		AND (@UserName IS NULL OR (UserName = @UserName OR UserName IS NULL))
END
GO
GRANT EXEC ON [dbo].[usp_EnumerateUserFilters] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateUserFilter]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateUserFilter]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateUserFilter] 
	@UserFilterID uniqueidentifier,
	@DataSourceName nvarchar(128),
	@FilterName nvarchar(128),
	@UserName nvarchar(128),
	@ColumnLayout nvarchar(1000),
	@FilterExpression nvarchar(max),
	@AutoAdjustDateValues bit
AS
BEGIN
	-- Overwrite other filter with same name
	DELETE FROM
		UserFilterExclusion
	WHERE
		UserFilterID IN
		(
			SELECT
				UserFilterID
			FROM
				UserFilter
			WHERE
				DataSourceName = @DataSourceName
				AND FilterName = @FilterName
				AND UserName = @UserName
				AND UserFilterID != @UserFilterID
		);
	DELETE FROM
		UserFilter
	WHERE
		DataSourceName = @DataSourceName
		AND FilterName = @FilterName
		AND UserName = @UserName
		AND UserFilterID != @UserFilterID;
	 
	-- First try updating an existing filter
	UPDATE
		UserFilter
	SET
		DataSourceName = @DataSourceName,
		FilterName = @FilterName,
		UserName = @UserName,
		ColumnLayout = @ColumnLayout,
		FilterExpression = @FilterExpression,
		ModifiedTime = GETDATE(),
		AutoAdjustDateValues = @AutoAdjustDateValues
	WHERE
		UserFilterID = @UserFilterID;
	
	-- Fall back to adding a new filter
	IF @@ROWCOUNT = 0
		INSERT INTO UserFilter
			(UserFilterID, DataSourceName, FilterName, UserName, ColumnLayout, FilterExpression, AutoAdjustDateValues)
		VALUES
			(@UserFilterID, @DataSourceName, @FilterName, @UserName, @ColumnLayout, @FilterExpression, @AutoAdjustDateValues);
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateUserFilter] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_AddUserFilterExclusion]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_AddUserFilterExclusion]
GO
CREATE PROCEDURE [dbo].[usp_AddUserFilterExclusion] 
	@UserFilterID uniqueidentifier,
	@UserName nvarchar(128),
	@ExclusionKey nvarchar(255)
AS
BEGIN
	-- Start with a security check to ensure username is really associated with specified filter ID
	SELECT
		@UserFilterID = UserFilterID
	FROM
		UserFilter
	WHERE
		UserFilterID = @UserFilterID
		AND UserName = @UserName;
		
	-- Try updating an existing exclusion (so we aren't adding duplicates)
	UPDATE
		UserFilterExclusion
	SET
		CreatedTime = GETDATE(),
		ExpirationTime = NULL
	WHERE
		UserFilterID = @UserFilterID
		AND ExclusionKey = @ExclusionKey;
		
	-- Fall back to adding a new exclusion
	IF @@ROWCOUNT = 0
		INSERT INTO UserFilterExclusion
			(UserFilterID, ExclusionKey, CreatedTime, ExpirationTime)
		VALUES
			(@UserFilterID, @ExclusionKey, GETDATE(), NULL);
END
GO
GRANT EXEC ON [dbo].[usp_AddUserFilterExclusion] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteUserFilterExclusions]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteUserFilterExclusions]
GO
CREATE PROCEDURE [dbo].[usp_DeleteUserFilterExclusions] 
	@UserFilterID uniqueidentifier,
	@UserName nvarchar(128)
AS
BEGIN
	DELETE FROM
		UserFilterExclusion
	WHERE
		UserFilterID = @UserFilterID;
END
GO
GRANT EXEC ON [dbo].[usp_DeleteUserFilterExclusions] TO Vrm_Manager
GO
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectRequestAudit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectRequestAudit]
GO
CREATE PROCEDURE [dbo].[usp_SelectRequestAudit]
	@RequestAuditID uniqueidentifier = NULL,
	@RequestID uniqueidentifier = NULL,
	@RequestAuditEventID tinyint = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		RequestAuditID
		,RequestAuditDescription
		,RequestAuditDate
		,RequestAuditState
		,RequestAuditUser
		,RequestID
		,RequestAuditTypeID
	FROM [RequestAudit]
	WHERE (RequestAuditID = @RequestAuditID OR @RequestAuditID IS NULL) AND
		(RequestAuditTypeID = @RequestAuditEventID OR @RequestAuditEventID IS NULL) AND
		(RequestID = @RequestID OR @RequestID IS NULL)
	ORDER BY RequestAuditDate, RequestAuditUser;
END
GO
GRANT EXEC ON [dbo].[usp_SelectRequestAudit] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteRequestAudit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteRequestAudit]
GO
CREATE PROCEDURE [dbo].[usp_DeleteRequestAudit]
	@RequestAuditID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [RequestAudit] WHERE RequestAuditID = @RequestAuditID;
END
GO
GRANT EXEC ON [dbo].[usp_DeleteRequestAudit] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateRequestAudit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateRequestAudit]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateRequestAudit] 
	@RequestAuditID uniqueidentifier
	,@RequestAuditDescription nvarchar(max)=NULL
	,@RequestAuditState nvarchar(128)=NULL
	,@RequestAuditUser nvarchar(128)=NULL
	,@RequestID uniqueidentifier
	,@RequestAuditTypeID tinyint
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	UPDATE [RequestAudit]
	SET 
		RequestAuditDescription = @RequestAuditDescription
		,RequestAuditState = @RequestAuditState
		,RequestAuditUser = @RequestAuditUser
		,RequestID = @RequestID
		,RequestAuditTypeID = @RequestAuditTypeID
	WHERE 
		RequestAuditID = @RequestAuditID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [RequestAudit]
		(RequestAuditID
		,RequestAuditDescription
		,RequestAuditDate
		,RequestAuditState
		,RequestAuditUser
		,RequestID
		,RequestAuditTypeID)
	 VALUES
		(@RequestAuditID
		,@RequestAuditDescription
		,GETDATE()
		,@RequestAuditState
		,@RequestAuditUser
		,@RequestID
		,@RequestAuditTypeID)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateRequestAudit] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdatePropertySet]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdatePropertySet]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdatePropertySet] 
	@PropertySetID uniqueidentifier,
	@SetName nvarchar(40),
	@IsEnabled bit,
	@IsDefault bit = 0,
	@Description nvarchar(max)=null,
	@Xml nvarchar(max)
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [PropertySetXml]
		SET [SetName] = @SetName, [Description] = @Description, [Xml] = @Xml, IsEnabled = @IsEnabled, IsDefault = @IsDefault
		WHERE [PropertySetID] = @PropertySetID;
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [PropertySetXml]
		(PropertySetID
		,SetName
		,IsEnabled
		,IsDefault
		,Description
		,Xml)
	 VALUES
		(@PropertySetID
		,@SetName
		,@IsEnabled
		,@IsDefault
		,@Description
		,@Xml)	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdatePropertySet] TO Vrm_Manager
GO
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectPropertySet]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectPropertySet]
GO
CREATE PROCEDURE [dbo].[usp_SelectPropertySet]
	@SetName nvarchar(40)
AS
BEGIN
	SELECT 
		PropertySetID,
		SetName,
		IsEnabled,
		IsDefault,
		Description,
		Xml
	FROM [PropertySetXml]
	WHERE SetName = @SetName or @SetName is null
END
GO
GRANT EXEC ON [dbo].[usp_SelectPropertySet] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeletePropertySet]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeletePropertySet]
GO
CREATE PROCEDURE [dbo].[usp_DeletePropertySet] 
	@PropertySetID uniqueidentifier
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	DELETE FROM [PropertySetXml] WHERE PropertySetID=@PropertySetID;
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_DeletePropertySet] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateVMLoginUser]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateVMLoginUser]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateVMLoginUser] 
	@VirtualMachineID uniqueidentifier,
	@LoginUserName nvarchar(256),
	@LastLoginDate datetime = NULL,
	@LastLogoffDate datetime = NULL,
	@NumLogins int = NULL,
	@ErrorCode bigint = NULL,
	@ErrorMessage nvarchar(1000) = NULL,
	@AgentID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	UPDATE [VMLoginUser]
	SET 
		LastLoginDate = @LastLoginDate
		,LastLogoffDate = @LastLogoffDate
		,NumLogins = @NumLogins
		,LastUpdated = GETDATE()
		,ErrorCode = @ErrorCode
		,ErrorMessage = @ErrorMessage
		,AgentID = @AgentID
	WHERE 
		VirtualMachineID = @VirtualMachineID AND 
		LoginUserName = @LoginUserName
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [VMLoginUser]
		(VirtualMachineID
		,LoginUserName
		,LastLoginDate
		,LastLogoffDate
		,LastUpdated
		,NumLogins
		,ErrorCode
		,ErrorMessage
		,AgentID
		)
	 VALUES
		(@VirtualMachineID
		,@LoginUserName
		,@LastLoginDate
		,@LastLogoffDate
		,GETDATE()
		,@NumLogins
		,@ErrorCode
		,@ErrorMessage
		,@AgentID
		)	
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateVMLoginUser] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_UpdateLastLogonUserForVM]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_UpdateLastLogonUserForVM]
GO
CREATE PROCEDURE [dbo].[usp_UpdateLastLogonUserForVM] 
	@VirtualMachineID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	UPDATE VirtualMachine
	SET LastLoggedDate = LatestByVM.LastLoginDate , LastLoggedUser = LatestByVM.LoginUserName
	FROM
	(
		SELECT lv.VirtualMachineID, lv.LoginUserName, lv.LastLoginDate
		FROM LastLogonUserView lv
		INNER JOIN 
		(
			SELECT VirtualMachineID,  MAX(LastLoginDate) as LastLoginDate
			FROM LastLogonUserView
			GROUP BY VirtualMachineID
		) MaxDateByVM
		ON lv.VirtualMachineID = MaxDateByVM.VirtualMachineID AND lv.LastLoginDate = MaxDateByVM.LastLoginDate
		WHERE lv.VirtualMachineID = @VirtualMachineID
	) LatestByVM
	WHERE 
		VirtualMachine.VirtualMachineID = @VirtualMachineID
END
GO
GRANT EXEC ON [dbo].[usp_UpdateLastLogonUserForVM] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressCreateNetworkProfile - used to create network profile
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressCreateNetworkProfile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressCreateNetworkProfile]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressCreateNetworkProfile]
	@ID uniqueidentifier,
	@StaticName nvarchar(255),
	@StaticDesc nvarchar(2048),
	@SubnetMaskIPv4 NVARCHAR(255),
	@GatewayIPv4Address NVARCHAR(255),
	@PrimaryDNSIPv4Address NVARCHAR(255),
	@SecondaryDNSIPv4Address NVARCHAR(255),
	@DnsSuffix NVARCHAR(255),
	@DnsSearchSuffix NVARCHAR(255),
	@PrimaryWinsIPv4Address NVARCHAR(255),
	@SecondaryWinIPv4Address NVARCHAR(255)
AS
BEGIN
INSERT INTO [StaticIPv4NetworkProfile]
(ID, 
 StaticIPv4NetworkProfileName, 
 ProfileDescription, 
 SubnetMaskIPv4, 
 GatewayIPv4Address,
 PrimaryDNSIPv4Address, 
 SecondaryDNSIPv4Address, 
 DnsSuffix,
 DnsSearchSuffix,
 PrimaryWinsIPv4Address, 
 SecondaryWinsIPv4Address,
 CreatedDate,
 LastModifiedDate)
 VALUES
 (@ID, 
  @StaticName, 
  @StaticDesc, 
  @SubnetMaskIPv4,
  @GatewayIPv4Address, 
  @PrimaryDNSIPv4Address, 
  @SecondaryDNSIPv4Address,
  @DnsSuffix, 
  @DnsSearchSuffix,
  @PrimaryWinsIPv4Address, 
  @SecondaryWinIPv4Address,
  GETUTCDATE(),
  GETUTCDATE()
  );
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressCreateNetworkProfile] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressCreateRange - used to create range
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressCreateRange]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressCreateRange]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressCreateRange]
	@ID uniqueidentifier,
	@Rangename nvarchar(255),
	@Rangedesc nvarchar(2048),
	@StaticIPv4NetworkProfileID uniqueidentifier,
	@BeginIPv4Address NVARCHAR(40),
	@EndIPv4Address NVARCHAR(40)
AS
BEGIN
INSERT INTO [StaticIPv4Range]
(ID, 
 StaticIPv4RangeName, 
 IPv4RangeDescription, 
 StaticIPv4NetworkProfileID, 
 BeginIPv4Address,
 EndIPv4Address,
 CreatedDate,
 LastModifiedDate
 )
 VALUES
 (@ID, 
  @Rangename, 
  @Rangedesc, 
  @StaticIPv4NetworkProfileID,
  @BeginIPv4Address, 
  @EndIPv4Address,
  GETUTCDATE(),
  GETUTCDATE()
  );
END  
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressCreateRange] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressCreateNetworkProfile - used to create network profile
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressCreateNetworkProfile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressCreateNetworkProfile]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressCreateNetworkProfile]
	@ID uniqueidentifier,
	@StaticName nvarchar(255),
	@StaticDesc nvarchar(2048),
	@SubnetMaskIPv4 NVARCHAR(255),
	@GatewayIPv4Address NVARCHAR(255),
	@PrimaryDNSIPv4Address NVARCHAR(255),
	@SecondaryDNSIPv4Address NVARCHAR(255),
	@DnsSuffix NVARCHAR(255),
	@DnsSearchSuffix NVARCHAR(255),
	@PrimaryWinsIPv4Address NVARCHAR(255),
	@SecondaryWinIPv4Address NVARCHAR(255)
AS
BEGIN
INSERT INTO [StaticIPv4NetworkProfile]
(ID, 
 StaticIPv4NetworkProfileName, 
 ProfileDescription, 
 SubnetMaskIPv4, 
 GatewayIPv4Address,
 PrimaryDNSIPv4Address, 
 SecondaryDNSIPv4Address, 
 DnsSuffix,
 DnsSearchSuffix,
 PrimaryWinsIPv4Address, 
 SecondaryWinsIPv4Address,
 CreatedDate,
 LastModifiedDate)
 VALUES
 (@ID, 
  @StaticName, 
  @StaticDesc, 
  @SubnetMaskIPv4,
  @GatewayIPv4Address, 
  @PrimaryDNSIPv4Address, 
  @SecondaryDNSIPv4Address,
  @DnsSuffix, 
  @DnsSearchSuffix,
  @PrimaryWinsIPv4Address, 
  @SecondaryWinIPv4Address,
  GETUTCDATE(),
  GETUTCDATE()
  );
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressCreateNetworkProfile] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressCreateAddress - used to create ipaddress
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressCreateAddress]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressCreateAddress]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressCreateAddress]
	@ID uniqueidentifier,
	@StaticIPv4NetworkProfileID uniqueidentifier,
	@StaticIPv4RangeID uniqueidentifier,
	@VirtualMachineID uniqueidentifier,
	@Hostname nvarchar(255),
	@IPv4Address NVARCHAR(40),
	@IPSortValue bigint,
	@StaticIPv4AddressState integer,
	@NetworkInterface integer
AS
BEGIN
INSERT INTO [StaticIPv4Address]
(ID, 
 StaticIPv4NetworkProfileID, 
 StaticIPv4RangeID,
 VirtualMachineID, 
 Hostname, 
 IPv4Address,
 IPSortValue,
 StaticIPv4AddressState, 
 NetworkInterfaceCardOffset,
 CreatedDate,
 LastModifiedDate)
 VALUES 
 (@ID, 
  @StaticIPv4NetworkProfileID, 
  @StaticIPv4RangeID,
  @VirtualMachineID,
  @Hostname, 
  @IPv4Address,
  @IPSortValue,
  @StaticIPv4AddressState, 
  @NetworkInterface, 
  GETUTCDATE(),
  GETUTCDATE()
  );
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressCreateAddress] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressUpdateNetworkProfile - used to update network profile
-- 03/11/2009 - C Nale
-- 11/03/2009 - K Mati added code to synchronize VirtualMachine.Network%.ProfileName custom property values with network profile name
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressUpdateNetworkProfile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressUpdateNetworkProfile]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressUpdateNetworkProfile]
	@ID uniqueidentifier,
	@StaticName nvarchar(255),
	@StaticDesc nvarchar(2048),
	@SubnetMaskIPv4 NVARCHAR(255),
	@GatewayIPv4Address NVARCHAR(255),
	@PrimaryDNSIPv4Address NVARCHAR(255),
	@SecondaryDNSIPv4Address NVARCHAR(255),
	@DnsSuffix NVARCHAR(255),
	@DnsSearchSuffix NVARCHAR(255),
	@PrimaryWinsIPv4Address NVARCHAR(255),
	@SecondaryWinIPv4Address NVARCHAR(255)
AS
BEGIN

UPDATE [EntityProperties]
SET PropertyValue = @StaticName
WHERE PropertyName LIKE N'VirtualMachine.Network%.ProfileName'
AND PropertyValue = (
	SELECT StaticIPv4NetworkProfileName
	FROM [StaticIPv4NetworkProfile]
	WHERE ID = @ID
);

UPDATE [StaticIPv4NetworkProfile]
SET 
	StaticIPv4NetworkProfileName = @StaticName,
		ProfileDescription =@StaticDesc,
		SubnetMaskIPv4 = @SubnetMaskIPv4,
		GatewayIPv4Address = @GatewayIPv4Address,
		PrimaryDNSIPv4Address = @PrimaryDNSIPv4Address,
		SecondaryDNSIPv4Address = @SecondaryDNSIPv4Address,
	DnsSuffix =@DnsSuffix,
	DnsSearchSuffix = @DnsSearchSuffix,
	PrimaryWinsIPv4Address =@PrimaryWinsIPv4Address,
	SecondaryWinsIPv4Address =@SecondaryWinIPv4Address,
	LastModifiedDate = GETUTCDATE()
WHERE
	ID = @ID;

END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressUpdateNetworkProfile] TO Vrm_Manager
GO


----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressUpdateRange - used to update range
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressUpdateRange]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressUpdateRange]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressUpdateRange]
	@ID uniqueidentifier,
	@Rangename nvarchar(255),
	@Rangedesc nvarchar(2048),
	@StaticIPv4NetworkProfileID uniqueidentifier,
	@BeginIPv4Address NVARCHAR(40),
	@EndIPv4Address NVARCHAR(40)
AS
BEGIN
UPDATE [StaticIPv4Range]
SET
	StaticIPv4RangeName = @Rangename,
	IPv4RangeDescription = @Rangedesc,
	StaticIPv4NetworkProfileID = @StaticIPv4NetworkProfileID,
	BeginIPv4Address = @BeginIPv4Address,
	EndIPv4Address = @EndIPv4Address,
	LastModifiedDate = GETUTCDATE()
 WHERE
	ID = @ID;
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressUpdateRange] TO Vrm_Manager
GO


----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressUpdateAddress - used to update address
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressUpdateAddress]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressUpdateAddress]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressUpdateAddress]
	@ID uniqueidentifier,
	@StaticIPv4NetworkProfileID uniqueidentifier,
	@StaticIPv4RangeID uniqueidentifier,
	@VirtualMachineID uniqueidentifier,
	@Hostname nvarchar(255),
	@IPv4Address NVARCHAR(40),
	@IPSortValue bigint,
	@StaticIPv4AddressState integer,
	@NetworkInterface integer
AS
BEGIN
UPDATE [StaticIPv4Address]
SET
	StaticIPv4NetworkProfileID =@StaticIPv4NetworkProfileID,
	StaticIPv4RangeID =@StaticIPv4RangeID, 
	VirtualMachineID =@VirtualMachineID, 
	Hostname =@Hostname, 
	IPv4Address =@IPv4Address,
	IPSortValue =@IPSortValue,
	StaticIPv4AddressState =@StaticIPv4AddressState, 
	NetworkInterfaceCardOffset =@NetworkInterface,
	LastModifiedDate = GETUTCDATE()
 WHERE
	ID =@ID;
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressUpdateAddress] TO Vrm_Manager
GO


----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressRemoveNetworkProfile -rempve network profile
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressRemoveNetworkProfile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressRemoveNetworkProfile]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressRemoveNetworkProfile]
	@ID uniqueidentifier
AS
BEGIN
DELETE FROM [StaticIPv4NetworkProfile] WHERE ID=@ID;
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressRemoveNetworkProfile] TO Vrm_Manager
GO



----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressRemoveRange -rempve range
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressRemoveRange]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressRemoveRange]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressRemoveRange]
	@ID uniqueidentifier
AS
BEGIN
DELETE FROM [StaticIPv4Range] WHERE ID=@ID;
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressRemoveRange] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressRemoveAddress -remove address
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressRemoveAddress]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressRemoveAddress]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressRemoveAddress]
	@ID uniqueidentifier
AS
BEGIN
DELETE FROM [StaticIPv4Address] WHERE ID=@ID;
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressRemoveAddress] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressGetAllNetworkProfiles -get all network profiles order by the date they where created
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressGetAllNetworkProfiles]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressGetAllNetworkProfiles]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressGetAllNetworkProfiles]
AS
BEGIN
SELECT * FROM [StaticIPv4NetworkProfile] ORDER BY CreatedDate ASC;
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressGetAllNetworkProfiles] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressGetNetworkProfileByID -get profile by ID
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressGetNetworkProfileByID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressGetNetworkProfileByID]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressGetNetworkProfileByID]
	@ID uniqueidentifier
AS
BEGIN
SELECT * FROM [StaticIPv4NetworkProfile]
WHERE ID =@ID;
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressGetNetworkProfileByID] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressRangeGetAllForProfile -get all the ranges for the selected profile
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressRangeGetAllForProfile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressRangeGetAllForProfile]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressRangeGetAllForProfile]
	@StaticIPv4NetworkProfileID uniqueidentifier
AS
BEGIN
SELECT * FROM [StaticIPv4Range] 
WHERE StaticIPv4NetworkProfileID = @StaticIPv4NetworkProfileID
ORDER BY CreatedDate ASC;
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressRangeGetAllForProfile] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressRangeGetByID -get range by ID
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressRangeGetByID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressRangeGetByID]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressRangeGetByID]
	@ID uniqueidentifier
AS
BEGIN
SELECT * FROM [StaticIPv4Range]
WHERE ID = @ID;
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressRangeGetByID] TO Vrm_Manager
GO


----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressGetAllForProfile -get ALL of the address for a given Profile
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressGetAllForProfile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressGetAllForProfile]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressGetAllForProfile]
	@StaticIPv4NetworkProfileID uniqueidentifier
AS
BEGIN
SELECT * FROM [StaticIPv4Address]
WHERE StaticIPv4NetworkProfileID =@StaticIPv4NetworkProfileID
ORDER BY IPSortValue ASC;
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressGetAllForProfile] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressGetAllForRange -get ALL of the address for a given Range
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressGetAllForRange]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressGetAllForRange]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressGetAllForRange]
	@StaticIPv4RangeID uniqueidentifier
AS
BEGIN
SELECT * FROM [StaticIPv4Address]
WHERE StaticIPv4RangeID =@StaticIPv4RangeID
ORDER BY IPSortValue ASC;
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressGetAllForRange] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressGetByID -get an address by ID
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressGetByID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressGetByID]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressGetByID]
	@ID uniqueidentifier
AS
BEGIN
SELECT * FROM [StaticIPv4Address]
WHERE ID =@ID;
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressGetByID] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressGetNextUnallocated -get the next available IP address for a Profile ORDER BY IPSortValue ASC... (should be 10.0.0.1, 10.1.0.1, etc)
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressGetNextUnallocated]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressGetNextUnallocated]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressGetNextUnallocated]
	@StaticIPv4NetworkProfileID uniqueidentifier,
	@VirtualMachineID uniqueidentifier
AS
BEGIN
--BEGIN TRANSACTION
declare @ID uniqueidentifier

SELECT TOP 1 @ID=ID FROM [StaticIPv4Address] with (updlock)
WHERE StaticIPv4NetworkProfileID =@StaticIPv4NetworkProfileID AND StaticIPv4AddressState = 1
ORDER BY IPSortValue ASC;

-- update the records
UPDATE [StaticIPv4Address] 
SET 
	StaticIPv4AddressState=0,
	VirtualMachineID = @VirtualMachineID
	
WHERE ID =@ID;

-- now select the record
SELECT * FROM [StaticIPv4Address] WHERE ID=@ID;

--COMMIT
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressGetNextUnallocated] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_GetNextNetworkAllocationIndex - increment NetworkAllocation Index for a given index
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_GetNextNetworkAllocationIndex]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_GetNextNetworkAllocationIndex]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_GetNextNetworkAllocationIndex]
	@HostReservationID uniqueidentifier
AS
BEGIN
  --BEGIN TRANSACTION
	-- select the value that was just updated ....
	declare @currentIndex int
	SELECT @currentIndex = CurrentNetworkAllocationIndex FROM [HostReservation] ROWLOCK WHERE HostReservationID = @HostReservationID;

	-- update the value 
	UPDATE [HostReservation] 
	SET 
		CurrentNetworkAllocationIndex = @currentIndex + 1
	WHERE
		HostReservationID = @HostReservationID;

	SELECT @currentIndex
  --COMMIT
END
GO
GRANT EXEC ON [dbo].[usp_GetNextNetworkAllocationIndex] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_GetNextStorageAllocationIndex - increment StorageAllocation Index for a given index
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_GetNextStorageAllocationIndex]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_GetNextStorageAllocationIndex]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_GetNextStorageAllocationIndex]
	@HostReservationID uniqueidentifier
AS
BEGIN
  --BEGIN TRANSACTION
	-- select the value that was just updated ....
	declare @currentIndex int
	SELECT @currentIndex = CurrentStorageAllocationIndex FROM [HostReservation] ROWLOCK WHERE HostReservationID = @HostReservationID;

	-- update the value 
	UPDATE [HostReservation] 
	SET 
		CurrentStorageAllocationIndex = @currentIndex + 1
	WHERE
		HostReservationID = @HostReservationID;

	SELECT @currentIndex
  --COMMIT
END
GO
GRANT EXEC ON [dbo].[usp_GetNextStorageAllocationIndex] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_UpdateVirtualMachineHostStorageReservationID - check to see if there is enough of space avaiable for this vm disc request
--                                     and if there is update the vm object
--									   return TRUE if success, FALSE otherwise
-- 03/13/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_UpdateVirtualMachineHostStorageReservationID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_UpdateVirtualMachineHostStorageReservationID]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_UpdateVirtualMachineHostStorageReservationID]
	@VirtualMachineID uniqueidentifier,
	@HostStorageReservationID uniqueidentifier
AS
BEGIN
declare @MaxCapacity bigint
declare @TotalStorage bigint
declare @VMStorage bigint
declare @retVal int
SET @retVal = 0
--BEGIN TRANSACTION
-- select the HostReservationToStorage object and lock it
SELECT @MaxCapacity=MaxCapacity FROM [HostReservationToStorage] ROWLOCK
WHERE
	HostReservationToStorageID =@HostStorageReservationID;
	
-- now get the "proposed vm storage size"
SELECT @VMStorage = VMTotalStorageGB FROM [VirtualMachine]
WHERE
	VirtualMachineID = @VirtualMachineID;

-- now that we have the row lock, sum up the total disc usage in the vms for that ID
SELECT @TotalStorage = SUM(VMTotalStorageGB)FROM [VirtualMachine]
WHERE
	HostStorageReservationID = @HostStorageReservationID;
	
-- now see if we can allocate 
IF @TotalStorage + @VMStorage <= @MaxCapacity
BEGIN
	UPDATE [VirtualMachine]
	SET
		HostStorageReservationID = @HostStorageReservationID
	WHERE
		VirtualMachineID = @VirtualMachineID;
	SET @retVal = 1
END
SELECT @retVal;
END
GO
GRANT EXEC ON [dbo].[usp_UpdateVirtualMachineHostStorageReservationID] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_StaticIPv4AddressGetByAll -get all of the defined static ip addresses
-- 03/17/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressGetByAll]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressGetByAll]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressGetByAll]
AS
BEGIN
SELECT * FROM [StaticIPv4Address]
ORDER BY
	IPSortValue ASC;
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressGetByAll] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_RemoveStaticIPv4AddressForRange -remove addresses for given range
-- 03/11/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_RemoveStaticIPv4AddressForRange]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_RemoveStaticIPv4AddressForRange]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_RemoveStaticIPv4AddressForRange]
	@RangeID uniqueidentifier
AS
BEGIN
DELETE FROM [StaticIPv4Address] WHERE StaticIPv4RangeID=@RangeID;
END
GO
GRANT EXEC ON [dbo].[usp_RemoveStaticIPv4AddressForRange] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectVMNetwork]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectVMNetwork]
GO
CREATE PROCEDURE [dbo].[usp_SelectVMNetwork]
	@VMNetworkID uniqueidentifier = NULL,
	@VirtualMachineID uniqueidentifier = NULL,
	@HostNicID uniqueidentifier = NULL,
	@VMNetworkName nvarchar(256) = NULL,
	@MacAddress nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		VMToNetworkID
		,VirtualMachineID
		,vn.HostNicID
		,NetworkOrder
		,MacAddress
	FROM [VMToNetwork] vn INNER JOIN HostNic n ON vn.HostNicID = n.HostNicID
	WHERE (VMToNetworkID = @VMNetworkID OR @VMNetworkID IS NULL) AND
		(VirtualMachineID = @VirtualMachineID OR @VirtualMachineID IS NULL) AND
		(vn.HostNicID = @HostNicID OR @HostNicID IS NULL) AND
		(n.NetworkName = @VMNetworkName OR @VMNetworkName IS NULL)
	ORDER BY NetworkOrder
END
GO
GRANT EXEC ON [dbo].[usp_SelectVMNetwork] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteVMNetwork]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteVMNetwork]
GO
CREATE PROCEDURE [dbo].[usp_DeleteVMNetwork]
	@VMToNetworkID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [VMToNetwork] WHERE VMToNetworkID = @VMToNetworkID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteVMNetwork] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateVMNetwork]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateVMNetwork]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateVMNetwork] 
	@VMToNetworkID uniqueidentifier
	,@VirtualMachineID uniqueidentifier
	,@HostNicID uniqueidentifier
	,@NetworkOrder int
	,@MacAddress nvarchar(256) = NULL
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [VMToNetwork]
	SET 
		VirtualMachineID = @VirtualMachineID
		,HostNicID = @HostNicID
		,NetworkOrder = @NetworkOrder
		,MacAddress = @MacAddress
	WHERE 
		VMToNetworkID = @VMToNetworkID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [VMToNetwork]
		(VMToNetworkID
		,VirtualMachineID
		,HostNicID
		,NetworkOrder
		,MacAddress)
	 VALUES
		(@VMToNetworkID
		,@VirtualMachineID
		,@HostNicID
		,@NetworkOrder
		,@MacAddress)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateVMNetwork] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_DestroyStaticIPsForVirtualMachine -get all of the defined static ip addresses
-- 03/17/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_UpdateStaticIPsStateForVirtualMachine]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_UpdateStaticIPsStateForVirtualMachine]
GO
-- CREATE
CREATE PROCEDURE [dbo].[usp_UpdateStaticIPsStateForVirtualMachine]
	@vmID uniqueidentifier,
	@staticIPv4AddressState int
AS
BEGIN
UPDATE [StaticIPv4Address]
SET
	LastModifiedDate = GETUTCDATE(),
	StaticIPv4AddressState=@staticIPv4AddressState
	
WHERE
	VirtualMachineID=@vmID;
END 
GO
GRANT EXEC ON [dbo].[usp_UpdateStaticIPsStateForVirtualMachine] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- usp_UpdateStaticIPsStateForVirtualMachine -get all of the defined static ip addresses
-- 03/17/2009 - C Nale
--
-- DROP IF EXITS
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DestroyStaticIPsForVirtualMachine]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DestroyStaticIPsForVirtualMachine]
GO
-- CREATE
CREATE PROCEDURE [dbo].[usp_DestroyStaticIPsForVirtualMachine]
	@vmID uniqueidentifier,
	@staticIPv4AddressState int
AS
BEGIN
UPDATE [StaticIPv4Address]
SET
	VirtualMachineID= null,
	LastModifiedDate = GETUTCDATE(),
	StaticIPv4AddressState=2
	
WHERE
	VirtualMachineID=@vmID;
END
GO
GRANT EXEC ON [dbo].[usp_DestroyStaticIPsForVirtualMachine] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectVirtualMachinePerformance]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectVirtualMachinePerformance]
GO
CREATE PROCEDURE [dbo].[usp_SelectVirtualMachinePerformance]
	@VirtualMachineID uniqueidentifier = NULL,
	@VirtualMachineName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		p.VirtualMachineID
		,VirtualMachineName
		,CpuUsageAverage
		,MemUsageAverage
		,DiskUsageAverage
		,NetUsageAverage
		,LastCollectedTime
		,PerfTimeStamp
	FROM [VMPerformance] p INNER JOIN VirtualMachine v ON v.VirtualMachineID = p.VirtualMachineID
	WHERE (p.VirtualMachineID = @VirtualMachineID OR @VirtualMachineID IS NULL) AND
		(VirtualMachineName = @VirtualMachineName OR @VirtualMachineName IS NULL)
	ORDER BY PerfTimeStamp
END
GO
GRANT EXEC ON [dbo].[usp_SelectVirtualMachinePerformance] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteVirtualMachinePerformance]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteVirtualMachinePerformance]
GO
CREATE PROCEDURE [dbo].[usp_DeleteVirtualMachinePerformance]
	@VirtualMachineID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [VMPerformance] WHERE VirtualMachineID = @VirtualMachineID;
END
GO
GRANT EXEC ON [dbo].[usp_DeleteVirtualMachinePerformance] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateVirtualMachinePerformance]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateVirtualMachinePerformance]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateVirtualMachinePerformance] 
	@VirtualMachineID uniqueidentifier = NULL
	,@VirtualMachineName nvarchar(255) = NULL
	,@CpuUsageAverage decimal(28,3)
	,@MemUsageAverage decimal(28,3)
	,@DiskUsageAverage decimal(28,3)
	,@NetUsageAverage decimal(28,3)
	,@PerfTimeStamp datetime
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	DECLARE @vmID uniqueidentifier
	SET @vmID = @VirtualMachineID
	IF @VirtualMachineName IS NOT NULL
		SELECT @vmID = VirtualMachineID FROM VirtualMachine WHERE VirtualMachineName = @VirtualMachineName
	UPDATE [VMPerformance]
	SET 
		CpuUsageAverage = @CpuUsageAverage
		,MemUsageAverage = @MemUsageAverage
		,DiskUsageAverage = @DiskUsageAverage
		,NetUsageAverage = @NetUsageAverage
		,PerfTimeStamp = @PerfTimeStamp
		,LastCollectedTime = GETDATE()
	WHERE 
		VirtualMachineID = @vmID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [VMPerformance]
		(VirtualMachineID
		,CpuUsageAverage
		,MemUsageAverage
		,DiskUsageAverage
		,NetUsageAverage
		,PerfTimeStamp
		,LastCollectedTime)
	 VALUES
		(@vmID
		,@CpuUsageAverage
		,@MemUsageAverage
		,@DiskUsageAverage
		,@NetUsageAverage
		,@PerfTimeStamp
		,GETDATE())
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateVirtualMachinePerformance] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateEntityPerformance]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateEntityPerformance]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateEntityPerformance] 
	@EntityID uniqueidentifier
	,@EntityName nvarchar(255) = NULL
	,@EntityTypeID tinyint
	,@MetricValue decimal(28,3)
	,@MetricTypeName nvarchar(128)
	,@PerfTimeStamp datetime
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
	-- THE CONTENT OF THIS STORED PROCEDURE WAS REMOVED BUG 43184
	
	-- UPDATE [Performance] SHOULD BE REMOVED (NO USE CASE FOR UPDATE)
	-- WHEN STORED PROCEDURE CONTENT IS PUT BACK
	
	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateEntityPerformance] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_GetNumOfPendingWorkItems]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_GetNumOfPendingWorkItems]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_GetNumOfPendingWorkItems]
	@DataCollectionStatusID uniqueidentifier
AS
-- select the value that was just updated ....
SELECT COUNT(WorkItemID) NumOfPendingWorkItems FROM [WorkItem] WHERE DataCollectionStatusID = @DataCollectionStatusID;
GO
GRANT EXEC ON [dbo].[usp_GetNumOfPendingWorkItems] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_ResetDataCollectionStatus]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_ResetDataCollectionStatus]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_ResetDataCollectionStatus]
	@DataCollectionStatusID uniqueidentifier=NULL
	,@AgentID uniqueidentifier=NULL
	,@EntityID uniqueidentifier=NULL
	,@FilterSpecGroupName nvarchar(128)=NULL
AS
BEGIN
	UPDATE DataCollectionStatus SET LastCollectedTime = null, CollectionStartTime = null 
	FROM DataCollectionStatus s INNER JOIN FilterSpec f ON f.FilterSpecID = s.FilterSpecID  
		INNER JOIN FilterSpecGroup g ON g.FilterSpecGroupID = f.FilterSpecGroupID
	WHERE (DataCollectionStatusID = @DataCollectionStatusID OR @DataCollectionStatusID IS NULL) AND
		(AgentID = @AgentID OR @AgentID IS NULL) AND
		(EntityID = @EntityID OR @EntityID IS NULL) AND
		(FilterSpecGroupName = @FilterSpecGroupName OR @FilterSpecGroupName IS NULL)
END
GO
GRANT EXEC ON [dbo].[usp_ResetDataCollectionStatus] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_GetProvisioningGroupCostRanges]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_GetProvisioningGroupCostRanges]
GO
-- CREATE 
CREATE PROCEDURE [dbo].[usp_GetProvisioningGroupCostRanges]
AS
BEGIN
SELECT * FROM uv_ProvisioningGroupCostView
END
GO
GRANT EXEC ON [dbo].[usp_GetProvisioningGroupCostRanges] TO Vrm_Manager
GO
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertCategoryLog]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertCategoryLog]
GO
-- CREATE
CREATE PROCEDURE [dbo].[usp_InsertCategoryLog]
	@CategoryID INT,
	@LogID INT
AS
BEGIN
	SET NOCOUNT ON;

	DECLARE @CatLogID INT
	SELECT @CatLogID FROM [CategoryLog] WHERE CategoryID = @CategoryID AND LogID = @LogID
	IF @CatLogID IS NULL
	BEGIN
		INSERT CategoryLog(CategoryID, LogID) VALUES(@CategoryID, @LogID)
		RETURN @@IDENTITY
	END
	ELSE RETURN @CatLogID
END
GO
GRANT EXEC ON [dbo].[usp_InsertCategoryLog] TO Vrm_Manager
GO
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_AddCategory]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_AddCategory]
GO
-- CREATE
CREATE PROCEDURE [dbo].[usp_AddCategory]
	@CategoryName NVARCHAR(64),
	@LogID INT
AS
BEGIN
	SET NOCOUNT ON;

	DECLARE @CatID int
	SELECT @CatID = CategoryID FROM Categories WHERE CategoryName = @CategoryName
	IF @CatID IS NULL
	BEGIN
		INSERT Categories(CategoryName) VALUES(@CategoryName)
		SELECT @CatID = @@IDENTITY
	END

	EXEC usp_InsertCategoryLog @CatID, @LogID

	RETURN @CatID
END
GO
GRANT EXEC ON [dbo].[usp_AddCategory] TO Vrm_Manager
GO
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_LogEntryEntLib]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_LogEntryEntLib]
GO
-- CREATE
CREATE PROCEDURE [dbo].[usp_LogEntryEntLib] 
(
	@EventID INT,
	@Priority INT,
	@Severity NVARCHAR(64),
	@Title NVARCHAR(256),
	@Timestamp DATETIME,
	@MachineName NVARCHAR(64),
	@AppDomainName NVARCHAR(512),
	@ProcessID NVARCHAR(256),
	@ProcessName NVARCHAR(512),
	@ThreadName NVARCHAR(512),
	@Win32ThreadID NVARCHAR(128),
	@Message NTEXT,
	@FormattedMessage NTEXT,
	@LogID INT OUTPUT
)
AS
BEGIN
	INSERT INTO [Audit]
	(
		[EventID],
		[Priority],
		[Severity],
		[Title],
		[Timestamp],
		[MachineName],
		[AppDomainName],
		[ProcessID],
		[ProcessName],
		[ThreadName],
		[Win32ThreadID],
		[Message],
		[FormattedMessage]
	)
	VALUES
	(
		@EventID,
		@Priority,
		@Severity,
		@Title,
		@Timestamp,
		@MachineName,
		@AppDomainName,
		@ProcessID,
		@ProcessName,
		@ThreadName,
		@Win32ThreadID,
		@Message,
		@FormattedMessage
	)

	SET @LogID=@@IDENTITY

END
GO
GRANT EXEC ON [dbo].[usp_LogEntryEntLib] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EnumerateAudit]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EnumerateAudit]
GO
-- CREATE
CREATE PROCEDURE [dbo].[usp_EnumerateAudit] 
AS
BEGIN
   SELECT
	   *,
	   -- change next line to retreive and join with comma categories from Categories.CategoryName
	   -- where Categories.CategoryID = enties in CategoryLog.CategoryID where LogID match
	   --(a.ProcessID) Categories
	   [dbo].GetCategoriesForAuditMessage(LogID) as Categories
   FROM [Audit] a
   WHERE LogID IN
	   (SELECT TOP 1000 LogID FROM [Audit] ORDER BY LogID DESC)
   ORDER BY LogID DESC
END
GO
GRANT EXEC ON [dbo].[usp_EnumerateAudit] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteApprovalPolicy]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteApprovalPolicy]
GO
CREATE PROCEDURE [dbo].[usp_DeleteApprovalPolicy]
	  @PolicyID uniqueidentifier = NULL
AS
BEGIN
	  SET NOCOUNT ON;
	  DELETE FROM [ApprovalPolicy] WHERE PolicyId = @PolicyID
 END
GO
GRANT EXEC ON [dbo].[usp_DeleteApprovalPolicy] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateApprovalPolicy]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateApprovalPolicy]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateApprovalPolicy]
	  @PolicyID uniqueidentifier
	,@PolicyName nvarchar(50)
	,@PolicyDescription nvarchar(2000) = NULL
	,@EmailOwner bit
	  ,@EmailApprover bit
	  ,@XmlConfiguration nvarchar(MAX) = NULL
	  ,@GroupAdminApproval bit
	
AS
BEGIN
	  SET NOCOUNT OFF;
--      BEGIN TRANSACTION;

	  UPDATE [ApprovalPolicy]
	  SET
				  PolicyId = @PolicyID
			,PolicyName = @PolicyName
			,PolicyDescription = @PolicyDescription
			,EmailOwner = @EmailOwner
			,EmailApprover = @EmailApprover
				  ,XmlConfiguration = @XmlConfiguration
				  ,GroupAdminApproval = @GroupAdminApproval
	  WHERE
			PolicyId = @PolicyID

	  IF @@ROWCOUNT = 0
			INSERT INTO [ApprovalPolicy]
			(PolicyId
			,PolicyName
			,PolicyDescription
			,EmailOwner
			,EmailApprover
				  ,XmlConfiguration
				  ,GroupAdminApproval)
	 VALUES
			(@PolicyID
			,@PolicyName
			,@PolicyDescription
			,@EmailOwner
			,@EmailApprover
				  ,@XmlConfiguration
				  ,@GroupAdminApproval
);
--    COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateApprovalPolicy] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectApprovalPolicy]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectApprovalPolicy]
GO
CREATE PROCEDURE [dbo].[usp_SelectApprovalPolicy]
	  @PolicyID uniqueidentifier = NULL,
	  @SearchString nvarchar(256) = NULL,
	  @PolicyName nvarchar(50) = NULL,
	  @ResultCount int = 0
AS
BEGIN
	  /*SET ROWCOUNT @ResultCount;*/
	  SELECT
			PolicyId
		,PolicyName
		,PolicyDescription
		,EmailOwner
		,EmailApprover
			,XmlConfiguration
			,GroupAdminApproval
	  FROM [ApprovalPolicy]
	  WHERE (PolicyId = @PolicyID OR @PolicyID IS NULL) AND
			(PolicyName LIKE @SearchString OR @SearchString IS NULL) AND
			(PolicyName = @PolicyName OR @PolicyName IS NULL)
	  ORDER BY PolicyName;
END
GO
GRANT EXEC ON [dbo].[usp_SelectApprovalPolicy] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteApprovalGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteApprovalGroup]
GO
CREATE PROCEDURE [dbo].[usp_DeleteApprovalGroup]
	  @GroupID uniqueidentifier = NULL
AS
BEGIN
	  SET NOCOUNT ON;
	  DELETE FROM [ProvisioningGroup] WHERE GroupID = @GroupID;
END
GO
GRANT EXEC ON [dbo].[usp_DeleteApprovalGroup] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateApprovalGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateApprovalGroup]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateApprovalGroup] 
	  @GroupID uniqueidentifier
	,@GroupName nvarchar(50)
	,@GroupDescription nvarchar(2000) = NULL
	,@AdministratorEmail nvarchar(256) = NULL
AS
BEGIN
	  SET NOCOUNT OFF;
--      BEGIN TRANSACTION;

	  UPDATE [ProvisioningGroup]
	  SET 
			GroupName = @GroupName
			,GroupDescription = @GroupDescription
			,AdministratorEmail = @AdministratorEmail
	  WHERE 
			GroupID = @GroupID
			
	  IF @@ROWCOUNT = 0 
			INSERT INTO [ProvisioningGroup]
			(GroupID
			,GroupName
			,GroupDescription
			,AdministratorEmail
			,GroupType)
	 VALUES
			(@GroupID
			,@GroupName
			,@GroupDescription
			,@AdministratorEmail
			,1)
--    COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateApprovalGroup] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectApprovalGroup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectApprovalGroup]
GO
CREATE PROCEDURE [dbo].[usp_SelectApprovalGroup]
	  @GroupID uniqueidentifier = NULL,
	  @SearchString nvarchar(256) = NULL,
	  @GroupName nvarchar(256) = NULL,
	  @ResultCount int = 0
AS
BEGIN
	  /*SET ROWCOUNT @ResultCount;*/
	  SELECT 
		 GroupID
		,GroupName
		,GroupDescription
		,AdministratorEmail
		,IsTestGroup
		,Flags
	  FROM [ProvisioningGroup]
	  WHERE (GroupID = @GroupID OR @GroupID IS NULL) AND
			(GroupName LIKE @SearchString OR @SearchString IS NULL) AND
			(GroupName = @GroupName OR @GroupName IS NULL) AND 
			GroupType=1
	  ORDER BY GroupName
END
GO
GRANT EXEC ON [dbo].[usp_SelectApprovalGroup] TO Vrm_Manager
GO

---------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectHostToStorageForReportUsage]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectHostToStorageForReportUsage]
GO

CREATE PROCEDURE [dbo].[usp_SelectHostToStorageForReportUsage]
	@pHostId uniqueidentifier = NULL
AS
BEGIN
	SELECT 
		HostToStorageID
		,HostID
		,HS.StorageID
		,HS.StoragePath
		,S.StorageUniqueID
		,S.StorageDevice
		,S.StorageTotalCapacityGB
		,S.StorageFreeCapacityGB
		,S.StorageTypeID
		,S.StorageName
		,COALESCE((SELECT ReservedCapacityInGB FROM [HostStorageReservationView] srv WHERE srv.StorageID = HS.StorageID), 0) ReservedCapacityInGB
		,COALESCE((SELECT ReservedUsedCapacityInGB FROM [HostStorageReservationUsedView] sruv WHERE sruv.StorageID = HS.StorageID), 0) ReservedUsedCapacityInGB
	FROM [HostToStorage] HS, [Storage] S
	WHERE HS.StorageID = S.StorageID AND
		(HostID = @pHostId)
	ORDER BY StoragePath
END
GO
GRANT EXEC ON [dbo].[usp_SelectHostToStorageForReportUsage] TO Vrm_Manager
GO

---------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_UpdateDataCollectionFrequency]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_UpdateDataCollectionFrequency]
GO

CREATE PROCEDURE [dbo].[usp_UpdateDataCollectionFrequency]
	  @TaskName nvarchar(64),
	  @Frequency int
AS
BEGIN
	update CollectionSchedule Set FrequencyInMinutes = @Frequency, ScheduleName = N'Every ' + Convert(nvarchar(10), @Frequency, 0) + N' Minutes'
	FROM CollectionSchedule c INNER JOIN FilterSpecGroup g ON c.ScheduleID = g.ScheduleID
	WHERE g.FilterSpecGroupName = @TaskName
END
GO
GRANT EXEC ON [dbo].[usp_UpdateDataCollectionFrequency] TO Vrm_Manager
GO

---------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsPhysicalMachine]') AND type in (N'P', N'FN'))
DROP FUNCTION [dbo].[IsPhysicalMachine]
GO

-- Function for testing whether or not a virtual machine is related to a physical machine
-- Parameters:
-- @VirtualMachineID : The virtual machine id
-- Returns BIT value:
-- 1 = true  : the virtual machine is related to a physical machine
-- 0 = false : just a regular old virtual machine
CREATE FUNCTION [dbo].[IsPhysicalMachine] (@VirtualMachineID UNIQUEIDENTIFIER)
RETURNS BIT AS
BEGIN
	RETURN
	(
		SELECT COUNT(*)
		FROM VirtualMachine v
		WHERE v.MachineType = 1
		AND v.VirtualMachineID = @VirtualMachineID
	)
END
GO
GRANT EXEC ON [dbo].[IsPhysicalMachine] TO Vrm_Manager
GO

---------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsCloudMachine]') AND type in (N'P', N'FN'))
DROP FUNCTION [dbo].[IsCloudMachine]
GO

-- Function for testing whether or not a virtual machine is related to a Cloud machine
-- Parameters:
-- @VirtualMachineID : The virtual machine id
-- Returns BIT value:
-- 1 = true  : the virtual machine is related to a Cloud machine
-- 0 = false : virtual or physical machine
CREATE FUNCTION [dbo].[IsCloudMachine] (@VirtualMachineID UNIQUEIDENTIFIER)
RETURNS BIT AS
BEGIN
	RETURN
	(
		SELECT COUNT(*)
		FROM VirtualMachine v
		WHERE v.MachineType = 2
		AND v.VirtualMachineID = @VirtualMachineID
	)
END

GO
GRANT EXEC ON [dbo].[IsCloudMachine] TO Vrm_Manager
GO

---------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_AllocatePhysicalReservation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_AllocatePhysicalReservation]
GO
CREATE PROCEDURE [dbo].[usp_AllocatePhysicalReservation] 
	@VirtualMachineID uniqueidentifier,
	@GroupID uniqueidentifier,
	@VMMemorySize int,
	@VMCpuCount int,
	@ReservationPolicyID uniqueidentifier,
	@UserLocation nvarchar(256)
AS

BEGIN
	DECLARE @CPUMatching bit -- 0 = At Least; 1 = Exactly
	DECLARE @MemoryMatching bit -- 0 = At Least; 1 = Exactly
	DECLARE @InterfaceType nvarchar(max)	 -- Set to ManagementEndpoint.InterfaceType

	SELECT
	@CPUMatching = CAST(ep1.PropertyValue AS BIT),
	@MemoryMatching = CAST(ep2.PropertyValue AS BIT),
	@InterfaceType = t.InterfaceTypeId
	FROM EntityProperties ep1, EntityProperties ep2, VirtualMachineTemplate t, VirtualMachine v
	WHERE t.VirtualMachineTemplateID = ep1.EntityID AND ep1.PropertyName = N'__matching_cpu'
	AND   t.VirtualMachineTemplateID = ep2.EntityID AND ep2.PropertyName = N'__matching_memory'
	AND   t.VirtualMachineTemplateID = v.VirtualMachineTemplateID
	AND v.VirtualMachineID = @VirtualMachineID;
	
	DECLARE @PhysicalMachineID uniqueidentifier
	DECLARE @ReservationID uniqueidentifier

	SELECT
		@PhysicalMachineID = CONVERT(uniqueidentifier, E.PropertyValue)
	FROM EntityProperties E
	WHERE E.EntityID = @VirtualMachineID
	AND E.PropertyName = N'VirtualMachine.Admin.PhysicalMachineID'

	IF (@PhysicalMachineID IS NOT NULL)
	BEGIN
		SELECT
			@ReservationID = HR.HostReservationID,
			@PhysicalMachineID = P.PhysicalMachineID
		FROM EntityProperties E, PhysicalMachines P, VirtualMachine V, HostReservationInfo HR
		WHERE E.EntityID = @VirtualMachineID
		AND E.PropertyName = N'VirtualMachine.Admin.PhysicalMachineID'
		AND CAST(E.PropertyValue AS uniqueidentifier) = P.PhysicalMachineID
		AND P.PhysicalMachineID = V.PhysicalMachineID
		AND V.HostReservationID = HR.HostReservationID
		AND V.VirtualMachineTemplateID IS NULL
		AND P.PhysicalMachineID IN
		(	
			SELECT P.PhysicalMachineID from PhysicalMachines P
			WHERE P.PhysicalController_PhysicalControllerID IN
			(
				SELECT PC.PhysicalControllerID FROM PhysicalControllers PC
				WHERE PC.ManagementEndpoint_ManagementEndpointID IN 
				(
					SELECT ME.ManagementEndpointID FROM ManagementEndpoints ME
					WHERE ME.InterfaceType = @InterfaceType
				)	
			)
		)
		AND P.PhysicalMachineID NOT IN
		(
			SELECT DISTINCT V.PhysicalMachineID 
			FROM VirtualMachine V, EntityProperties E
			WHERE E.PropertyName = N'Cisco.ServiceProfile.Dn'
			AND E.EntityID = V.VirtualMachineID
		)
		AND
		(
			(
				@CPUMatching = 0 AND @VMCpuCount <= P.ProcessorCount
			)
			OR
			(
				@CPUMatching = 1 AND @VMCpuCount = P.ProcessorCount 
			)
		)
		AND
		(
			(
				@MemoryMatching = 0 AND @VMMemorySize <= P.MemoryInMB 
			)
			OR
			(
				@MemoryMatching = 1 AND @VMMemorySize = P.MemoryInMB
			)
		)
		AND HR.GroupID = @GroupID 
		AND (HR.VirtualMachineQuota = 0 OR HR.VirtualMachineQuota > HR.ResTotalVMCount)
		AND HR.Enabled = 1	
		AND (@ReservationPolicyID is null or HR.ReservationPolicyID = @ReservationPolicyID)
		AND (@UserLocation = '' or @UserLocation is null or
			(SELECT UPPER(DataCenter) FROM PhysicalControllers pc
			WHERE pc.PhysicalControllerID = p.PhysicalController_PhysicalControllerID) = @UserLocation)
	END
	ELSE
	BEGIN
		-- Using Original Reservation Logic, search (by priority) the best reservations that
		-- can be allocated to a group
		SELECT TOP 1
			@ReservationID = HR.HostReservationID,
			@PhysicalMachineID = P.PhysicalMachineID
		FROM PhysicalMachines P, VirtualMachine V, HostReservationInfo HR, ManagementEndpoints E
		WHERE
			P.PhysicalMachineID = V.PhysicalMachineID
			AND V.HostReservationID = HR.HostReservationID
			-- Only include reservations with unprovisioned physical machines
			AND V.VirtualMachineTemplateID IS NULL
			AND P.PhysicalMachineID IN
			(	
				SELECT P.PhysicalMachineID from PhysicalMachines P
				WHERE P.PhysicalController_PhysicalControllerID IN
				(
					SELECT PC.PhysicalControllerID FROM PhysicalControllers PC
					WHERE PC.ManagementEndpoint_ManagementEndpointID IN 
					(
						SELECT ME.ManagementEndpointID FROM ManagementEndpoints ME
						WHERE ME.InterfaceType = @InterfaceType
					)	
				)
			)
			AND P.PhysicalMachineID NOT IN
			(
				SELECT DISTINCT V.PhysicalMachineID 
				FROM VirtualMachine V, EntityProperties E
				WHERE E.PropertyName = N'Cisco.ServiceProfile.Dn'
				AND E.EntityID = V.VirtualMachineID
			)
			AND
			(
				(
					@CPUMatching = 0 AND @VMCpuCount <= P.ProcessorCount
				)
				OR
				(
					@CPUMatching = 1 AND @VMCpuCount = P.ProcessorCount 
				)
			)
			AND
			(
				(
					@MemoryMatching = 0 AND @VMMemorySize <= P.MemoryInMB 
				)
				OR
				(
					@MemoryMatching = 1 AND @VMMemorySize = P.MemoryInMB
				)
			)
			AND HR.GroupID = @GroupID 
			AND (HR.VirtualMachineQuota = 0 OR HR.VirtualMachineQuota > HR.ResTotalVMCount)
			AND HR.Enabled = 1	
			AND (@ReservationPolicyID is null or HR.ReservationPolicyID = @ReservationPolicyID)
			AND (@UserLocation = N'' or @UserLocation is null or
				(SELECT UPPER(DataCenter) FROM PhysicalControllers pc
				WHERE pc.PhysicalControllerID = p.PhysicalController_PhysicalControllerID) = @UserLocation)
		ORDER BY
			-- Retrieve highest priority reservation using percentage free slots as tie-breaker
			HR.ReservationPriority, 
			CASE WHEN HR.VirtualMachineQuota = 0 THEN HR.ResTotalVMCount 
				ELSE 100 * HR.ResTotalVMCount/HR.VirtualMachineQuota END;
	END
	
-- Delete the virtual machine previously associated with a physical machine
	IF @PhysicalMachineID IS NOT NULL
	BEGIN
		DELETE FROM VirtualMachine WHERE PhysicalMachineID = @PhysicalMachineID;
	END

-- Select reservation data from host reservation view and apply selection criteria.
	UPDATE
		VirtualMachine
	SET
		HostReservationID = @ReservationID,
		PhysicalMachineID = @PhysicalMachineID
	WHERE
		VirtualMachineID = @VirtualMachineID;

	SELECT @ReservationID
END

GO
GRANT EXEC ON [dbo].[usp_AllocatePhysicalReservation] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_AllocateCloudReservation]') AND type in (N'P', N'PC'))

DROP PROCEDURE [dbo].[usp_AllocateCloudReservation]
GO
CREATE PROCEDURE [dbo].[usp_AllocateCloudReservation] 
	@VirtualMachineID uniqueidentifier,
	@GroupID uniqueidentifier,
	@ReservationPolicyID uniqueidentifier,
	@UserLocation nvarchar(256)
AS

BEGIN
	--Declare Variables
	DECLARE @ReservationID uniqueidentifier
	DECLARE @HostID uniqueidentifier
       DECLARE @TotalEbsVolumeStorageRequested int
	
       SET @TotalEbsVolumeStorageRequested = ISNULL(dbo.GetVirtualMachinePropertyValue(@VirtualMachineID, N'__amazon.ebs.totalStorageRequested'), 0)
	
       -- Using Original Reservation Logic, search (by priority) the best reservations that can be allocated to a group
       SELECT TOP 1
              @ReservationID = HR.HostReservationID,
              @HostID = HR.HostID
	FROM HostReservationInfo HR
			  JOIN HostReservationEbsVolumeCapacity HREVC ON HR.HostReservationID = HREVC.HostReservationID
	WHERE
		-- Eliminate reservations not in the template group
		HR.GroupID = @GroupID 
		 -- Only include reservations with machine slots free
		AND (HR.VirtualMachineQuota = 0 OR HR.VirtualMachineQuota > HR.ResTotalVMCount)
		-- Only include enabled reservations
		AND HR.Enabled = 1
		-- Only include cloud reservations
		AND HR.MachineType = 2
		-- Only include correct reservation policies
		AND (@ReservationPolicyID is null or HR.ReservationPolicyID = @ReservationPolicyID)
              -- Only include allowed reservations by AMI (Filter by AMI Region)
		AND HR.HostID IN (SELECT HostID FROM dbo.AmiOfMachineToHosts(@VirtualMachineID))
              -- Only include reservations that have enough capacity for EBS Volume Storage
              AND (HREVC.AvailableCapacity IS NULL OR @TotalEbsVolumeStorageRequested = 0 OR HREVC.AvailableCapacity >= @TotalEbsVolumeStorageRequested)
              -- Only include reservations that have the availability zone or subnet (if the request is for a VPC)
              AND HR.HostReservationID IN (SELECT HostReservationID FROM dbo.AvailabilityZoneOrSubnetToReservations(@VirtualMachineID, @UserLocation))
              -- Only include reservations that have the requested security groups.
              AND HR.HostReservationID IN (SELECT HostReservationID FROM dbo.SecurityGroupsToReservations(@VirtualMachineID))
	ORDER BY
		-- Retrieve highest priority reservation using percentage free slots as tie-breaker
		HR.ReservationPriority, 
		CASE WHEN HR.VirtualMachineQuota = 0 THEN HR.ResTotalVMCount 
			ELSE 100 * HR.ResTotalVMCount/HR.VirtualMachineQuota END
	
	UPDATE
		VirtualMachine
	SET
		HostReservationID = @ReservationID,
		HostID = @HostID
	WHERE
		VirtualMachineID = @VirtualMachineID;

	SELECT @ReservationID
END
GO

GRANT EXEC ON [dbo].[usp_AllocateCloudReservation] TO Vrm_Manager
GO

---------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_AllocateReservation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_AllocateReservation]
GO

CREATE PROCEDURE [dbo].[usp_AllocateReservation] 
	@VirtualMachineID uniqueidentifier,
	@GroupID uniqueidentifier,
	@VMDiskSize int,
	@VMMemorySize int,
	@VMCpuCount int,
	@ReservationPolicyID uniqueidentifier,
	@UserLocation nvarchar(256)
AS
BEGIN
	
	IF [dbo].[IsPhysicalMachine](@VirtualMachineID) = 1
	BEGIN
		-- call the sp to allocate physical machine reservations
		EXEC [dbo].[usp_AllocatePhysicalReservation]
			@VirtualMachineID,
			@GroupID,
			@VMMemorySize,
			@VMCpuCount,
			@ReservationPolicyID,
			@UserLocation;
		RETURN
	END

	IF [dbo].[IsCloudMachine](@VirtualMachineID) = 1
	BEGIN
		-- Call the stored procedure to allocate cloud machine reservations
		EXEC [dbo].[usp_AllocateCloudReservation]
			@VirtualMachineID,
			@GroupID,
			@ReservationPolicyID,
			@UserLocation;
		RETURN
	END

END
GO
GRANT EXEC ON [dbo].[usp_AllocateReservation] TO Vrm_Manager
GO

---------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_GetAvailableReservations]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_GetAvailableReservations]
GO

CREATE PROCEDURE [dbo].[usp_GetAvailableReservations] 
	@VirtualMachineID uniqueidentifier,
	@GroupID uniqueidentifier,
	@VMDiskSize int,
	@VMCpuCount int,
	@ReservationPolicyID uniqueidentifier,
	@UserLocation nvarchar(256),
	@RequestedAllocationType tinyint = 3   -- Indifferent
AS
BEGIN
	-- The following pertains to allocating virtual machine reservations.
	DECLARE @RuntimeReservationPolicyID uniqueidentifier
	SELECT @RuntimeReservationPolicyID = PropertyValue FROM VirtualMachineProperties
	WHERE PropertyName =N'__reservationPolicyID' AND EntityID = @VirtualMachineID
	
	IF (@RuntimeReservationPolicyID IS NOT NULL)
	BEGIN
		SET @ReservationPolicyID = @RuntimeReservationPolicyID;
	END
	
	DECLARE @DataCenterPolicy NVARCHAR(255)
	SELECT	@DataCenterPolicy = vmp.PropertyValue
	FROM	VirtualMachineProperties vmp
	WHERE	vmp.EntityID = @VirtualMachineID
	AND		vmp.PropertyName = N'VRM.Datacenter.Policy'
	
	DECLARE @IsTpmEnabled BIT
	SELECT	@IsTpmEnabled = vmp.PropertyValue
	FROM	VirtualMachineProperties vmp
	WHERE	vmp.EntityID = @VirtualMachineID
	AND		vmp.PropertyName = N'VirtualMachine.Host.TpmEnabled'

	-- reservation selection, filtered by group, active hosts, enabled, with aggregate storage
	-- sorted by best reservation, ordered by location, priority, then utiliztion ratio
	SELECT	hrl.HostReservationID
	FROM	HostReservation			hrl with (updlock)  -- force locking to execute on primary key
	JOIN	HostReservation			hr	ON hrl.HostReservationID = hr.HostReservationID
	JOIN	Host					h	ON hr.HostID = h.HostID
	LEFT JOIN HostProperties		hpl	on h.HostID = hpl.EntityID
										and hpl.PropertyName = N'Vrm.DataCenter.Location'
	LEFT JOIN HostReservationStats hrst on hr.HostReservationID = hrst.HostReservationID
	-- aggregate storage check								
	JOIN
	(
			SELECT	hrs.HostReservationID,
					CASE 
						WHEN COUNT(hrs.MaxCapacity) != COUNT(*) THEN NULL /* If any storage path capacities are null, the total capacity should be null (i.e. unlimited) */
						ELSE SUM(hrs.MaxCapacity - hrss.StorageAllocated)
					END AS AllocatedStorageAvailable,
					SUM(StorageFreeCapacityGB) AS PhysicalStorageAvailable
			FROM	HostReservationToStorage hrs
			JOIN	HostToStorage hs	on hrs.HostToStorageID = hs.HostToStorageID
										AND hs.Flags = 0
			JOIN	Storage s on hs.StorageID = s.StorageID			
			JOIN	HostReservationToStorageStats hrss	ON hrs.HostReservationToStorageID = hrss.HostReservationToStorageID
			WHERE	hrs.[Enabled] = 1
			GROUP BY hrs.HostReservationID
	) hrsst ON	hr.HostReservationID = hrsst.HostReservationID									
	WHERE	hr.GroupID = @GroupID 	-- Eliminate reservations not in the template group
	AND		h.HostStateID = 0		-- Only include active hosts
	AND		hr.[Enabled] = 1		-- Only include enabled reservations
	AND		(@ReservationPolicyID is null or hr.ReservationPolicyID = @ReservationPolicyID)
	-- data center location and policy check, by default uses the exact match
	AND		(@UserLocation IS NULL OR ISNULL(NULLIF(@DataCenterPolicy,N''), N'Exact') <> N'Exact' OR hpl.PropertyValue = @UserLocation)
	AND		(@IsTpmEnabled IS NULL OR @IsTpmEnabled = 0 OR h.IsTpmEnabled = 1) -- Only include hosts with trust hardware installed
	AND		(hrsst.AllocatedStorageAvailable >= @VMDiskSize OR hrsst.AllocatedStorageAvailable IS NULL) -- Only include reservations with disk space free
	AND		(hrsst.PhysicalStorageAvailable >= @VMDiskSize OR h.AllocationType = 2) -- Only include where physical storage is greater than VM size
	-- requested allocation type for vCD (0 = guaranteed, 1 = limited, 2 = unlimited, 3 = indifferent)
	AND		(@RequestedAllocationType = 3 OR h.AllocationType = @RequestedAllocationType)
	ORDER BY
		-- location matches first, then by priority, then my allocation percentage
		CASE 
			WHEN @UserLocation = hpl.PropertyValue THEN 0
			ELSE 1
		END,
		hr.ReservationPriority, 
		CASE 
			WHEN hr.MaxVMsPowerOn = 0 AND hrst.MachinesAllocated = 0 THEN (-1)
			WHEN hr.MaxVMsPowerOn = 0 AND hrst.MachinesAllocated <> 0 THEN 1 - (CAST(1 AS FLOAT))/hrst.MachinesAllocated
			ELSE 1 + (CAST(hrst.MachinesAllocated AS FLOAT)) / hr.MaxVMsPowerOn 
		END
END
GO
GRANT EXEC ON [dbo].[usp_GetAvailableReservations] TO Vrm_Manager
GO

---------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_GetUICustomization]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_GetUICustomization]
GO
CREATE PROCEDURE [dbo].[usp_GetUICustomization] 
AS
BEGIN
	select * from UICustomization;
END
GO
GRANT EXEC ON [dbo].[usp_GetUICustomization] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUICustomization]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUICustomization]
GO
CREATE PROCEDURE [dbo].[usp_InsertUICustomization] 
	@ID uniqueidentifier,
	@ShowDashboard int,
	@ShowVMGrid int,
	@ShowVMGridFilters int,
	@ShowVMGridMultiSelect int,
	@ShowVMGridExport int,
	@VMGridDefaultColumns ntext,
	@ShowPendingGrid int,
	@ShowPendingGridExport int,
	@ShowReclaimGrid int,
	@ShowReclaimGridExport int,
	@ShowExpireGrid int,
	@ShowExpireGridExport int,
	@ShowRecentGrid int,
	@ShowRecentGridExport int,
	@RequestVMShownFields ntext,
	@DefaultInitialPage int,
	@ShowVMGridExtraColumns int,
	@ShowReclaimColumns int
AS
BEGIN
	INSERT INTO UICustomization (id, lastmodified, showdashboard, showvmgrid, showvmgridfilters, showvmgridmultiselect,
	showvmgridexport, vmgriddefaultcolumns, showpendinggrid, showpendinggridexport, showreclaimgrid, showreclaimgridexport,
	showexpiregrid, showexpiregridexport, showrecentgrid, showrecentgridexport, requestvmshownfields, defaultinitialpage,showvmgridextracolumns, showreclaimcolumns)
	VALUES (@ID, (getDate()), @ShowDashboard, @ShowVMGrid, @ShowVMGridFilters, @ShowVMGridMultiSelect, @ShowVMGridExport,
	@VMGridDefaultColumns, @ShowPendingGrid, @ShowPendingGridExport, @ShowReclaimGrid, @ShowReclaimGridExport, @ShowExpireGrid,
	@ShowExpireGridExport, @ShowRecentGrid, @ShowRecentGridExport, @RequestVMShownFields, @DefaultInitialPage, @ShowVMGridExtraColumns, @ShowReclaimColumns);
	select @@rowcount;	
END
GO
GRANT EXEC ON [dbo].[usp_InsertUICustomization] TO Vrm_Manager
GO
-----------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_UpdateUICustomization]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_UpdateUICustomization]
GO
CREATE PROCEDURE [dbo].[usp_UpdateUICustomization] 
	@ID uniqueidentifier,
	@ShowDashboard int,
	@ShowVMGrid int,
	@ShowVMGridFilters int,
	@ShowVMGridMultiSelect int,
	@ShowVMGridExport int,
	@VMGridDefaultColumns ntext,
	@ShowPendingGrid int,
	@ShowPendingGridExport int,
	@ShowReclaimGrid int,
	@ShowReclaimGridExport int,
	@ShowExpireGrid int,
	@ShowExpireGridExport int,
	@ShowRecentGrid int,
	@ShowRecentGridExport int,
	@RequestVMShownFields ntext,
	@DefaultInitialPage int,
	@ShowVMGridExtraColumns int,
	@ShowReclaimColumns int
AS
BEGIN
	UPDATE UICustomization SET
	id = @ID,
	showdashboard = @ShowDashboard,
	showvmgrid = @ShowVMGrid,
	showvmgridfilters = @ShowVMGridFilters,
	showvmgridmultiselect = @ShowVMGridMultiSelect,
	showvmgridexport = @ShowVMGridExport,
	vmgriddefaultcolumns = @VMGridDefaultColumns,
	showpendinggrid = @ShowPendingGrid,
	showpendinggridexport = @ShowPendingGridExport,
	showreclaimgrid = @ShowReclaimGrid,
	showreclaimgridexport = @ShowReclaimGridExport,
	showexpiregrid = @ShowExpireGrid,
	showexpiregridexport = @ShowExpireGridExport,
	showrecentgrid = @ShowRecentGrid,
	showrecentgridexport = @ShowRecentGridExport,
	requestvmshownfields = @RequestVMShownFields,
	defaultinitialpage = @DefaultInitialPage,
	lastmodified = (getDate()),
	showvmgridextracolumns = @ShowVMGridExtraColumns,
	showreclaimcolumns = @ShowReclaimColumns
	WHERE id = @ID;
	select @@rowcount;
END
GO
GRANT EXEC ON [dbo].[usp_UpdateUICustomization] TO Vrm_Manager
GO
-----------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_GetUICustomizationByID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_GetUICustomizationByID]
GO
CREATE PROCEDURE [dbo].[usp_GetUICustomizationByID] 
	@ID uniqueidentifier
AS
BEGIN
	SELECT * FROM UICustomization WHERE id = @ID;
END
GO
GRANT EXEC ON [dbo].[usp_GetUICustomizationByID] TO Vrm_Manager
GO

-----------------------------------------------------------------------------------------------------------------
--Insert Host Reservation Policy SP

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertHostReservationPolicy]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertHostReservationPolicy]
GO
CREATE PROCEDURE [dbo].[usp_InsertHostReservationPolicy] 
	@Id uniqueidentifier,
	@Name ntext,
	@Description ntext
AS
BEGIN
	INSERT INTO HostReservationPolicy	( id, lastmodified, name, description)
	VALUES								(@Id, getdate(),  @Name,  @Description);
	SELECT @@rowcount;
END
GO
GRANT EXEC ON [dbo].[usp_InsertHostReservationPolicy] TO Vrm_Manager
GO

-----------------------------------------------------------------------------------------------------------------
--Update Host Reservation Policy SP
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_UpdateHostReservationPolicyById]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_UpdateHostReservationPolicyById]
GO
CREATE PROCEDURE [dbo].[usp_UpdateHostReservationPolicyById] 
	@Id uniqueidentifier,
	@Name ntext,
	@description ntext
AS
BEGIN UPDATE HostReservationPolicy SET
	id = @Id,
	lastmodified = getdate(),
	name = @Name,
	description = @description
WHERE id = @Id;
SELECT @@rowcount;
END
GO
GRANT EXEC ON [dbo].[usp_UpdateHostReservationPolicyById] TO Vrm_Manager
GO

-----------------------------------------------------------------------------------------------------------------
--Delete Host Reservation Policy SP

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteHostReservationPolicyById]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteHostReservationPolicyById]
GO
CREATE PROCEDURE [dbo].[usp_DeleteHostReservationPolicyById]
	@Id uniqueidentifier
AS
BEGIN
	DELETE FROM HostReservationPolicy
	WHERE id = @Id;
	SELECT @@rowcount;
END
GO
GRANT EXEC ON [dbo].[usp_DeleteHostReservationPolicyById] TO Vrm_Manager
GO


-----------------------------------------------------------------------------------------------------------------
--Select Host Reservation Policy By Id SP

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_GetHostReservationPolicyById]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_GetHostReservationPolicyById]
GO
CREATE PROCEDURE [dbo].[usp_GetHostReservationPolicyById]
	@Id uniqueidentifier
AS
BEGIN
	SELECT * FROM HostReservationPolicy WHERE id = @Id;
END
GO
GRANT EXEC ON [dbo].[usp_GetHostReservationPolicyById] TO Vrm_Manager
GO

-----------------------------------------------------------------------------------------------------------------
--Select Host Reservation Policy SP

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_GetHostReservationPolicy]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_GetHostReservationPolicy]
GO
CREATE PROCEDURE [dbo].[usp_GetHostReservationPolicy]
	@Id uniqueidentifier = NULL
AS
BEGIN
	SELECT * FROM HostReservationPolicy
	WHERE (id = @Id OR @Id IS NULL);
END
GO
GRANT EXEC ON [dbo].[usp_GetHostReservationPolicy] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteStorageArray]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteStorageArray]
GO
CREATE PROCEDURE [dbo].[usp_DeleteStorageArray]
	@StorageArrayID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [StorageArray] WHERE StorageArrayID = @StorageArrayID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteStorageArray] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateStorageArray]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateStorageArray]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateStorageArray] 
	@StorageArrayID uniqueidentifier,
	@CredentialID uniqueidentifier,
	@StorageArrayName nvarchar(128),
	@StorageArrayDesc nvarchar(1024)=NULL,
	@IsFileCloneSoftwareInstalled bit,
	@StorageArrayManagementEndpoint nvarchar(128)
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;

	UPDATE [StorageArray]
	SET 
		StorageArrayName = @StorageArrayName
		,StorageArrayDesc = @StorageArrayDesc
		,IsFileCloneSoftwareInstalled = @IsFileCloneSoftwareInstalled
		,StorageArrayManagementEndpoint = @StorageArrayManagementEndpoint
		,CredentialID = @CredentialID
	WHERE 
		StorageArrayID = @StorageArrayID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [StorageArray]
		(StorageArrayID
		,StorageArrayName
		,StorageArrayDesc
		,IsFileCloneSoftwareInstalled
		,CredentialID
		,StorageArrayManagementEndpoint)
	 VALUES
		(@StorageArrayID
		,@StorageArrayName
		,@StorageArrayDesc
		,@IsFileCloneSoftwareInstalled
		,@CredentialID
		,@StorageArrayManagementEndpoint)	
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateStorageArray] TO Vrm_Manager
GO
-----------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectStorageArray]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectStorageArray]
GO
CREATE PROCEDURE [dbo].[usp_SelectStorageArray] 
	@StorageArrayID uniqueidentifier = NULL 
AS
BEGIN
	SELECT StorageArrayID
		,StorageArrayName
		,StorageArrayDesc
		,IsFileCloneSoftwareInstalled
		,StorageArrayManagementEndpoint
		,CredentialID
	FROM StorageArray
	WHERE 
		@StorageArrayID IS NULL OR StorageArrayID = @StorageArrayID
END
GO
GRANT EXEC ON [dbo].[usp_SelectStorageArray] TO Vrm_Manager
GO
-----------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_GetExternalWorkflows]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_GetExternalWorkflows]
GO
CREATE PROCEDURE [dbo].[usp_GetExternalWorkflows]
	@PrimaryWorkflowId uniqueidentifier = NULL,
	@ExternalWorkflowId uniqueidentifier = NULL
AS
BEGIN

SELECT PrimaryWorkflowId, ExternalWorkflowId
FROM
	ExternalWorkflowMap
WHERE (PrimaryWorkflowId = @PrimaryWorkflowId OR @PrimaryWorkflowId IS NULL)
AND (ExternalWorkflowId = @ExternalWorkflowId OR @ExternalWorkflowId IS NULL)
ORDER BY PrimaryWorkflowId ASC, ExternalWorkflowId ASC
END
GO
GRANT EXEC ON [dbo].[usp_GetExternalWorkflows] TO Vrm_Manager
GO
-----------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_AddExternalWorkflow]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_AddExternalWorkflow]
GO
CREATE PROCEDURE [dbo].[usp_AddExternalWorkflow]
	@PrimaryWorkflowId uniqueidentifier,
	@ExternalWorkflowId uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	INSERT INTO [ExternalWorkflowMap] (PrimaryWorkflowId, ExternalWorkflowId)
	VALUES (@PrimaryWorkflowId, @ExternalWorkflowId);
END
GO
GRANT EXEC ON [dbo].[usp_AddExternalWorkflow] TO Vrm_Manager
GO
-----------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteExternalWorkflow]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteExternalWorkflow]
GO
CREATE PROCEDURE [dbo].[usp_DeleteExternalWorkflow]
	@PrimaryWorkflowID uniqueidentifier = NULL,
	@ExternalWorkflowID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [ExternalWorkflowMap]
	WHERE (PrimaryWorkflowId = @PrimaryWorkflowID OR @PrimaryWorkflowID IS NULL)
	AND (ExternalWorkflowId = @ExternalWorkflowID OR @ExternalWorkflowID IS NULL);
END
GO
GRANT EXEC ON [dbo].[usp_DeleteExternalWorkflow] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectEmailProfile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectEmailProfile]
GO
CREATE PROCEDURE [dbo].[usp_SelectEmailProfile]
	@EmailProfileID uniqueidentifier = NULL,
	@SearchString nvarchar(256) = NULL,
	@EmailProfileName nvarchar(256) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT 
		EmailProfileId
		,EmailProfileName
		,EmailProfileDescription
		,EmailServerAddress
		,EmailServerPort
		,SubjectProductName
		,DefaultFromAddress
		,EnableSSL
		,UseServiceCredentials
		,CredentialID
	FROM [EmailProfile]
	WHERE (EmailProfileId = @EmailProfileID OR @EmailProfileID IS NULL) AND
		(EmailProfileName LIKE @SearchString OR @SearchString IS NULL) AND
		(EmailProfileName = @EmailProfileName OR @EmailProfileName IS NULL)
	ORDER BY EmailProfileName
END
GO
GRANT EXEC ON [dbo].[usp_SelectEmailProfile] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteEmailProfile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteEmailProfile]
GO
CREATE PROCEDURE [dbo].[usp_DeleteEmailProfile]
	@EmailProfileID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [EmailProfile] WHERE EmailProfileId = @EmailProfileID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteEmailProfile] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertUpdateEmailProfile]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertUpdateEmailProfile]
GO
CREATE PROCEDURE [dbo].[usp_InsertUpdateEmailProfile] 
	@EmailProfileID uniqueidentifier,
	@EmailProfileName nvarchar(128),
	@EmailProfileDescription nvarchar(1024) = null,
	@EmailServerAddress nvarchar(128),
	@EmailServerPort int,
	@SubjectProductName nvarchar(128),
	@DefaultFromAddress nvarchar(128),
	@EnableSSL bit,
	@UseServiceCredentials bit,
	@CredentialID uniqueidentifier
AS
BEGIN
	SET NOCOUNT OFF;
	UPDATE [EmailProfile]
	SET 
		EmailProfileName = @EmailProfileName
		,EmailProfileDescription = @EmailProfileDescription
		,EmailServerAddress = @EmailServerAddress
		,EmailServerPort = @EmailServerPort
		,SubjectProductName = @SubjectProductName
		,DefaultFromAddress = @DefaultFromAddress
		,EnableSSL = @EnableSSL
		,UseServiceCredentials = @UseServiceCredentials
		,CredentialID = @CredentialID
	WHERE 
		EmailProfileId = @EmailProfileID
		
	IF @@ROWCOUNT = 0 
		INSERT INTO [EmailProfile]
		(EmailProfileId
		,EmailProfileName
		,EmailProfileDescription
		,EmailServerAddress
		,EmailServerPort
		,SubjectProductName
		,DefaultFromAddress
		,EnableSSL
		,UseServiceCredentials
		,CredentialID)
	 VALUES
		(@EmailProfileID
		,@EmailProfileName
		,@EmailProfileDescription
		,@EmailServerAddress
		,@EmailServerPort
		,@SubjectProductName
		,@DefaultFromAddress
		,@EnableSSL
		,@UseServiceCredentials
		,@CredentialID)	
END
GO
GRANT EXEC ON [dbo].[usp_InsertUpdateEmailProfile] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_UpdateNetAppEstimatedStorage]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_UpdateNetAppEstimatedStorage]
GO
CREATE PROCEDURE [dbo].[usp_UpdateNetAppEstimatedStorage] 
AS
BEGIN
	SET NOCOUNT OFF;
	
	CREATE TABLE #EstimatedSizeFactor (StorageID [uniqueidentifier], VolumeSavingsFactor float)
	CREATE TABLE #VmsOnNetApp (VirtualMachineID [uniqueidentifier] , StorageID [uniqueidentifier])

	INSERT INTO #EstimatedSizeFactor
	SELECT hts.StorageID, (s.StorageTotalCapacityGB - s.StorageFreeCapacityGB) / NULLIF( SUM( CASE WHEN vm.VMUsedStorageGB - vm.VMInitialUsedSpace < -0.01 OR vm.VMUsedStorageGB = 0 OR vm.VMInitialUsedSpace = 0 THEN 0 ELSE ABS(vm.VMUsedStorageGB - vm.VMInitialUsedSpace) END ) ,0)
	FROM VirtualMachine vm
	JOIN
		VMDiskHardware vmdh ON vm.VirtualMachineID = vmdh.VirtualMachineID
	JOIN
		HostToStorage hts ON vmdh.HostToStorageID = hts.HostToStorageID
	JOIN 
		Storage s on hts.StorageID = s.StorageID
	WHERE s.ManagementEndpointID IS NOT NULL 
	GROUP BY
		hts.StorageID , s.StorageTotalCapacityGB, s.StorageFreeCapacityGB

	INSERT INTO #VmsOnNetApp
	SELECT vm.VirtualMachineID , s.StorageID
	FROM VirtualMachine vm
	INNER JOIN
		VMDiskHardware vmdh on vmdh.VirtualMachineID = vm.VirtualMachineID
	INNER JOIN 
		HostToStorage hts on hts.HostToStorageID = vmdh.HostToStorageID
	INNER JOIN
		Storage s on hts.StorageID = s.StorageID
	WHERE 
		s.ManagementEndpointID IS NOT NULL 
	AND vm.IsTemplate = 0

	UPDATE VirtualMachine
	SET VMEstimatedUsedSpace = 
	CASE
		--Not On NetApp Storage
		WHEN VirtualMachineID NOT IN (SELECT VirtualMachineID FROM #VmsOnNetApp)
			THEN VMTotalStorageGB
		--On NetApp Storage
		WHEN VirtualMachineID IN (SELECT VirtualMachineID FROM #VmsOnNetApp)
			THEN 
			CASE
				--WMI Is Acting Up
				WHEN VMInitialUsedSpace = 0 OR VMUsedStorageGB = 0 OR VMUsedStorageGB - VMInitialUsedSpace < -0.01
					THEN VMTotalStorageGB
				--Everything is OK
				ELSE
					(ABS(VMUsedStorageGB - VMInitialUsedSpace) * (
																	SELECT DISTINCT esf.VolumeSavingsFactor
																	FROM #VmsOnNetApp vona
																	JOIN
																		#EstimatedSizeFactor esf on esf.StorageID = vona.StorageID
																	WHERE
																		vona.VirtualMachineID = VirtualMachineID
																  ))
			END
	END

	UPDATE VirtualMachine
	SET VMEstimatedUsedSpace = VMTotalStorageGB
	WHERE VMEstimatedUsedSpace > VMTotalStorageGB
	
	DROP TABLE #EstimatedSizeFactor
	DROP TABLE #VmsOnNetApp

END
GO
GRANT EXEC ON [dbo].[usp_UpdateNetAppEstimatedStorage] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressGetNetworkProfileByName]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressGetNetworkProfileByName]
GO

CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressGetNetworkProfileByName]
	@ProfileName nvarchar(255)
AS
BEGIN
SELECT * FROM [StaticIPv4NetworkProfile]
WHERE StaticIPv4NetworkProfileName = @ProfileName
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressGetNetworkProfileByName] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_StaticIPv4AddressGetNetworkProfileByHostReservationHostNicID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_StaticIPv4AddressGetNetworkProfileByHostReservationHostNicID]
GO

-- CREATE 
CREATE PROCEDURE [dbo].[usp_StaticIPv4AddressGetNetworkProfileByHostReservationHostNicID]
	@HostReservationID uniqueidentifier,
	@HostNicID uniqueidentifier
AS
BEGIN
SELECT * FROM [StaticIPv4NetworkProfile] statIPv4NetworkProf
INNER JOIN [HostNicToReservation] hostNicToRes ON hostNicToRes.StaticIPv4NetworkProfileID = statIPv4NetworkProf.ID
WHERE hostNicToRes.HostNicID = @HostNicID AND hostNicToRes.HostReservationID = @HostReservationID;
END
GO
GRANT EXEC ON [dbo].[usp_StaticIPv4AddressGetNetworkProfileByHostReservationHostNicID] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteChangeStateRequest]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_DeleteChangeStateRequest]
GO
CREATE PROCEDURE [dbo].[usp_DeleteChangeStateRequest] 
	@WorkflowID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [ChangeStateRequests] WHERE WorkflowID = @WorkflowID
END
GO
GRANT EXEC ON [dbo].[usp_DeleteChangeStateRequest] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectChangeStateRequests]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectChangeStateRequests]
GO
CREATE PROCEDURE [dbo].[usp_SelectChangeStateRequests]
	@WorkflowID uniqueidentifier = NULL,
	@SearchString nvarchar(255) = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT WorkflowID, NextState, IsEvent
	FROM ChangeStateRequests
	WHERE (@WorkflowID IS NULL OR WorkflowID = @WorkflowID)
END
GO
GRANT EXEC ON [dbo].[usp_SelectChangeStateRequests] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectPhysicalMachineProperties]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectPhysicalMachineProperties]
GO
CREATE PROCEDURE [dbo].[usp_SelectPhysicalMachineProperties]
	@PhysicalMachinePropertyID uniqueidentifier = NULL,
	@PhysicalMachineID uniqueidentifier = NULL,
	@Name nvarchar(128) = NULL,
	@VirtualMachineID uniqueidentifier = NULL
AS
BEGIN
	SELECT P.PhysicalMachinePropertyID, P.PhysicalMachineID, P.Name, P.Value
	FROM "PhysicalMachineProperties" P
	LEFT JOIN "VirtualMachine" V on V.PhysicalMachineID = P.PhysicalMachineID
	WHERE (@PhysicalMachinePropertyID IS NULL OR P.PhysicalMachinePropertyID = @PhysicalMachinePropertyID)
	AND (@PhysicalMachineID IS NULL OR P.PhysicalMachineID = @PhysicalMachineID)
	AND (@Name IS NULL OR P.Name = @Name)
	AND (@VirtualMachineID IS NULL OR V.VirtualMachineID = @VirtualMachineID)
END
GO
GRANT EXEC ON [dbo].[usp_SelectPhysicalMachineProperties] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_GetPhysicalMachineIDFromVirtualMachine]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_GetPhysicalMachineIDFromVirtualMachine]
GO
CREATE PROCEDURE [dbo].[usp_GetPhysicalMachineIDFromVirtualMachine]
	@VirtualMachineID uniqueidentifier = NULL
AS
BEGIN
	SELECT V.PhysicalMachineID
	FROM VirtualMachine V
	WHERE V.VirtualMachineID = @VirtualMachineID
END
GO
GRANT EXEC ON [dbo].[usp_GetPhysicalMachineIDFromVirtualMachine] TO Vrm_Manager
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_GetEndpointInterfaceFromVirtualMachineID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_GetEndpointInterfaceFromVirtualMachineID]
GO
CREATE PROCEDURE [dbo].[usp_GetEndpointInterfaceFromVirtualMachineID]
	@VirtualMachineID uniqueidentifier = NULL
AS
BEGIN
DECLARE @ManagementEndpointID uniqueidentifier = NULL
IF [dbo].[IsPhysicalMachine](@VirtualMachineID) = 1
	BEGIN
		SELECT @ManagementEndpointID = E.ManagementEndpointID 
		FROM ManagementEndpoints E
		LEFT JOIN PhysicalControllers P ON E.ManagementEndpointID = P.ManagementEndpoint_ManagementEndpointID
		LEFT JOIN PhysicalMachines M ON P.PhysicalControllerID = M.PhysicalController_PhysicalControllerID
		LEFT JOIN VirtualMachine V ON  M.PhysicalMachineID = V.PhysicalMachineID
		WHERE V.VirtualMachineID = @VirtualMachineID
	END
ELSE
	BEGIN
	 SELECT @ManagementEndpointID = E.ManagementEndpointID 
		FROM ManagementEndpoints E
		LEFT JOIN Host H ON E.ManagementEndpointID = H.ManagementEndpointID
		LEFT JOIN VirtualMachine V ON  H.HostID = V.HostID
		WHERE V.VirtualMachineID = @VirtualMachineID
	END
SELECT E.InterfaceType FROM ManagementEndpoints E
WHERE E.ManagementEndpointID = @ManagementEndpointID
END
GRANT EXEC ON [dbo].[usp_GetEndpointInterfaceFromVirtualMachineID] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_DeleteVirtualMachineDiskAssociation]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[usp_DeleteVirtualMachineDiskAssociation]

GO
CREATE PROCEDURE [dbo].[usp_DeleteVirtualMachineDiskAssociation]
	@VirtualMachineID uniqueidentifier,
	@VMToStorageID uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM VMDiskHardware WHERE VirtualMachineID = @VirtualMachineID AND VMToStorageID = @VMToStorageID
END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectAppServiceTemplate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectAppServiceTemplate]
GO
CREATE PROCEDURE [dbo].[usp_SelectAppServiceTemplate]
	@VirtualMachineTemplateId uniqueidentifier = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT *
	FROM AppServiceTemplates
	WHERE (VirtualMachineTemplateId = @VirtualMachineTemplateId)
	ORDER BY Id
END
GO
GRANT EXEC ON [dbo].[usp_SelectAppServiceTemplate] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectAppServiceComponentTemplate]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectAppServiceComponentTemplate]
GO
CREATE PROCEDURE [dbo].[usp_SelectAppServiceComponentTemplate]
	@AppServiceTemplateId int = 0,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT *
	FROM AppServiceComponentTemplates
	WHERE (AppServiceTemplateId = @AppServiceTemplateId)
	ORDER BY Id
END
GO
GRANT EXEC ON [dbo].[usp_SelectAppServiceComponentTemplate] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectAppServiceComponentTemplateByComponentMachineId]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectAppServiceComponentTemplateByComponentMachineId]
GO
CREATE PROCEDURE [dbo].[usp_SelectAppServiceComponentTemplateByComponentMachineId]
	@VirtualMachineId uniqueidentifier = NULL,
	@ResultCount int = 0
AS
BEGIN
	IF (@ResultCount > 0)
	BEGIN
		SET ROWCOUNT @ResultCount
	END

	SELECT *
	FROM AppServiceComponentTemplates
	WHERE 
	Id = (SELECT [AppServiceComponentTemplateId] FROM [AppServiceComponents] where VirtualMachineId = @VirtualMachineId)
	ORDER BY Id
END
GO
GRANT EXEC ON [dbo].[usp_SelectAppServiceComponentTemplateByComponentMachineId] TO Vrm_Manager
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_InsertAppServiceComponent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_InsertAppServiceComponent]
GO
CREATE PROCEDURE [dbo].[usp_InsertAppServiceComponent] 
	@VirtualMachineId uniqueidentifier
	,@AppServiceComponentTemplateId int
	,@AppServiceId uniqueidentifier
AS
BEGIN
	SET NOCOUNT OFF;
	--BEGIN TRANSACTION;
  INSERT INTO [AppServiceComponents]
  (VirtualMachineId
  ,AppServiceComponentTemplateId
  ,AppServiceId)
 VALUES
  (@VirtualMachineId
  ,@AppServiceComponentTemplateId
  ,@AppServiceId)
	--COMMIT TRANSACTION;
END
GO
GRANT EXEC ON [dbo].[usp_InsertAppServiceComponent] TO Vrm_Manager
GO



----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_SelectAppServiceComponentVMTemplatesByAppServiceID]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_SelectAppServiceComponentVMTemplatesByAppServiceID]
GO
CREATE PROCEDURE [dbo].[usp_SelectAppServiceComponentVMTemplatesByAppServiceID] 
	@AppServiceId uniqueidentifier
AS
BEGIN
  SELECT vmt.* FROM 
  ((AppServiceComponents c LEFT JOIN AppServiceComponentTemplates ct on c.AppServiceComponentTemplateId = ct.AppServiceTemplateId)
                        LEFT JOIN VirtualMachineTemplate vmt on vmt.VirtualMachineTemplateID = ct.VirtualMachineTemplateId)
  where c.AppServiceId = @AppServiceId
END
GO
GRANT EXEC ON [dbo].[usp_SelectAppServiceComponentVMTemplatesByAppServiceID] TO Vrm_Manager
GO

