CREATE SCHEMA [DynamicOps.VMWare] AUTHORIZATION [dbo]
GO

CREATE TABLE [DynamicOps.VMWare].[ReconfigureRequestNetworks](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[RequestId] [int] NOT NULL,
	[Operation] [int] NOT NULL,
	[RequestedNetworkName] [nvarchar](512) NOT NULL,
	[OriginalNetworkName] [nvarchar](512) NOT NULL,
	[OriginalNetworkUniqueId] [nvarchar](512) NOT NULL,
	[StaticIPv4Address] [nvarchar](40) NULL,
	[MACAddress] [nvarchar](50) NULL,
 CONSTRAINT [PK_ReconfigureRequestNetworks] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

CREATE TABLE [DynamicOps.VMWare].[ReconfigureRequests](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[StateOperationUniqueId] [uniqueidentifier] NULL,
    [EntityId] [uniqueidentifier] NULL,
	[InitialCPU] [int] NOT NULL,
	[RequestedCPU] [int] NOT NULL,
	[InitialMemoryMB] [int] NOT NULL,
	[RequestedMemoryMB] [int] NOT NULL,
 CONSTRAINT [PK_ReconfigureRequests] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

CREATE TABLE [DynamicOps.VMWare].[ReconfigureRequestStorages](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[RequestId] [int] NOT NULL,
	[Operation] [int] NOT NULL,
	[DeviceID] [nvarchar](256) NULL,
    [ExternalDiskId] [nvarchar](256) NULL,
	[DiskName] [nvarchar](256) NULL,
	[DriveLetter] [nvarchar](256) NULL,
	[Label] [nvarchar](256) NULL,
	[RequestedDiskSize] [int] NOT NULL,
	[OriginalDiskSize] [int] NOT NULL,
	[StorageName] [nvarchar](256) NULL,
	[StorageAllocationPolicyName] [nvarchar](128) NULL,
 CONSTRAINT [PK_RequestStorages] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [DynamicOps.VMWare].[ReconfigureRequestNetworks]  WITH CHECK ADD  CONSTRAINT [FK_ReconfigureRequestNetworks_ReconfigureRequests_RequestId] FOREIGN KEY([RequestId])
REFERENCES  [DynamicOps.VMWare].[ReconfigureRequests] ([Id])
ON DELETE CASCADE
GO

ALTER TABLE [DynamicOps.VMWare].[ReconfigureRequestNetworks] CHECK CONSTRAINT [FK_ReconfigureRequestNetworks_ReconfigureRequests_RequestId]
GO

ALTER TABLE [DynamicOps.VMWare].[ReconfigureRequestStorages]  WITH CHECK ADD  CONSTRAINT [FK_ReconfigureRequestStorages_ReconfigureRequests_RequestId] FOREIGN KEY([RequestId])
REFERENCES [DynamicOps.VMWare].[ReconfigureRequests] ([Id])
ON DELETE CASCADE
GO

ALTER TABLE [DynamicOps.VMWare].[ReconfigureRequestStorages] CHECK CONSTRAINT [FK_ReconfigureRequestStorages_ReconfigureRequests_RequestId]
GO

CREATE TABLE [DynamicOps.VMWare].[ReconfigureRequestStorageProperties](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[StorageId] [int] NOT NULL,
	[PropertyName] [nvarchar](128) NOT NULL,
	[PropertyValue] [nvarchar](max) NULL,
	[IsHidden] bit NOT NULL DEFAULT 0,
	[IsRuntime] bit NOT NULL DEFAULT 0,
	[IsEncrypted] bit NOT NULL DEFAULT 0
 CONSTRAINT [PK_ReconfigureRequestStorageProperties] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [DynamicOps.VMWare].[ReconfigureRequestStorageProperties]  WITH CHECK ADD  CONSTRAINT [FK_ReconfigureRequestStorageProperties_ReconfigureRequestStorages_StorageId] FOREIGN KEY([StorageId])
REFERENCES [DynamicOps.VMWare].[ReconfigureRequestStorages] ([Id])
ON DELETE CASCADE
GO

ALTER TABLE [DynamicOps.VMWare].[ReconfigureRequestStorageProperties] CHECK CONSTRAINT [FK_ReconfigureRequestStorageProperties_ReconfigureRequestStorages_StorageId]
GO

CREATE TABLE [DynamicOps.VMWare].[ReconfigureRequestNetworkProperties](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[NetworkId] [int] NOT NULL,
	[PropertyName] [nvarchar](128) NOT NULL,
	[PropertyValue] [nvarchar](max) NULL,
	[IsHidden] bit NOT NULL DEFAULT 0,
	[IsRuntime] bit NOT NULL DEFAULT 0,
	[IsEncrypted] bit NOT NULL DEFAULT 0
 CONSTRAINT [PK_ReconfigureRequestNetworkProperties] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [DynamicOps.VMWare].[ReconfigureRequestNetworkProperties]  WITH CHECK ADD  CONSTRAINT [FK_ReconfigureRequestNetworkProperties_ReconfigureRequestNetworks_NetworkId] FOREIGN KEY([NetworkId])
REFERENCES [DynamicOps.VMWare].[ReconfigureRequestNetworks] ([Id])
ON DELETE CASCADE
GO

ALTER TABLE [DynamicOps.VMWare].[ReconfigureRequestNetworkProperties] CHECK CONSTRAINT [FK_ReconfigureRequestNetworkProperties_ReconfigureRequestNetworks_NetworkId]
GO
