:On Error Exit

SET NOCOUNT ON
-- Restricts volume of output to errors and
-- messages that use the PRINT function

PRINT 'Creating Announcements'
EXEC usp_UpdateAnnouncement N'Welcome',N'',N'<p>Welcome to %APP_NAME%.<br />&nbsp;<br />You are logged on as <span style="font-weight:bold; font-size:12px;">%USER_NAME%</span>. If this is not you, please contact your administrator.</p>';
EXEC usp_UpdateAnnouncement N'SupportInfo',N'',N'<div>If you have not already been setup with access, contact the following teams for new requests: </div>
<ul>
    <li>Virtual Servers - Contact your IT Relationship Manager</li>
    <li>Virtual Workstations - Contact Project Management</li>
</ul>';
EXEC usp_UpdateAnnouncement N'NoAccessAvailable',N'',N'We are unable to determine your access to this system.  You need to obtain access to this system before using it.';

PRINT 'Creating Integrated Credential'
INSERT INTO [Credential] VALUES ('75B941F4-A3CC-49B2-BF5A-95F288D52795', N'', NULL, NULL, NULL, N'Integrated', N'Built-in credential for integrated authentication.')

PRINT 'Creating Hypervisor Types'
INSERT INTO [HypervisorType] VALUES (0, N'VirtualCenter', N'Hypervisor management type is VirtualCenter')
INSERT INTO [HypervisorType] VALUES (1, N'ESX', N'Hypervisor management type is ESX server')
INSERT INTO [HypervisorType] VALUES (2, N'Xen', N'Hypervisor management type is XEN Server')
INSERT INTO [HypervisorType] VALUES (3, N'HyperV', N'Hypervisor management type is Hyper-V server')

PRINT 'Creating Storage Types'
INSERT INTO [HostStorageType] VALUES (0, N'LocalDisk', N'Local Disk')
INSERT INTO [HostStorageType] VALUES (1, N'SAN', N'SAN storage')
INSERT INTO [HostStorageType] VALUES (2, N'NFS', N'NFS storage')
INSERT INTO [HostStorageType] VALUES (3, N'UNKNOWN', N'Not Known')

PRINT 'Creating HostState Types'
INSERT INTO [HostState] VALUES (0, N'Active', N'Active')
INSERT INTO [HostState] VALUES (1, N'Maintenance', N'Maintenance')
INSERT INTO [HostState] VALUES (2, N'DrainStop', N'DrainStop')

PRINT 'Provisioning Group Types'
INSERT INTO [GroupType] VALUES (0, N'Provisioning Group', N'Provisioning Group')
INSERT INTO [GroupType] VALUES (1, N'Approval Group', N'Approval Group')

PRINT 'Creating Request Types'
INSERT INTO [RequestType] VALUES (0, N'Create VM', N'Create Machine request')
INSERT INTO [RequestType] VALUES (1, N'Extend Lease', N'Machine Lease Extention Request')
INSERT INTO [RequestType] VALUES (2, N'Reclamation', N'Machine Reclmation Request')
INSERT INTO [RequestType] VALUES (3, N'PowerOn', N'Machine Power On Request')
INSERT INTO [RequestType] VALUES (4, N'PowerOff', N'Machine Power Off Request')
INSERT INTO [RequestType] VALUES (5, N'RequestVM', N'Submit Machine Request')
INSERT INTO [RequestType] VALUES (6, N'ReconfigureAmazonVM', N'Reconfigure Amazon Machine')

PRINT 'Creating Request Audit Types'
INSERT INTO [RequestAuditType] VALUES (0, N'Created', N'Request created')
INSERT INTO [RequestAuditType] VALUES (1, N'Resubmitted', N'Request resubmitted')
INSERT INTO [RequestAuditType] VALUES (2, N'Assigned', N'Request assigned')
INSERT INTO [RequestAuditType] VALUES (3, N'UserNotified', N'User notified')
INSERT INTO [RequestAuditType] VALUES (4, N'Approved', N'Request approved')
INSERT INTO [RequestAuditType] VALUES (5, N'Rejected', N'Request rejected')
INSERT INTO [RequestAuditType] VALUES (6, N'Expired', N'Request expired')
INSERT INTO [RequestAuditType] VALUES (7, N'Edited', N'Request edited')
INSERT INTO [RequestAuditType] VALUES (8, N'StateChanged', N'Request state changed')
INSERT INTO [RequestAuditType] VALUES (80, N'Completed', N'Request completed')
INSERT INTO [RequestAuditType] VALUES (90, N'Deleted', N'Request deleted')
INSERT INTO [RequestAuditType] VALUES (91, N'Closed', N'Request closed')

INSERT INTO [RequestAuditType] VALUES (100, N'Create', N'Request create event')
INSERT INTO [RequestAuditType] VALUES (101, N'Resubmit', N'Request resubmit event')
INSERT INTO [RequestAuditType] VALUES (102, N'Assign', N'Request assign event')
INSERT INTO [RequestAuditType] VALUES (103, N'UserNotify', N'User notify event')
INSERT INTO [RequestAuditType] VALUES (104, N'Approve', N'Request approve event')
INSERT INTO [RequestAuditType] VALUES (105, N'Reject', N'Request reject event')
INSERT INTO [RequestAuditType] VALUES (106, N'Expire', N'Request expire event')
INSERT INTO [RequestAuditType] VALUES (107, N'Edit', N'Request edit event')
INSERT INTO [RequestAuditType] VALUES (180, N'Complete', N'Request complete event')
INSERT INTO [RequestAuditType] VALUES (190, N'Delete', N'Request delete event')
INSERT INTO [RequestAuditType] VALUES (191, N'Close', N'Request close event')

PRINT 'Creating Default Schedules'
INSERT INTO CollectionSchedule (ScheduleID, ScheduleName, FrequencyInMinutes) VALUES ('E862D230-436A-4729-B302-984245F08877', N'Every Day', 1440)
INSERT INTO CollectionSchedule (ScheduleID, ScheduleName, FrequencyInMinutes) VALUES ('6525534D-8183-4da4-BAC1-F40BCCFE1F87', N'Every 12 Hours', 720)
INSERT INTO CollectionSchedule (ScheduleID, ScheduleName, FrequencyInMinutes) VALUES ('6C3CF3A8-F6C7-4f99-A144-BBA3E73E48B9', N'Every 1 Hour', 60)
INSERT INTO CollectionSchedule (ScheduleID, ScheduleName, FrequencyInMinutes) VALUES ('E2271275-448E-472d-9C13-353D818429A9', N'Every 15 Minutes', 15)

PRINT 'Creating agent capability types'
INSERT INTO AgentCapabilityType VALUES(N'vSphereHypervisor')
INSERT INTO AgentCapabilityType VALUES(N'HyperVHypervisor')
INSERT INTO AgentCapabilityType VALUES(N'XenHypervisor')
INSERT INTO AgentCapabilityType VALUES(N'WMI')
INSERT INTO AgentCapabilityType VALUES(N'Scvmm')
INSERT INTO AgentCapabilityType VALUES(N'AmazonEC2')
INSERT INTO AgentCapabilityType VALUES(N'vCloud')
INSERT INTO AgentCapabilityType VALUES(N'Kvm')

PRINT 'Creating Default Filter Groups for data collection'
-- Inventory 
INSERT INTO FilterSpecGroup (FilterSpecGroupID, FilterSpecGroupName, ScheduleID) VALUES ('A7784CC2-4A04-44e9-8D0F-1295D4AB5D5F', N'inventory', 'E862D230-436A-4729-B302-984245F08877')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('4B40AAD1-C007-4DC2-8141-3A11BFE0872A', 'A7784CC2-4A04-44e9-8D0F-1295D4AB5D5F', N'vSphere', N'vSphereHypervisor')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('17F1B6EC-34BD-4be6-8FD5-E88FF5DA17D2', 'A7784CC2-4A04-44e9-8D0F-1295D4AB5D5F', N'hyperv', N'HyperVHypervisor')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('7F2DB8E9-B1B5-462d-BFB9-4C4CE71B07B8', 'A7784CC2-4A04-44e9-8D0F-1295D4AB5D5F', N'xen', N'XenHypervisor')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('813D164C-696A-11E1-82B4-4B9C4824019B', 'A7784CC2-4A04-44e9-8D0F-1295D4AB5D5F', N'scvmm', N'Scvmm')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('87724DE8-696A-11E1-B69B-4C9C4824019B', 'A7784CC2-4A04-44e9-8D0F-1295D4AB5D5F', N'amazon', N'AmazonEC2')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('94E8573A-A9CA-481E-9A28-0B0009AAB610', 'A7784CC2-4A04-44e9-8D0F-1295D4AB5D5F', N'vCloud', N'vCloud')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('760bf6a3-1c7d-403a-85ee-dba399504d06', 'A7784CC2-4A04-44e9-8D0F-1295D4AB5D5F', N'kvm', N'Kvm')

-- Power State
INSERT INTO FilterSpecGroup (FilterSpecGroupID, FilterSpecGroupName, ScheduleID, DependsOnFilterSpecGroupID) VALUES ('B1DECB8C-D05D-4430-B4CB-72C8A985BD10', N'state', 'E2271275-448E-472d-9C13-353D818429A9', 'A7784CC2-4A04-44e9-8D0F-1295D4AB5D5F')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('AE4760C0-0AFD-49AB-A292-F4247DDC3BEE', 'B1DECB8C-D05D-4430-B4CB-72C8A985BD10', N'vSphere', N'vSphereHypervisor')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('BF689384-F3AE-4a2b-AD94-F369B664F526', 'B1DECB8C-D05D-4430-B4CB-72C8A985BD10', N'hyperv', N'HyperVHypervisor')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('149E74BE-80D9-40ca-B631-9EFA561A8DB3', 'B1DECB8C-D05D-4430-B4CB-72C8A985BD10', N'xen', N'XenHypervisor')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('C0D9ED98-696A-11E1-870A-E99C4824019B', 'B1DECB8C-D05D-4430-B4CB-72C8A985BD10', N'scvmm', N'Scvmm')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('C54AF9DA-696A-11E1-8D40-F29C4824019B', 'B1DECB8C-D05D-4430-B4CB-72C8A985BD10', N'amazon', N'AmazonEC2')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('66AD9C0E-91C5-48D0-8FEC-5D3D81C5D79A', 'B1DECB8C-D05D-4430-B4CB-72C8A985BD10', N'vCloud', N'vCloud')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('9240399a-f5f4-4ecd-8e15-21c04571ef15', 'B1DECB8C-D05D-4430-B4CB-72C8A985BD10', N'kvm', N'Kvm')

-- Performance
INSERT INTO FilterSpecGroup (FilterSpecGroupID, FilterSpecGroupName, ScheduleID, DependsOnFilterSpecGroupID) VALUES ('34219AA6-F896-45ca-AF06-F5CA4AF306BE', N'performance', 'E862D230-436A-4729-B302-984245F08877', 'A7784CC2-4A04-44e9-8D0F-1295D4AB5D5F')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('046630DD-5BA4-49D9-9768-9043838823FF', '34219AA6-F896-45ca-AF06-F5CA4AF306BE', N'vSphere', N'vSphereHypervisor')

-- WMI
INSERT INTO FilterSpecGroup (FilterSpecGroupID, FilterSpecGroupName, ScheduleID) VALUES ('449F8F38-7C8C-4e2c-B5F2-17E642CDAF29', N'wmi.logon', '6525534D-8183-4da4-BAC1-F40BCCFE1F87')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('B48AB9A9-EC92-4b90-A12B-474282745695', '449F8F38-7C8C-4e2c-B5F2-17E642CDAF29', N'wmi.logon', N'WMI')

-- vCNS
INSERT INTO FilterSpecGroup (FilterSpecGroupID, FilterSpecGroupName, ScheduleID, DependsOnFilterSpecGroupID) VALUES ('3989ee8f-a0f2-4cd3-8792-cd7eb26b4b27', 'VCNSInventory', 'E862D230-436A-4729-B302-984245F08877', 'A7784CC2-4A04-44e9-8D0F-1295D4AB5D5F')
INSERT INTO FilterSpec (FilterSpecID, FilterSpecGroupID, FilterSpecName, AgentCapabilityName) VALUES ('8a9ab7ce-9e50-444f-9184-db617008a6d2', '3989ee8f-a0f2-4cd3-8792-cd7eb26b4b27', 'vSphere', 'vSphereHypervisor')

PRINT 'Creating StorageAllocationPolicy Types'
INSERT INTO [StorageAllocationPolicy] VALUES (1, N'Sequential', N'StorageAllocationPolicy Sequential')
INSERT INTO [StorageAllocationPolicy] VALUES (0, N'RoundRobin', N'StorageAllocationPolicy RoundRobin')
INSERT INTO [StorageAllocationPolicy] VALUES (2, N'WeightedRoundRobin', N'StorageAllocationPolicy WeightedRoundRobin')
INSERT INTO [StorageAllocationPolicy] VALUES (3, N'SortedRoundRobin', N'StorageAllocationPolicy SortedRoundRobin')
INSERT INTO [StorageAllocationPolicy] VALUES (4, N'PrioritizedRoundRobin', N'StorageAllocationPolicy PrioritizedRoundRobin')

PRINT 'Entiry Types for storing performance'
INSERT INTO [EntityType] VALUES (0, N'VirtualMachine', N'VirtualMachine')
INSERT INTO [EntityType] VALUES (1, N'Host', N'Host')

PRINT 'Metric Types for storing performance'
INSERT INTO [MetricType](MetricTypeID, MetricTypeName, MetricTypeDesc) VALUES (0, N'cpu.usage.average', N'cpu.usage.average')
INSERT INTO [MetricType](MetricTypeID, MetricTypeName, MetricTypeDesc) VALUES (1, N'mem.usage.average', N'mem.usage.average')
INSERT INTO [MetricType](MetricTypeID, MetricTypeName, MetricTypeDesc) VALUES (2, N'net.usage.average', N'net.usage.average')
INSERT INTO [MetricType](MetricTypeID, MetricTypeName, MetricTypeDesc) VALUES (3, N'disk.usage.average', N'disk.usage.average')

PRINT 'Creating built-in Enterprise Admin VM filters'
INSERT INTO UserFilter (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('f8fe28cd-417b-40fd-abb2-e9a4a35be121', N'VMList_EnterpriseAdminMachines', N'Default view',            N',Checkbox,VirtualMachineName,VirtualMachineState,Description,ExpirationDate,DestructionDate,SourceVMTemplate,Owner,OwnerExist,Host,Group,Reservation,LastPowerOffDate,LastPowerOnDate,IsMissing,GuestOS,GuestOSFamily,AvgCpuUsagePct,TotalMemoryInGB,AvgMemUsagePct,TotalStorageInGB,UsedStorageGB,AvgDiskUsageKBPerSec,AvgNetUsageKBPerSec|sort1|a1|visible24|t0|t1|t2|f3|f3|f3|t3|t4|f-1|t5|t6|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1', NULL, '4/8/2009', '4/8/2009', 0);
INSERT INTO UserFilter (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('f9a8baad-d869-4f50-a94a-a60442d0ef9c', N'VMList_EnterpriseAdminMachines', N'Low CPU utilization',     N',Checkbox,VirtualMachineName,VirtualMachineState,Description,ExpirationDate,DestructionDate,SourceVMTemplate,Owner,OwnerExist,Host,Group,Reservation,LastPowerOffDate,LastPowerOnDate,IsMissing,GuestOS,GuestOSFamily,AvgCpuUsagePct,TotalMemoryInGB,AvgMemUsagePct,TotalStorageInGB,UsedStorageGB,AvgDiskUsageKBPerSec,AvgNetUsageKBPerSec|sort1|a1|visible24|t0|t1|t3|f3|f3|f3|t4|t5|f-1|f-1|t6|f-1|f-1|f-1|f-1|f-1|f-1|t2|f-1|f-1|f-1|f-1|f-1|f-1', N'[VMPerformance.CpuUsageAverage] <= 5.0m And [VMPerformance.CpuUsageAverage] Is Not Null', '4/8/2009', '4/8/2009', 0)
INSERT INTO UserFilter (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('2ff7ef8d-a762-49f8-a671-f0c3ca27e26a', N'VMList_EnterpriseAdminMachines', N'Low disk utilization',    N',Checkbox,VirtualMachineName,VirtualMachineState,Description,ExpirationDate,DestructionDate,SourceVMTemplate,Owner,OwnerExist,Host,Group,Reservation,LastPowerOffDate,LastPowerOnDate,IsMissing,GuestOS,GuestOSFamily,AvgCpuUsagePct,TotalMemoryInGB,AvgMemUsagePct,TotalStorageInGB,UsedStorageGB,AvgDiskUsageKBPerSec,AvgNetUsageKBPerSec|sort1|a1|visible24|t0|t1|t3|f3|f3|f3|t4|t5|f-1|f-1|t6|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|t2|f-1', N'[VMPerformance.DiskUsageAverage] <= 2.0m And [VMPerformance.DiskUsageAverage] Is Not Null', '4/8/2009', '4/8/2009', 0);
INSERT INTO UserFilter (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('e5f052be-41c1-411c-bd09-6b2174a5ee83', N'VMList_EnterpriseAdminMachines', N'Low memory utilization',  N',Checkbox,VirtualMachineName,VirtualMachineState,Description,ExpirationDate,DestructionDate,SourceVMTemplate,Owner,OwnerExist,Host,Group,Reservation,LastPowerOffDate,LastPowerOnDate,IsMissing,GuestOS,GuestOSFamily,AvgCpuUsagePct,TotalMemoryInGB,AvgMemUsagePct,TotalStorageInGB,UsedStorageGB,AvgDiskUsageKBPerSec,AvgNetUsageKBPerSec|sort1|a1|visible24|t0|t1|t3|f3|f3|f3|t4|t5|f-1|f-1|t6|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|t2|f-1|f-1|f-1|f-1', N'[VMPerformance.MemUsageAverage] <= 10.0m And [VMPerformance.MemUsageAverage] Is Not Null', '4/8/2009', '4/8/2009', 0);
INSERT INTO UserFilter (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('d7378132-291e-4196-bc9e-20f028109924', N'VMList_EnterpriseAdminMachines', N'Low network utilization', N',Checkbox,VirtualMachineName,VirtualMachineState,Description,ExpirationDate,DestructionDate,SourceVMTemplate,Owner,OwnerExist,Host,Group,Reservation,LastPowerOffDate,LastPowerOnDate,IsMissing,GuestOS,GuestOSFamily,AvgCpuUsagePct,TotalMemoryInGB,AvgMemUsagePct,TotalStorageInGB,UsedStorageGB,AvgDiskUsageKBPerSec,AvgNetUsageKBPerSec|sort1|a1|visible24|t0|t1|t3|f3|f3|f3|t4|t5|f-1|f-1|t6|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|t2', N'[VMPerformance.NetUsageAverage] <= 1.0m And [VMPerformance.NetUsageAverage] Is Not Null', '4/8/2009', '4/8/2009', 0);
INSERT INTO UserFilter (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('966be017-d0a3-4191-b65c-b6763d3b3ef5', N'VMList_EnterpriseAdminMachines', N'Off for 90+ days',        N',Checkbox,VirtualMachineName,VirtualMachineState,Description,ExpirationDate,DestructionDate,SourceVMTemplate,Owner,OwnerExist,Host,Group,Reservation,LastPowerOffDate,LastPowerOnDate,IsMissing,GuestOS,GuestOSFamily,AvgCpuUsagePct,TotalMemoryInGB,AvgMemUsagePct,TotalStorageInGB,UsedStorageGB,AvgDiskUsageKBPerSec,AvgNetUsageKBPerSec|sort1|a1|visible24|t0|t1|t3|f3|f3|f3|t4|t5|f-1|f-1|f-1|f-1|t7|f-1|f-1|t2|f-1| f-1|f-1|f-1|f-1|f-1|f-1|f-1', N'[LastPowerOnDate] <= #2009-01-08# And [LastPowerOffDate] Is Not Null', '4/8/2009', '4/8/2009', 1);
INSERT INTO UserFilter (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('0ec6b9f4-2e2c-46af-8583-b62814089411', N'VMList_EnterpriseAdminMachines', N'Owner inactive in AD',    N',Checkbox,VirtualMachineName,VirtualMachineState,Description,ExpirationDate,DestructionDate,SourceVMTemplate,Owner,OwnerExist,Host,Group,Reservation,LastPowerOffDate,LastPowerOnDate,IsMissing,GuestOS,GuestOSFamily,AvgCpuUsagePct,TotalMemoryInGB,AvgMemUsagePct,TotalStorageInGB,UsedStorageGB,AvgDiskUsageKBPerSec,AvgNetUsageKBPerSec|sort1|a1|visible24|t0|t1|t3|f3|f3|f3|t5|t2|f-1|f-1|t6|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|f-1|t4', N'[OwnerExists] = False', '4/8/2009', '4/8/2009', 0);

PRINT 'Creating built-in host filters'
INSERT INTO UserFilter (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('45877844-4a20-4321-a7f2-3b7af9dd9bfc', N'HostList', N'Default view',                       N',Host,AgentStatus,CollectData,Description,NumReservations,TotalAvailable,VMQuotaReserved,VMQuotaFree,VMQuotaUsed,VMQuotaPercentageGraph,MemoryInMB,ReservedMemoryMB,UnreservedMemoryMB,FreeMemoryMB,UsedMemoryMB,HostMemoryPercentageGraph,PercentMemoryAllocated,PercentMemoryFree,TotalStorageInGB,ReservedStorageGB,UnreservedStorageGB,FreeStorageGB,AllocatedStorageGB,HostStorageReservedGraph,PercentStorageAllocated,PercentStorageFree|sort1|a0|visible25|t0|t1|t2|f-1|t3|t4|f-1|f-1|f-1|t5|f-1|f-1|f-1|f-1|f-1|t6|f-1|f-1|f-1|f-1|f-1|f-1|f-1|t7|f-1|f-1', NULL, '4/8/2009', '4/8/2009', 0);
INSERT INTO UserFilter (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('6fa69c0b-640f-4910-96b5-ed8e71afa10d', N'HostList', N'Compute resources with overallocated resources', N',Host,AgentStatus,CollectData,Description,NumReservations,TotalAvailable,VMQuotaReserved,VMQuotaFree,VMQuotaUsed,VMQuotaPercentageGraph,MemoryInMB,ReservedMemoryMB,UnreservedMemoryMB,FreeMemoryMB,UsedMemoryMB,HostMemoryPercentageGraph,PercentMemoryAllocated,PercentMemoryFree,TotalStorageInGB,ReservedStorageGB,UnreservedStorageGB,FreeStorageGB,AllocatedStorageGB,HostStorageReservedGraph,PercentStorageAllocated,PercentStorageFree|sort1|d18|visible25|t0|f-1|f-1|f-1|f-1|f-1|f-1|f-1|t1|f-1|t4|f-1|f-1|f-1|t3|f-1|t2|f-1|t7|f-1|f-1|f-1|t6|f-1|t5|f-1', N'[PercentMemoryAllocated] > 100 Or [PercentStorageAllocated] > 100', '4/8/2009', '4/8/2009', 0);
INSERT INTO UserFilter (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('b2b8e6d3-afb8-42a9-9fc2-463877033b03', N'HostList', N'Compute resources with overreserved resources',  N',Host,AgentStatus,CollectData,Description,NumReservations,TotalAvailable,VMQuotaReserved,VMQuotaFree,VMQuotaUsed,VMQuotaPercentageGraph,MemoryInMB,ReservedMemoryMB,UnreservedMemoryMB,FreeMemoryMB,UsedMemoryMB,HostMemoryPercentageGraph,PercentMemoryAllocated,PercentMemoryFree,TotalStorageInGB,ReservedStorageGB,UnreservedStorageGB,FreeStorageGB,AllocatedStorageGB,HostStorageReservedGraph,PercentStorageAllocated,PercentStorageFree|sort1|d17|visible25|t0|f-1|f-1|f-1|f-1|f-1|t1|f-1|f-1|f-1|t4|t3|f-1|f-1|f-1|t2|f-1|f-1|t7|t6|f-1|f-1|f-1|t5|f-1|f-1', N'[HostMemoryPercentageGraph] > 100 Or [PercentStorageReserved] > 100', '4/8/2009', '4/8/2009', 0);
INSERT INTO UserFilter (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('453a7ecf-a475-4cdb-896f-08503383c4e9', N'HostList', N'Compute resources with underreserved resources', N',Host,AgentStatus,CollectData,Description,NumReservations,TotalAvailable,VMQuotaReserved,VMQuotaFree,VMQuotaUsed,VMQuotaPercentageGraph,MemoryInMB,ReservedMemoryMB,UnreservedMemoryMB,FreeMemoryMB,UsedMemoryMB,HostMemoryPercentageGraph,PercentMemoryAllocated,PercentMemoryFree,TotalStorageInGB,ReservedStorageGB,UnreservedStorageGB,FreeStorageGB,AllocatedStorageGB,HostStorageReservedGraph,PercentStorageAllocated,PercentStorageFree|sort1|a17|visible25|t0|f-1|f-1|f-1|f-1|f-1|t1|f-1|f-1|f-1|t4|t3|f-1|f-1|f-1|t2|f-1|f-1|t7|t6|f-1|f-1|f-1|t5|f-1|f-1', N'[HostMemoryPercentageGraph] < 50 And [PercentStorageReserved] < 50', '4/8/2009', '4/8/2009', 0);
INSERT INTO UserFilter (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('2fbf645c-4620-4417-9f30-bbbe8c764077', N'HostList', N'Memory-bound compute resources',        N',Host,AgentStatus,CollectData,Description,NumReservations,TotalAvailable,VMQuotaReserved,VMQuotaFree,VMQuotaUsed,VMQuotaPercentageGraph,MemoryInMB,ReservedMemoryMB,UnreservedMemoryMB,FreeMemoryMB,UsedMemoryMB,HostMemoryPercentageGraph,PercentMemoryAllocated,PercentMemoryFree,TotalStorageInGB,ReservedStorageGB,UnreservedStorageGB,FreeStorageGB,AllocatedStorageGB,HostStorageReservedGraph,PercentStorageAllocated,PercentStorageFree|sort1|d18|visible25|t0|f-1|f-1|f-1|f-1|f-1|t2|f-1|t1|f-1|t5|f-1|f-1|f-1|t4|f-1|t3|f-1|t7|f-1|f-1|f-1|t6|f-1|f-1|f-1', N'[PercentMemoryAllocated] >= 95 And ([PercentUsedVirtualMachineQuota] < 50 Or [PercentStorageAllocated] < 50)', '4/8/2009', '4/8/2009', 0);
INSERT INTO UserFilter (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('892755ee-8c8c-44ba-986b-e16a6c3c9939', N'HostList', N'Storage-bound compute resources',       N',Host,AgentStatus,CollectData,Description,NumReservations,TotalAvailable,VMQuotaReserved,VMQuotaFree,VMQuotaUsed,VMQuotaPercentageGraph,MemoryInMB,ReservedMemoryMB,UnreservedMemoryMB,FreeMemoryMB,UsedMemoryMB,HostMemoryPercentageGraph,PercentMemoryAllocated,PercentMemoryFree,TotalStorageInGB,ReservedStorageGB,UnreservedStorageGB,FreeStorageGB,AllocatedStorageGB,HostStorageReservedGraph,PercentStorageAllocated,PercentStorageFree|sort1|d18|visible25|t0|f-1|f-1|f-1|f-1|f-1|t2|f-1|t1|f-1|t4|f-1|f-1|f-1|t3|f-1|f-1|f-1|t7|f-1|f-1|f-1|t6|f-1|t5|f-1', N'[PercentStorageAllocated] >= 95 And ([PercentUsedVirtualMachineQuota] < 50 Or [PercentMemoryAllocated] < 50)', '4/8/2009', '4/8/2009', 0);
INSERT INTO UserFilter (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('580a2284-8521-4cd3-9c6d-9de1a871406a', N'HostList', N'Quota-bound compute resources',      N',Host,AgentStatus,CollectData,Description,NumReservations,TotalAvailable,VMQuotaReserved,VMQuotaFree,VMQuotaUsed,VMQuotaPercentageGraph,MemoryInMB,ReservedMemoryMB,UnreservedMemoryMB,FreeMemoryMB,UsedMemoryMB,HostMemoryPercentageGraph,PercentMemoryAllocated,PercentMemoryFree,TotalStorageInGB,ReservedStorageGB,UnreservedStorageGB,FreeStorageGB,AllocatedStorageGB,HostStorageReservedGraph,PercentStorageAllocated,PercentStorageFree|sort1|d18|visible25|t0|f-1|f-1|f-1|f-1|f-1|t2|f-1|t1|t3|t5|f-1|f-1|f-1|t4|f-1|f-1|f-1|t7|f-1|f-1|f-1|t6|f-1|f-1|f-1', N'[PercentUsedVirtualMachineQuota] >= 95 And ([PercentMemoryAllocated] < 50 Or [PercentStorageAllocated] < 50)', '4/8/2009', '4/8/2009', 0);

PRINT 'Creating built-in Reclamation Request filters'
INSERT INTO UserFilter (UserFilterID, DataSourceName, FilterName, ColumnLayout, FilterExpression, CreatedTime, ModifiedTime, AutoAdjustDateValues) VALUES ('e0bc2711-2c5b-4038-8eaf-b951d8db255c', N'VMReclamationList', N'Group Manager Notified',            N',VirtualMachine.VirtualMachineName,Status,RequestUser.UserName,VirtualMachine.VirtualMachineExt.UserName,RequestDate,RequestComments,RequestFilter,CostDaily,LastAction,LastActionState,LastActionUser,LastActionDate,SentToGroupManager|sort1|a0|visible13|t0|t1|t2|t3|t4|t5|f-1|t6|t7|t8|t9|t10|t11', '[SentToGroupManager] = True', '4/8/2009', '4/8/2009', 0);

PRINT 'Creating PropertySets'
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('9A4FC1FF-8DCE-41BB-929F-A42F912657F7', N'ActiveDirectoryCleanupPlugin', 1, 1,N'Customize Active Directory cleanup',N'<Doc><CustomProperties><Property Name="Plugin.AdMachineCleanup.Execute" DefaultValue="true" Encrypted="false" PromptUser="false" /><Property Name="Plugin.AdMachineCleanup.UserName" DefaultValue="Username of AD account with sufficient rights to delete, disable, rename or move AD accounts" Encrypted="false" PromptUser="false" /><Property Name="Plugin.AdMachineCleanup.Password" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Plugin.AdMachineCleanup.Delete" DefaultValue="true" Encrypted="false" PromptUser="false" /><Property Name="Plugin.AdMachineCleanup.MoveToOu" DefaultValue="" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('BA032D10-7829-4E1E-91E9-F096FCDDECEF', N'CitrixDesktopProperties', 1, 1, N'Enable Citrix XenDesktop integration for provisioned machines',N'<Doc><CustomProperties><Property Name="VirtualMachine.VDI.Type" DefaultValue="XenDesktop" Encrypted="false" PromptUser="false" /><Property Name="VDI.Server.Name" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="VDI.Server.Group" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="VDI.ActiveDirectory.Interval" DefaultValue="00:00:15" Encrypted="false" PromptUser="false" /><Property Name="VDI.ActiveDirectory.Timeout" DefaultValue="00:30:00" Encrypted="false" PromptUser="false" /><Property Name="VDI.ActiveDirectory.Delay" DefaultValue="00:00:05" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('19DD8C82-E9DE-4DAD-86FE-78E0F9B93CB3', N'Disk1Properties', 1, 1, N'Provision with two disks instead of the default one',N'<Doc><CustomProperties><Property Name="VirtualMachine.Disk1.Letter" DefaultValue="D" Encrypted="false" PromptUser="false" /><Property Name="VirtualMachine.Disk1.Label" DefaultValue="D_Drive" Encrypted="false" PromptUser="false" /><Property Name="VirtualMachine.Disk1.Size" DefaultValue="1" Encrypted="false" PromptUser="false" /><Property Name="VirtualMachine.Disk1.Percent" DefaultValue="100" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('395EB2EC-943A-4EC6-A761-BAFF947DF822', N'Disk2Properties', 1, 1, N'Provision with a third disk',N'<Doc><CustomProperties><Property Name="VirtualMachine.Disk2.Letter" DefaultValue="E" Encrypted="false" PromptUser="false" /><Property Name="VirtualMachine.Disk2.Label" DefaultValue="E_Drive" Encrypted="false" PromptUser="false" /><Property Name="VirtualMachine.Disk2.Size" DefaultValue="1" Encrypted="false" PromptUser="false" /><Property Name="VirtualMachine.Disk2.Percent" DefaultValue="100" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('B3595576-F15B-445A-B74D-78DE59405C21', N'Disk3Properties', 1, 1, N'Provision with a fourth disk',N'<Doc><CustomProperties><Property Name="VirtualMachine.Disk3.Letter" DefaultValue="F" Encrypted="false" PromptUser="false" /><Property Name="VirtualMachine.Disk3.Label" DefaultValue="F_Drive" Encrypted="false" PromptUser="false" /><Property Name="VirtualMachine.Disk3.Size" DefaultValue="1" Encrypted="false" PromptUser="false" /><Property Name="VirtualMachine.Disk3.Percent" DefaultValue="100" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('4DFE3844-DAF9-4b70-9C58-044644197B91', N'StaticNetworkProperties', 1, 1, N'Set up provisioning by cloning with static IP address assignment',N'<Doc><CustomProperties><Property Name="VirtualMachine.Network0.ProfileName" DefaultValue="" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('AD80755C-2671-4B88-8B99-42CD2E10E5EC', N'MiscellaneousVrmProperties', 1, 1, N'Specify miscellaneous vCAC settings',N'<Doc><CustomProperties><Property Name="VirtualMachine.Admin.AddOwnerToAdmins" DefaultValue="false" Encrypted="false" PromptUser="false" /><Property Name="VirtualMachine.Admin.EncryptPasswords" DefaultValue="true" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('77E77AED-67A8-435F-9133-B8610B343634', N'RemoteDesktopProtocolProperties', 1, 1, N'Modify settings for RDP connections to machines',N'<Doc><CustomProperties><Property Name="RDP.File.Name" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="VirtualMachine.Rdp.Setting1" DefaultValue="connect to console:i:1" Encrypted="false" PromptUser="false" /><Property Name="VirtualMachine.Rdp.Setting2" DefaultValue="span monitors:i:1" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('814611FB-3115-4F83-886D-1B9C40418764', N'SysprepProperties', 1, 1, N'Specify SysPrep settings for provisioned machines',N'<Doc><CustomProperties><Property Name="Sysprep.Identification.DomainAdmin" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Sysprep.Identification.DomainAdminPassword" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Sysprep.Identification.JoinDomain" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Sysprep.GuiUnattended.AdminPassword" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Sysprep.GuiUnattended.AutoLogon" DefaultValue="Yes" Encrypted="false" PromptUser="false" /><Property Name="Sysprep.GuiUnattended.AutoLogonCount" DefaultValue="1" Encrypted="false" PromptUser="false" /><Property Name="Sysprep.GuiUnattended.TimeZone" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Sysprep.UserData.OrgName" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Sysprep.UserData.ProductKey" DefaultValue="" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('2673DC3F-01E7-487C-BEFE-1D4E89A670C6', N'VMwareWindows2003Properties', 1, 1, N'Specify VMware Windows 2003 guest OS',N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="winNetStandardGuest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('23A03E1B-B806-4EBB-9DFB-8C20012F3376', N'VMwareWindowsXpProperties', 1, 1, N'Specify VMware Windows XP guest OS',N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="winXPProGuest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('DCF55929-061C-4BEC-B4C5-309818A78883', N'WimImagingProperties', 1, 1, N'Specify the WIM image to be used in WIM-based  provisioning',N'<Doc><CustomProperties><Property Name="Image.ISO.Location" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Image.ISO.Name" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Image.Network.Password" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Image.Network.User" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Image.WIM.Index" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Image.WIM.Name" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Image.WIM.Path" DefaultValue="" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('0D220756-6AA0-4908-82EE-9BE23CE1BC33', N'VMwareWindows2003Enterprise64Properties', 1, 1, N'Specify VMware Windows 2003 Enterprise Server (64bit) guest OS',N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="winNetEnterprise64Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('90436908-37B9-4B7A-B448-B7CCC6FB122F', N'VMwareWindows2003EnterpriseProperties', 1, 1, N'Specify VMware Windows 2003 Enterprise Server guest OS',N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="winNetEnterpriseGuest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('2CA3DE07-4562-4766-9BF8-4727B8A0CA5C', N'VMwareWindows2003Standard64Properties', 1, 1, N'Specify VMware Windows 2003 Server (64bit) guest OS',N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="winNetStandard64Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('83CE98D1-0582-47DD-A9A2-F985B7197441', N'VMwareWindowsVista64Properties', 1, 1, N'Specify VMware Vista (64bit) guest OS',N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="winVista64Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('3CE089FF-1523-4A73-85FA-9A6E0D44995B', N'VMwareWindowsVistaProperties', 1, 1, N'Specify VMware Vista guest OS',N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="winVistaGuest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('D5BEC89C-4167-4d7e-BB58-94FE628B30C6', N'CitrixProvisioningProperties', 1, 1, N'Enable Citrix Provisioning Server Integration in provisioning',N'<Doc><CustomProperties><Property Name="VirtualMachine.EPI.Type" DefaultValue="CitrixProvisioning" Encrypted="false" PromptUser="false" /><Property Name="EPI.Server.Name" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="EPI.Server.VDiskName" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="EPI.Server.Site" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="EPI.Server.Collection" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="EPI.Server.Store" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="EPI.Server.Port" DefaultValue="54321" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('EFB5CDF0-85BD-11DE-8A2C-94C356D89593', N'LinuxExternalScriptProperties', 1, 1, N'Specify postprovisioning scripts (Linux)',N'<Doc><CustomProperties><Property Name="Linux.ExternalScript.Name" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Linux.ExternalScript.LocationType" DefaultValue="local/nfs" Encrypted="false" PromptUser="false" /><Property Name="Linux.ExternalScript.Server" DefaultValue="Only use for NFS type" Encrypted="false" PromptUser="false" /><Property Name="Linux.ExternalScript.Path" DefaultValue="" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('34E5392C-87F5-11DE-AED4-B90856D89593', N'DiskPartitioningProperties', 1, 1, N'Modify disk formatting and partitioning options for provisioned machines','<Doc><CustomProperties><Property Name="Command.DiskPart.Options" DefaultValue="Align=64" Encrypted="false" PromptUser="false" /><Property Name="Command.FormatDisk.Options" DefaultValue="/A:32K" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('4A2CCAB3-5647-43D1-9EB4-E1B8EE220872', N'ExternalPreProvisioningVbScript', 1, 1, N'Specify a Visual Basic preprovisioning script',N'<Doc><CustomProperties><Property Name="VbScript.PreProvisioning.Name" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="VbScript.UnProvisioning.Name" DefaultValue="" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('4ED7542F-D070-44FA-A880-A2914E3458C2', N'ExternalPostProvisioningVbScript', 1, 1, N'Specify a Visual Basic postprovisioning script',N'<Doc><CustomProperties><Property Name="VbScript.PostProvisioning.Name" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="VbScript.UnProvisioning.Name" DefaultValue="" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('E0AAF0A5-9F14-4969-9017-71F11549066C', N'VMwareRhel5Properties', 1, 1, N'Specify VMware Redhat Server v5 guest OS', N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="rhel5Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('8C760458-A86C-471B-9786-6F1421377ACC', N'VMwareRhel5_64Properties', 1, 1, N'Specify VMware Redhat Server v5 (64bit) guest OS', N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="rhel5_64Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('0CBCE738-5E81-4A89-A2AD-FB6994CC9D99', N'VMwareRhel6Properties', 1, 1, N'Specify VMware Redhat Server v6 guest OS', N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="rhel6Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('59045122-9927-4A3F-BAFE-3A5363806B9F', N'VMwareRhel6_64Properties', 1, 1, N'Specify VMware Redhat Server v6 (64bit) guest OS', N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="rhel6_64Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('B6C327C8-DD7F-4B4F-8B65-CAB4FCB2B2EC', N'VMwareSles10Properties', 1, 1, N'Specify VMware SuSE Server v10 guest OS', N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="sles10Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('E1800F76-154E-499D-9B15-FE5242119A89', N'VMwareSles10_64Properties', 1, 1, N'Specify VMware SuSE Server v10 (64bit) guest OS', N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="sles10_64Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('D8DEF877-2778-4B9C-A266-D92AC6DBA94F', N'VMwareSles11Properties', 1, 1, N'Specify VMware SuSE Server v11 guest OS', N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="sles11Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('3885D93C-86DC-4A03-B6EE-4B1FE8F7A6D4', N'VMwareSles11_64Properties', 1, 1, N'Specify VMware SuSE Server v11 (64bit) guest OS', N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="sles11_64Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('7F1EB25A-7CC7-4271-B789-FDA70C4FA028', N'VMwareSles9Properties', 1, 1, N'Specify VMware SuSE Server v9 guest OS', '<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="slesGuest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('6C7A9EE7-1E20-48A8-A90A-469E3C299339', N'VMwareSles9_64Properties', 1, 1, N'Specify VMware SuSE Server v9 (64bit) guest OS', N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="sles64Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('25B53A22-5C89-462F-9625-687E9C7E4211', N'VMwareSolaris10Properties', 1, 1, N'Specify VMware Solaris v10 guest OS', N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="solaris10Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('CE874BFD-0ABB-477C-BE42-3EAECD2B4BEA', N'VMwareSolaris10_64Properties', 1, 1, N'Specify VMware Solaris v10 (64bit) guest OS', N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="solaris10_64Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('EA4267AC-DDE3-4073-A145-00BAFEBE3E47', N'VMwareWindows2008R2_64Properties', 1, 1, N'Specify VMware Windows Server 2008 R2 guest OS', N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="windows7Server64Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('1888E71B-B7E3-4D95-883C-BA806C531C73', N'VMwareWindows7Properties', 1, 1, N'Specify VMware Windows 7 guest OS', N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="windows7Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('FF1A9783-6285-4281-95F8-89168EE29EDD', N'VMwareWindows7_64Properties', 1, 1, N'Specify VMware Windows 7 (64bit) guest OS', N'<Doc><CustomProperties><Property Name="VMware.VirtualCenter.OperatingSystem" DefaultValue="windows7_64Guest" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('6602E0BE-7BB5-42D1-9015-C46555E2E50F', N'NetAppFlexCloneProperties', 1, 1, N'Provision by cloning using NetApp FlexClone-enabled storage', N'<Doc><CustomProperties><Property Name="Image.ISO.Location" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Image.ISO.Name" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Sysprep.GuiUnattended.AutoLogon" DefaultValue="Yes" Encrypted="false" PromptUser="false"/><Property Name="Sysprep.GuiUnattended.AutoLogonCount" DefaultValue="1" Encrypted="false" PromptUser="false"/><Property Name="Sysprep.Identification.DomainAdmin" DefaultValue="" Encrypted="false" PromptUser="false"/><Property Name="Sysprep.Identification.DomainAdminPassword" DefaultValue="" Encrypted="false" PromptUser="false"/><Property Name="Sysprep.Identification.JoinDomain" DefaultValue="" Encrypted="false" PromptUser="false"/></CustomProperties></Doc>');
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('8993D1A8-7666-4f4a-9279-ECF89466F404', N'HPSABuildMachineProperties', 1, 1, N'Enable HP SA integration in provisioning',N'<Doc><CustomProperties><Property Name="EPI.Server.Name" DefaultValue="FQDN of Opsware Core Server" Encrypted="false" PromptUser="false"/><Property Name="VirtualMachine.EPI.Type" DefaultValue="Opsware" Encrypted="false" PromptUser="false"/><Property Name="Opsware.Server.Name" DefaultValue="FQDN of Opsware Core Server" Encrypted="false" PromptUser="false"/><Property Name="Opsware.Server.Username" DefaultValue="Opsware Admin Login name" Encrypted="false" PromptUser="false"/><Property Name="Opsware.BootImage.Name" DefaultValue="Opsware Boot ISO name e.g. winpe32" Encrypted="false" PromptUser="false"/><Property Name="Opsware.Customer.Name" DefaultValue="Opsware Customer Name" Encrypted="false" PromptUser="false"/><Property Name="Opsware.Facility.Name" DefaultValue="Opsware Facility Name" Encrypted="false" PromptUser="false"/><Property Name="Opsware.OSSequence.Name" DefaultValue="Opsware OS Sequence Name" Encrypted="false" PromptUser="false"/><Property Name="Opsware.Machine.Password" DefaultValue="Opsware OS Sequence Image Admin Password" Encrypted="false" PromptUser="false"/><Property Name="Opsware.Realm.Name" DefaultValue="Opsware Realm Name" Encrypted="false" PromptUser="false"/><Property Name="Opsware.ProvSuccess.Notify" DefaultValue="Optional - Email Address to notify on provisioning success" Encrypted="false" PromptUser="false"/><Property Name="Opsware.ProvSuccess.Owner" DefaultValue="Optional - Opsware user to own machine on provisioning success" Encrypted="false" PromptUser="false"/><Property Name="Opsware.ProvFail.Notify" DefaultValue="Optional - Email Address to notify on provisioning failure" Encrypted="false" PromptUser="false"/><Property Name="Opsware.ProvFail.Owner" DefaultValue="Optional - Opsware user to own machine on provisioning failure" Encrypted="false" PromptUser="false"/><Property Name="Opsware.Register.Timeout" DefaultValue="180" Encrypted="false" PromptUser="false"/><Property Name="Opsware.WOL.Enabled" DefaultValue="True" Encrypted="false" PromptUser="false"/><Property Name="Opsware.WOL.Delay" DefaultValue="45" Encrypted="false" PromptUser="false"/></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('8061A4FA-F928-4f91-AB31-20DE7FC3C114', N'HPSASoftWareProperties', 1, 1, N'Enable HPSA integration in software deployment',N'<Doc><CustomProperties><Property Name="LoadSoftware" DefaultValue="true" Encrypted="false" PromptUser="false"/><Property Name="VirtualMachine.EPI.Type" DefaultValue="Opsware" Encrypted="false" PromptUser="false"/><Property Name="EPI.Server.Name" DefaultValue="FQDN of Opsware Core Server" Encrypted="false" PromptUser="false"/><Property Name="Opsware.Server.Name" DefaultValue="FQDN of Opsware Core Server" Encrypted="false" PromptUser="false"/><Property Name="Opsware.Server.Username" DefaultValue="Opsware Admin Login name" Encrypted="false" PromptUser="false"/><Property Name="Opsware.Software.Install" DefaultValue="true" Encrypted="false" PromptUser="false"/></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('80CA79C6-A414-4477-B730-029A2C05ABA4', N'SCCMProvisioningProperties', 1, 1, N'Set up SCCM-based provisioning',N'<Doc><CustomProperties><Property Name="SCCM.Server.Name" DefaultValue="FQDN of the SCCM Server" Encrypted="false" PromptUser="false"/><Property Name="SCCM.Server.SiteCode" DefaultValue="" Encrypted="false" PromptUser="false"/><Property Name="SCCM.Server.UserName" DefaultValue="SCCM Server Admin Login" Encrypted="false" PromptUser="false"/><Property Name="SCCM.Server.Password" DefaultValue="Password for Admin User" Encrypted="true" PromptUser="false"/><Property Name="SCCM.Collection.Name" DefaultValue="Name of the target collection" Encrypted="false" PromptUser="false"/></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('C04FABB2-9B88-11DF-83D7-1D39E0D72085', N'BootIsoProperties', 1, 1, N'Specify the boot ISO to be used in WIM-based, kickstart/autoyast or SCCM-based provisioning',N'<Doc><CustomProperties><Property Name="Image.ISO.Location" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Image.ISO.Name" DefaultValue="" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('EB7F936A-8719-11E0-9C50-23064824019B', N'PxeProvisioningProperties', 1, 1, N'Set up PXE-based provisioning',N'<Doc><CustomProperties><Property Name="Pxe.Setup.ScriptName" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Pxe.Clean.ScriptName" DefaultValue="" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('F7593027-DAD7-418E-A945-0FF66C2B306D', N'BMCSoftWareProperties', 1, 1, N'Enable BMC integration in software deployment',N'<Doc><CustomProperties><Property Name="LoadSoftware" DefaultValue="true" Encrypted="false" PromptUser="false"/><Property Name="VirtualMachine.EPI.Type" DefaultValue="BMC" Encrypted="false" PromptUser="false"/><Property Name="EPI.Server.Name" DefaultValue="FQDN of BladeLogic Server" Encrypted="false" PromptUser="false"/><Property Name="BMC.Software.Install" DefaultValue="true" Encrypted="false" PromptUser="false"/><Property Name="BMC.Software.BatchLocation" DefaultValue="Location of software jobs; must match Website\Software.txt" Encrypted="false" PromptUser="false"/><Property Name="BMC.Service.Profile" DefaultValue="Name of the default authentication profile on the BladeLogic server" Encrypted="false" PromptUser="false"/></CustomProperties></Doc>'  );
INSERT INTO PropertySetXml (PropertySetID, SetName, IsEnabled, IsDefault, Description, Xml) VALUES ('726AEA42-4875-11E1-BC67-15C74824019B', N'BootIsoCredentialProperties', 1, 1, N'Specify the boot credential ISO to be used in WIM-based, kickstart/autoyast or SCCM-based provisioning',N'<Doc><CustomProperties><Property Name="Image.ISO.UserName" DefaultValue="" Encrypted="false" PromptUser="false" /><Property Name="Image.ISO.Password" DefaultValue="" Encrypted="false" PromptUser="false" /></CustomProperties></Doc>'  );

PRINT 'Inserting UI Customization defaults'
INSERT INTO UICustomization (id, lastmodified, showdashboard, 
	showvmgrid, showvmgridfilters, showvmgridmultiselect, showvmgridexport, vmgriddefaultcolumns, 
	showpendinggrid, showpendinggridexport, showreclaimgrid, showreclaimgridexport, showexpiregrid, showexpiregridexport, 
	showrecentgrid, showrecentgridexport, requestvmshownfields, defaultinitialpage,
	showvmgridextracolumns, showreclaimcolumns)
	VALUES ((newid()), (getDate()), 1, 
	1, 0, 1, 0, N'Status,Type, Description,ExpirationDate,DestructionDate', 
	1, 0, 1, 0, 1, 0, 
	1, 0, N'Type,LeaseInDays,ArchiveInDays,MemoryInMB,StorageInGB,NumCpus,CostDaily,Description', 3, 
	1, 0);

PRINT 'Inserting ApprovalGroups'
INSERT INTO ProvisioningGroup (GroupID, GroupName, GroupDescription, Flags, GroupType) VALUES ('D80DA1FD-7157-4166-95DE-2F7F43D651FE', N'<<Owner>>'			    ,	N'User who requested the machine'	,2,1);
INSERT INTO ProvisioningGroup (GroupID, GroupName, GroupDescription, Flags, GroupType) VALUES ('78AA552C-72C7-476c-9059-AA3AEAA93EDA', N'[Machine Provisioning]',	N'Step in which the machines are built',7,1);

PRINT 'Inserting the Physical fake Host'
INSERT INTO Host(HostID, HostName, MachineType) VALUES ('00000000-0000-0000-0000-000000000000', N'Physical Reservation', 1)

PRINT 'Inserting the AppService fake Host'
INSERT INTO Host(HostID, HostName, MachineType) VALUES ('FBE1198E-2B65-42FB-8437-4942DAD514A2', N'AppService Host', 3)

PRINT 'Inserting Default App Appearance'
INSERT INTO AppAppearance ( AppName, Logo, LastUpdate, EnableStaticIPv4Service, DefaultGridPageSize, EnableFlexCloneProvisioning, EnableComplexApprovals, EnableSnapshotManagement, EnableVirtualDataCenterSkill) 
			VALUES ( N'vCloud Automation Center', NULL, GETDATE(), 0, 25, 0, 0, 1,0)

PRINT 'Inserting InterfaceTypes'
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'AmazonEC2', 2, N'Amazon EC2', null, null, 0, 1, 1, 1);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'CiscoUcs', 1, N'Cisco UCS Manager', null, null, 0, 1, 0, 1);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'CitrixXen', 0, N'XenServer', null, null, 0, 0, 1, 1);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'DellIdrac', 1, N'Dell iDRAC', null, null, 0, 1, 0, 1);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'Generic', 0, N'Generic', null, null, 0, 0, 0, 1);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'HpIlo', 1, N'HP iLO', null, null, 0, 1, 0, 1);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'HyperV', 0, N'Hyper-V', null, null, 0, 0, 1, 1);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'NetAppOnTapp', 3, N'NetApp ONTAP', null, null, 0, 1, 0, 0);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'Scvmm', 0, N'Hyper-V (SCVMM)', null, null, 1, 1, 1, 1);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'vCloud', 2, N'vApp (vCloud Director)', null, null, 0, 1, 1, 1);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'vCO', 5, N'vCenter Orchestrator', null, null, 0, 1, 0, 0);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'vSphere', 0, N'vSphere (vCenter)', null, null, 1, 1, 1, 1);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'Kvm', 0, N'KVM (RHEV)', null, null, 0, 1, 1, 1);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'MultiMachine', 4, N'Multi-Machine', null, null, 0, 0, 0, 1);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'GenericPhysical', 1, N'Physical', null, null, 0, 0, 1, 0);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'vCloudComponent', 2, N'vApp Component (vCloud Director)', null, null, 0, 0, 0, 1);
INSERT INTO InterfaceTypes (InterfaceTypeId, EndpointType, DisplayName, [Description], Url, IntegratedSecurity, HasEndpoints, HasReservations, HasBlueprints) VALUES (N'Test', 0, N'Test', null, null, 0, 0, 0, 0);

PRINT 'Inserting Property Dictionary'
-- create default property attributes
INSERT INTO [PropertyAttributeTypes] (Name, FullDescription, IsRule) VALUES (N'RegEx', N'Regular Expression Validation', 1)
INSERT INTO [PropertyAttributeTypes] (Name, FullDescription, IsRule) VALUES (N'HelpText', N'Help Text for entry (e.g. ToolTip)', 0)
INSERT INTO [PropertyAttributeTypes] (Name, FullDescription, IsRule) VALUES (N'MinValue', N'Smallest acceptable value for the property.', 1)
INSERT INTO [PropertyAttributeTypes] (Name, FullDescription, IsRule) VALUES (N'MaxValue', N'Largest acceptable value for the property', 0)
INSERT INTO [PropertyAttributeTypes] (Name, FullDescription, IsRule) VALUES (N'Interval', N'The increment and decrement amount.', 0)
INSERT INTO [PropertyAttributeTypes] (Name, FullDescription, IsRule) VALUES (N'ValueList', N'Comma separated list of values.', 1)
INSERT INTO [PropertyAttributeTypes] (Name, FullDescription, IsRule) VALUES (N'ValueExpression', N'Expression used to determine initial values', 1)
INSERT INTO [PropertyAttributeTypes] (Name, FullDescription, IsRule) VALUES (N'Relationship', N'Property Name of related definition.', 1)
INSERT INTO [PropertyAttributeTypes] (Name, FullDescription, IsRule) VALUES (N'OrderIndex', N'Value to represent default display order.', 1)

-- create default control types
INSERT INTO [ControlTypes] (Name, AssemblyFQN, FullDescription, UserControlFileName) VALUES (N'TextBox',N'',N'Single line text edit box.',N'')
INSERT INTO [ControlTypes] (Name, AssemblyFQN, FullDescription, UserControlFileName) VALUES (N'Label',N'',N'Read-only style label.',N'')
INSERT INTO [ControlTypes] (Name, AssemblyFQN, FullDescription, UserControlFileName) VALUES (N'Link',N'',N'Hyperlink with text of DisplayName and Url of Value.',N'')
INSERT INTO [ControlTypes] (Name, AssemblyFQN, FullDescription, UserControlFileName) VALUES (N'DropDownList',N'',N'DropDownList style ComboBox. Value must be selected from the List.',N'')
INSERT INTO [ControlTypes] (Name, AssemblyFQN, FullDescription, UserControlFileName) VALUES (N'DropDown',N'',N'DropDown style ComboBox.  Allows Text other than values contained in the List.',N'')
INSERT INTO [ControlTypes] (Name, AssemblyFQN, FullDescription, UserControlFileName) VALUES (N'Integer',N'',N'Numeric spin editor for integer with max/min attributes.',N'')
INSERT INTO [ControlTypes] (Name, AssemblyFQN, FullDescription, UserControlFileName) VALUES (N'CheckBox',N'',N'CheckBox returns true/false values.',N'')
INSERT INTO [ControlTypes] (Name, AssemblyFQN, FullDescription, UserControlFileName) VALUES (N'Notes',N'',N'Multiple line text edit box.',N'')
INSERT INTO [ControlTypes] (Name, AssemblyFQN, FullDescription, UserControlFileName) VALUES (N'Password',N'',N'Masked text editor hiding current value.',N'')
INSERT INTO [ControlTypes] (Name, AssemblyFQN, FullDescription, UserControlFileName) VALUES (N'DateTimeEdit',N'',N'Calendar Date with Time TextBox for entering DateTime.',N'')

-- create default attributes for control types
-- TextBox, RegEx, HelpText, OrderIndex (tbd MaxLength)
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'TextBox', N'RegEx')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'TextBox', N'HelpText')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'TextBox', N'OrderIndex')
-- Label, HelpText, OrderIndex
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'Label', N'HelpText')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'Label', N'OrderIndex')
-- Link, OrderIndex
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'Link', N'OrderIndex')
-- DropDownList HelpText, ValueList, ValueExpression, Relationship, OrderIndex
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'DropDownList', N'HelpText')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'DropDownList', N'ValueList')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'DropDownList', N'ValueExpression')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'DropDownList', N'Relationship')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'DropDownList', N'OrderIndex')
-- DropDown, RegEx, HelpText, ValueList, ValueExpression, Relationship, OrderIndex
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'DropDown', N'RegEx')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'DropDown', N'HelpText')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'DropDown', N'ValueList')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'DropDown', N'ValueExpression')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'DropDown', N'Relationship')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'DropDown', N'OrderIndex')
-- Integer, HelpText, MinValue, MaxValue, Interval, OrderIndex
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'Integer', N'HelpText')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'Integer', N'MinValue')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'Integer', N'MaxValue')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'Integer', N'Interval')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'Integer', N'OrderIndex')
-- CheckBox, HelpText, OrderIndex
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'CheckBox', N'HelpText')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'CheckBox', N'OrderIndex')
-- Notes, RegEx, HelpText, OrderIndex (tbd MaxLength)
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'Notes', N'RegEx')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'Notes', N'HelpText')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'Notes', N'OrderIndex')
-- Password, RegEx, HelpText, OrderIndex (tbd MaxLength)
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'Password', N'RegEx')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'Password', N'HelpText')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'Password', N'OrderIndex')
-- Calendar, HelpText, MinValue, OrderIndex (tbd MaxLength)
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'DateTimeEdit', N'HelpText')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'DateTimeEdit', N'MinValue')
INSERT INTO [ControlTypePropertyAttributeType] VALUES (N'DateTimeEdit', N'OrderIndex')
-- Reconfigure VM Approval Definitions and State Operation Definitions
INSERT INTO [ApprovalDefinitions] VALUES (N'ReconfigureVM.Standard', N'Standard Approval for Reconfiguring VMs', N'ReconfigureVM.ApprovalRequest', N'ReconfigureVM.ApprovalGranted', N'ReconfigureVM.ApprovalRejected')
INSERT INTO [ApprovalDefinitions] VALUES (N'ReconfigureVM.Owner', N'Owner Approval for Reconfiguring VMs', N'ReconfigureVM.OwnerApprovalRequest', null, null)
INSERT INTO StateOperationDefinitions VALUES (N'ReconfigureVM', N'Reconfigure Virtual Machine', 0, GetUtcDate())
INSERT INTO [StateOperationDefinitionProperties] VALUES((SELECT Id FROM [StateOperationDefinitions] WHERE [name] = N'ReconfigureVM'), N'EmailUniqueCode.Failed', N'ReconfigureVM.ReconfigureFailed', 0, 0, 0)
INSERT INTO [StateOperationDefinitionProperties] VALUES((SELECT Id FROM [StateOperationDefinitions] WHERE [name] = N'ReconfigureVM'), N'EmailUniqueCode.Successful', N'ReconfigureVM.ReconfigureSuccessful', 0, 0, 0)
INSERT INTO [StateOperationExecutionStates] VALUES (N'ReconfigureVM.Pending') 
INSERT INTO [StateOperationExecutionStates] VALUES (N'ReconfigureVM.WaitingForApproval')
INSERT INTO [StateOperationExecutionStates] VALUES (N'ReconfigureVM.QueuedForOwner')
INSERT INTO [StateOperationExecutionStates] VALUES (N'ReconfigureVM.WaitingForExecution')
INSERT INTO [StateOperationExecutionStates] VALUES (N'ReconfigureVM.Scheduled')
INSERT INTO [StateOperationExecutionStates] VALUES (N'ReconfigureVM.Queued')
INSERT INTO [StateOperationExecutionStates] VALUES (N'ReconfigureVM.InProgress') 
INSERT INTO [StateOperationExecutionStates] VALUES (N'ReconfigureVM.FailedWaitingForRetry')
INSERT INTO [StateOperationExecutionStates] VALUES (N'ReconfigureVM.RetryRequestMade') 
INSERT INTO [StateOperationExecutionStates] VALUES (N'ReconfigureVM.Failed') 
INSERT INTO [StateOperationExecutionStates] VALUES (N'ReconfigureVM.Successful')
INSERT INTO [StateOperationExecutionStates] VALUES (N'ReconfigureVM.Canceled')
INSERT INTO [StateOperationExecutionStates] VALUES (N'ReconfigureVM.Complete')
INSERT INTO [StateOperationExecutionStates] VALUES (N'ReconfigureVM.ExecutionUpdated')

PRINT 'Inserting Default Display Icons'
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('00000000-0000-0000-0000-000000000001', 0x89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af4000000097048597300000ec300000ec301c76fa86400000315494441545885ed964d8b544714869f53f7cee874c7cf410c427603d984107461fe4136ae5c0afe04fd0732b8763910b2719145dc846c2481acdd2510501c186957d94445fc609ce9b6efad3a278baafb313ddd7d7ba075a32f14d5b7eadc7adff375bbe0333e75c89dbb7fd8a2c6669666300cd26cd6de330c0eec91d62a1b80a783ed1ee073802fb2bd6539b4101efcb383206781ddbc5aec5dbe4adf05fc9c78c8b46739b8d37e6cdb674e282587c1dfc00ec049a0a805f45de044ae783dba478b2017181914ad25c0d502bc8157f0ba70491c1142b0c367e7ed8752c1014791606688083a71b813419333ce4130399cc349019dc4558527dbd80d606a4dc5d3744965eb02e08c95950e01b379ad2134500c35e2d0e6b799a1a475b35a602c4c434ac7e94901556fca14420c44a0ac4814821921d54a30086a941ad78246017564ead93031d4c9a400cb27eb42cdf01ae78ac0b7084a8d82bc26bb24aad426452109c71a115e3dd9aa3b9c822a024e04af8606a308569394217a5baa5184e84d50f06629ec29e4c45a0070ae558012639b39213b58841205a45251338685e1bd320e4a11c087e4696ad122184e2a526bf28b2002e21a868ab80b750a9eef05bc0f943ec40884b81192874d8a927c91695d7564d42978350a14e392a0561fbea013cb115084d83699fb08ac2db82a0599c847f178127504348de54270e6c824470953cfafbb60456c294575108aba92b10dc9c83826bd2902520abed9df593a7d85df377ee4d747f7f9b9ffe73401a90b5efcfbc104b0c14c0ed9dcfacd0683c71f8e7c0604f90e78963f1d6caf09720e380564f35e3a71b2ff70defebbddfdef010f04baffdddf932ea51e780b8c88f791a938b37efedbd563c7e79e68ac6eecedbef90bd8a3bba93c3014806b376e3be2677d6a239cfbf2ab8bc7cf5eb822e26ecd3bb11c0f7f1abdfeeffedbd72f1f10af7ff3a260807576de0fd76ffe027cbdb6dabbd4650b302a86dbc093f5d3ebd781e2ded6e6dc48740a48d1e9a5d107d6809519ef2a3006f681619a8b7b5b9b3323b1d0958c98aff7697ed721dc925dc9021fd7853e7e290a6dfbaef7ac1af3bc07f81fc273e50896acead70000000049454e44ae426082, 0xd6db31b192bc774262dfcef8fb78a473)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('fff0286b-982a-4531-8294-0c4f537867ad', 0x89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af4000000097048597300000ec300000ec301c76fa864000003f0494441545885ed944b4c1b5714863f0fe3f7f8811f80dc9a28044571166da10814b51155d42edaae92eedaae41555476d9c1a23ba46ee99275775d544a15a9add4027d18525e419062440dc1c57130f6d89e607b663c5dd8f20368a42a0d5924bf648deed5f9cff7cfbd670c2ff5522fba4c8357ae19cf03dc3b30ec003411e0d21bef9e29fcfef20f003e202702542a2ab76edee0cbafbea93f9f46b76ede00a8f76b56536f3750360d5eb966f444de7a2ae07fd5f6c62ff40e0cbf06a444004d2b737ff1f699c02ff57fd8b2160154b504c0d5b7af3e53f8ecdc6c9dd512403bb6d9d96ee77c971b4130d5f734bd422c2193c9b7d602f4863c74b4db9f08df2d86616ef6044b300c03b55cac6f7478ed5c087910453376b71fc9ff2a76b71fb32812e96ec7e3b4b434087aed75b820882d1e93493811442d17318cfa976f88baa6a296aa0104139ceb7461b649f8c211dacc562449a25028502e1678b8b584cf52e2dec6034ac522369b9548d7798e0a320e4f9060cfeb2d1eb5a890d9db406b7a41b55444d7d4fa5ad4340d55ad16b81c16ac160bbe70047fb093eeee6e2449425114a2d1284ac5c6fee63c733fadd366756213caf4daf669132d5c7ce713dacc56060606b05aad64b359e2f1388651211d5f6d04508b689a06600210744d25be552d705845ac920741b4d0d3d3432c1663747494743a4d5f5f1f764f070e5f8880a77ae45ded0e00a460188bddc5d0d0106b6b6b8c8c8c20cb32e17018c16cc76c77d703c4b7564f9e809257f0baab4d0dc18cc964c2ebf5323e3eced2d23a2e978ba9a9293c1e0f76770097c34ca6a8a3572a0058251fa15008a7d3c9c4c4448b677e7e9e52a931784a5ec1e9901a43a8eb8d346939cfd6ca6feceded512814989c9ce4faf50f181b1b23954a21cb3247b90312070a008fe4ead595952cc964f2544f269321b6f22b87997c9dd3cc146af701c09d1fa3ec6ead515464a2d128914884e9e969fc7e3f0b0b0b1cc92976ffda265ba8bed161ae4849d5c9a7769ee8291c3ce0eef2669dd3cc149bef03606e79076ffb6d8c4a85442241301824994c72947bc4ce1f7798b997c0e5f65467467233b3fa37efbd1926bef0ef1ec33028951a9c6333d01a202157f8eee745867319fcaff49274f93892533cdcdde4fbbb3be4cb624bfd7ece607de790cbe72036f335eeae0b758f9cdcc6a8e81c573353d49b8e03e062ff4700cc67812c4019f00283042283044eb4831cf0bb5c5ba49b3dfda7544333535435f0765d0652006412d1534dff87cc6295252757a0f63f2002385d012080f999a11b7202d964832402482eef19a04f9708f0e7e2b7cf8b6f88ef7ffa990de8043c40db19c24b802e021a90011e531b8c33920e3c36017cfcf917420d7e96018cdaef05d73fce1dd7e8496855cc0000000049454e44ae426082, 0x4f88d99e942b5aeac11a6eb9fe8b968c)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('257fe860-f02f-4f1b-9089-37d24ae68929', 0x89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af4000000097048597300000ec300000ec301c76fa864000002c5494441545885cd974f4814511cc73fcab88266bb5a8229b4b56e7fd4308b45c2434511e8512182edd6a9cb4227afcb9ea23f7468a15b56a25274f06487204202939cdccaf2df61d743b0965269bbedcc9bddb5c3baa2cc483bb3b3d0178661defbbdf7fbcc8ff7bef3a68c4ddd1d18dbc084a623b273241c5c3733c648d2f6874b5d1d1c6ca8a5aaaa02556448291a4945e3775261f55792959f49d6120aefdecb007580bd0079c9b2cc9ddbb70038d0d0407d7d3deeb63354bb9a00882fc770edd95b6ceedd017c3e1f83434f775460e9eb77529a2d39770798fd3041bcd645854322a50892c93f08a1a10a41369305d8ba9704a0b5a3aba0350033a501882e7c647dd585a3b282b49641151aaaaa9252042945a0a81a592d635b721d80e7d8c97f56209d5080a9d2002c7e91598dbb703824d2e90c4215a8aa40d9bc84c890cd94b00247db7c05ae81486900f415c8ad81ffbe02c5d8b8a1115991551bb70d202fb3366e3b80591bb70dc0aa8deb00ee2dde643631cba3ce615300566d5c07f049ccf1f2c72b53c9c1ba8deb001e9f18a4aa33f7166664d5c67700dc7f324a7c39662a715e566d5c02f00742d5d311b905d89fdf22cab9b937d73aaff26c6594e8db18ee85f33d4062dbd81a7f20e41c0907d7c0ba89490023e1601298dfded1dbdd474d6d25656a9ab42305303f120e2e155e81c26cdcb66d68b502e54693f903a14317a317987c10c133eca165e238408b3f10328c2f4652ef589fee43d215dd87c7e3a1f98897a5580cb7dbcdf8f8f88bb5cbebf476f7e967f95604c08db3d7758d939f2378bd5ed88032a0a9b11100a35880a9e7d68fcbd2c3e5215da327e5c155eb229bcdd2d2da8ad072098c6201dab9621d60e1f5a2aeb17ca99cfefe7e5dbb512c40fbe652b662e352f34c8f93dcf7794ba2c638b879e6b071c7296260cdc6a5cd934951ff78a707c6006b366e9b0f58b5715b00a623b213a833f1c3ba55f1bfb3ca691d7c429a890000000049454e44ae426082, 0x83100961a7afaabac1a57602b1c88e2b)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('445825d2-4bad-45ba-bd25-4135158c9d2d', 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, 0x464c2791d1411ee7416d6a1d53c3c4e3)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('3119f2b2-3778-40ff-a27a-4a33f2cfc8e2', 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, 0xe62aa214a5242a633079924c3d1e304c)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('717fd46e-0a28-485f-9241-55cf66612aaa', 0x89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af4000000097048597300000ec300000ec301c76fa8640000016a494441545885ed973b4f024114853f1623ae8cb091440b5b4b1b0d2d85bd9d517f0e85ad9db131c652138d85511ba3952d828d95044a488c0105711fb3608121c6c03e90478c7baa4966f6e4cb3db3776660cc0ab92dd839bc6af56b9ecd65a60109c8a3dd74579f092f46a9e4120b7371125a947058c13025ba69619812c3b2a9bd1b54eb3a95d706d59a8e6e586472f700b3c01bd000ecbe01be6b7363bd33164230230442085455657975ab33572a17d1442c0698c0472f3fdf0027a7678e15e8e2af38f9394e8e429e2a90bdbb24af694c46228414055b4a6c2991526299269665d16a368707b0925af3bd09a1e009e05f44e0d8478208861d816bab0f22081a511041104100f077006ef573b69fd27efd07731600149e0be4eb79bf00aef20cf0603c72fd72333e80bdc50312c9e8c00146b1097f7f25db3fbea0542e0e06c72f4036979902e635118b03619ffe06ed3761cf2a78a980042ab41f98aebfd50fd95fdff53ca93e01a20a60fc165f755d0000000049454e44ae426082, 0xeb11989d2f97da762e26af4ceb53e8c0)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('381bdfd3-f28e-434c-b50b-7353667d5cea', 0x89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af4000000097048597300000ec300000ec301c76fa86400000303494441545885ed964f48944118c67fab6e6e84ba6286a918ae66645981e1c1c2a20c0f5e3a6886425da508924aa88b18095dea90d521e8108428846244a744ec601286a506fe497755747755685dd0557777a6c3fe71bfddfd7415f5920f0cf3cebcf3cef3cc3b33df7cb0873dece17f8746cdf1f2c59b2ce0cf76902cad384ffc9c9c1f05dc4d8d75225201b2b8a494b494f8b07e29254208a494fe22a4408a005b4a26a7e6686969469f7cf8ecb0f9ef6f60355044d44e924b29494f4da2a2e23ab639736f4e8a3e0fd85779a7decfabc8802feddb452ec55adb6cb1d1d2d24cc2c19482118b6dc09709cd6e90fb8a75d61e222250800ccbba0318331ab1ba7487007b4ca0a3ea46e5ae08785cdf009000381502acd68588271142788b1be9addd8ab6c7166e6f2dd66a2f748036e416b47e68e6c7f7ee0dedbede9e2d91070888023421028e64645076edaaaa2d84f0db5b2117c2ade0531cc2e292d21d4b7ba0fda5a313ab4b771ab06c6a0b7c69fff4b18dc1febe2d91076720a22d084efb5a7fe4e44f2f5ce151e683c033105e407e412146d3acdf1e1bb7208420ef4c3e43431308e1e658ee497ef50f6f6ae536d3291c6607522a3f378a6b68314f299c524a901289f4db22a8cf3f26a880b25d3fd210bc564d8880f6f6f6e0413b0ebf80ee51f37ed025037a207aa3c095c291beaafc32dae63f33d13b41fae8b952606613dc2b802b30034ec0063858e73fc107a97372207e1f9a6517ae9865000b30bd09016e604941e47da7351108282acc49ea585c5ac4e170603299588dcbbc087c03c406b1fe3500322c51796bf97357acbb462df2f2f8250c06035947b331198dccccccd0d5d5c542b95d952d6649fb4afb35f77e5363ddb2a23fdce0951867cdbda25baa93f50cf6919d9d0dd293aab4d45400ee1655abc63ceb7c7d5b0b4ff06cd5fa02b4da68de5adeab4e667018d027ea1142703c379755a71360dd18ad361a3c2fa00261055887ecef9c53d337d5268b3245515b5b1bd23fdc39a22a20d69ed89aee39e81b0bc8183f5f0d3c0462c3f957e3c293640d64aa0a60ed9629f00ff8ae1686f0bede1e0000000049454e44ae426082, 0xe1508f54f73210850b71a6bee03db38a)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('8db0e1ac-668b-4d5a-ae63-75dc0ba56be0', 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, 0xa5007cfa4d293b1d9a68874b52134b40)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('05f88e6a-01e1-4dc8-9904-98cae7a1efa9', 0x89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af4000000097048597300000ec300000ec301c76fa86400000304494441545885ed97bb6f145714c67fd7b602c6c3b2b2a35020525150d0c4d052505010453409c1ff0325543441a28048e9ac34284a910210c805e221252155242490f1d250202c43674b08b1b617efcebd77ee97621e9e15bbf6ac9183847ca499fb9c73be73be738feec02716d36bf297dfef6bab0ae71ab37b000ff8ebd33f6daa67a4dfc2f1634738f0d53e26ea630c0f0f115b4fc73a62eb895dc2eafb9866abc3bbe5359aab1d3ab163b6f114601c5801d68064cb00caf2e399ef8b7e1445ec8d22a228627474946f4e9c2dd616975e518f6a35c002ed2aba2b01b8757b66c308f4d03954452f836cdc2ee91b81b97fef315faff3c5ae5d98a12112ef49bcc77b8fb316e71c0a61fb004c1eff6ee024848581017cb61454ae233b146c07053dcbfbc0007628d82944ff97f4bd908cb55f532b51e0767fdd478590c02024012248100242194d42c12309294010efad78f4e4f19eca14ccfcdd60ead4d1d4a404823c03241104129991b41f2444d60fea5afb63e61ec078a5fb4097bf2ad5d9ac2fca2f43572516e8dc494cb6d24e3c23d30f595c7a0350db420ea878e7bd1c54daea83369735ef598e2dc2b0dc5a05181918806440a634a6dbe19c8a90edc9f6b613cf8a7334ad05091b5ba0e2956c5d7be6317cf894f84d594807ca00acc496a6b5346d8c3024590dd910c03f9d3bbc78f9824b872f17f60d10947bbb9e1085f12cf1d23d0619a1e93f9948601c65f322490280d910c0c29b05e65bf3a981e00baeafdf7f8ab509d639acf5749c27b69638f6c4cee39cc73acfd50b67d629c972220f991006b371049ec5cff9ebed4360fd48014c7d3b992ac98f1d22040aef42c98830d93e938df358b23905bf1efa8d896363009852b6dd7c3057290257ceff507c534420d5560d4059824271eecf9e9accbc545184427ee4425e84c8c390ceab943faa10816b37eeb2b8f4aa184f9d3e9d265750bf4f7a802e2567173585f44ec2b9c6ec6e607f3daaed038601565aedc6c59fafb1dc5aa5d55aeb2a301f23fd22e08177a43f9806e0d193c707812f811a306cfadfbc02e97fa163f3db71fc1fb06fbe8b9a67a7d10000000049454e44ae426082, 0x6e1b8d35797f4f5c833b24f83b636caf)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('931c84fe-ce79-41d3-8100-9980113b66c6', 0x89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af4000000097048597300000ec300000ec301c76fa86400000343494441545885ed945f6853571cc73f37bd37b4da3f3121b65124b6dad24135ad8c522684c17c105d0babb8079dbe75f4a54f833128ddf04151f14d109f5d15a4e0c3441166c7c828c8600c5626d235ad83465dacb64d6e53e83dd7b3879b7bda7853299ac417bf70c8ef77ce3de7f3bdbfdfc9850ffaa0f72c6da42ff613d05b49a844bb3b13fde2182074a0b7f7f0fe4af2b97defaf234000c8ea12ee5cbefee068250dec0a0712403db0ea9b89f61fdb1ddac2d0c91e864ef60094e5d71dbb435b78bcebf36f000948edc4d099aa3dffde12df0e9f2eeb5bbbba78f61ac968ff01601e78a1dfb8fc833dd2170320fecf6859e189d6afdcd0062cf29710803f13bf43047e3cfe1d00ed463f008fac5b25c94f8d9d77188e647ebcf2b9335df16e6c6197e44d8bc916365df16ecf7c4105b24696b9ec0c00ed4167be54797631bbbe02e05460cd4057bc1bf3de2fcc5bd3ce86ec3240c97273c9a4eb70373ffff668e30a984b2693ff8d03b05f7f0ac0a4284d6e2e99eb2ba0b981ba031d3d9dac982bcc4f0b2e5c79ccb29963d9cc952c5f3157e8e8e9e4756900237d31f9d9c1363e4d8e791e28a57edd739cf1892992d1fe18f00c78a95ad0d6f9117fb47c4fe2fe552677de29d8b82f7594f8a14112f7af92f9781cbd4a73860e463e16b65c37af15c4a9b14f881f1a24520fe3135305672b03c2b2c84c4f512bd3f88c6dea01bfa1512bd3846b2c6a651aea4318bae6199690f9d8e7595b926932d37f13ded7e6a98a6fcd8020dade52b0e837341a837eb50e1485af41bd70bfeedcb7687b8b3aa3a881d98749846579e08d214355a8b88137c30ddda7f6cf3e4c6e6c20d2bc03211c8733a37b15bc299837208a55c00b7d1d6e189ada1f69deb1b101dbb278929c530b2ebc31e457eb8506360737f22d78929c53671435202c8b50c4f97e7e79ee998237156dc1e6e1ae81502458d06257ea5ff03c35cfb6ed01800278b5dfeda1d382eccdb0e790cd48588285f4a29baa2fa13210083720a504f0c001a494c43a4fbd15dcdd1f083778e6b5e1e161f9d6a7be836633fe9dc00b1d606060804c26432e97c334cdb2c32f5dba48b0f5e05660594fa5520c0e7e5d766811d50086be5ad75c1dac6b6e041a80aa0a1a58055ee9800016801ceb6e67056403b9ff01181babd9d4e9e1210000000049454e44ae426082, 0x10b989fd5273bed550d778fa54f22534)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('68332858-3a7c-4c71-adde-ac53f99d9b0a', 0x89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af4000000097048597300000ec300000ec301c76fa864000002d7494441545885ed964d48545114c77f571f2a7e648ae147198a50813246599160b5898216ed82c09db40d5bb508a1add02222a122080aab95b6182bcb5c68059aa34ca8a595a98d33ca640333d38cda7b735bbc719c8fa7e94c3a1bcfe6bd7bffef9e7398f37bff79b01ddb91e41000f79e76c9f51e905222254882577d11b6d6ef096a32fc8c5c293368b56402aab2bc71e2c801c38293333f29db5d60a8f50e8c5157b3df50ebb37ee3587585a176a7d50c900fb89570c1e75b400b48542d80aa69a85a80d756858f6d0e9a1bf2623421563fb79636e79c452076004b29e10d443fd833aad03fbec4bec2d8245a4022f4091a6b62752d180a9012fa057a3e7c0e35b2b7a400cb443aefc614b253dd9c3e9cc9d0a729008410080102fdfa7ee88bbe17ae09811002cbf0f7d01ec13d11358e5003276b6b79dceda2a9be08739f97be492f5ed7042d8d155494151bceb2b377843375951bd69ebd7c15dbc0adf65f389772b9fed0c1b04dc1363945cb9572f27766e90fa60a544de2f107f0f803b8fd819524716a0021062e9fcfc1ed7430389dc1c4d769aed517b0a7288fd66e2f179aac31493c7e2d94245e2da281d2a22c9a2f15e09a19a7e16c3a3595c574f4fb78d1e7a4aa3436c9c29f95773a5e0d9002e0ee932e59638af481b7a3928e8145d2553b572f96e0f5ab787c8bfc8f6833b7231026604e01dda1b273f223207c33e2c5eb72d0dc58be2684e74e5585d6aa2623b4d5206c33b743d085f506900941b85c7c350d581b4229370fc2e8e286104a29e386d0a8f80620d4e770fb51a73c7e28725e5b006135309b3084f138611042200461b29d50cae43aa1944973421dc29b0f9ecbbaa3a608211a42c7fc6fc379c6130610f24f084d0689128430cc0965624e9830841263088b77e5f2c33e0fc40f5a4210a6a52978fd2a103f68ebfa3bbe71df2c6d761b73ce59c3996d4608c441c0ae000c5a2d1940a140e402a95bd4c322a02d7f13aa800bf041cc87eb668506f8fe023acbf7552fc575df0000000049454e44ae426082, 0xba10625b4a17480be5ea3fb4616d9568)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('3c299a8c-85eb-4604-997d-af7a604e9ece', 0x89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af4000000097048597300000ec300000ec301c76fa864000002c5494441545885e596cb4b547114c73fd7464447e64e268186b57113b4aa4d41b40812ff89a24de6a28816ad8284c045d4265c4811b409c1dcd5468a10a41645561a28640b2d2848d47939f7f57bb4b8d769ae77ae33ea0c417d6198f9bdcef9fc1ee7cc81ff5d4679e3e6c397bada02a934522aa4d208a5905297fa44f958f0ed8ffbbf014c6bb10d1080181b19d289ad0e92474f906a69aad3fefe28e728de3c9f04e800724011901180544b133d6673dd01be67bd920bc0052c80fa6fb5ba12e57eff0640487f1d20f406365fea6e2594c6121adbd3d84201e04a8d611838a2b2ed1080172caa26a5a1e02a0aaec2f214454f630b8dd8c506c200526eeb306b4b728eef788f87555a1d7b0252c39a25590f3e7b7418ab1080108abcab585871c9398d731a0be00945d6aeed1dec41a1f41f0a434f36dc794461801aa3e09f028884e1e9a64cdd8c3fedb9cdc4ec33263ade03f0b91a80d6303af9ae6e00d0cf59fa1925de6608c0b4165b814ec004f6c52dca1472b395fad3eda993800748ca92cd16d9f80549142018c8069362ffa8baba7b2bf65bb95f5eb0be18405492c0af05542500096c0413226a4d1df47efef8caf2d2978a9637b2ab3376b1c0f153e7d28043fc49a8b191a128c0b54b174781cb31e4feca52bda7105221840a6ac3a02d1552ea8c08b5fde83ad2bd7ffac9f8785f3954282bbd9d5bd6bd873be930dbb663d895d6b245ce5fbf45ba3d7508ff9aacb1912115a9093727375026fef5d8107d0358aee4c1d25de60bf3dc3ff678c7d6af0c5ca03991c0344d4cd324994c3270f546ecfc1040bee8603b2e73ee022fd65e71c771770c706fe451a4cf0edb69c68f302302b0b25ec4939a416398c1ae6116bfadee18a0061994bdbd1040266f91c9578cc086290450c8af4e4fbd9e3ad32867067cc00fc1ca25d9c74f337de9f6d401208d7f57f596c64f72de26c4d62850f8d9ab34a18aca1f49ad059c47592afe0d927677b5294e6d6d0000000049454e44ae426082, 0x12d817e36d034c205c59dcde3b5e0ee6)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('dad23e4e-fc52-4519-8de2-b9ebe59f75ba', 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, 0xcc77c3fc4dd09c80feaa5b9c830d862c)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('9a07f044-a860-46ec-bec2-c038b90c35a0', 0x89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af4000000097048597300000ec300000ec301c76fa864000002fd494441545885ed974d68d44018869f998c71d57691aaadd4df2a88208ac50a56f0228820164f825e44100485828237c54aaba837c19f835af0e4dd8315bc0a5eb41ead78e841445afce92addae4d32f93c24bb6137a96eed560ffac230c93799bcefbcdf7cf981fff8d7a16a033d03637dc0a55f4d0ca5dca4722c35e721c93512c700da9be44af3c7c10120c812200fceb4cd75613f45d7d1c774770cb70193665e997e8ea540a0ffa2001730990e1c3b7290956d2bc9e572b8ae8beb2ec4755d44046b2d4110606d10f7d1791004789e87effb78be87e779884836b53a05d1fe53990ecc2b790d520204fe1839402a053684feebb7eabec1efa0ebe8e3444056dd1fbf319e9a3497ba3fd899a773e3922c2d62804b27f6b752280ac569f02d04168250a2de421882d67153e0c4bdd60a47a5e38e03468371c0388af3d786e8bc7820d30d0354c877acfe423ee7035028199e8eb4cc99dccc5ce8aa22a0bcf27cce67697e713c3ed51072e3cc280088aba06c7b6ab001e43af5b0cf484139e7859201a600989832f34e0e608464c3352ae7f59203681bd2b0dd3e5b72006345fe08f9d9fea1caf1a205a57bc48f0d63c384fcd3b7f4c40d6dd158a128acc82bb482c9e9647c554b7d2befee18de05f8808d5b11f0b49584fce60987779fa4aa1f1d170a45a1efb0c3c87b61721acef5689ebd0e39d7a379fe26acd7761ff80a8c0363c067e0bbda73fe83eceb6c452b189b48cfdad4ae70348cbc17b6ad8f56fb6a3479d9ecddaad10a0eedcc56f0e88570b67f88ee8ee1ed31f944ec400888b16192db35cba1e425935b9a5425e7eb5a155fa30a65f7669d69bbeaba5b452e2f4fd6ea0901fbf0665f500e682b52212979d077d8e1d56864f9db0f52c9793db67fbb7abaaad5838a035a2bf28ba077d0b276b9a277d0b2658dc27160595375bc6c7b2d9af705e9e0af0408d5a556ce796da9cd647b198f5ed4f51192bac8b437c9e53b779f5c98b5f45960f182a9fbc49bae568469fe3838d0ddc16da2cfe48564fcac34002171dda7040001517d4e03ce3c099098fc7bad80bf8e1fd97bc5faba7c002d0000000049454e44ae426082, 0x3304674dc1f1963e6e67d9e1051df20d)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('980f51d5-69db-4220-a02f-c64b512d53fe', 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, 0xbe41e437c4bcae1e8969012f4871b467)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('4801e65b-1bab-45e7-9e47-de4dd4ae9dc2', 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, 0x7bbb65c3f4a03c88a94e25d71045fba3)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('6334dd1a-255e-4652-86f3-defca25f44b5', 0x89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af4000000097048597300000ec300000ec301c76fa8640000029c494441545885cd963f68136118c67fd5a0b6a6491003150411c145c4c5a1a8a81407a550702868c5a04e2e66920e2ec1d93a65b050101cbc16159c4408a51922ba8416cca04929a7949ad4f48f499a3469d2c421c9e5d2dc5dee3b52da070209dffb3d79eefd9ee7de0ff6185d22c563af3f558cd667e7c23d400928497e9f616d1d36110100f787aee2b01f2193cb93ce16882733fc8eaf13fcf215e018900672c0f6ae0800b87b671880137d7db8dd6ecef6df269e9071d91d0e600bd834cb6549c0e4d4fb960ea8f80e8870090b989999a6b7b7874c26472abdc1ca7a9ab5f50d511aeb0206066e687ae0e787b7f51253e6b32c60bf774028d69604ecf70e084328327594295bfab38e091809dfdb5b01531727f59676df84cf5ebe219e9045b77546c0ec5cb81b70bbec0e57e152ec7b3299e4e4fce52b40b65652a03a0d4dbf8c448fa008fc03e247cf1da264cb4375f02cd53e7fa94e42d302940e0c8e4a9a9b9c9bf34ec9ef4b03487edff6c893e75920c7e132e58345a88edffa34aa0015c9ef5362d28eb7e9081e3e1852be2fa68a4c7ffc0c8d194f4d4419c0e3f550e9aa40f5f251327a4a23de160f2ca68a2c671b7789fcb51fb2c7ebd125b779170cd75727b47995fdea1fe13ff99682e5c4324b6bfaf78b6830a6bb06709c9b9abc9a022281404bc1a9e8f5f340cbcbdee65d90a3c1186722b72ea03aa29d4875236bf1360978f5ee9b816b4f4742a18062c43a546d4f4b7edf2fad9d6d7865c0a974e0f1703f1bb902996c9eade23689950c9bf9222fc6c771d91d8a11ebae5e9da8b637d58d3c382a35a5458d76bc8d183e7aaa2f7607cca4c52caf0d20140a386b4fa98716623d57ab6186d706506b9dae9176c2c8d56a98e1b5742d3772b52884049871b596113b2600cca765d70488a4a5e302aca4a51dfe030db48ef9ac4fb7b30000000049454e44ae426082, 0x07e16c8b284ce56d926d59fab22b0ed1)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('cdd845ca-292a-4b6e-aca8-e613a6c40fc6', 0x89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af4000000097048597300000ec300000ec301c76fa8640000030c494441545885ed964f4814511cc73f333b41c8e66a5dfa0bb96d5142491db40c3b1895d5c9a08b5097a2bf480675a80ed2d1f35282645d423a7508a27f641894d525c4c872a35d24d48b85e238eecc9b371dd65d769d57ed3fe8505f5876debeef6fdef7cd9bdf8785fffad7a5015ceb79e62d9e10aec41612db71b3be5d6c47620b17293d42562cd417ed9c29258091bed8b67b2786aee55d78fbce0380e54079020434ada000e59201e04adf09e079001ee91921615e481cd7c3f5db4b0b3097747216b68464d69698b6c4743c2c472264f916f505b0e605334989e9487e582e49e1213d28e3467f1f602e29f8f2dd4671123e79d245da4974cff9b3390fe90073f322afc501343d40606905525b52960006802d5c869f3ecdbba8bffe1ccddccc8caf743ff6f44020c7633b0ec9a48d2364eae3822df171c4000859b110a99eced1c4e4b778fa7ad5cab5752cf47cebc0452006590cd8dad8c092809ef726d21c3100166896039413d7babd151226c64631a7a798888f0cedd8b54f493e4dd73174bd288e180037eebd7aa9eb7a93dab23f7b30ddd4941a0b21de0d0ef637f7453b4dd5fb932f470c005dd79b8e1dde8ea6e5bf83a3e7afd657052bab01b3148e64503cf97d96ad6f230c377c511a2fb59f24180c12aea9e1f8a90b39f5a5702413203636c5fd556f898d4d298da72f7791edcd56211c51061042bc8bdeeaa92fa4508311c085c238a20c3038d8dfbc709e992762b50cc53bf69ca177f22e9f5f8cb261f860a60d17e4a6c7a57024dd862660669b5a5b8e2cae9be98b762654372c8523c6e2a262540a47947dd7d67e7d7de3a6157173cec4b22c128904f6b29a43c093be68a7afa17ecf11b5d21cd15a1f1ef1bd3e7bbf36130e87d9b03142221e677c7c9c818101a68faaff7ded372f530447a80a56ae333af69cf14dbef9f09e4824025eea11ad59bd1a009517e0e3a3e23962f44edef599c35698aaea2aa4946ca9adc57652a45379017671b6688e680d3d3b7d47b0e5f566e54d461a3f297f6fabe81a7af2fc419d72f217d2602414ac3ca0b5b55faf44d14205ca2545de42ba2ac391fffaabfa0963d3ca4cf61bffaa0000000049454e44ae426082, 0xfcd968a7a394a0df821ff4cfa163776c)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('9d90b5fd-da4e-4e93-a0a4-e991bc15ed3b', 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, 0x1d259b4b906ac56a8515596229219374)
INSERT INTO [dbo].[DisplayIcon] ([DisplayIconId], [Content], [Hash]) VALUES ('9ea69c17-5011-4649-add1-ed7e78477e96', 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, 0xd9f08f902d87380e4cb5d3b2e59c792f)
