﻿SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[HostReservationAvailabilityZonesView]'))
DROP VIEW [dbo].HostReservationAvailabilityZonesView
GO
CREATE VIEW [dbo].[HostReservationAvailabilityZonesView]
AS
	SELECT r.HostReservationId, az.Name AvailabilityZone, 0 as IsVPC
		FROM [DynamicOps.AmazonWSModel].AmazonHostReservations r
			JOIN [DynamicOps.AmazonWSModel].CloudReservationAvailabilityZone raz
				ON r.Id = raz.CloudReservations_Id
			JOIN [DynamicOps.AmazonWSModel].AvailabilityZones az
				ON raz.AvailabilityZones_Id = az.Id
	UNION
	SELECT r.HostReservationId, az.Name AvailabilityZone, 1 as IsVPC
		FROM [DynamicOps.AmazonWSModel].AmazonHostReservations r
			JOIN [DynamicOps.AmazonWSModel].CloudReservationSubnet rsn
				ON r.Id = rsn.CloudReservations_Id
			JOIN [DynamicOps.AmazonWSModel].Subnets sn
				ON rsn.Subnets_Id = sn.Id
			JOIN [DynamicOps.AmazonWSModel].AvailabilityZones az
				ON sn.AvailabilityZone_Id = az.Id
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ImagesRegionView]'))
DROP VIEW [dbo].ImagesRegionView
GO
CREATE VIEW [dbo].ImagesRegionView
AS
	SELECT i.Id Images_Id, r.Name Region
	FROM [DynamicOps.AmazonWSModel].Images i
	JOIN (
		SELECT Images_Id, min(Regions_Id) Regions_Id
		FROM [DynamicOps.AmazonWSModel].RegionImage
		GROUP BY Images_Id
	) ri
		ON i.Id = ri.Images_Id
	JOIN [DynamicOps.AmazonWSModel].Regions r
		ON ri.Regions_Id = r.Id
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[HostReservationEbsVolumeCapacity]'))
DROP VIEW [dbo].HostReservationEbsVolumeCapacity
GO
CREATE VIEW [dbo].[HostReservationEbsVolumeCapacity]
AS
	SELECT  hr.HostReservationID, 
			ahr.StorageQuota - ISNULL(SUM(CAST(v.Size AS float)), 0) AS AvailableCapacity
		FROM	[DynamicOps.AmazonWSModel].AmazonHostReservations AS ahr 
			INNER JOIN dbo.HostReservation AS hr ON hr.HostReservationID = ahr.HostReservationId 
			LEFT JOIN dbo.VirtualMachine AS vm ON vm.HostReservationID = hr.HostReservationID 
			LEFT JOIN [DynamicOps.AmazonWSModel].Instances AS i ON i.VirtualMachineId = vm.VirtualMachineID 
			LEFT JOIN [DynamicOps.AmazonWSModel].ElasticBlockStorageVolumes AS v ON v.Instance_Id = i.Id
		GROUP BY hr.HostReservationID, ahr.StorageQuota
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AmiOfMachineToHosts]') AND type = N'IF')
DROP FUNCTION [dbo].[AmiOfMachineToHosts]
GO
CREATE FUNCTION [dbo].[AmiOfMachineToHosts] (@VirtualMachineID UNIQUEIDENTIFIER)
	RETURNS TABLE 
	AS
	RETURN SELECT r.HostId
	FROM VirtualMachine m
	JOIN [DynamicOps.AmazonWSModel].AmazonVirtualMachineTemplates abp
		ON m.VirtualMachineTemplateID = abp.VirtualMachineTemplateId
	JOIN [DynamicOps.AmazonWSModel].Images i
		ON abp.Image_Id = i.Id
	JOIN [DynamicOps.AmazonWSModel].RegionImage ri
		ON i.Id = ri.Images_Id
	JOIN [DynamicOps.AmazonWSModel].Regions r
		ON ri.Regions_Id = r.Id
	WHERE m.VirtualMachineID = @VirtualMachineID
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Split]') AND type = N'TF')
DROP FUNCTION [dbo].[Split]
GO
CREATE FUNCTION [dbo].[Split](@String nvarchar(MAX), @Delimiter nchar(1))       
	RETURNS @TempTable TABLE (Item nvarchar(MAX))       
	AS
	BEGIN       
		DECLARE @idx int       
		DECLARE @slice nvarchar(MAX)       

		SELECT @idx = 1       
		IF LEN(@String) < 1 OR @String IS NULL 
			RETURN       

		WHILE @idx != 0       
		BEGIN       
			SET @idx = CHARINDEX(@Delimiter, @String)       
			IF @idx != 0       
				SET @slice = LEFT(@String, @idx - 1)       
			ELSE       
				SET @slice = @String       

			IF(LEN(@slice) > 0)  
				INSERT INTO @TempTable(Item) VALUES(@slice)       

			SET @String = RIGHT(@String, LEN(@String) - @idx)       
			IF LEN(@String) = 0 BREAK       
		END   

		RETURN       
	END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SecurityGroupsToReservations]') AND type = N'TF')
DROP FUNCTION [dbo].[SecurityGroupsToReservations]
GO
CREATE FUNCTION [dbo].[SecurityGroupsToReservations] (@VirtualMachineId uniqueidentifier)
RETURNS @ReservationList TABLE (HostReservationId uniqueidentifier)
AS
	BEGIN
		DECLARE @SecurityGroup nvarchar(max)
		DECLARE @CountOfSecurityGroups int

		SET @SecurityGroup = dbo.GetVirtualMachinePropertyValue(@VirtualMachineId, N'__amazon.securityGroups')
		SELECT @CountOfSecurityGroups = COUNT(*) FROM dbo.Split(@SecurityGroup, ',')
	
		IF (@SecurityGroup IS NULL OR @SecurityGroup = '')
		BEGIN
			-- Return all hostreservations
			INSERT INTO @ReservationList 
			SELECT HostReservationId FROM HostReservation
		END		
		ELSE
		BEGIN
			-- Return all hostreservations that contain all of the security groups
			INSERT INTO @ReservationList
			SELECT hr.HostReservationId
				FROM dbo.HostReservation hr 
					JOIN [DynamicOps.AmazonWSModel].[AmazonHostReservations] ahr ON hr.HostReservationID = ahr.HostReservationId
					JOIN [DynamicOps.AmazonWSModel].[CloudReservationSecurityGroup] crsg ON ahr.Id = crsg.CloudReservations_Id
					JOIN [DynamicOps.AmazonWSModel].[SecurityGroups] sg ON crsg.SecurityGroups_Id = sg.Id
					JOIN (SELECT sg2.Name FROM [DynamicOps.AmazonWSModel].[SecurityGroups] sg2
						JOIN dbo.Split(@SecurityGroup, ',') mysg ON mysg.Item = sg2.Id) sgnames ON sgnames.Name = sg.Name
				GROUP BY hr.HostReservationId
				HAVING COUNT(DISTINCT sg.Name) = @CountOfSecurityGroups
		END
	
		RETURN 
	END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AvailabilityZoneOrSubnetToReservations]') AND type = N'TF')
DROP FUNCTION [dbo].[AvailabilityZoneOrSubnetToReservations]
GO
CREATE FUNCTION [dbo].[AvailabilityZoneOrSubnetToReservations] (@VirtualMachineId uniqueidentifier, @AvailabilityZone nvarchar(256))
RETURNS @ReservationList TABLE (HostReservationId uniqueidentifier)
AS
	BEGIN
		DECLARE @SubnetId int
		DECLARE @AdvancedCapabilitiesMode bit
	
		SET @SubnetId = dbo.GetVirtualMachinePropertyValue(@VirtualMachineId, N'__amazon.subnetId')
		SET @AdvancedCapabilitiesMode = dbo.GetVirtualMachinePropertyValue(@VirtualMachineId, N'__amazon_advancedCapabilitiesMode')
		
		IF (@AdvancedCapabilitiesMode != 1)
		BEGIN
			IF (@AvailabilityZone IS NOT NULL AND @AvailabilityZone != '')
			BEGIN
				-- Return all reservations containing the requested location
				INSERT INTO @ReservationList 
				SELECT hr.HostReservationId 
					FROM HostReservation hr
						JOIN HostReservationAvailabilityZonesView HRAZ ON hr.HostReservationId = HRAZ.HostReservationId
					WHERE @AvailabilityZone = HRAZ.AvailabilityZone
				
				RETURN
			END			
		END
		ELSE
		BEGIN		
			-- It is assumed either a subnet OR availability zone will be specified.  If a subnet is specified it will take precedence
			IF (@SubnetId IS NOT NULL)
			BEGIN
				-- Return all hostreservations where the subnet exists
				INSERT INTO @ReservationList
				SELECT hr.HostReservationId
					FROM dbo.HostReservation hr 
						JOIN [DynamicOps.AmazonWSModel].[AmazonHostReservations] ahr ON hr.HostReservationID = ahr.HostReservationId
						JOIN [DynamicOps.AmazonWSModel].[CloudReservationSubnet] crs ON ahr.Id = crs.CloudReservations_Id
						JOIN [DynamicOps.AmazonWSModel].[Subnets] s ON crs.Subnets_Id = @SubnetId
				RETURN				
			END
			ELSE
			BEGIN
				IF (@AvailabilityZone IS NOT NULL AND @AvailabilityZone != '')							
				BEGIN
					-- Return all non-VPC hostreservations where the availability zone exists
					INSERT INTO @ReservationList
					SELECT hr.HostReservationId 
					FROM HostReservation hr
						JOIN HostReservationAvailabilityZonesView HRAZ ON hr.HostReservationId = HRAZ.HostReservationId
					WHERE @AvailabilityZone = HRAZ.AvailabilityZone	
						AND IsVPC = 0
						
					RETURN
				END				
				ELSE
				BEGIN
					-- Return all non-VPC hostreservations
					INSERT INTO @ReservationList
					SELECT HRAZ.HostReservationId 
					FROM HostReservationAvailabilityZonesView HRAZ
					WHERE IsVPC = 0
						
					RETURN
				END				
			END	
			RETURN
		END
		
		-- If no cases match, return all reservations
		INSERT INTO @ReservationList 
		SELECT hr.HostReservationId 
			FROM HostReservation hr
	
		RETURN 
	END
GO
