#!/bin/bash

#echo "[Globals]" > ./results.txt
echo "<results>" > ../External/results.xml

#Find all the ip adresses, exclude local and VPN
/sbin/ifconfig | grep 'inet addr:' | grep -v '127.0.0.1' | grep 'Bcast' > ./temp_address.txt

# Control variable for number of IP address
i=0

# Write the ip address in the config file
while read line
do 
       ipTemp=$(/usr/bin/env perl -e "print substr('$line',index('$line',':')+1,index('$line','Bcast')-index('$line',':')-3);")
       echo "<parameter name=\"VirtualMachine.Network${i}.IPAddress\">$ipTemp</parameter>" >> ../External/results.xml || Error 6
       let "i+=1"
done < ./temp_address.txt

# Write the number of Ip address
#echo "VirtualMachine.Network.IpNumber=$i" >> ./results.txt || Error 6
echo "</results>" >> ../External/results.xml
chmod 644 ../External/results.xml

# Delete temp file
rm -rf ./temp_address.txt

exit 0
