@echo off

rem ##############################################################################
rem #
rem # Copyright (c) 2013 VMware, Inc. All rights reserved.
rem # -- VMware Confidential
rem #
rem ##############################################################################

rem Starts NGC and waits for deployment to finish, which is indicated by the presence
rem of the .started file
rem Pre-conditions
rem      DOT_STARTED variable set
rem      vspherewebclientsvc stopped
rem      .started file deleted

rem Start NGC
call "%~dp0..\common" Starting vSphere Web Client
net start vspherewebclientsvc 2>&1
if ERRORLEVEL 1 (
   set last_error=Failed to start vSphere Web Client
   exit /B 1
)

rem poll for .started file which indicates deployment is finished. Times out after 60 tries (15 minutes)
call "%~dp0..\common" Waiting for web client to start
echo Starting vSphere Web Client... (this may take some time) 1>&2
set /a TRIES=60
:waitForStart
if "%TRIES%" == "0" (
   set last_error=Timed out waiting for vSphere Web Client to start
   exit /B 1
)

call "%~dp0..\common" time out in %TRIES%
call "%~dp0..\common" Waiting for 15 seconds
timeout /T 15 /NOBREAK > NUL
if EXIST "%DOT_STARTED%" (
   goto :endWaitForStart
)

set /a TRIES=%TRIES%-1
goto :waitForStart
:endWaitForStart

call "%~dp0..\common" vSphere Web Client started
echo vSphere Web Client started. 1>&2
exit /B 0
