@echo off

rem ##############################################################################
rem #
rem # Copyright (c) 2013 VMware, Inc. All rights reserved.
rem # -- VMware Confidential
rem #
rem ##############################################################################

if %gen_cert_key_length% lss 2048 (
	call "%~dp0common.bat" Key length should be more than 2048. Change the key length value in ssl-environment.bat file
	exit /b 3
)



set csr_config_file_name=%component_csr_output_folder%\csr_openssl.cfg
if exist %csr_config_file_name% del /q %csr_config_file_name%
rem write the config file
echo [ req ] > %csr_config_file_name%
echo default_bits = %gen_cert_key_length% >> %csr_config_file_name%
echo default_keyfile = rui.key >> %csr_config_file_name%
echo distinguished_name = req_distinguished_name >> %csr_config_file_name%
echo encrypt_key = no >> %csr_config_file_name%
echo prompt = no >> %csr_config_file_name%
echo string_mask = nombstr >> %csr_config_file_name%
echo req_extensions = v3_req >> %csr_config_file_name%
echo. >> %csr_config_file_name%
echo [ v3_req ] >> %csr_config_file_name%
echo basicConstraints = CA:FALSE >> %csr_config_file_name%
echo keyUsage = digitalSignature, keyEncipherment, dataEncipherment >> %csr_config_file_name%
echo extendedKeyUsage = serverAuth, clientAuth >> %csr_config_file_name%
echo subjectAltName = IP:%gen_cert_server_ip%, DNS:%gen_cert_server_short_name%, DNS:%gen_cert_server_fqdn% >> %csr_config_file_name%
echo. >> %csr_config_file_name%
echo [ req_distinguished_name ] >> %csr_config_file_name%
echo countryName = %gen_cert_country% >> %csr_config_file_name%
echo stateOrProvinceName = %gen_cert_state% >> %csr_config_file_name%
echo localityName = %gen_cert_locality_name% >> %csr_config_file_name%
echo 0.organizationName = %gen_cert_organization_name% >> %csr_config_file_name%
echo organizationalUnitName = %gen_cert_organizational_unit_name_internal% >> %csr_config_file_name%
echo commonName = %gen_cert_common_name% >> %csr_config_file_name%

call "%~dp0common.bat" Created the openssl config file : %csr_config_file_name%

rem generate a csr & keys
rem rui-orig.key is the private key in des, rui.key is the private key in rsa format
"%~dp0openssl\openssl" req -new -nodes -out "%component_csr_output_folder%\rui.csr" -keyout "%component_csr_output_folder%\rui-orig.key" -config %csr_config_file_name%

rem check for errors
if errorlevel 1 (
	exit /b %errorlevel%
)
call "%~dp0common.bat" Created the CSR and private key in the output folder

"%~dp0openssl\openssl" rsa -in "%component_csr_output_folder%\rui-orig.key" -out "%component_csr_output_folder%\rui.key"
rem rui.csr is the resultant CSR

rem check for errors
if errorlevel 1 (
	exit /b %errorlevel%
)
call "%~dp0common.bat" Converted the private key in RSA format.

rem delete rui-orig.key
del /q "%component_csr_output_folder%\rui-orig.key"

exit /b 0


