/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.fault.ADIDSAlreadyExistFault;
import com.vmware.vim.binding.sso.admin.fault.CertificateDeletionFault;
import com.vmware.vim.binding.sso.admin.fault.DirectoryServiceConnectionFault;
import com.vmware.vim.binding.sso.admin.fault.DomainManagerFault;
import com.vmware.vim.binding.sso.admin.fault.DomainNotFoundFault;
import com.vmware.vim.binding.sso.admin.fault.DuplicateDomainNameFault;
import com.vmware.vim.binding.sso.admin.fault.DuplicateSolutionCertificateFault;
import com.vmware.vim.binding.sso.admin.fault.ExternalSTSCertChainInvalidTrustedPathFault;
import com.vmware.vim.binding.sso.admin.fault.ExternalSTSExtraneousCertsInCertChainFault;
import com.vmware.vim.binding.sso.admin.fault.GroupCyclicDependencyFault;
import com.vmware.vim.binding.sso.admin.fault.HostNotJoinedRequiredDomainFault;
import com.vmware.vim.binding.sso.admin.fault.InvalidPasswordPolicyFault;
import com.vmware.vim.binding.sso.admin.fault.LocalOSDomainRegistrationFault;
import com.vmware.vim.binding.sso.admin.fault.NativeADRegistrationFault;
import com.vmware.vim.binding.sso.admin.fault.NoSuchExternalSTSConfigFault;
import com.vmware.vim.binding.sso.admin.fault.NoSuchRelyingPartyFault;
import com.vmware.vim.binding.sso.admin.fault.PasswordPolicyViolationFault;
import com.vmware.vim.binding.sso.admin.fault.SmtpConfigNotSetFault;
import com.vmware.vim.binding.sso.fault.InternalFault;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.sso.fault.InvalidPrincipalFault;
import com.vmware.vim.binding.sso.fault.NoDomainSearchPermission;
import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.binding.sso.fault.RuntimeServiceFault;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.NotSupported;
import com.vmware.vim.sso.admin.client.InvalidCredentialsException;
import com.vmware.vim.sso.admin.exception.ADIDSAlreadyExistException;
import com.vmware.vim.sso.admin.exception.Bug;
import com.vmware.vim.sso.admin.exception.CertificateDeletionException;
import com.vmware.vim.sso.admin.exception.DirectoryServiceConnectionException;
import com.vmware.vim.sso.admin.exception.DomainManagerException;
import com.vmware.vim.sso.admin.exception.DomainNotFoundException;
import com.vmware.vim.sso.admin.exception.DuplicateDomainNameException;
import com.vmware.vim.sso.admin.exception.DuplicateSolutionCertificateException;
import com.vmware.vim.sso.admin.exception.ExternalSTSCertChainInvalidTrustedPathException;
import com.vmware.vim.sso.admin.exception.ExternalSTSExtraneousCertsInCertChainException;
import com.vmware.vim.sso.admin.exception.GroupCyclicDependencyException;
import com.vmware.vim.sso.admin.exception.HostNotJoinedRequiredDomainException;
import com.vmware.vim.sso.admin.exception.InternalError;
import com.vmware.vim.sso.admin.exception.InvalidPasswordPolicyException;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.LocalOSDomainRegistrationException;
import com.vmware.vim.sso.admin.exception.NativeADRegistrationException;
import com.vmware.vim.sso.admin.exception.NoDomainSearchPermissionException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NoSuchExternalSTSConfigException;
import com.vmware.vim.sso.admin.exception.NoSuchRelyingPartyException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.PasswordPolicyViolationException;
import com.vmware.vim.sso.admin.exception.ServiceException;
import com.vmware.vim.sso.admin.exception.SmtpConfigNotSetException;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.sso.admin.util.CertificateUtil;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vim.vmomi.core.exception.InternalException;

public abstract class VmomiClientCommand<T> {
    public final T execute() throws ServiceException, SystemException {
        try {
            return this.actionCommand();
        }
        catch (SslException e) {
            if (e.getCause() instanceof CertificateValidationException) {
                CertificateValidationException cause = (CertificateValidationException)e.getCause();
                throw new com.vmware.vim.sso.admin.exception.CertificateValidationException(e.getMessage(), (Throwable)cause, cause.getCertificateChain(), cause.getThumbprint());
            }
            throw new InternalError(e.getMessage(), e.getCause());
        }
        catch (ConnectionException e) {
            throw new com.vmware.vim.sso.admin.exception.ConnectionException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidPrincipalFault e) {
            throw new InvalidPrincipalException("" + e.getPrincipal());
        }
        catch (ADIDSAlreadyExistFault e) {
            throw new ADIDSAlreadyExistException(e.getDomainName());
        }
        catch (GroupCyclicDependencyFault e) {
            throw new GroupCyclicDependencyException(e.getGroupBeingAdded(), e.getExistingGroup());
        }
        catch (DomainNotFoundFault e) {
            throw new DomainNotFoundException(e.getDomainName());
        }
        catch (DuplicateDomainNameFault e) {
            throw new DuplicateDomainNameException(e.getDomainName(), e.getDomainAlias());
        }
        catch (DuplicateSolutionCertificateFault e) {
            throw new DuplicateSolutionCertificateException(e.getMessage());
        }
        catch (NoSuchRelyingPartyFault e) {
            throw new NoSuchRelyingPartyException(e.getRelyingPartyName());
        }
        catch (PasswordPolicyViolationFault e) {
            throw new PasswordPolicyViolationException(e.getMessage());
        }
        catch (InvalidPasswordPolicyFault e) {
            throw new InvalidPasswordPolicyException(e.getMessage());
        }
        catch (CertificateDeletionFault e) {
            throw new CertificateDeletionException(CertificateUtil.decodeCertificate((String)e.getCertificate()));
        }
        catch (DirectoryServiceConnectionFault e) {
            throw new DirectoryServiceConnectionException(e.getMessage(), e.getUri());
        }
        catch (ExternalSTSCertChainInvalidTrustedPathFault e) {
            throw new ExternalSTSCertChainInvalidTrustedPathException(e.getIssuerName());
        }
        catch (ExternalSTSExtraneousCertsInCertChainFault e) {
            throw new ExternalSTSExtraneousCertsInCertChainException(e.getIssuerName());
        }
        catch (NoSuchExternalSTSConfigFault e) {
            throw new NoSuchExternalSTSConfigException(e.getIssuerName());
        }
        catch (HostNotJoinedRequiredDomainFault e) {
            throw new HostNotJoinedRequiredDomainException(e.getRequiredDomainName(), e.getJoinedDomainName());
        }
        catch (DomainManagerFault e) {
            throw new DomainManagerException(e.getDomainName(), e.getErrorCode() != null ? e.getErrorCode() : -1);
        }
        catch (SmtpConfigNotSetFault e) {
            throw new SmtpConfigNotSetException(e.getMessage());
        }
        catch (NotAuthenticated e) {
            throw new NotAuthenticatedException(e.getMessage());
        }
        catch (ServiceFault e) {
            throw new InternalError("Unhadled VMODL fault.", (Throwable)e);
        }
        catch (InternalException e) {
            throw new InternalError(e.getMessage(), e.getCause());
        }
        catch (InvalidCredentials e) {
            throw new InvalidCredentialsException(e.getMessage());
        }
        catch (NoPermission e) {
            throw new NoPermissionException(e.getMessage());
        }
        catch (LocalOSDomainRegistrationFault e) {
            throw new LocalOSDomainRegistrationException(e.getMessage());
        }
        catch (InvalidArgument e) {
            throw new IllegalArgumentException(e.getMessage(), e.getCause());
        }
        catch (NotSupported e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
        catch (InternalFault e) {
            throw new InternalError(e.getMessage(), e.getCause());
        }
        catch (NoDomainSearchPermission e) {
            throw new NoDomainSearchPermissionException(e.getMessage(), e.getCause());
        }
        catch (NativeADRegistrationFault e) {
            throw new NativeADRegistrationException(e.getMessage(), e.getCause());
        }
        catch (RuntimeServiceFault e) {
            throw new InternalError("Unhadled VMODL fault.", (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalError("General failure.", (Throwable)e);
        }
    }

    public final T executeEnsuringNoDomainError() {
        try {
            return this.execute();
        }
        catch (ServiceException e) {
            throw new Bug((Throwable)e);
        }
    }

    public final <T1 extends ServiceException> T executeEnsuringDomainErrorIs(Class<T1> c1) throws T1 {
        return this.executeEnsuringDomainErrorIs(c1, c1, c1, c1, c1);
    }

    public final <T1 extends ServiceException, T2 extends ServiceException> T executeEnsuringDomainErrorIs(Class<T1> c1, Class<T2> c2) throws T1, T2 {
        return this.executeEnsuringDomainErrorIs(c1, c2, c2, c2, c2);
    }

    public final <T1 extends ServiceException, T2 extends ServiceException, T3 extends ServiceException> T executeEnsuringDomainErrorIs(Class<T1> c1, Class<T2> c2, Class<T3> c3) throws T1, T2, T3 {
        return this.executeEnsuringDomainErrorIs(c1, c2, c3, c3, c3);
    }

    public final <T1 extends ServiceException, T2 extends ServiceException, T3 extends ServiceException, T4 extends ServiceException> T executeEnsuringDomainErrorIs(Class<T1> c1, Class<T2> c2, Class<T3> c3, Class<T4> c4) throws T1, T2, T3, T4 {
        return this.executeEnsuringDomainErrorIs(c1, c2, c3, c4, c4);
    }

    private final <T1 extends ServiceException, T2 extends ServiceException, T3 extends ServiceException, T4 extends ServiceException, T5 extends ServiceException> T executeEnsuringDomainErrorIs(Class<T1> c1, Class<T2> c2, Class<T3> c3, Class<T4> c4, Class<T5> c5) throws T1, T2, T3, T4, T5 {
        try {
            T res = this.execute();
            return res;
        }
        catch (ServiceException e) {
            if (c1.equals(((Object)((Object)e)).getClass())) {
                throw e;
            }
            if (c2.equals(((Object)((Object)e)).getClass())) {
                throw e;
            }
            if (c3.equals(((Object)((Object)e)).getClass())) {
                throw e;
            }
            if (c4.equals(((Object)((Object)e)).getClass())) {
                throw e;
            }
            if (c5.isAssignableFrom(((Object)((Object)e)).getClass())) {
                throw e;
            }
            throw new Bug((Throwable)e);
        }
    }

    public abstract T actionCommand() throws ServiceFault, RuntimeServiceFault;
}

