/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.admin.fault.NoSuchRelyingPartyFault;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.sso.admin.PasswordExpirationConfig;
import com.vmware.vim.sso.admin.ServerConfigurator;
import com.vmware.vim.sso.admin.TrustedSTSConfig;
import com.vmware.vim.sso.admin.client.vmomi.impl.SdkVmodlTypeConversions;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.CertificateDeletionException;
import com.vmware.vim.sso.admin.exception.ExternalSTSCertChainInvalidTrustedPathException;
import com.vmware.vim.sso.admin.exception.ExternalSTSExtraneousCertsInCertChainException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NoSuchExternalSTSConfigException;
import com.vmware.vim.sso.admin.exception.NoSuchRelyingPartyException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;
import com.vmware.vim.sso.admin.util.CertificateUtil;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;

final class ServerConfiguratorImpl
implements ServerConfigurator {
    private final ConfigurationManagementService _vmomiService;

    public ServerConfiguratorImpl(ConfigurationManagementService vmomiService) {
        assert (vmomiService != null);
        this._vmomiService = vmomiService;
    }

    public long getClockTolerance() throws SystemException {
        return (Long)new VmomiClientCommand<Long>(){

            @Override
            public Long actionCommand() throws ServiceFault, SystemException {
                return ServerConfiguratorImpl.this._vmomiService.getClockTolerance();
            }
        }.executeEnsuringNoDomainError();
    }

    public int getDelegationCount() throws SystemException, NotAuthenticatedException {
        return (Integer)new VmomiClientCommand<Integer>(){

            @Override
            public Integer actionCommand() throws ServiceFault, SystemException {
                return ServerConfiguratorImpl.this._vmomiService.getDelegationCount();
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public Set<CertPath> getKnownCertificateChains() throws SystemException {
        return (Set)new VmomiClientCommand<Set<CertPath>>(){

            @Override
            public Set<CertPath> actionCommand() throws ServiceFault, SystemException {
                return SdkVmodlTypeConversions.fromVmodl(ServerConfiguratorImpl.this._vmomiService.getKnownCertificateChains());
            }
        }.executeEnsuringNoDomainError();
    }

    public long getMaximumBearerTokenLifetime() throws SystemException, NotAuthenticatedException {
        return (Long)new VmomiClientCommand<Long>(){

            @Override
            public Long actionCommand() throws ServiceFault, SystemException {
                return ServerConfiguratorImpl.this._vmomiService.getMaximumBearerTokenLifetime();
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public long getMaximumHoKTokenLifetime() throws SystemException, NotAuthenticatedException {
        return (Long)new VmomiClientCommand<Long>(){

            @Override
            public Long actionCommand() throws ServiceFault, SystemException {
                return ServerConfiguratorImpl.this._vmomiService.getMaximumHoKTokenLifetime();
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public PasswordExpirationConfig getPasswordExpirationConfiguration() throws SystemException, NotAuthenticatedException {
        return (PasswordExpirationConfig)new VmomiClientCommand<PasswordExpirationConfig>(){

            @Override
            public PasswordExpirationConfig actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.PasswordExpirationConfig)ServerConfiguratorImpl.this._vmomiService.getPasswordExpirationConfiguration());
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public int getRenewCount() throws SystemException, NotAuthenticatedException {
        return (Integer)new VmomiClientCommand<Integer>(){

            @Override
            public Integer actionCommand() throws ServiceFault, SystemException {
                return ServerConfiguratorImpl.this._vmomiService.getRenewCount();
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    @Deprecated
    public Set<X509Certificate> getTrustedCertificates() throws SystemException {
        return (Set)new VmomiClientCommand<Set<X509Certificate>>(){

            @Override
            public Set<X509Certificate> actionCommand() throws ServiceFault, SystemException {
                return new HashSet<X509Certificate>(Arrays.asList(CertificateUtil.decodeCertificates((String[])ServerConfiguratorImpl.this._vmomiService.getTrustedCertificates())));
            }
        }.executeEnsuringNoDomainError();
    }

    public Set<X509Certificate> getIssuersCertificates() {
        return (Set)new VmomiClientCommand<Set<X509Certificate>>(){

            @Override
            public Set<X509Certificate> actionCommand() throws ServiceFault, SystemException {
                return new HashSet<X509Certificate>(Arrays.asList(CertificateUtil.decodeCertificates((String[])ServerConfiguratorImpl.this._vmomiService.getIssuersCertificates())));
            }
        }.executeEnsuringNoDomainError();
    }

    public Set<CertPath> getExternalIdpTrustedCertificateChains() {
        return (Set)new VmomiClientCommand<Set<CertPath>>(){

            @Override
            public Set<CertPath> actionCommand() throws ServiceFault, SystemException {
                return SdkVmodlTypeConversions.fromVmodl(ServerConfiguratorImpl.this._vmomiService.getExternalIdpTrustedCertificateChains());
            }
        }.executeEnsuringNoDomainError();
    }

    public boolean deleteTrustedCertificate(final String fingerprint) throws CertificateDeletionException, NotAuthenticatedException, NoPermissionException {
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws ServiceFault, SystemException {
                return ServerConfiguratorImpl.this._vmomiService.deleteTrustedCertificate(fingerprint);
            }
        }.executeEnsuringDomainErrorIs(CertificateDeletionException.class, NotAuthenticatedException.class);
    }

    public void setClockTolerance(final long milliseconds) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validatePositiveNumber((long)milliseconds, (String)"Milliseconds");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                ServerConfiguratorImpl.this._vmomiService.setClockTolerance(milliseconds);
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void setDelegationCount(final int delegationCount) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validatePositiveNumber((long)delegationCount, (String)"Delegation count");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                ServerConfiguratorImpl.this._vmomiService.setDelegationCount(delegationCount);
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void setMaximumBearerTokenLifetime(final long maxLifetime) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validatePositiveNumber((long)maxLifetime, (String)"Maximum bearer token lifetime");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                ServerConfiguratorImpl.this._vmomiService.setMaximumBearerTokenLifetime(maxLifetime);
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void setMaximumHoKTokenLifetime(final long maxLifetime) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validatePositiveNumber((long)maxLifetime, (String)"Maximum HOK token lifetime");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                ServerConfiguratorImpl.this._vmomiService.setMaximumHoKTokenLifetime(maxLifetime);
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void setNewSignerIdentity(final PrivateKey signingKey, final CertPath signingCertificateChain) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)signingKey, (String)"Signing key");
        ValidateUtil.validateNotNull((Object)signingCertificateChain, (String)"Signing certificate chain");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                ServerConfiguratorImpl.this._vmomiService.setNewSignerIdentity(SdkVmodlTypeConversions.toVmodl(signingKey), SdkVmodlTypeConversions.toVmodl(signingCertificateChain));
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void setRenewCount(final int renewCount) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validatePositiveNumber((long)renewCount, (String)"Renew count");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                ServerConfiguratorImpl.this._vmomiService.setRenewCount(renewCount);
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void updatePasswordExpirationConfiguration(final PasswordExpirationConfig config) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)config, (String)"Password expiration config");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                ServerConfiguratorImpl.this._vmomiService.updatePasswordExpirationConfiguration(VmodlTypeConversions.toVmodl((PasswordExpirationConfig)config));
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void importSAMLMetadata(final Document samlConfigDoc) throws NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotNull((Object)samlConfigDoc, (String)"SAML configuration");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                String domStr;
                try {
                    domStr = VmodlTypeConversions.domToVmodl((Document)samlConfigDoc);
                }
                catch (TransformerException e) {
                    throw new IllegalStateException(e);
                }
                ServerConfiguratorImpl.this._vmomiService.importSAMLMetadata(domStr);
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void deleteRelyingParty(final String relyingPartyName) throws NoSuchRelyingPartyException, NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotEmpty((Object)relyingPartyName, (String)"Relying party name");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws NoSuchRelyingPartyFault, NotAuthenticated {
                ServerConfiguratorImpl.this._vmomiService.deleteRelyingParty(relyingPartyName);
                return null;
            }
        }.executeEnsuringDomainErrorIs(NoSuchRelyingPartyException.class, NotAuthenticatedException.class);
    }

    public CertPath getExternalIdpTrustedCertificateChain(final String entityId) {
        return (CertPath)new VmomiClientCommand<CertPath>(){

            @Override
            public CertPath actionCommand() throws ServiceFault, SystemException {
                return SdkVmodlTypeConversions.fromVmodl(ServerConfiguratorImpl.this._vmomiService.getExternalIdpTrustedCertificateChain(entityId));
            }
        }.executeEnsuringNoDomainError();
    }

    public void importTrustedSTSConfiguration(final TrustedSTSConfig stsConfig) throws NotAuthenticatedException, NoPermissionException, ExternalSTSCertChainInvalidTrustedPathException, ExternalSTSExtraneousCertsInCertChainException {
        ValidateUtil.validateNotEmpty((Object)stsConfig.getIssuerName(), (String)"issuerName");
        ValidateUtil.validateNotNull((Object)stsConfig.getCertPath(), (String)"certPath");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                ServerConfiguratorImpl.this._vmomiService.importTrustedSTSConfiguration(VmodlTypeConversions.toVmodl((TrustedSTSConfig)stsConfig));
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class, ExternalSTSCertChainInvalidTrustedPathException.class, ExternalSTSExtraneousCertsInCertChainException.class);
    }

    public void removeTrustedSTSConfiguration(final String issuerName) throws NotAuthenticatedException, NoPermissionException, NoSuchExternalSTSConfigException {
        ValidateUtil.validateNotEmpty((Object)issuerName, (String)"issuerName");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                ServerConfiguratorImpl.this._vmomiService.removeTrustedSTSConfiguration(issuerName);
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class, NoSuchExternalSTSConfigException.class);
    }

    public void importExternalIDPConfiguration(final Document configDoc) throws NotAuthenticatedException, NoPermissionException, ExternalSTSCertChainInvalidTrustedPathException, ExternalSTSExtraneousCertsInCertChainException {
        ValidateUtil.validateNotNull((Object)configDoc, (String)"configDoc");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                String domStr;
                try {
                    domStr = VmodlTypeConversions.domToVmodl((Document)configDoc);
                }
                catch (TransformerException e) {
                    throw new IllegalStateException(e);
                }
                ServerConfiguratorImpl.this._vmomiService.importExternalIDPConfiguration(domStr);
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class, ExternalSTSCertChainInvalidTrustedPathException.class, ExternalSTSExtraneousCertsInCertChainException.class);
    }
}

