/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.PrincipalDiscoveryService;
import com.vmware.vim.binding.sso.admin.PrincipalManagementService;
import com.vmware.vim.binding.sso.admin.fault.PasswordPolicyViolationFault;
import com.vmware.vim.binding.sso.fault.InvalidPrincipalFault;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.PersonDetails;
import com.vmware.vim.sso.admin.PersonUser;
import com.vmware.vim.sso.admin.PrincipalSelfManagement;
import com.vmware.vim.sso.admin.SolutionDetails;
import com.vmware.vim.sso.admin.client.vmomi.impl.SdkVmodlTypeConversions;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.PasswordPolicyViolationException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;

public class PrincipalSelfManagementImpl
implements PrincipalSelfManagement {
    private final PrincipalManagementService _managementSvc;
    private final PrincipalDiscoveryService _discoverySvc;

    public PrincipalSelfManagementImpl(PrincipalManagementService managementSvc, PrincipalDiscoveryService discoverySvc) {
        assert (managementSvc != null);
        assert (discoverySvc != null);
        this._managementSvc = managementSvc;
        this._discoverySvc = discoverySvc;
    }

    public void deleteSolutionUser() throws InvalidPrincipalException, NotAuthenticatedException {
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws InvalidPrincipalFault, NotAuthenticated {
                PrincipalSelfManagementImpl.this._managementSvc.deleteSelfSolutionUser();
                return null;
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public void resetLocalPersonUserPassword(final char[] newPassword) throws InvalidPrincipalException, PasswordPolicyViolationException, NotAuthenticatedException {
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws InvalidPrincipalFault, PasswordPolicyViolationFault, NotAuthenticated {
                PrincipalSelfManagementImpl.this._managementSvc.resetSelfLocalPersonUserPassword(String.valueOf(newPassword));
                return null;
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, PasswordPolicyViolationException.class, NotAuthenticatedException.class);
    }

    public PrincipalId updateLocalPersonUserDetails(final PersonDetails details) throws InvalidPrincipalException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)details, (String)"User details");
        return (PrincipalId)new VmomiClientCommand<PrincipalId>(){

            @Override
            public PrincipalId actionCommand() throws InvalidPrincipalFault, NotAuthenticated {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.PrincipalId)PrincipalSelfManagementImpl.this._managementSvc.updateSelfLocalPersonUserDetails(VmodlTypeConversions.toVmodl((PersonDetails)details)));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public PrincipalId updateSolutionUserDetails(final SolutionDetails details) throws InvalidPrincipalException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)details, (String)"User details");
        return (PrincipalId)new VmomiClientCommand<PrincipalId>(){

            @Override
            public PrincipalId actionCommand() throws InvalidPrincipalFault, NotAuthenticated {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.PrincipalId)PrincipalSelfManagementImpl.this._managementSvc.updateSelfLocalSolutionUserDetails(VmodlTypeConversions.toVmodl((SolutionDetails)details)));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public int getDaysRemainingUntilPasswordExpiration() throws InvalidPrincipalException, NotAuthenticatedException {
        return (Integer)new VmomiClientCommand<Integer>(){

            @Override
            public Integer actionCommand() throws InvalidPrincipalFault, NotAuthenticated {
                return PrincipalSelfManagementImpl.this._managementSvc.getDaysRemainingUntilSelfPasswordExpiration();
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public PersonUser getPersonUser() throws InvalidPrincipalException, NotAuthenticatedException {
        return (PersonUser)new VmomiClientCommand<PersonUser>(){

            @Override
            public PersonUser actionCommand() throws InvalidPrincipalFault, NotAuthenticated {
                return SdkVmodlTypeConversions.fromVmodl(PrincipalSelfManagementImpl.this._discoverySvc.findSelfPersonUser());
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }
}

