/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.PasswordPolicyService;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.sso.admin.PasswordPolicy;
import com.vmware.vim.sso.admin.PasswordPolicyConfigurator;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.InvalidPasswordPolicyException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;

final class PasswordPolicyConfiguratorImpl
implements PasswordPolicyConfigurator {
    private final PasswordPolicyService _vmomiService;

    public PasswordPolicyConfiguratorImpl(PasswordPolicyService vmomiService) {
        assert (vmomiService != null);
        this._vmomiService = vmomiService;
    }

    public PasswordPolicy getLocalPasswordPolicy() throws SystemException, NotAuthenticatedException {
        return (PasswordPolicy)new VmomiClientCommand<PasswordPolicy>(){

            @Override
            public PasswordPolicy actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.PasswordPolicy)PasswordPolicyConfiguratorImpl.this._vmomiService.getLocalPasswordPolicy());
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void updateLocalPasswordPolicy(final PasswordPolicy policy) throws InvalidPasswordPolicyException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotNull((Object)policy, (String)"Password policy");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                PasswordPolicyConfiguratorImpl.this._vmomiService.updateLocalPasswordPolicy(VmodlTypeConversions.toVmodl((PasswordPolicy)policy));
                return null;
            }
        }.executeEnsuringDomainErrorIs(InvalidPasswordPolicyException.class, NotAuthenticatedException.class);
    }
}

