/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.idp.provision.client.vmomi.impl;

import com.vmware.vim.binding.idp.ServiceContent;
import com.vmware.vim.binding.idp.ServiceInstance;
import com.vmware.vim.binding.idp.SessionManager;
import com.vmware.vim.binding.idp.fault.ServiceFault;
import com.vmware.vim.binding.idp.provision.ProvisioningService;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.idp.IdpManagement;
import com.vmware.vim.idp.provision.client.IdpProvisionClient;
import com.vmware.vim.idp.provision.client.vmomi.ClientConfiguration;
import com.vmware.vim.idp.provision.client.vmomi.impl.IdpManagementImpl;
import com.vmware.vim.idp.provision.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class IdpProvisionClientImpl
implements IdpProvisionClient {
    private final Log _log = LogFactory.getLog(IdpProvisionClientImpl.class);
    private static final String SERVICE_NAME = "idpServiceInstance";
    private static final String CREATE_SUCCESS_MSG = "IDP provisioning service client was created successfully";
    private final Client _client;
    private final IdpManagement _idpManagement;
    private final SessionManager _sessionManager;

    public IdpProvisionClientImpl(Client client, ClientConfiguration.AuthenticationData authData) {
        assert (client != null);
        assert (authData != null);
        this._client = client;
        ServiceContent serviceContent = this.createServiceContent();
        this._sessionManager = (SessionManager)this._client.createStub(SessionManager.class, serviceContent.getSessionManager());
        ProvisioningService vmomiIdpMgmt = (ProvisioningService)this._client.createStub(ProvisioningService.class, serviceContent.getProvisioningService());
        this._idpManagement = new IdpManagementImpl(vmomiIdpMgmt);
        this.login(authData);
        this._log.info((Object)CREATE_SUCCESS_MSG);
    }

    @Override
    public IdpManagement getProvisioningService() {
        return this._idpManagement;
    }

    @Override
    public void dispose() {
        this.logout();
    }

    private void login(ClientConfiguration.AuthenticationData authData) {
        assert (authData != null);
        SignInfoImpl signInfo = new SignInfoImpl(authData.getHokKey(), authData.getAuthToken());
        RequestContextImpl signedContext = new RequestContextImpl();
        signedContext.setSignInfo((SignInfo)signInfo);
        ((Stub)this._sessionManager)._setRequestContext((RequestContext)signedContext);
        new VmomiClientCommand<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                try {
                    IdpProvisionClientImpl.this._sessionManager.login();
                }
                finally {
                    ((Stub)IdpProvisionClientImpl.this._sessionManager)._setRequestContext(null);
                }
                return null;
            }
        }.executeEnsuringNoDomainError();
    }

    private void logout() throws SystemException {
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault {
                IdpProvisionClientImpl.this._sessionManager.logout();
                return null;
            }
        }.executeEnsuringNoDomainError();
    }

    private ServiceContent createServiceContent() {
        VmodlType type = VmodlTypeMap.Factory.getTypeMap().getVmodlType(ServiceInstance.class);
        assert (type != null);
        ManagedObjectReference moRef = new ManagedObjectReference();
        moRef.setType(type.getWsdlName());
        moRef.setValue(SERVICE_NAME);
        final ServiceInstance serviceInstance = (ServiceInstance)this._client.createStub(ServiceInstance.class, moRef);
        return (ServiceContent)new VmomiClientCommand<ServiceContent>(){

            @Override
            public ServiceContent actionCommand() throws ServiceFault {
                return serviceInstance.retrieveServiceContent();
            }
        }.executeEnsuringNoDomainError();
    }
}

