/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.idp.provision.client.vmomi.impl;

import com.vmware.vim.binding.idp.provision.ProvisioningService;
import com.vmware.vim.binding.idp.provision.fault.DuplicateIdpNameFault;
import com.vmware.vim.binding.idp.provision.fault.IdpNotFoundFault;
import com.vmware.vim.idp.IdpManagement;
import com.vmware.vim.idp.IdpService;
import com.vmware.vim.idp.exception.DuplicateIdpNameException;
import com.vmware.vim.idp.exception.IdpNotFoundException;
import com.vmware.vim.idp.provision.client.vmomi.impl.VmodlTypeConversions;
import com.vmware.vim.idp.provision.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.util.Set;

public final class IdpManagementImpl
implements IdpManagement {
    private final ProvisioningService _vmomiService;

    public IdpManagementImpl(ProvisioningService vmomiService) {
        assert (vmomiService != null);
        this._vmomiService = vmomiService;
    }

    public Set<IdpService> createIdp(final String idpName, final String adminUser, final char[] adminPass) throws DuplicateIdpNameException {
        ValidateUtil.validateNotEmpty((Object)idpName, (String)"IDP name");
        ValidateUtil.validateNotEmpty((Object)adminUser, (String)"adminUser");
        ValidateUtil.validateNotNull((Object)adminPass, (String)"adminPassword");
        return (Set)new VmomiClientCommand<Set<IdpService>>(){

            @Override
            public Set<IdpService> actionCommand() throws DuplicateIdpNameFault {
                return VmodlTypeConversions.fromVmodl(IdpManagementImpl.this._vmomiService.createIdp(idpName, adminUser, new String(adminPass)));
            }
        }.executeEnsuringDomainErrorIs(DuplicateIdpNameException.class);
    }

    public Set<IdpService> listServices(final String idpName) throws IdpNotFoundException {
        ValidateUtil.validateNotEmpty((Object)idpName, (String)"IDP name");
        return (Set)new VmomiClientCommand<Set<IdpService>>(){

            @Override
            public Set<IdpService> actionCommand() throws IdpNotFoundFault {
                return VmodlTypeConversions.fromVmodl(IdpManagementImpl.this._vmomiService.listServices(idpName));
            }
        }.executeEnsuringDomainErrorIs(IdpNotFoundException.class);
    }

    public void deleteIdp(final String idpName) throws IdpNotFoundException {
        ValidateUtil.validateNotEmpty((Object)idpName, (String)"IDP name");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws IdpNotFoundFault {
                IdpManagementImpl.this._vmomiService.deleteIdp(idpName);
                return null;
            }
        }.executeEnsuringDomainErrorIs(IdpNotFoundException.class);
    }
}

