/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.PrincipalManagementService;
import com.vmware.vim.binding.sso.admin.fault.GroupCyclicDependencyFault;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.sso.fault.InvalidPrincipalFault;
import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.GroupDetails;
import com.vmware.vim.sso.admin.PersonDetails;
import com.vmware.vim.sso.admin.PrincipalManagement;
import com.vmware.vim.sso.admin.SolutionDetails;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.DuplicateSolutionCertificateException;
import com.vmware.vim.sso.admin.exception.GroupCyclicDependencyException;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.PasswordPolicyViolationException;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;

final class PrincipalManagementImpl
implements PrincipalManagement {
    private final PrincipalManagementService _service;

    public PrincipalManagementImpl(PrincipalManagementService service) {
        assert (service != null);
        this._service = service;
    }

    public boolean addGroupToLocalGroup(final PrincipalId groupId, final String groupName) throws InvalidPrincipalException, GroupCyclicDependencyException, NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotNull((Object)groupId, (String)"Group id");
        ValidateUtil.validateNotEmpty((Object)groupName, (String)"Group name");
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws InvalidPrincipalFault, GroupCyclicDependencyFault, NotAuthenticated {
                return PrincipalManagementImpl.this._service.addGroupToLocalGroup(VmodlTypeConversions.toVmodl((PrincipalId)groupId), groupName);
            }
        }.executeEnsuringDomainErrorIs(GroupCyclicDependencyException.class, InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public boolean[] addGroupsToLocalGroup(final PrincipalId[] groupIds, final String groupName) throws InvalidPrincipalException, GroupCyclicDependencyException, NotAuthenticatedException, SystemException {
        PrincipalManagementImpl.validateContainsNoNulls(groupIds, "Group id");
        ValidateUtil.validateNotEmpty((Object)groupName, (String)"Group name");
        return (boolean[])new VmomiClientCommand<boolean[]>(){

            @Override
            public boolean[] actionCommand() throws InvalidPrincipalFault, GroupCyclicDependencyFault, ServiceFault {
                return PrincipalManagementImpl.this._service.addGroupsToLocalGroup(VmodlTypeConversions.toVmodl((PrincipalId[])groupIds), groupName);
            }
        }.executeEnsuringDomainErrorIs(GroupCyclicDependencyException.class, InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public boolean addUserToLocalGroup(final PrincipalId userId, final String groupName) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotNull((Object)userId, (String)"User id");
        ValidateUtil.validateNotEmpty((Object)groupName, (String)"Group name");
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws SystemException, NotAuthenticated, NoPermission, InvalidCredentials, InvalidPrincipalFault, ServiceFault {
                return PrincipalManagementImpl.this._service.addUserToLocalGroup(VmodlTypeConversions.toVmodl((PrincipalId)userId), groupName);
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public boolean[] addUsersToLocalGroup(final PrincipalId[] userIds, final String groupName) throws InvalidPrincipalException, NoPermissionException, NotAuthenticatedException, SystemException {
        PrincipalManagementImpl.validateContainsNoNulls(userIds, "User id");
        ValidateUtil.validateNotEmpty((Object)groupName, (String)"Group name");
        return (boolean[])new VmomiClientCommand<boolean[]>(){

            @Override
            public boolean[] actionCommand() throws NoPermission, InvalidCredentials, NotAuthenticated, ServiceFault {
                return PrincipalManagementImpl.this._service.addUsersToLocalGroup(VmodlTypeConversions.toVmodl((PrincipalId[])userIds), groupName);
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public PrincipalId createLocalGroup(final String groupName, final GroupDetails groupDetails) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotEmpty((Object)groupName, (String)"Group name");
        ValidateUtil.validateNotNull((Object)groupDetails, (String)"Group details");
        return (PrincipalId)new VmomiClientCommand<PrincipalId>(){

            @Override
            public PrincipalId actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.PrincipalId)PrincipalManagementImpl.this._service.createLocalGroup(groupName, VmodlTypeConversions.toVmodl((GroupDetails)groupDetails)));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public PrincipalId createLocalPersonUser(final String userName, final PersonDetails userDetails, final char[] password) throws InvalidPrincipalException, PasswordPolicyViolationException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotEmpty((Object)userName, (String)"User name");
        ValidateUtil.validateNotNull((Object)userDetails, (String)"User details");
        ValidateUtil.validateNotNull((Object)password, (String)"Password");
        return (PrincipalId)new VmomiClientCommand<PrincipalId>(){

            @Override
            public PrincipalId actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.PrincipalId)PrincipalManagementImpl.this._service.createLocalPersonUser(userName, VmodlTypeConversions.toVmodl((PersonDetails)userDetails), new String(password)));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class, PasswordPolicyViolationException.class);
    }

    public PrincipalId createLocalSolutionUser(final String userName, final SolutionDetails solutionDetails) throws InvalidPrincipalException, SystemException, DuplicateSolutionCertificateException, NotAuthenticatedException {
        ValidateUtil.validateNotEmpty((Object)userName, (String)"User name");
        ValidateUtil.validateNotNull((Object)solutionDetails, (String)"Solution details");
        return (PrincipalId)new VmomiClientCommand<PrincipalId>(){

            @Override
            public PrincipalId actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.PrincipalId)PrincipalManagementImpl.this._service.createLocalSolutionUser(userName, VmodlTypeConversions.toVmodl((SolutionDetails)solutionDetails)));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, DuplicateSolutionCertificateException.class, NotAuthenticatedException.class);
    }

    public void deleteLocalPrincipal(final String principalName) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotEmpty((Object)principalName, (String)"Principal name");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                PrincipalManagementImpl.this._service.deleteLocalPrincipal(principalName);
                return null;
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public boolean removeFromLocalGroup(final PrincipalId principalId, final String groupName) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotNull((Object)principalId, (String)"Principal Id");
        ValidateUtil.validateNotEmpty((Object)groupName, (String)"Group name");
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws ServiceFault, SystemException {
                return PrincipalManagementImpl.this._service.removeFromLocalGroup(VmodlTypeConversions.toVmodl((PrincipalId)principalId), groupName);
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public boolean[] removeFromLocalGroup(final PrincipalId[] principalIds, final String groupName) throws InvalidPrincipalException, SystemException, NoPermissionException, NotAuthenticatedException {
        PrincipalManagementImpl.validateContainsNoNulls(principalIds, "Principal Id");
        ValidateUtil.validateNotEmpty((Object)groupName, (String)"Group name");
        return (boolean[])new VmomiClientCommand<boolean[]>(){

            @Override
            public boolean[] actionCommand() throws InvalidPrincipalFault, ServiceFault, SecurityError, NoPermission {
                return PrincipalManagementImpl.this._service.removePrincipalsFromLocalGroup(VmodlTypeConversions.toVmodl((PrincipalId[])principalIds), groupName);
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public void resetLocalPersonUserPassword(final String userName, final char[] newPassword) throws InvalidPrincipalException, PasswordPolicyViolationException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotNull((Object)userName, (String)"User name");
        ValidateUtil.validateNotNull((Object)newPassword, (String)"Password");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                PrincipalManagementImpl.this._service.resetLocalPersonUserPassword(userName, new String(newPassword));
                return null;
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, PasswordPolicyViolationException.class, NotAuthenticatedException.class);
    }

    public void resetLocalPersonUserPassword(final String userName, final char[] oldPassword, final char[] newPassword) throws InvalidPrincipalException, PasswordPolicyViolationException, SystemException {
        ValidateUtil.validateNotNull((Object)userName, (String)"User name");
        ValidateUtil.validateNotNull((Object)oldPassword, (String)"Old password");
        ValidateUtil.validateNotNull((Object)newPassword, (String)"New password");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                PrincipalManagementImpl.this._service.resetLocalUserPassword(userName, new String(oldPassword), new String(newPassword));
                return null;
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, PasswordPolicyViolationException.class);
    }

    public boolean unlockUserAccount(final PrincipalId userId) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotNull((Object)userId, (String)"Principal Id");
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws ServiceFault, SystemException {
                return PrincipalManagementImpl.this._service.unlockUserAccount(VmodlTypeConversions.toVmodl((PrincipalId)userId));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public PrincipalId updateLocalPersonUserDetails(final String userName, final PersonDetails userDetails) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotNull((Object)userName, (String)"User name");
        ValidateUtil.validateNotNull((Object)userDetails, (String)"User details");
        return (PrincipalId)new VmomiClientCommand<PrincipalId>(){

            @Override
            public PrincipalId actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.PrincipalId)PrincipalManagementImpl.this._service.updateLocalPersonUserDetails(userName, VmodlTypeConversions.toVmodl((PersonDetails)userDetails)));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public PrincipalId updateLocalSolutionUserDetails(final String userName, final SolutionDetails userDetails) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotNull((Object)userName, (String)"User name");
        ValidateUtil.validateNotNull((Object)userDetails, (String)"User details");
        return (PrincipalId)new VmomiClientCommand<PrincipalId>(){

            @Override
            public PrincipalId actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.PrincipalId)PrincipalManagementImpl.this._service.updateLocalSolutionUserDetails(userName, VmodlTypeConversions.toVmodl((SolutionDetails)userDetails)));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public PrincipalId updateLocalGroupDetails(final String groupName, final GroupDetails groupDetails) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException, SystemException {
        ValidateUtil.validateNotNull((Object)groupName, (String)"Group name");
        ValidateUtil.validateNotNull((Object)groupDetails, (String)"Group details");
        return (PrincipalId)new VmomiClientCommand<PrincipalId>(){

            @Override
            public PrincipalId actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.PrincipalId)PrincipalManagementImpl.this._service.updateLocalGroupDetails(groupName, VmodlTypeConversions.toVmodl((GroupDetails)groupDetails)));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public boolean disableUserAccount(final PrincipalId userId) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotNull((Object)userId, (String)"Principal Id");
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws ServiceFault, SystemException {
                return PrincipalManagementImpl.this._service.disableUserAccount(VmodlTypeConversions.toVmodl((PrincipalId)userId));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public boolean enableUserAccount(final PrincipalId userId) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        ValidateUtil.validateNotNull((Object)userId, (String)"Principal Id");
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws ServiceFault, SystemException {
                return PrincipalManagementImpl.this._service.enableUserAccount(VmodlTypeConversions.toVmodl((PrincipalId)userId));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    private static <T> void validateContainsNoNulls(T[] values, String elementName) {
        ValidateUtil.validateNotNull(values, (String)(elementName + "s"));
        for (T v : values) {
            ValidateUtil.validateNotNull(v, (String)elementName);
        }
    }
}

