/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.internals;

import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;
import java.io.File;
import org.apache.commons.lang.SystemUtils;

public final class CommonPaths {
    private static File getApplicationDataDir() {
        try {
            return new File(Shell32Util.getFolderPath(35));
        }
        catch (Win32Exception e) {
            boolean isFileNotFound = WinError.S_FALSE.equals(e.getHR()) || new WinNT.HRESULT(-2147467259).equals(e.getHR());
            String msg = isFileNotFound ? "Unexpected error retrieving the Common Application Data directory: " + e.getMessage() : "The Common Application Data directory does not exists.";
            throw new IllegalStateException(msg, e);
        }
    }

    public static File getVMwareConfigDataDir() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return new File(CommonPaths.getApplicationDataDir(), "VMware");
        }
        throw new IllegalStateException("getVMwareConfigDataDir() should not be invoked on Linux");
    }

    public static File getSystemTrustStoreDir() {
        return SystemUtils.IS_OS_WINDOWS ? new File(CommonPaths.getVMwareConfigDataDir(), "SSL") : new File("/etc/ssl/certs");
    }

    public static File getLsUrlFile() {
        return SystemUtils.IS_OS_WINDOWS ? new File(CommonPaths.getVMwareConfigDataDir(), "ls_url.txt") : new File("/etc/vmware-sso/ls_url.txt");
    }
}

