/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.impl;

import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.install.CertificateType;
import com.vmware.vim.install.RegistrationProviderConfig;
import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.impl.AdminServiceAccess;
import com.vmware.vim.install.impl.LookupServiceAccess;
import com.vmware.vim.sso.admin.DomainManagement;
import com.vmware.vim.sso.admin.PrincipalDiscovery;
import com.vmware.vim.sso.admin.PrincipalManagement;
import com.vmware.vim.sso.admin.PrincipalSelfManagement;
import com.vmware.vim.sso.admin.RoleManagement;
import com.vmware.vim.sso.admin.client.AdminClient;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegistrationProviderImpl
implements RegistrationServiceProvider {
    private static final boolean DEFAULT_TO_SYSTEM_TRUST_STORE = false;
    private final Log _log = LogFactory.getLog(RegistrationProviderImpl.class);
    private final RegistrationProviderConfig _config;
    private final LookupServiceAccess _lsAccess;
    private final AdminServiceAccess _adminAccess;

    public RegistrationProviderImpl(RegistrationProviderConfig config) {
        this._config = config;
        this._log.info("Intializing registration provider...");
        this._lsAccess = new LookupServiceAccess(this._config.getLsAddress(), this.getEffectiveTrustStore(), this._config.getVerifier());
        this._adminAccess = AdminServiceAccess.createDiscover(this._lsAccess.getLookupService(), this._config);
        this.setAuthContext(this._lsAccess.getLookupService(), this._adminAccess.getAuthnToken());
    }

    @Override
    public AdminClient getAdminService() {
        return this._adminAccess.getAdminService();
    }

    @Override
    public LookupService getLookupService() {
        return this._lsAccess.getLookupService();
    }

    @Override
    @Deprecated
    public PrincipalManagement getPrincipalManagement() {
        return this._adminAccess.getAdminService().getPrincipalManagement();
    }

    @Override
    @Deprecated
    public PrincipalSelfManagement getSelfManagement() {
        return this._adminAccess.getAdminService().getPrincipalSelfManagement();
    }

    @Override
    @Deprecated
    public PrincipalDiscovery getPrincipalDiscovery() {
        return this._adminAccess.getAdminService().getPrincipalDiscovery();
    }

    @Override
    @Deprecated
    public DomainManagement getDomainManagement() {
        return this._adminAccess.getAdminService().getDomainManagement();
    }

    @Override
    @Deprecated
    public RoleManagement getRoleManagement() {
        return this._adminAccess.getAdminService().getRoleManagement();
    }

    @Override
    public Map<CertificateType, X509Certificate[]> downloadCertificates() {
        HashMap<CertificateType, X509Certificate[]> certificates = new HashMap<CertificateType, X509Certificate[]>(CertificateType.values().length);
        X509Certificate[] adminCerts = this._adminAccess.getSslCertificates();
        X509Certificate[] lsCerts = this._lsAccess.downloadSslCertificates();
        certificates.put(CertificateType.ADMIN_SSL_CHAIN, adminCerts);
        certificates.put(CertificateType.LS_SSL_CHAIN, lsCerts);
        certificates.put(CertificateType.GC_SSL_CHAIN, lsCerts);
        certificates.put(CertificateType.STS_SSL_CHAIN, lsCerts);
        certificates.put(CertificateType.STS_ROOT_CERTIFICATES, this._adminAccess.getStsTrustedCertificates());
        return certificates;
    }

    private final ManagedObject setAuthContext(ManagedObject service, SamlToken token) {
        SignInfoImpl signInfo = token != null ? new SignInfoImpl(this._config.getSolutionPrivateKey(), token) : null;
        RequestContextImpl context = new RequestContextImpl();
        context.setSignInfo(signInfo);
        ((Stub)((Object)service))._setRequestContext(context);
        return service;
    }

    private KeyStore getEffectiveTrustStore() {
        if (this._config.getTrustStore() != null || this._config.getVerifier() == null) {
            // empty if block
        }
        KeyStore effectiveTrustStore = this._config.getTrustStore();
        return effectiveTrustStore;
    }
}

