/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.util;

import com.vmware.vim.sso.admin.util.CertificateUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;

public final class FileCertificateUtil {
    private static final String LOAD_KEY_ERROR = "Cannot load private key from file";
    private static final String LOAD_CERT_ERROR = "Cannot load certificate from file";
    private static final Log _log = LogFactory.getLog(FileCertificateUtil.class);
    private static final String CERTIFICATE_FORMAT = "-----BEGIN CERTIFICATE-----%n%s-----END CERTIFICATE-----";

    public static PrivateKey loadPrivateKey(String filename) {
        Security.addProvider(new BouncyCastleProvider());
        File file = new File(filename);
        if (!file.exists()) {
            try {
                file = new File(ConfigurationUtils.getURL(null, filename).toURI());
            }
            catch (URISyntaxException e) {
                _log.error(e);
                throw new IllegalStateException(e);
            }
            catch (MalformedURLException e) {
                _log.error(e);
                throw new IllegalStateException(e);
            }
        }
        BufferedReader keyStream = null;
        try {
            PrivateKey key;
            keyStream = new PEMReader(new FileReader(file));
            Object keyObj = ((PEMReader)keyStream).readObject();
            if (keyObj instanceof KeyPair) {
                key = ((KeyPair)keyObj).getPrivate();
            } else if (keyObj instanceof PrivateKey) {
                key = (PrivateKey)keyObj;
            } else {
                throw new IllegalArgumentException("Key file doesn't contain private key in a supported format. Supported formats are: PKCS#1 unencrypted, PKCS#8 unencrypted");
            }
            PrivateKey privateKey = key;
            return privateKey;
        }
        catch (Exception e) {
            _log.debug(LOAD_KEY_ERROR, e);
            throw new IllegalArgumentException(LOAD_KEY_ERROR, e);
        }
        finally {
            if (keyStream != null) {
                try {
                    keyStream.close();
                }
                catch (IOException e) {
                    _log.trace("Error while closing stream: " + e.getMessage(), e);
                }
            }
        }
    }

    public static X509Certificate loadCertificate(String filename) {
        Security.addProvider(new BouncyCastleProvider());
        File file = new File(filename);
        if (!file.exists()) {
            try {
                file = new File(ConfigurationUtils.getURL(null, filename).toURI());
            }
            catch (URISyntaxException e) {
                _log.error(e.getMessage());
                throw new IllegalStateException(e);
            }
            catch (MalformedURLException e) {
                _log.error(e);
                throw new IllegalStateException(e);
            }
        }
        BufferedReader certStream = null;
        try {
            certStream = new PEMReader(new FileReader(file));
            X509Certificate x509Certificate = (X509Certificate)((PEMReader)certStream).readObject();
            return x509Certificate;
        }
        catch (Exception e) {
            _log.error(e.getMessage());
            _log.debug(LOAD_CERT_ERROR, e);
            throw new IllegalArgumentException(LOAD_CERT_ERROR, e);
        }
        finally {
            if (certStream != null) {
                try {
                    certStream.close();
                }
                catch (IOException e) {
                    _log.trace("Error while closing stream: " + e.getMessage(), e);
                }
            }
        }
    }

    public static void storeCertificate(String filename, X509Certificate certificate, boolean overwrite) {
        File file = new File(filename);
        _log.trace(file.getAbsoluteFile());
        if (file.exists()) {
            if (overwrite) {
                _log.warn("The file " + filename + " already exists. Overwriting...");
            } else {
                _log.warn("The file " + filename + " already exists. Won't store certificate.");
                return;
            }
        }
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file, false)));
            writer.write(String.format(CERTIFICATE_FORMAT, CertificateUtil.encodeCertificate(certificate)));
            writer.flush();
        }
    }

    private FileCertificateUtil() {
    }
}

