/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands.util;

import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vim.binding.lookup.ServiceRegistrationForm;
import com.vmware.vim.install.cli.commands.LsPropertyKeys;
import com.vmware.vim.install.cli.commands.PropertiesParser;
import com.vmware.vim.install.cli.commands.SolutionRegistrationForm;
import com.vmware.vim.install.cli.commands.SsoPropertyKeys;
import com.vmware.vim.install.cli.util.FileCertificateUtil;
import com.vmware.vim.sso.admin.util.CertificateUtil;
import java.io.File;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public final class ParserUtil {
    private static final Log _log = LogFactory.getLog(ParserUtil.class);

    public static ServiceRegistrationForm extractServiceFormFromFile(File propFiles) throws ConfigurationException {
        _log.debug("Parsing properties file " + propFiles.getAbsolutePath());
        PropertiesParser parser = new PropertiesParser(propFiles);
        URI type = parser.getURI(LsPropertyKeys.serviceType.getValue());
        String version = parser.getString(LsPropertyKeys.serviceVersion.getValue());
        String friendlyName = parser.getString(LsPropertyKeys.serviceName.getValue());
        String ownerId = parser.getString(LsPropertyKeys.serviceOwnerId.getValue());
        String description = parser.getString(LsPropertyKeys.serviceDescription.getValue());
        String productId = parser.getString(LsPropertyKeys.serviceProductId.getValue());
        String[] sections = parser.getSectionsContainingKey(LsPropertyKeys.serviceEndpointSection.getValue());
        ServiceEndpoint[] endpoints = new ServiceEndpoint[sections.length];
        String endpointKeyFormat = LsPropertyKeys.serviceEndpointSection.getValue() + "%d.%s";
        for (int i = 0; i < sections.length; ++i) {
            if (sections[i] == null) continue;
            String certFile = parser.getString(String.format(endpointKeyFormat, i, LsPropertyKeys.endpointSsl.getValue()));
            X509Certificate cert = certFile == null || certFile.equals("") ? null : FileCertificateUtil.loadCertificate(certFile);
            endpoints[i] = new ServiceEndpoint(cert == null ? null : CertificateUtil.encodeCertificate(cert), parser.getURI(String.format(endpointKeyFormat, i, LsPropertyKeys.endpointUri.getValue())), parser.getString(String.format(endpointKeyFormat, i, LsPropertyKeys.endpointProtocol.getValue())));
        }
        ServiceRegistrationForm form = new ServiceRegistrationForm(version, type, ownerId, friendlyName, description, endpoints, productId, null);
        _log.trace(form.toString() + " successfully parsed");
        return form;
    }

    public static SolutionRegistrationForm extractSolutionRegistrationForm(String props) throws ConfigurationException {
        _log.debug("Parsing properties file: " + props);
        PropertiesParser parser = new PropertiesParser(props);
        X509Certificate certificate = FileCertificateUtil.loadCertificate(parser.getString(SsoPropertyKeys.solutionCertificate.getValue()));
        SolutionRegistrationForm form = new SolutionRegistrationForm(parser.getString(SsoPropertyKeys.solutionUsername.getValue()), certificate, parser.getString(SsoPropertyKeys.solutionDescription.getValue()));
        _log.trace(form.toString() + " parsed succesfully from file");
        return form;
    }

    public static List<String> extractServiceIdsFromFile(String filename) {
        ArrayList<String> serviceIds = new ArrayList<String>();
        try (Scanner scanner = null;){
            scanner = new Scanner(new File(filename));
            while (scanner.hasNext()) {
                serviceIds.add(scanner.nextLine());
            }
        }
        if (serviceIds.isEmpty()) {
            throw new IllegalArgumentException("The serviceId file " + filename + " has no values");
        }
        return serviceIds;
    }
}

