/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.sso.admin.PrincipalManagement;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidateSsoCommand
implements Command {
    private static final Log _log = LogFactory.getLog(ValidateSsoCommand.class);
    private final PrincipalManagement _principalManagement;

    public ValidateSsoCommand(PrincipalManagement principalManagement) {
        this._principalManagement = principalManagement;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode code;
        try {
            this._principalManagement.deleteLocalPrincipal("inv@lidUser");
            _log.warn("We deleted smth that shouldn't have been deleted");
            code = ReturnCode.Success;
        }
        catch (InvalidPrincipalException e) {
            code = ReturnCode.Success;
        }
        catch (NotAuthenticatedException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            code = ReturnCode.NotPrivileged;
        }
        catch (NoPermissionException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            code = ReturnCode.NotPrivileged;
        }
        catch (SystemException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            code = ReturnCode.ServiceNotResponding;
        }
        return code;
    }
}

