/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.Commands;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.commands.CommandArgumentsParser;
import com.vmware.vim.install.cli.commands.UpdateSolutionCommand;
import com.vmware.vim.install.cli.util.FileCertificateUtil;
import com.vmware.vim.sso.admin.client.AdminClient;
import java.security.cert.X509Certificate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public final class UpdateSolutionCommandParser
extends CommandArgumentsParser {
    private static final String ARG_SOLUTION_NAME = "solution-name";
    private static final String ARG_NEW_CERT = "new-certificate";
    private static final String ARG_NEW_DESCRIPTION = "new-description";
    private static final String MSG_NEED_CERT_OR_DESC = String.format("At least one of `%s' or `%s' must be provided.", "new-certificate", "new-description");
    private String _solutionName = null;
    private X509Certificate _oldCertificate = null;
    private X509Certificate _newCertificate = null;
    private String _newDescription = null;

    public UpdateSolutionCommandParser() {
        super(Commands.updateSolution, true);
    }

    @Override
    protected Options createOptions() {
        Options opts = super.createOptions();
        Option solNameOpt = new Option(null, ARG_SOLUTION_NAME, true, "The name of the solution user to update. Optional, if the authenticating user is a solution user, in which case the authenticating user will be updated. Required otherwise. If explicitly provided, the authenticating user must have SSO administrative privileges.");
        opts.addOption(solNameOpt);
        Option newCertOpt = new Option(null, ARG_NEW_CERT, true, "The new solution user certificate. Optional. If not provided, the currently effective solution user certificate will not be changed; the authenticating user must have read privileges in SSO in order to retrieve the current certificate for the update operation. " + MSG_NEED_CERT_OR_DESC);
        opts.addOption(newCertOpt);
        Option newDescOpt = new Option(null, ARG_NEW_DESCRIPTION, true, "The new solution user description. Optional. If not provided, the currently effective solution user description will not be changed; the authenticating user must have read privileges in SSO in order to retrive the current description for the update operation. " + MSG_NEED_CERT_OR_DESC);
        opts.addOption(newDescOpt);
        return opts;
    }

    @Override
    protected void parseAdditionalOptions(CommandLine line) {
        this._solutionName = line.getOptionValue(ARG_SOLUTION_NAME);
        String newCertFile = line.getOptionValue(ARG_NEW_CERT);
        this._newCertificate = newCertFile == null ? null : FileCertificateUtil.loadCertificate(newCertFile);
        String oldCertFile = line.getOptionValue("sc");
        this._oldCertificate = oldCertFile == null ? null : FileCertificateUtil.loadCertificate(oldCertFile);
        this._newDescription = line.getOptionValue(ARG_NEW_DESCRIPTION);
        if (this._newCertificate == null && this._newDescription == null) {
            throw new IllegalArgumentException(MSG_NEED_CERT_OR_DESC);
        }
        if (this._solutionName == null && this._oldCertificate == null) {
            throw new IllegalArgumentException("Either an explicit solution user name must be provided or solution user (certificate) authentication must be used.");
        }
    }

    @Override
    protected Command createCommand(RegistrationServiceProvider serviceProvider) {
        AdminClient adminService = serviceProvider.getAdminService();
        return new UpdateSolutionCommand(adminService.getPrincipalDiscovery(), adminService.getPrincipalManagement(), adminService.getPrincipalSelfManagement(), this._solutionName, this._oldCertificate, this._newCertificate, this._newDescription);
    }
}

