/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnregisterSolutionCommand
implements Command {
    private static final Log _log = LogFactory.getLog(UnregisterSolutionCommand.class);
    private static final String SELF_UNREG_ERR_MSG = "The authenticated user cannot be deleted as it is either a person user or doesn't exist any more. Cause: ";
    private final RegistrationServiceProvider _serviceProvider;
    private final String _solutionUsername;

    public UnregisterSolutionCommand(RegistrationServiceProvider serviceProvider, String solutionUsername) {
        assert (serviceProvider != null);
        this._serviceProvider = serviceProvider;
        this._solutionUsername = solutionUsername == null || solutionUsername.isEmpty() ? null : solutionUsername;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode code = ReturnCode.OperationFailed;
        try {
            _log.debug("First try to delete the authenticated user...");
            this._serviceProvider.getAdminService().getPrincipalSelfManagement().deleteSolutionUser();
            code = ReturnCode.Success;
            _log.info("Successfully deleted authenticated user");
        }
        catch (InvalidPrincipalException e) {
            if (this._solutionUsername != null) {
                _log.debug(SELF_UNREG_ERR_MSG + e.getMessage());
                _log.trace("", e);
            } else {
                _log.error("Cannot unregister authenticated user and no valid solutionUsername is provided for deleting. Cause of failure: " + e.getMessage());
                _log.debug("", e);
                code = ReturnCode.UnregisterFailed;
            }
        }
        catch (NotAuthenticatedException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            code = ReturnCode.NotPrivileged;
        }
        catch (SystemException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            code = ReturnCode.ServiceNotResponding;
        }
        if (code == ReturnCode.OperationFailed && this._solutionUsername != null) {
            try {
                this._serviceProvider.getAdminService().getPrincipalManagement().deleteLocalPrincipal(this._solutionUsername);
                code = ReturnCode.Success;
            }
            catch (InvalidPrincipalException e) {
                _log.error(e.getMessage());
                _log.debug("", e);
                code = ReturnCode.UnregisterFailed;
            }
            catch (NotAuthenticatedException e) {
                _log.error(e.getMessage());
                _log.debug("", e);
                code = ReturnCode.NotPrivileged;
            }
            catch (NoPermissionException e) {
                _log.error(e.getMessage());
                _log.debug("", e);
                code = ReturnCode.NotPrivileged;
            }
            catch (SystemException e) {
                _log.error(e.getMessage());
                _log.debug("", e);
                code = ReturnCode.ServiceNotResponding;
            }
        }
        return code;
    }
}

