/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.fault.EntryNotFoundFault;
import com.vmware.vim.binding.lookup.fault.ServiceFault;
import com.vmware.vim.binding.lookup.fault.UnsupportedSiteFault;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UnregisterServiceCommand
implements Command {
    private static final Log _log = LogFactory.getLog(UnregisterServiceCommand.class);
    private final LookupService _lookupService;
    private final String _serviceId;

    public UnregisterServiceCommand(LookupService lookupService, String serviceId) {
        this._lookupService = lookupService;
        this._serviceId = serviceId;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode code;
        try {
            this._lookupService.unregisterService(this._serviceId);
            code = ReturnCode.Success;
            _log.info(String.format("Service with id \"%s\" is successfully unregistered", this._serviceId));
        }
        catch (UnsupportedSiteFault e) {
            _log.error(e.getMessage(), e);
            code = ReturnCode.UnregisterFailed;
        }
        catch (EntryNotFoundFault e) {
            _log.error(e.getMessage(), e);
            code = ReturnCode.UnregisterFailed;
        }
        catch (InvalidArgument e) {
            _log.error(e.getMessage(), e);
            code = ReturnCode.InvalidInput;
        }
        catch (SecurityError e) {
            _log.error(e.getMessage(), e);
            code = ReturnCode.NotPrivileged;
        }
        catch (ServiceFault e) {
            _log.error(e.getMessage(), e);
            code = ReturnCode.UnregisterFailed;
        }
        return code;
    }
}

