/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.binding.lookup.ServiceRegistrationForm;
import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.Commands;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.commands.CommandArgumentsParser;
import com.vmware.vim.install.cli.commands.CompositeCommand;
import com.vmware.vim.install.cli.commands.RegisterServiceCommand;
import com.vmware.vim.install.cli.commands.util.ParserUtil;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RegisterServiceCommandParser
extends CommandArgumentsParser {
    private static final Log _log = LogFactory.getLog(RegisterServiceCommandParser.class);
    private ServiceRegistrationForm[] _serviceInfo;
    private String _siFile;

    public RegisterServiceCommandParser() {
        super(Commands.registerService, 2);
    }

    @Override
    protected void parseAdditionalOptions(CommandLine line) {
        String propertiesLocation = line.getOptionValue("ip");
        String dir = line.getOptionValue("dir");
        this._siFile = line.getOptionValue("si");
        File siFile = new File(this._siFile);
        if (siFile.isDirectory()) {
            throw new IllegalArgumentException(siFile.getAbsolutePath() + " is a directory. Please provide a filename");
        }
        File[] propFiles = null;
        if (dir != null && !dir.isEmpty()) {
            File folder = new File(dir);
            WildcardFileFilter fileFilter = new WildcardFileFilter(propertiesLocation);
            propFiles = folder.listFiles(fileFilter);
        } else {
            propFiles = new File[]{new File(propertiesLocation)};
        }
        if (propFiles.length == 0) {
            _log.warn("No properties files found");
            return;
        }
        this._serviceInfo = new ServiceRegistrationForm[propFiles.length];
        for (int i = 0; i < propFiles.length; ++i) {
            try {
                this._serviceInfo[i] = ParserUtil.extractServiceFormFromFile(propFiles[i]);
                continue;
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }

    @Override
    protected Options createOptions() {
        Options options = super.createOptions();
        Option propOption = new Option("ip", "installation-properties", true, "The file, containing the registration information. In case when a folder is provided with the --dir option, only paths relative to that folder are accepted");
        propOption.setRequired(true);
        options.addOption(propOption);
        Option fileOption = new Option("si", "serviceId-file", true, "The file where the serviceId will be stored");
        fileOption.setRequired(true);
        options.addOption(fileOption);
        options.addOption("dir", "", true, "In case of multiple property files, the directory in which to search for the files");
        return options;
    }

    @Override
    protected Command createCommand(RegistrationServiceProvider serviceProvider) {
        Command[] commands = new RegisterServiceCommand[this._serviceInfo.length];
        for (int i = 0; i < this._serviceInfo.length; ++i) {
            ServiceRegistrationForm serviceInfo = this._serviceInfo[i];
            commands[i] = new RegisterServiceCommand(serviceProvider.getLookupService(), serviceInfo, this._siFile);
        }
        return new CompositeCommand(commands);
    }
}

