/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceRegistrationForm;
import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RegisterServiceCommand
implements Command {
    private final Log _log = LogFactory.getLog(RegisterServiceCommand.class);
    private final LookupService _lookupService;
    private final ServiceRegistrationForm _service;
    private final String _siFile;

    public RegisterServiceCommand(LookupService lookupService, ServiceRegistrationForm service, String siFile) {
        this._lookupService = lookupService;
        this._service = service;
        this._siFile = siFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReturnCode execute() {
        ReturnCode code;
        try (PrintWriter writer = null;){
            Service service = this._lookupService.registerService(this._service);
            this._log.info(String.format("Service with name '%s' was registered with ID: '%s'", service.getServiceName(), service.getServiceId()));
            writer = new PrintWriter(new FileOutputStream(this._siFile, true));
            this._log.info("Appending serviceId to file");
            writer.println(service.getServiceId());
            code = ReturnCode.Success;
        }
        return code;
    }
}

