/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.Commands;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.commands.CommandArgumentsParser;
import com.vmware.vim.install.cli.commands.RegisterDomainCommand;
import com.vmware.vim.install.cli.commands.RegisterDomainForm;
import com.vmware.vim.sso.admin.ExternalDomain;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;

public final class RegisterDomainCommandParser
extends CommandArgumentsParser {
    private static final String ARG_BASE_DN = "baseDn";
    private static final String ARG_DOMAIN_TYPE = "domainType";
    private static final String ARG_DOMAIN_NAME = "domainName";
    private static final String ARG_DOMAIN_ALIAS = "domainAlias";
    private static final String ARG_PRIMARY_URL = "primaryUrl";
    private static final String ARG_FAILOVER_URL = "failoverUrl";
    private static final String ARG_AUTHN_TYPE = "authnType";
    private static final String ARG_AUTHN_USER = "authnUser";
    private static final String ARG_AUTHN_PASSWORD = "authnPassword";
    private RegisterDomainForm _registerDomainForm;

    public RegisterDomainCommandParser() {
        super(Commands.registerDomain, 2);
    }

    @Override
    protected Command createCommand(RegistrationServiceProvider serviceProvider) {
        return new RegisterDomainCommand(serviceProvider.getAdminService().getDomainManagement(), this._registerDomainForm);
    }

    @Override
    protected Options createOptions() {
        Options opts = this.createCommonOptions();
        Option typeOpt = new Option(null, ARG_DOMAIN_TYPE, true, "The type of the domain to register. Valid types are: ActiveDirectory, OpenLdap, NIS.");
        typeOpt.setRequired(true);
        opts.addOption(typeOpt);
        Option nameOpt = new Option(null, ARG_DOMAIN_NAME, true, "The name of the domain to register");
        nameOpt.setRequired(true);
        opts.addOption(nameOpt);
        opts.addOption(null, ARG_DOMAIN_ALIAS, true, "The alias of the domain register. Optional");
        Option primaryUrlOpt = new Option(null, ARG_PRIMARY_URL, true, "URL of the domain's primary server.");
        primaryUrlOpt.setRequired(true);
        opts.addOption(primaryUrlOpt);
        opts.addOption(null, ARG_FAILOVER_URL, true, "URL of the domain's failover server. Optional.");
        Option authnTypeOpt = new Option(null, ARG_AUTHN_TYPE, true, "Specifies how the SSO server should authenticate to the external server(s) when searching for users/groups. Valid values are: anonynoums, password, reuseSession.");
        authnTypeOpt.setRequired(true);
        opts.addOption(authnTypeOpt);
        opts.addOption(null, ARG_AUTHN_USER, true, "The username used for authentication to the external server(s). Only required is authnType is passwod.");
        opts.addOption(null, ARG_AUTHN_PASSWORD, true, "The password used for authentication to the external server(s). Only required is authnType is passwod.");
        Option baseDnOpt = new Option(null, ARG_BASE_DN, true, "The base naming context the SSO will use to access the external OpenLDAP or Active Directory service. Required for OpenLDAP and ActiveDirectory. Not relevant for NIS. ");
        baseDnOpt.setRequired(false);
        opts.addOption(baseDnOpt);
        return opts;
    }

    @Override
    protected void parseAdditionalOptions(CommandLine line) {
        this._registerDomainForm = new RegisterDomainForm(this.getEnumeratedParam(ExternalDomain.Type.class, line, ARG_DOMAIN_TYPE), line.getOptionValue(ARG_DOMAIN_NAME), line.getOptionValue(ARG_DOMAIN_ALIAS), this.getUriParam(line, ARG_PRIMARY_URL), this.getUriParam(line, ARG_FAILOVER_URL), line.getOptionValue(ARG_BASE_DN), this.getEnumeratedParam(ExternalDomain.AuthenticationType.class, line, ARG_AUTHN_TYPE), line.getOptionValue(ARG_AUTHN_USER), line.getOptionValue(ARG_AUTHN_PASSWORD));
    }

    private URI getUriParam(CommandLine line, String paramName) {
        String param = line.getOptionValue(paramName);
        try {
            return param == null ? null : new URI(param);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid value for parameter %s: not a URI.", paramName), e);
        }
    }

    private <E extends Enum<E>> E getEnumeratedParam(Class<E> enumType, CommandLine line, String paramName) {
        String param = line.getOptionValue(paramName);
        assert (param != null);
        try {
            return Enum.valueOf(enumType, param);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid value for %s. Expected one of: %s", paramName, StringUtils.join(enumType.getEnumConstants()), Character.valueOf(',')), e);
        }
    }
}

