/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalINIConfiguration;

public class PropertiesParser {
    private final HierarchicalINIConfiguration _config;

    public PropertiesParser(String fileName) throws ConfigurationException {
        this._config = new HierarchicalINIConfiguration(fileName);
    }

    public PropertiesParser(File file) throws ConfigurationException {
        this._config = new HierarchicalINIConfiguration(file);
    }

    public String getString(String key) {
        return this._config.getString(key);
    }

    public URI getURI(String key) {
        String uriStr = this.getString(key);
        try {
            return uriStr == null ? null : new URI(uriStr);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String[] getSectionsContainingKey(String sectionKey) {
        Set sections = this._config.getSections();
        ArrayList<String> secStrings = new ArrayList<String>(sections.size());
        for (Object section : sections) {
            if (!(section instanceof String) || !((String)section).startsWith(sectionKey)) continue;
            secStrings.add((String)section);
        }
        return secStrings.toArray(new String[0]);
    }
}

