/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.SearchCriteria;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vim.binding.lookup.fault.ServiceFault;
import com.vmware.vim.install.RegistrationProviderConfig;
import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.impl.RegistrationProviderImpl;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.client.exception.ClientException;
import com.vmware.vim.vmomi.client.exception.SslException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.commons.lang.builder.StandardToStringStyle;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListServicesCommand
implements Command {
    private final Log log = LogFactory.getLog(ListServicesCommand.class);
    private static final String fileId = "$Id: //depot/vicore/vicore-2013-rel/regtool/viregtool/src/main/java/com/vmware/vim/install/cli/commands/ListServicesCommand.java#1 $";
    private final String[] args;

    public ListServicesCommand(String[] cmdArgs) {
        this.log.debug("Initializing $Id: //depot/vicore/vicore-2013-rel/regtool/viregtool/src/main/java/com/vmware/vim/install/cli/commands/ListServicesCommand.java#1 $");
        this.args = (String[])cmdArgs.clone();
    }

    private static String argumentsToString(String[] args) {
        if (null != args) {
            return Arrays.deepToString(args);
        }
        return "<empty>";
    }

    @Override
    public ReturnCode execute() {
        ReturnCode res = ReturnCode.InvalidCommand;
        this.log.debug("Executing " + this);
        try {
            this.log.trace("Parsing arguments : " + this.args);
            if (null == this.args || 0 == this.args.length) {
                this.printUsage();
                res = ReturnCode.InvalidInput;
            } else {
                URI lsAddress = new URI(this.args[0]);
                this.log.trace("Creating RegistrationProviderConfiguration builder using address " + lsAddress);
                RegistrationProviderConfig.Builder builder = new RegistrationProviderConfig.Builder(lsAddress);
                this.log.trace("Building client to LookupService.");
                LookupService lsServiceContent = new RegistrationProviderImpl(builder.create()).getLookupService();
                this.log.trace("Getting LookupService VI site name.");
                String viSite = lsServiceContent.getViSite();
                this.log.trace("Creating search criteria which would filter for VI site=" + viSite);
                SearchCriteria searchCriteria = new SearchCriteria(null, viSite, null);
                this.log.trace("Searching for " + searchCriteria);
                Service[] found = lsServiceContent.find(searchCriteria);
                int count = null != found ? found.length : 0;
                this.log.info("Found " + count + " services.");
                for (int i = 0; i < count; ++i) {
                    this.log.info("\nService " + (i + 1) + "\n-----------\n" + this.asString(found[i]));
                }
                res = ReturnCode.Success;
            }
        }
        catch (UnexpectedStatusCodeException e) {
            this.log.error(e.getMessage());
            this.log.debug(e);
            res = ReturnCode.ServiceNotResponding;
        }
        catch (SslException e) {
            this.log.error(e.getMessage());
            this.log.debug("", e);
            res = ReturnCode.SslHandshakeFailed;
        }
        catch (ClientException e) {
            this.log.error("Service unreachable");
            this.log.debug("", e);
            res = ReturnCode.ServiceNotResponding;
        }
        catch (ServiceFault e) {
            this.log.error(e.getMessage());
            this.log.debug(e);
            res = ReturnCode.ServiceNotResponding;
        }
        catch (URISyntaxException e) {
            this.log.error("Cannot convert first argument to URI. Invalid arguments:" + ListServicesCommand.argumentsToString(this.args));
            this.printUsage();
            res = ReturnCode.InvalidInput;
        }
        return res;
    }

    private String asString(Service service) {
        StandardToStringStyle style = new StandardToStringStyle();
        style.setUseClassName(false);
        style.setUseIdentityHashCode(false);
        Object[] endpointStrings = new String[service.endpoints.length];
        for (int i = 0; i < endpointStrings.length; ++i) {
            ServiceEndpoint endpoint = service.endpoints[i];
            endpointStrings[i] = new ToStringBuilder(endpoint, style).append("url", endpoint.getUrl()).append("protocol", endpoint.getProtocol()).toString();
        }
        style.setFieldSeparator(System.getProperty("line.separator"));
        style.setContentStart("");
        style.setContentEnd("");
        return new ToStringBuilder(service, style).append("serviceId", service.getServiceId()).append("serviceName", service.getServiceName()).append("type", service.getType()).append("endpoints", endpointStrings).append("version", service.getVersion()).append("description", service.getDescription()).append("ownerId", service.getOwnerId()).append("productId", service.getProductId()).append("viSite", service.getViSite()).toString();
    }

    private void printUsage() {
        this.log.error("This command requires one argument - the URL of the LookupService, e.g. https://lookup:7444/lookupservice/sdk");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.hashCode() + "[Arguments provided = " + ListServicesCommand.argumentsToString(this.args) + " ]";
    }
}

