/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.Commands;
import com.vmware.vim.install.cli.commands.CheckVersionCommand;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.commands.CommandArgumentsParser;
import java.math.BigDecimal;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckVersionCommandParser
extends CommandArgumentsParser {
    private static final Log _log = LogFactory.getLog(CheckVersionCommandParser.class);
    private BigDecimal _version;

    public CheckVersionCommandParser() {
        super(Commands.checkVersion, 3);
    }

    @Override
    protected void parseAdditionalOptions(CommandLine line) {
        try {
            this._version = new BigDecimal(line.getOptionValue("vn"));
        }
        catch (NumberFormatException e) {
            _log.error("The provided version string is not a valid number");
            if (_log.isDebugEnabled()) {
                _log.debug("", e);
            }
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    protected Options createOptions() {
        Options options = super.createOptions();
        Option version = new Option("vn", "version-number", true, "The version number of the currently running client");
        version.setRequired(true);
        options.addOption(version);
        return options;
    }

    @Override
    protected Command createCommand(RegistrationServiceProvider serviceProvider) {
        return new CheckVersionCommand(serviceProvider, this._version);
    }
}

