/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.DomainManagement;
import com.vmware.vim.sso.admin.Group;
import com.vmware.vim.sso.admin.PersonUser;
import com.vmware.vim.sso.admin.PrincipalDiscovery;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckPrincipalExistsCommand
implements Command {
    private static final Log _log = LogFactory.getLog(CheckPrincipalExistsCommand.class);
    private final DomainManagement _domainManagement;
    private final PrincipalDiscovery _principalDiscovery;
    private final String _principal;
    private final boolean _checkIsGroup;

    public CheckPrincipalExistsCommand(DomainManagement domainManagement, PrincipalDiscovery principalDiscovery, String principal, boolean checkIsGroup) {
        this._domainManagement = domainManagement;
        this._principalDiscovery = principalDiscovery;
        this._principal = principal;
        this._checkIsGroup = checkIsGroup;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode code;
        try {
            PrincipalId principalId = this.parsePrincipal();
            _log.debug("Checking whether " + (this._checkIsGroup ? "group" : "user") + " with id \"" + principalId + "\" exists");
            PersonUser user = this._principalDiscovery.findPersonUser(principalId);
            Group group = this._principalDiscovery.findGroup(principalId);
            if (user == null && group == null) {
                _log.error("No user or group found with id " + principalId);
                code = ReturnCode.InvalidUser;
            } else if (this._checkIsGroup && group != null || !this._checkIsGroup && user != null) {
                _log.info(String.format("%s %s is discovered", this._checkIsGroup ? "Group" : "User", principalId.toString()));
                code = ReturnCode.Success;
            } else {
                _log.error(String.format("Searching for %s with id %s but found a %s instead", this._checkIsGroup ? "group" : "user", principalId.toString(), this._checkIsGroup ? "user" : "group"));
                code = ReturnCode.IncorrectPrincipalType;
            }
        }
        catch (NotAuthenticatedException e) {
            _log.error(e.getMessage());
            _log.trace("", e);
            code = ReturnCode.NotPrivileged;
        }
        catch (NoPermissionException e) {
            _log.error(e.getMessage());
            _log.trace("", e);
            code = ReturnCode.NotPrivileged;
        }
        catch (SystemException e) {
            _log.error(e.getMessage());
            _log.trace("", e);
            code = ReturnCode.ServiceNotResponding;
        }
        return code;
    }

    private PrincipalId parsePrincipal() throws NoPermissionException, NotAuthenticatedException {
        String domainPart;
        String namePart;
        int upnIndex = this._principal.lastIndexOf("@");
        int netbiosIndex = this._principal.indexOf("\\");
        if (netbiosIndex != -1) {
            _log.info("NetBIOS separator is present, principal name is assumed to be in the NetBIOS format.");
            namePart = this._principal.substring(netbiosIndex + 1);
            domainPart = this._principal.substring(0, netbiosIndex);
        } else if (upnIndex != -1) {
            _log.info("UPN separator is present, principal name is assumed to be in the UPN format.");
            namePart = this._principal.substring(0, upnIndex);
            domainPart = this._principal.substring(upnIndex + 1);
        } else {
            _log.info("No domain name provided. Assuming default value (the local OS) if present in the SSO installation provided");
            namePart = this._principal;
            domainPart = this._domainManagement.getLocalOSDomainName();
            if (domainPart == null || domainPart.isEmpty()) {
                throw new IllegalArgumentException("The local OS identity source is not registered with the SSO installation");
            }
        }
        return new PrincipalId(namePart, domainPart);
    }
}

