/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.Commands;
import com.vmware.vim.install.cli.commands.CheckDomainExistsCommand;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.commands.CommandArgumentsParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CheckDomainExistsCommandParser
extends CommandArgumentsParser {
    private static final String LOCAL_IS_ARG = "local-is";
    private static final String DOMAIN_ARG = "domain";
    private String _domainName;
    private boolean _checkLocalIs;

    public CheckDomainExistsCommandParser() {
        super(Commands.checkDomainExists);
    }

    @Override
    protected void parseAdditionalOptions(CommandLine line) {
        this._domainName = line.getOptionValue(DOMAIN_ARG);
        this._checkLocalIs = line.hasOption(LOCAL_IS_ARG);
        if (this._domainName == null && !this._checkLocalIs) {
            throw new IllegalArgumentException(String.format("At least one of the options '%s' and '%s' should be provided", DOMAIN_ARG, LOCAL_IS_ARG));
        }
    }

    @Override
    protected Options createOptions() {
        Options options = super.createCommonOptions();
        Option option = new Option(null, DOMAIN_ARG, true, "Domain name or alias which needs to be checked");
        options.addOption(option);
        options.addOption(null, LOCAL_IS_ARG, false, "To check whether local OS identity source exists");
        return options;
    }

    @Override
    protected Command createCommand(RegistrationServiceProvider serviceProvider) {
        return new CheckDomainExistsCommand(serviceProvider, this._domainName, this._checkLocalIs);
    }
}

