/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.sso.admin.DomainManagement;
import com.vmware.vim.sso.admin.ExternalDomain;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CheckDomainExistsCommand
implements Command {
    private static final Log _log = LogFactory.getLog(CheckDomainExistsCommand.class);
    private final DomainManagement _dm;
    private final String _domainName;
    private final boolean _checkLocalIs;

    CheckDomainExistsCommand(RegistrationServiceProvider serviceProvider, String domainName, boolean checkLocalIs) {
        this._dm = serviceProvider.getAdminService().getDomainManagement();
        this._domainName = domainName;
        this._checkLocalIs = checkLocalIs;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode code = ReturnCode.OperationFailed;
        try {
            String localOS;
            String systemDomain = this._dm.getSystemDomainName();
            boolean isSystem = this._domainName != null && this._domainName.equalsIgnoreCase(systemDomain);
            ExternalDomain domain = this._domainName != null && !isSystem ? this._dm.findExternalDomain(this._domainName) : null;
            String string = localOS = this._checkLocalIs ? this._dm.getLocalOSDomainName() : null;
            code = domain == null && !isSystem && this._domainName != null ? (localOS == null && this._checkLocalIs ? ReturnCode.NoDomain : ReturnCode.DomainNotFound) : (localOS == null && this._checkLocalIs ? ReturnCode.NoLocalOS : ReturnCode.Success);
        }
        catch (NoPermissionException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            code = ReturnCode.NotPrivileged;
        }
        catch (NotAuthenticatedException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            code = ReturnCode.InvalidCredentials;
        }
        catch (SystemException e) {
            _log.error(e.getMessage());
            _log.debug("", e);
            code = ReturnCode.ServiceNotResponding;
        }
        return code;
    }
}

