/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.RegistrationProviderConfig;
import com.vmware.vim.install.RegistrationProviderFactory;
import com.vmware.vim.install.RegistrationServiceProvider;
import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.ChangePasswordCommand;
import com.vmware.vim.install.cli.commands.ChangePasswordForm;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.install.cli.util.LsFinderUtil;
import com.vmware.vim.install.exception.ConnectionException;
import com.vmware.vim.install.exception.RegistrationException;
import com.vmware.vim.install.exception.SSLException;
import com.vmware.vim.sso.admin.client.AdminClient;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChangePasswordCommandParser {
    private static final String HELP_SWITCH = "help";
    private static final String LS_URL_SWITCH = "ls-url";
    private static final String THUMBPRINT_SWITCH = "thumbprint";
    private static final String USAGE_LINE = "sso_passwd [-d lookup-service] [-t thumbprint] username [password] [new-password]";
    private static final Log _log = LogFactory.getLog(ChangePasswordCommand.class);
    private final Options _options = new Options();

    public ChangePasswordCommandParser() {
        this._options.addOption("h", HELP_SWITCH, false, "Prints this help message");
        StringBuilder urlOptHelp = new StringBuilder();
        urlOptHelp.append("Optional address of Lookup Service server. ").append("Usually https://<public-address-of-SSO-server>:7444/lookupservice/sdk . ").append("If not specified, the command will try to contact an SSO ").append("server running on the current machine.");
        this._options.addOption(new Option("d", LS_URL_SWITCH, true, urlOptHelp.toString()));
        this._options.addOption("t", THUMBPRINT_SWITCH, true, "Thumbprint against which to verify the LS server's SSL certificate.");
        this._options.addOption("h", HELP_SWITCH, false, "Prints this help message.");
    }

    public Command parseCommand(String[] args) {
        Command command;
        try {
            CommandLine line = new PosixParser().parse(this._options, args);
            if (line.hasOption(HELP_SWITCH)) {
                this.printUsage();
                command = new StatusCommand(ReturnCode.Success);
            } else {
                ChangePasswordForm form = this.getChangePasswordForm(line.getArgs());
                URI lsUrl = this.getLookupServiceUrl(line.getOptionValue(LS_URL_SWITCH));
                ThumbprintVerifier verifier = this.getVerifier(line.getOptionValue(THUMBPRINT_SWITCH));
                RegistrationProviderConfig config = new RegistrationProviderConfig.Builder(lsUrl).withThumbprintVerifier(verifier).withAnonymousAuthn().create();
                RegistrationServiceProvider regSvc = RegistrationProviderFactory.getRegistrationProvider(config);
                AdminClient adminService = regSvc.getAdminService();
                command = new ChangePasswordCommand(adminService.getDomainManagement(), adminService.getPrincipalManagement(), form);
            }
        }
        catch (ConnectionException e) {
            _log.error(e.getMessage());
            command = new StatusCommand(ReturnCode.ServiceNotResponding);
        }
        catch (IllegalArgumentException e) {
            _log.error(e.getMessage());
            _log.trace("", e);
            command = new StatusCommand(ReturnCode.InvalidInput);
        }
        catch (IllegalStateException e) {
            _log.error(e.getMessage());
            _log.trace("", e);
            command = new StatusCommand(ReturnCode.InvalidEnvironment);
        }
        catch (SSLException e) {
            command = new StatusCommand(ReturnCode.SslHandshakeFailed);
        }
        catch (RegistrationException e) {
            command = new StatusCommand(ReturnCode.ServiceNotResponding);
        }
        catch (SystemException e) {
            _log.error(e.getMessage());
            _log.trace("", e);
            command = new StatusCommand(ReturnCode.ServiceNotResponding);
        }
        catch (ParseException e) {
            _log.error(e.getMessage());
            _log.trace("", e);
            this.printUsage();
            command = new StatusCommand(ReturnCode.InvalidInput);
        }
        return command;
    }

    private URI getLookupServiceUrl(String fromCmdLine) {
        URI lsUrl;
        if (fromCmdLine == null || fromCmdLine.isEmpty()) {
            lsUrl = LsFinderUtil.autoFindLsUrl();
        } else {
            try {
                lsUrl = LsFinderUtil.checkHttps(new URI(fromCmdLine));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        if (lsUrl == null) {
            throw new IllegalArgumentException("The lookup service address was not specified on the command line and could not be automatically detected. Use the `-d' switch to specify it explicitly. Use `--help' for more information.");
        }
        return lsUrl;
    }

    private ThumbprintVerifier getVerifier(final String trustedThumbprint) {
        ThumbprintVerifier verifier = trustedThumbprint != null && !trustedThumbprint.isEmpty() ? new ThumbprintVerifier(){

            @Override
            public void onSuccess(X509Certificate[] chain, String thumbprint, ThumbprintVerifier.Result verifyResult, boolean trustedChain, boolean verifiedAssertions) throws SSLException {
            }

            @Override
            public ThumbprintVerifier.Result verify(String thumbprint) {
                return thumbprint != null && thumbprint.equalsIgnoreCase(trustedThumbprint) ? ThumbprintVerifier.Result.MATCH : ThumbprintVerifier.Result.MISMATCH;
            }
        } : null;
        return verifier;
    }

    private ChangePasswordForm getChangePasswordForm(String[] args) {
        if (args == null || args.length < 1) {
            throw new IllegalArgumentException("User name is required, but wasn't provided. Use the `--help' switch to display the command's usage.");
        }
        String username = args[0];
        String oldPassword = args.length > 1 ? args[1] : null;
        String newPassword = args.length > 2 ? args[2] : null;
        return new ChangePasswordForm(username, oldPassword, newPassword);
    }

    private void printUsage() {
        StringWriter usage = new StringWriter();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(new PrintWriter(usage), 100, USAGE_LINE, null, this._options, 5, 5, null);
        _log.info(usage.toString());
    }

    private static final class StatusCommand
    implements Command {
        private final ReturnCode _errorCode;

        StatusCommand(ReturnCode errorCode) {
            this._errorCode = errorCode;
        }

        @Override
        public ReturnCode execute() {
            return this._errorCode;
        }
    }
}

