/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli.commands;

import com.vmware.vim.install.cli.ReturnCode;
import com.vmware.vim.install.cli.commands.Command;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.DomainManagement;
import com.vmware.vim.sso.admin.RoleManagement;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssignUserRoleCommand
implements Command {
    private static final Log _log = LogFactory.getLog(AssignUserRoleCommand.class);
    private final DomainManagement _domainManagement;
    private final RoleManagement _roleManagement;
    private final String _userRole;
    private final String _username;

    public AssignUserRoleCommand(DomainManagement domainManagement, RoleManagement roleManagement, String userRole, String username) {
        this._domainManagement = domainManagement;
        this._roleManagement = roleManagement;
        this._userRole = userRole;
        this._username = username;
    }

    @Override
    public ReturnCode execute() {
        ReturnCode code;
        RoleManagement.Role role = null;
        try {
            role = RoleManagement.Role.valueOf(this._userRole);
        }
        catch (IllegalArgumentException e) {
            _log.error(this._userRole + " is not a valid SSO Admin server role");
            ReturnCode returnCode = ReturnCode.InvalidInput;
        }
        if (role != null) {
            try {
                PrincipalId userId = new PrincipalId(this._username, this._domainManagement.getSystemDomainName());
                this._roleManagement.setRole(userId, role);
                _log.info(String.format("Successfully assigned role \"%s\" to user \"%s\"", new Object[]{role, userId}));
                code = ReturnCode.Success;
            }
            catch (InvalidPrincipalException e) {
                _log.error(e.getMessage());
                _log.debug(e);
                code = ReturnCode.InvalidUser;
            }
            catch (NotAuthenticatedException e) {
                _log.error(e.getMessage(), e);
                code = ReturnCode.NotPrivileged;
            }
            catch (NoPermissionException e) {
                _log.error(e.getMessage(), e);
                code = ReturnCode.NotPrivileged;
            }
            catch (SystemException e) {
                _log.error(e.getMessage(), e);
                code = ReturnCode.ServiceNotResponding;
            }
        } else {
            code = ReturnCode.AssignRoleFailed;
        }
        return code;
    }
}

