/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.install.cli;

public enum Commands {
    validateLsConnection("Validate connection to LookupService"),
    registerService("Register service in LookupService"),
    unregisterService("Unregister service from LookupService"),
    updateService("Updates a service already registered in LookupService"),
    validateSsoConnection("Validate connection to SSO"),
    validateUsername("Validate that the username is not already registered with SSO"),
    checkPrincipalExists("Check whether a person user or group with the specified fully qualified name exists. The following name formats are accepted: \n  DOMAIN\\principal (NetBIOS)\n  principal@domain (UPN)\n  principal (unqualified).\nIf the principal proper name contains backslash, the NetBIOS format must be used."),
    registerSolution("Register solution user in SSO"),
    updateSolution("Update an existing SSO solution user. The command supports two modes of operation:\n - Administrator mode, with explicitly provided solution user name.\n - Self-update mode, where the authenticating user is being updated."),
    assignUserRole("Assign SSO admin role to user"),
    unregisterSolution("Unregister solution user from SSO"),
    storeSsoData("Store all SSO-related locations in a file on the local system"),
    registerDomain("Register external domain in the SSO server. INTERNAL."),
    checkDomainExists("Check whether a domain with a given domain name/alias exists. If the additional flag 'local-is' is provided, the command checks also for the local OS identity source. INTERNAL"),
    listServices("List all services registered in LookupService running on given address (e.g. https://lookup:7444/lookupservice/sdk)"),
    changePassword("Change the password of a SSO system user (e.g. admin@System-Domain) by providing the user's old password."),
    checkVersion("Check whether the SSO version is lower than a defined version"),
    importServices("Import services and endpoints");

    private String _value;

    private Commands(String value) {
        this._value = value;
    }

    public String getValue() {
        return this._value;
    }

    public boolean isCrudCommand() {
        return Commands.isCrudCommand(this);
    }

    private static boolean isCrudCommand(Commands cmd) {
        boolean isCrud;
        switch (cmd) {
            case registerService: 
            case unregisterService: 
            case updateService: 
            case registerSolution: 
            case unregisterSolution: 
            case listServices: {
                isCrud = true;
                break;
            }
            default: {
                isCrud = false;
            }
        }
        return isCrud;
    }
}

