/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vim.vmomi.core.impl.SslUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class ThumbprintTrustManager
implements X509TrustManager {
    private static final Log LOG = LogFactory.getLog(ThumbprintTrustManager.class);
    private final X509TrustManager _defaultTrustManager;
    private final ThumbprintVerifier _thumbprintVerifier;
    private final ThreadLocal<ChainInfo> _tlsChainInfo;

    public ThumbprintTrustManager(KeyStore trustStore, ThumbprintVerifier verifier) throws KeyStoreException {
        this._defaultTrustManager = ThumbprintTrustManager.createDefaultTrustManger(trustStore);
        this._thumbprintVerifier = verifier;
        this._tlsChainInfo = new ThreadLocal();
    }

    private static X509TrustManager createDefaultTrustManger(KeyStore trustStore) throws KeyStoreException {
        TrustManagerFactory factory;
        try {
            factory = TrustManagerFactory.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to create trust manager factory", e);
        }
        factory.init(trustStore);
        for (TrustManager trustManager : factory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw new IllegalStateException("Unable to find default trust manager");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean isTrusted;
        ThumbprintVerifier.Result verifyResult;
        String certThumbprint;
        block8: {
            certThumbprint = null;
            verifyResult = ThumbprintVerifier.Result.UNKNOWN;
            isTrusted = false;
            try {
                try {
                    certThumbprint = SslUtil.computeCertificateThumbprint((X509Certificate)chain[0]);
                }
                catch (Exception e) {
                    throw new CertificateException("Unable to compute server certificate thumbprint", e);
                }
                if (this._thumbprintVerifier != null) {
                    verifyResult = this._thumbprintVerifier.verify(certThumbprint);
                }
                this._defaultTrustManager.checkServerTrusted(chain, authType);
                isTrusted = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Server certificate chain is trusted");
                }
            }
            catch (Exception e) {
                isTrusted = false;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Server certificate chain is not trusted");
                }
                if (verifyResult != ThumbprintVerifier.Result.MATCH) {
                    this._tlsChainInfo.set(new ChainInfo(chain, certThumbprint, verifyResult, isTrusted));
                    throw new CertificateException("Server certificate chain is not trusted and thumbprint doesn't match", e);
                }
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)"Server certificate chain is not trusted but thumbprint matches");
            }
        }
        this._tlsChainInfo.set(new ChainInfo(chain, certThumbprint, verifyResult, isTrusted));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this._defaultTrustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this._defaultTrustManager.getAcceptedIssuers();
    }

    public class HostnameVerifier
    implements X509HostnameVerifier {
        public void verify(String host, SSLSocket socket) throws IOException {
            Certificate[] certificates;
            SSLSession session = socket.getSession();
            if (session == null) {
                InputStream in = socket.getInputStream();
                in.available();
                session = socket.getSession();
                if (session == null) {
                    socket.startHandshake();
                    session = socket.getSession();
                }
            }
            try {
                certificates = session.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                ChainInfo chainInfo = (ChainInfo)ThumbprintTrustManager.this._tlsChainInfo.get();
                if (chainInfo != null) {
                    ThumbprintTrustManager.this._tlsChainInfo.set(null);
                    throw new CertificateValidationException("Server certificate chain not verified", chainInfo._chain, chainInfo._thumbprint, chainInfo._isTrusted, (Throwable)e);
                }
                throw new SSLException("Server certificate chain not verified (no details)", e);
            }
            this.verify(host, (X509Certificate)certificates[0]);
        }

        public void verify(String host, X509Certificate cert) throws SSLException {
            ChainInfo chainInfo;
            boolean assertionVerified;
            block5: {
                assertionVerified = false;
                chainInfo = (ChainInfo)ThumbprintTrustManager.this._tlsChainInfo.get();
                ThumbprintTrustManager.this._tlsChainInfo.set(null);
                try {
                    SSLSocketFactory.STRICT_HOSTNAME_VERIFIER.verify(this.formatHost(host), cert);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Server certificate assertion verified");
                    }
                    assertionVerified = true;
                }
                catch (SSLException e) {
                    if (null != chainInfo && chainInfo._verifyResult != ThumbprintVerifier.Result.MATCH) {
                        throw new CertificateValidationException("Server certificate assertion not verified and thumbprint not matched", chainInfo._chain, chainInfo._thumbprint, chainInfo._isTrusted, (Throwable)e);
                    }
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug((Object)"Server certificate assertion not verified but thumbprint matches");
                }
            }
            if (null != chainInfo && ThumbprintTrustManager.this._thumbprintVerifier != null) {
                ThumbprintTrustManager.this._thumbprintVerifier.onSuccess(chainInfo._chain, chainInfo._thumbprint, chainInfo._verifyResult, chainInfo._isTrusted, assertionVerified);
            }
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            SSLSocketFactory.STRICT_HOSTNAME_VERIFIER.verify(this.formatHost(host), cns, subjectAlts);
        }

        public boolean verify(String host, SSLSession session) {
            try {
                Certificate[] certificates = session.getPeerCertificates();
                this.verify(host, (X509Certificate)certificates[0]);
                return true;
            }
            catch (SSLException e) {
                return false;
            }
        }

        private String formatHost(String host) {
            if (host != null && host.startsWith("[") && host.endsWith("]")) {
                try {
                    return InetAddress.getByName(host).getHostAddress();
                }
                catch (UnknownHostException e) {
                    return host;
                }
            }
            return host;
        }
    }

    private static class ChainInfo {
        X509Certificate[] _chain;
        String _thumbprint;
        ThumbprintVerifier.Result _verifyResult;
        boolean _isTrusted;

        ChainInfo(X509Certificate[] chain, String thumbprint, ThumbprintVerifier.Result verifyResult, boolean isTrusted) {
            this._chain = chain;
            this._thumbprint = thumbprint;
            this._verifyResult = verifyResult;
            this._isTrusted = isTrusted;
        }
    }
}

