/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.common.Request;
import com.vmware.vim.vmomi.client.common.Response;
import com.vmware.vim.vmomi.client.common.Session;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpProtocolBinding;
import com.vmware.vim.vmomi.client.http.impl.ClientExceptionTranslator;
import com.vmware.vim.vmomi.client.http.impl.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpExchange;
import com.vmware.vim.vmomi.client.http.impl.HttpSession;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.HttpContext;

public class HttpProtocolBindingImpl
implements HttpProtocolBinding {
    private static final Log LOG = LogFactory.getLog(HttpProtocolBindingImpl.class);
    private static final Date EXPIRED = new Date(0L);
    private final URI _endpointUri;
    private final Executor _executor;
    private final DefaultHttpClient _client;
    private final HttpConfigurationImpl _config;
    private final HttpConfiguration.CompressionSupport _serverCompressionSupport;
    private InvocationInterceptor _invocationInterceptor;

    public HttpProtocolBindingImpl(URI serverUri, Executor executor, HttpConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("Client HTTP configuration is required");
        }
        this._endpointUri = serverUri;
        this._executor = executor;
        this._config = (HttpConfigurationImpl)config;
        CompiledHttpConfiguration compiledConfig = this._config.getCompiledConfiguration();
        this._client = new DefaultHttpClient(compiledConfig.getConnectionManager(), compiledConfig.getParams());
        final long keepAlivePeriod = this._config.getKeepAlivePeriod();
        this._client.setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                return keepAlivePeriod;
            }
        });
        this._serverCompressionSupport = this.resolveServerCompressionSupport();
    }

    @Override
    public void send(Request request, Response response, boolean sync) {
        HttpExchange exchange = new HttpExchange(request, response, (HttpClient)this._client, this._endpointUri, this._serverCompressionSupport == HttpConfiguration.CompressionSupport.ENABLE, this._invocationInterceptor, this._config);
        if (this._executor != null && !sync) {
            this._executor.execute(exchange);
        } else {
            if (!sync && LOG.isWarnEnabled()) {
                LOG.warn((Object)"Asynchronous execution requested but no Executor configured. The request will be executed as synchronous one.");
            }
            exchange.run();
        }
    }

    @Override
    public URI getEndpointUri() {
        return this._endpointUri;
    }

    @Override
    public HttpConfiguration getConfiguration() {
        return this._config;
    }

    @Override
    public Executor getExecutor() {
        return this._executor;
    }

    @Override
    public HttpConfiguration.CompressionSupport getServerCompressionSupport() {
        return this._serverCompressionSupport;
    }

    @Override
    public Object getImpl() {
        return this._client;
    }

    @Override
    public void setSession(Session session) {
        HttpSession httpSession = (HttpSession)session;
        this.setCookie("vmware_soap_session", httpSession.getId(), httpSession.getPath(), httpSession.getDomain());
    }

    @Override
    public void clearSession() {
        Cookie cookie;
        while ((cookie = this.getFirstCookie("vmware_soap_session")) != null) {
            this.removeCookie(cookie);
        }
    }

    @Override
    public Session getSession() {
        Cookie cookie = this.getFirstCookie("vmware_soap_session");
        if (cookie == null) {
            return null;
        }
        return new HttpSession(cookie.getValue(), cookie.getPath(), cookie.getDomain());
    }

    @Override
    public Session createSession(String id) {
        return new HttpSession(id, "/", this._endpointUri.getHost());
    }

    private void setCookie(String name, String value, String path, String domain) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setPath(path);
        cookie.setDomain(domain);
        this._client.getCookieStore().addCookie((Cookie)cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cookie getFirstCookie(String name) {
        CookieStore cookieStore;
        CookieStore cookieStore2 = cookieStore = this._client.getCookieStore();
        synchronized (cookieStore2) {
            for (Cookie cookie : cookieStore.getCookies()) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    private void removeCookie(Cookie cookie) {
        BasicClientCookie remove = new BasicClientCookie(cookie.getName(), cookie.getValue());
        remove.setPath(cookie.getPath());
        remove.setDomain(cookie.getDomain());
        remove.setExpiryDate(EXPIRED);
        this._client.getCookieStore().addCookie((Cookie)remove);
    }

    private HttpConfiguration.CompressionSupport resolveServerCompressionSupport() {
        HttpConfiguration.CompressionSupport res = this._config.getCompressionSupport();
        if (this._config.getCompressionSupport() == HttpConfiguration.CompressionSupport.ASK_SERVER) {
            HttpOptions options = new HttpOptions(this._endpointUri);
            HttpResponse optionsResponse = null;
            try {
                optionsResponse = this._client.execute((HttpUriRequest)options);
            }
            catch (ClientProtocolException e) {
                throw (RuntimeException)ClientExceptionTranslator.translate((Exception)((Object)e));
            }
            catch (IOException e) {
                throw (RuntimeException)ClientExceptionTranslator.translate(e);
            }
            Header acceptEncodingHeader = optionsResponse.getFirstHeader("Accept-Encoding");
            if (acceptEncodingHeader != null && acceptEncodingHeader.getValue().contains("gzip")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Server supports compression.");
                }
                res = HttpConfiguration.CompressionSupport.ENABLE;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Server does not support compression.");
                }
                res = HttpConfiguration.CompressionSupport.DISABLE;
            }
        }
        return res;
    }

    public void setInvocationInterceptor(InvocationInterceptor invocationInterceptor) {
        this._invocationInterceptor = invocationInterceptor;
    }
}

