/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vmodl.DynamicData;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.vmomi.core.exception.InternalException;
import com.vmware.vim.vmomi.core.types.ComplexType;
import com.vmware.vim.vmomi.core.types.ComplexTypeField;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.impl.ComplexTypeFieldImpl;
import com.vmware.vim.vmomi.core.types.impl.VmodlContextImpl;
import com.vmware.vim.vmomi.core.types.impl.VmodlTypeImpl;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComplexTypeImpl
extends VmodlTypeImpl
implements ComplexType {
    private Class<?> _parentClass;
    private HashMap<String, ComplexTypeField> _declaredField;
    private AtomicReference<HashMap<String, ComplexTypeField>> _field;
    private static final String PROPERTY_GETTER_PREFIX = "get";
    private static final String BOOLEAN_PROPERTY_GETTER_PREFIX = "is";
    private static final String PROPERTY_SETTER_PREFIX = "set";
    private static final Log _logger = LogFactory.getLog(ComplexTypeImpl.class);

    public ComplexTypeImpl(Class<?> clazz) {
        super(clazz);
        this.init(clazz);
    }

    private void init(Class<?> clazz) {
        this._field = new AtomicReference();
        Class<?>[] superInterfaces = clazz.getInterfaces();
        if (superInterfaces != null && superInterfaces.length == 1) {
            this._parentClass = superInterfaces[0];
        } else {
            this._parentClass = clazz.getSuperclass();
            if (this._parentClass == Exception.class) {
                this._parentClass = null;
            }
            if (this._parentClass == DynamicDataImpl.class) {
                this._parentClass = DynamicData.class;
            }
        }
        if (clazz.getAnnotation(managed.class) == null && clazz.getAnnotation(propertyOrder.class) != null) {
            this._declaredField = new LinkedHashMap<String, ComplexTypeField>();
            Object[] properties = clazz.getAnnotation(propertyOrder.class).value();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Complex type: " + this.getTypeName() + ", class: " + this.getTypeClass().getName() + ", properties: " + Arrays.toString(properties)));
            }
            try {
                for (int i = 0; i < properties.length; ++i) {
                    String methodSuffix = Character.toUpperCase(properties[i].charAt(0)) + ((String)properties[i]).substring(1);
                    Method getter = null;
                    try {
                        getter = clazz.getMethod(PROPERTY_GETTER_PREFIX + methodSuffix, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        getter = clazz.getMethod(BOOLEAN_PROPERTY_GETTER_PREFIX + methodSuffix, new Class[0]);
                    }
                    Method setter = clazz.getMethod(PROPERTY_SETTER_PREFIX + methodSuffix, getter.getReturnType());
                    ComplexTypeFieldImpl field = new ComplexTypeFieldImpl((String)properties[i], getter, setter);
                    this._declaredField.put(field.getName(), field);
                }
            }
            catch (NoSuchMethodException e) {
                throw new InternalException(e);
            }
        }
    }

    @Override
    public ComplexTypeField getProperty(String name2) {
        if (this._field.get() == null) {
            this.initAllProps();
        }
        return this._field.get().get(name2);
    }

    @Override
    public ComplexTypeField[] getProperties() {
        if (this._field.get() == null) {
            this.initAllProps();
        }
        return this._field.get().values().toArray(new ComplexTypeField[0]);
    }

    private void initAllProps() {
        if (((VmodlContextImpl)VmodlContext.getContext()).isInitializing()) {
            throw new IllegalStateException("Initializing type but the VmodlContext is not initialized!");
        }
        if (this._field.get() == null) {
            LinkedHashMap<String, ComplexTypeField> map2 = new LinkedHashMap<String, ComplexTypeField>();
            ComplexType parentType = this.getBaseType();
            if (parentType != null) {
                ComplexTypeField[] field = parentType.getProperties();
                for (int i = 0; i < field.length; ++i) {
                    map2.put(field[i].getName(), field[i]);
                }
            }
            if (this._declaredField != null) {
                map2.putAll(this._declaredField);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Initializing complex type for " + this.getTypeName() + " (" + this.getTypeClass().getName() + ") completed!"));
                for (ComplexTypeField complexTypeFields : ((HashMap)map2).values()) {
                    _logger.debug((Object)("Adding property " + complexTypeFields.getName() + " (version " + complexTypeFields.getVersion().getVersionClass().getName() + ")"));
                }
            }
            this._field.compareAndSet(null, map2);
        }
    }

    @Override
    public ComplexTypeField[] getDeclaredProperties() {
        return this._declaredField.values().toArray(new ComplexTypeField[0]);
    }

    @Override
    public ComplexType getBaseType() {
        if (this._parentClass == null) {
            return null;
        }
        return (ComplexType)VmodlTypeMap.Factory.getTypeMap().getVmodlType(this._parentClass);
    }

    @Override
    public boolean isA(ComplexType type) {
        try {
            this.getTypeClass().asSubclass(type.getTypeClass());
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public Object newInstance() {
        try {
            return this.getTypeClass().newInstance();
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }
}

