/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl.signature;

import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.impl.SoapMessage;
import com.vmware.vim.sso.client.impl.Util;
import com.vmware.vim.sso.client.impl.WsSecuritySignature;
import com.vmware.vim.sso.client.impl.exception.ParserException;
import com.vmware.vim.sso.client.impl.exception.SignatureException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class WsSecuritySignatureImpl
implements WsSecuritySignature {
    protected static final String SIGNATURE_ELEMENT_NAME = "Signature";
    protected static final String WSU_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    protected static final String WSU_ID_LOCAL_NAME = "Id";
    protected final SecurityTokenServiceConfig.HolderOfKeyConfig _holderOfKeyConfig;
    private static final String DIGITAL_SIGNATURE_NAMESPACE_PREFIX = "ds";
    private static final String WSU_TIMESTAMP_LOCAL_NAME = "Timestamp";
    private static final String WSU_PREFIX = "wsu";
    private static final String WSSE_JAXB_PACKAGE = "org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0";
    private static final String WST_JAXB_PACKAGE = "org.oasis_open.docs.ws_sx.ws_trust._200512";
    private static final String RSA_WITH_SHA512 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    private static final String PARSING_XML_ERROR_MSG = "Error while parsing the SOAP request (signature creation)";
    private static final String CREATING_SIGNATURE_ERR_MSG = "Error while creating SOAP request signature";
    private static final String MARSHALL_EXCEPTION_ERR_MSG = "Error marshalling JAXB document";
    private final Logger _log = LoggerFactory.getLogger(WsSecuritySignatureImpl.class);

    protected WsSecuritySignatureImpl(SecurityTokenServiceConfig.HolderOfKeyConfig holderOfKeyConfig) {
        assert (holderOfKeyConfig != null);
        this._holderOfKeyConfig = holderOfKeyConfig;
    }

    @Override
    public final SoapMessage sign(SoapMessage message) throws ParserException, SignatureException {
        assert (message != null);
        Provider securityProvider = this._holderOfKeyConfig.getSecurityProvider();
        XMLSignatureFactory xmlSigFactory = securityProvider != null ? XMLSignatureFactory.getInstance("DOM", securityProvider) : XMLSignatureFactory.getInstance();
        try {
            String bodyUuid = this.createSoapBodyUuid(message);
            CanonicalizationMethod canonicalizationMethod = xmlSigFactory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
            SignatureMethod signatureMethod = this.getSignatureMethod(xmlSigFactory);
            ArrayList<String> refList = new ArrayList<String>();
            refList.add(bodyUuid);
            refList.add(this.createTimestampUuid(message));
            List<Reference> references = this.createSignatureReferences(xmlSigFactory, refList);
            SignedInfo signedInfo = xmlSigFactory.newSignedInfo(canonicalizationMethod, signatureMethod, references);
            KeyInfoFactory kif = KeyInfoFactory.getInstance();
            KeyInfo ki = kif.newKeyInfo(Collections.singletonList(new DOMStructure(this.createKeyInfoContent(message))));
            XMLSignature signature = xmlSigFactory.newXMLSignature(signedInfo, ki, null, this.addUseKeySignatureId(message), null);
            DOMSignContext dsc = new DOMSignContext(this._holderOfKeyConfig.getPrivateKey(), message.getHeader().getFirstChild());
            dsc.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", DIGITAL_SIGNATURE_NAMESPACE_PREFIX);
            signature.sign(dsc);
            this._log.debug("Message with SOAPBody id: " + bodyUuid + " is signed.");
        }
        catch (NoSuchAlgorithmException e) {
            this._log.debug(CREATING_SIGNATURE_ERR_MSG);
            throw new SignatureException(CREATING_SIGNATURE_ERR_MSG, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            this._log.debug(CREATING_SIGNATURE_ERR_MSG);
            throw new SignatureException(CREATING_SIGNATURE_ERR_MSG, e);
        }
        catch (MarshalException e) {
            this._log.debug(CREATING_SIGNATURE_ERR_MSG);
            throw new SignatureException(CREATING_SIGNATURE_ERR_MSG, e);
        }
        catch (XMLSignatureException e) {
            this._log.debug(CREATING_SIGNATURE_ERR_MSG);
            throw new SignatureException(CREATING_SIGNATURE_ERR_MSG, e);
        }
        return message;
    }

    protected abstract String addUseKeySignatureId(SoapMessage var1) throws ParserException;

    protected abstract Node createKeyInfoContent(SoapMessage var1) throws ParserException;

    protected final Document marshallJaxbElement(Object jaxbElement) throws ParserException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document result = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0:org.oasis_open.docs.ws_sx.ws_trust._200512");
            result = dbf.newDocumentBuilder().newDocument();
            jaxbContext.createMarshaller().marshal(jaxbElement, (Node)result);
        }
        catch (JAXBException jaxbException) {
            this._log.debug(MARSHALL_EXCEPTION_ERR_MSG, (Throwable)jaxbException);
            throw new ParserException(MARSHALL_EXCEPTION_ERR_MSG, jaxbException);
        }
        catch (ParserConfigurationException pce) {
            this._log.debug(MARSHALL_EXCEPTION_ERR_MSG, (Throwable)pce);
            throw new ParserException(MARSHALL_EXCEPTION_ERR_MSG, pce);
        }
        return result;
    }

    private SignatureMethod getSignatureMethod(XMLSignatureFactory xmlSigFactory) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        PublicKey publicKey = this._holderOfKeyConfig.getCertificate().getPublicKey();
        SignatureMethod signatureMethod = publicKey instanceof RSAPublicKey && ((RSAPublicKey)publicKey).getModulus().bitCount() <= 512 ? xmlSigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null) : xmlSigFactory.newSignatureMethod(RSA_WITH_SHA512, null);
        return signatureMethod;
    }

    private String createSoapBodyUuid(SoapMessage message) throws ParserException {
        String bodyId = Util.randomNCNameUUID();
        try {
            message.getMessage().getSOAPBody().addAttribute(new QName(WSU_NAMESPACE, WSU_ID_LOCAL_NAME, WSU_PREFIX), bodyId);
        }
        catch (SOAPException e) {
            this._log.debug(PARSING_XML_ERROR_MSG);
            throw new ParserException(PARSING_XML_ERROR_MSG, e);
        }
        this._log.debug("Created wsu:Id for SOAPBody: " + bodyId);
        return bodyId;
    }

    private String createTimestampUuid(SoapMessage message) throws ParserException {
        NodeList timestampList = message.getHeader().getOwnerDocument().getElementsByTagNameNS(WSU_NAMESPACE, WSU_TIMESTAMP_LOCAL_NAME);
        assert (timestampList.getLength() <= 1);
        if (timestampList.getLength() == 1) {
            assert (timestampList.item(0).getNodeType() == 1);
            Element timestamp = (Element)timestampList.item(0);
            String timestampId = Util.randomNCNameUUID();
            Attr wsuId = timestamp.getOwnerDocument().createAttributeNS(WSU_NAMESPACE, WSU_ID_LOCAL_NAME);
            wsuId.setPrefix(timestamp.getPrefix());
            wsuId.setValue(timestampId);
            timestamp.setAttributeNodeNS(wsuId);
            timestamp.setIdAttributeNode(wsuId, true);
            this._log.trace("Created wsu:Id for wsu:Timestamp: " + timestampId);
            return timestampId;
        }
        this._log.trace("Timestamp element not found in the message");
        return null;
    }

    private List<Reference> createSignatureReferences(XMLSignatureFactory xmlSigFactory, List<String> referenceIdList) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        ArrayList<Reference> result = new ArrayList<Reference>();
        for (String refId : referenceIdList) {
            if (refId == null) continue;
            Reference ref = xmlSigFactory.newReference("#" + refId, xmlSigFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512", null), Collections.singletonList(xmlSigFactory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null)), null, null);
            result.add(ref);
        }
        return Collections.unmodifiableList(result);
    }
}

