/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl.signature;

import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.impl.SoapMessage;
import com.vmware.vim.sso.client.impl.Util;
import com.vmware.vim.sso.client.impl.exception.ParserException;
import com.vmware.vim.sso.client.impl.signature.WsSecuritySignatureImpl;
import com.vmware.vim.sso.client.util.codec.Base64;
import java.security.cert.CertificateEncodingException;
import javax.xml.soap.SOAPException;
import org.oasis_open.docs.ws_sx.ws_trust._200512.UseKeyType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.BinarySecurityTokenType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ReferenceType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.SecurityTokenReferenceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WsSecuritySignatureCertificate
extends WsSecuritySignatureImpl {
    private static final String X509_CERTIFICATE_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    private static final String SECURITY_ELEMENT = "Security";
    private static final String ERR_CREATING_USE_KEY_ELEMENT = "Error creating UseKey element";
    private final Logger _log = LoggerFactory.getLogger(WsSecuritySignatureCertificate.class);

    public WsSecuritySignatureCertificate(SecurityTokenServiceConfig.HolderOfKeyConfig config) {
        super(config);
    }

    @Override
    protected Node createKeyInfoContent(SoapMessage message) throws ParserException {
        String bstId = Util.randomNCNameUUID();
        NodeList secNodeList = message.getMessage().getSOAPPart().getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", SECURITY_ELEMENT);
        if (secNodeList.getLength() != 1) {
            throw new ParserException("No/too many security elements found");
        }
        secNodeList.item(0).appendChild(message.getMessage().getSOAPPart().importNode(this.createBinarySecurityToken(bstId), true));
        return this.createSecurityTokenReference(bstId);
    }

    @Override
    protected String addUseKeySignatureId(SoapMessage message) throws ParserException {
        String sigId = Util.randomNCNameUUID();
        try {
            message.getMessage().getSOAPBody().getFirstChild().appendChild(message.getMessage().getSOAPPart().importNode(this.createUseKeyElement(sigId), true));
        }
        catch (DOMException e) {
            this._log.debug(ERR_CREATING_USE_KEY_ELEMENT, (Throwable)e);
            throw new ParserException(ERR_CREATING_USE_KEY_ELEMENT, e);
        }
        catch (SOAPException e) {
            this._log.debug(ERR_CREATING_USE_KEY_ELEMENT, (Throwable)e);
            throw new ParserException(ERR_CREATING_USE_KEY_ELEMENT, e);
        }
        return sigId;
    }

    private Node createUseKeyElement(String sigId) throws ParserException {
        org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory wstFactory = new org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory();
        UseKeyType useKey = wstFactory.createUseKeyType();
        useKey.setSig(sigId);
        return this.marshallJaxbElement(useKey).getFirstChild();
    }

    private Node createBinarySecurityToken(String uuid) throws ParserException {
        ObjectFactory secExtFactory = new ObjectFactory();
        BinarySecurityTokenType bst = secExtFactory.createBinarySecurityTokenType();
        try {
            bst.setValue(Base64.encodeBase64String(this._holderOfKeyConfig.getCertificate().getEncoded()));
        }
        catch (CertificateEncodingException e) {
            String message = "Error creating BinarySecurityToken";
            this._log.debug(message, (Throwable)e);
            throw new ParserException(message, e);
        }
        bst.setValueType(X509_CERTIFICATE_TYPE);
        bst.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        bst.setId(uuid);
        return this.marshallJaxbElement(bst).getFirstChild();
    }

    private Node createSecurityTokenReference(String refId) throws ParserException {
        ObjectFactory secExtFactory = new ObjectFactory();
        SecurityTokenReferenceType stRef = secExtFactory.createSecurityTokenReferenceType();
        ReferenceType ref = secExtFactory.createReferenceType();
        ref.setURI("#" + refId);
        ref.setValueType(X509_CERTIFICATE_TYPE);
        stRef.getAny().add(ref);
        return this.marshallJaxbElement(stRef).getFirstChild();
    }
}

