/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl.processors.response;

import com.vmware.vim.sso.client.exception.InternalError;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.exception.MalformedTokenException;
import com.vmware.vim.sso.client.impl.GssResult;
import com.vmware.vim.sso.client.impl.exception.ParserException;
import com.vmware.vim.sso.client.impl.processors.response.ResponseHandlerImpl;
import com.vmware.vim.sso.client.util.codec.Base64;
import javax.xml.bind.JAXBContext;
import org.oasis_open.docs.ws_sx.ws_trust._200512.BinaryExchangeType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenResponseCollectionType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AcquireTokenByGssResponseHandler
extends ResponseHandlerImpl<GssResult> {
    private static final String PROCESS_RSTR_ERROR = "Error processing the response to SPNego token request";
    private static final String RSTRC_ELEMENT_NAME = "RequestSecurityTokenResponseCollection";
    private static final String RSTRC_NAMESPACE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    private final Logger _log = LoggerFactory.getLogger(AcquireTokenByGssResponseHandler.class);

    public AcquireTokenByGssResponseHandler(JAXBContext context) throws InternalError {
        super(context);
    }

    @Override
    public GssResult parseResponse(Node response) throws ParserException, InvalidTokenException {
        Element returnedToken = this.findReturnedToken(response);
        RequestSecurityTokenResponseType parsedResponse = returnedToken == null ? this.parseIntermediateGssResponse(response) : this.parseFinalGssResponse(response);
        byte[] leg = this.extractBinaryExchangeData(parsedResponse.getBinaryExchange());
        GssResult parseResult = new GssResult(leg, returnedToken, parsedResponse.getContext());
        return parseResult;
    }

    private Element findReturnedToken(Node node) throws ParserException {
        NodeList assertionNodes = ((Element)node).getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        if (assertionNodes.getLength() == 0) {
            return null;
        }
        if (assertionNodes.getLength() > 1) {
            this._log.debug("Error processing the response to SPNego token request: more than one saml:Assertion returned");
            throw new ParserException(PROCESS_RSTR_ERROR);
        }
        return (Element)assertionNodes.item(0);
    }

    private boolean findRSTRC(Node node) throws ParserException {
        boolean found = false;
        if (RSTRC_ELEMENT_NAME.equalsIgnoreCase(node.getLocalName()) && RSTRC_NAMESPACE.equalsIgnoreCase(node.getNamespaceURI())) {
            this._log.debug("Node is the RSTRC.");
            found = true;
        } else {
            NodeList rstrcNodes = ((Element)node).getElementsByTagNameNS(RSTRC_NAMESPACE, RSTRC_ELEMENT_NAME);
            this._log.debug(String.format("Found %d RSTRC elements.", rstrcNodes == null ? 0 : rstrcNodes.getLength()));
            found = rstrcNodes.getLength() > 0;
        }
        return found;
    }

    private RequestSecurityTokenResponseType parseIntermediateGssResponse(Node response) throws ParserException {
        RequestSecurityTokenResponseType parsedResponse = null;
        boolean hasRSTRC = this.findRSTRC(response);
        if (hasRSTRC) {
            this._log.debug("Intermediate response contains RSTRC. Parsing RSTR from there.");
            RequestSecurityTokenResponseCollectionType rstrc = this.parseStsResponse(response, RequestSecurityTokenResponseCollectionType.class, true);
            parsedResponse = rstrc.getRequestSecurityTokenResponse();
        } else {
            this._log.debug("Intermediate response does not contain RSTRC. Should be direct RSTR.");
            parsedResponse = this.parseStsResponse(response, RequestSecurityTokenResponseType.class, true);
        }
        if (parsedResponse == null) {
            this._log.error("Unable to get RSTR element from response.");
            throw new ParserException(PROCESS_RSTR_ERROR);
        }
        this.validateContextId(parsedResponse);
        return parsedResponse;
    }

    private RequestSecurityTokenResponseType parseFinalGssResponse(Node response) throws ParserException, MalformedTokenException {
        RequestSecurityTokenResponseType parsedResponse = this.parseStsResponse(response);
        if (!"urn:oasis:names:tc:SAML:2.0:assertion".equalsIgnoreCase(parsedResponse.getTokenType())) {
            String message = String.format("Received token with invalid format: '%s' (expected '%s')", parsedResponse.getTokenType(), "urn:oasis:names:tc:SAML:2.0:assertion");
            this._log.debug(message);
            throw new MalformedTokenException(message);
        }
        this.validateContextId(parsedResponse);
        return parsedResponse;
    }

    private byte[] extractBinaryExchangeData(BinaryExchangeType element) throws ParserException {
        if (element == null) {
            return null;
        }
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary".equals(element.getEncodingType()) || !"http://schemas.xmlsoap.org/ws/2005/02/trust/spnego".equals(element.getValueType())) {
            this._log.debug(PROCESS_RSTR_ERROR);
            throw new ParserException(PROCESS_RSTR_ERROR);
        }
        return Base64.decodeBase64(element.getValue());
    }

    private void validateContextId(RequestSecurityTokenResponseType response) throws ParserException {
        String contextId = response.getContext();
        if (contextId == null) {
            this._log.debug("Error processing the response to SPNego token request: Context is null");
            throw new ParserException(PROCESS_RSTR_ERROR);
        }
    }
}

